# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class ImageSummary(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'parent_id': 'str',
        'repo_tags': 'list[str]',
        'repo_digests': 'list[str]',
        'created': 'int',
        'size': 'int',
        'shared_size': 'int',
        'virtual_size': 'int',
        'labels': 'dict(str, str)',
        'containers': 'int'
    }

    attribute_map = {
        'id': 'Id',
        'parent_id': 'ParentId',
        'repo_tags': 'RepoTags',
        'repo_digests': 'RepoDigests',
        'created': 'Created',
        'size': 'Size',
        'shared_size': 'SharedSize',
        'virtual_size': 'VirtualSize',
        'labels': 'Labels',
        'containers': 'Containers'
    }

    def __init__(self, id=None, parent_id=None, repo_tags=None, repo_digests=None, created=None, size=None, shared_size=None, virtual_size=None, labels=None, containers=None, _configuration=None):  # noqa: E501
        """ImageSummary - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._id = None
        self._parent_id = None
        self._repo_tags = None
        self._repo_digests = None
        self._created = None
        self._size = None
        self._shared_size = None
        self._virtual_size = None
        self._labels = None
        self._containers = None
        self.discriminator = None

        self.id = id
        self.parent_id = parent_id
        self.repo_tags = repo_tags
        self.repo_digests = repo_digests
        self.created = created
        self.size = size
        self.shared_size = shared_size
        self.virtual_size = virtual_size
        self.labels = labels
        self.containers = containers

    @property
    def id(self):
        """Gets the id of this ImageSummary.  # noqa: E501


        :return: The id of this ImageSummary.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ImageSummary.


        :param id: The id of this ImageSummary.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def parent_id(self):
        """Gets the parent_id of this ImageSummary.  # noqa: E501


        :return: The parent_id of this ImageSummary.  # noqa: E501
        :rtype: str
        """
        return self._parent_id

    @parent_id.setter
    def parent_id(self, parent_id):
        """Sets the parent_id of this ImageSummary.


        :param parent_id: The parent_id of this ImageSummary.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and parent_id is None:
            raise ValueError("Invalid value for `parent_id`, must not be `None`")  # noqa: E501

        self._parent_id = parent_id

    @property
    def repo_tags(self):
        """Gets the repo_tags of this ImageSummary.  # noqa: E501


        :return: The repo_tags of this ImageSummary.  # noqa: E501
        :rtype: list[str]
        """
        return self._repo_tags

    @repo_tags.setter
    def repo_tags(self, repo_tags):
        """Sets the repo_tags of this ImageSummary.


        :param repo_tags: The repo_tags of this ImageSummary.  # noqa: E501
        :type: list[str]
        """
        if self._configuration.client_side_validation and repo_tags is None:
            raise ValueError("Invalid value for `repo_tags`, must not be `None`")  # noqa: E501

        self._repo_tags = repo_tags

    @property
    def repo_digests(self):
        """Gets the repo_digests of this ImageSummary.  # noqa: E501


        :return: The repo_digests of this ImageSummary.  # noqa: E501
        :rtype: list[str]
        """
        return self._repo_digests

    @repo_digests.setter
    def repo_digests(self, repo_digests):
        """Sets the repo_digests of this ImageSummary.


        :param repo_digests: The repo_digests of this ImageSummary.  # noqa: E501
        :type: list[str]
        """
        if self._configuration.client_side_validation and repo_digests is None:
            raise ValueError("Invalid value for `repo_digests`, must not be `None`")  # noqa: E501

        self._repo_digests = repo_digests

    @property
    def created(self):
        """Gets the created of this ImageSummary.  # noqa: E501


        :return: The created of this ImageSummary.  # noqa: E501
        :rtype: int
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this ImageSummary.


        :param created: The created of this ImageSummary.  # noqa: E501
        :type: int
        """
        if self._configuration.client_side_validation and created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")  # noqa: E501

        self._created = created

    @property
    def size(self):
        """Gets the size of this ImageSummary.  # noqa: E501


        :return: The size of this ImageSummary.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this ImageSummary.


        :param size: The size of this ImageSummary.  # noqa: E501
        :type: int
        """
        if self._configuration.client_side_validation and size is None:
            raise ValueError("Invalid value for `size`, must not be `None`")  # noqa: E501

        self._size = size

    @property
    def shared_size(self):
        """Gets the shared_size of this ImageSummary.  # noqa: E501


        :return: The shared_size of this ImageSummary.  # noqa: E501
        :rtype: int
        """
        return self._shared_size

    @shared_size.setter
    def shared_size(self, shared_size):
        """Sets the shared_size of this ImageSummary.


        :param shared_size: The shared_size of this ImageSummary.  # noqa: E501
        :type: int
        """
        if self._configuration.client_side_validation and shared_size is None:
            raise ValueError("Invalid value for `shared_size`, must not be `None`")  # noqa: E501

        self._shared_size = shared_size

    @property
    def virtual_size(self):
        """Gets the virtual_size of this ImageSummary.  # noqa: E501


        :return: The virtual_size of this ImageSummary.  # noqa: E501
        :rtype: int
        """
        return self._virtual_size

    @virtual_size.setter
    def virtual_size(self, virtual_size):
        """Sets the virtual_size of this ImageSummary.


        :param virtual_size: The virtual_size of this ImageSummary.  # noqa: E501
        :type: int
        """
        if self._configuration.client_side_validation and virtual_size is None:
            raise ValueError("Invalid value for `virtual_size`, must not be `None`")  # noqa: E501

        self._virtual_size = virtual_size

    @property
    def labels(self):
        """Gets the labels of this ImageSummary.  # noqa: E501


        :return: The labels of this ImageSummary.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this ImageSummary.


        :param labels: The labels of this ImageSummary.  # noqa: E501
        :type: dict(str, str)
        """
        if self._configuration.client_side_validation and labels is None:
            raise ValueError("Invalid value for `labels`, must not be `None`")  # noqa: E501

        self._labels = labels

    @property
    def containers(self):
        """Gets the containers of this ImageSummary.  # noqa: E501


        :return: The containers of this ImageSummary.  # noqa: E501
        :rtype: int
        """
        return self._containers

    @containers.setter
    def containers(self, containers):
        """Sets the containers of this ImageSummary.


        :param containers: The containers of this ImageSummary.  # noqa: E501
        :type: int
        """
        if self._configuration.client_side_validation and containers is None:
            raise ValueError("Invalid value for `containers`, must not be `None`")  # noqa: E501

        self._containers = containers

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ImageSummary, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ImageSummary):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ImageSummary):
            return True

        return self.to_dict() != other.to_dict()
