# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class Mount(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'target': 'str',
        'source': 'str',
        'type': 'str',
        'read_only': 'bool',
        'consistency': 'str',
        'bind_options': 'MountBindOptions',
        'volume_options': 'MountVolumeOptions',
        'tmpfs_options': 'MountTmpfsOptions'
    }

    attribute_map = {
        'target': 'Target',
        'source': 'Source',
        'type': 'Type',
        'read_only': 'ReadOnly',
        'consistency': 'Consistency',
        'bind_options': 'BindOptions',
        'volume_options': 'VolumeOptions',
        'tmpfs_options': 'TmpfsOptions'
    }

    def __init__(self, target=None, source=None, type=None, read_only=None, consistency=None, bind_options=None, volume_options=None, tmpfs_options=None, _configuration=None):  # noqa: E501
        """Mount - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._target = None
        self._source = None
        self._type = None
        self._read_only = None
        self._consistency = None
        self._bind_options = None
        self._volume_options = None
        self._tmpfs_options = None
        self.discriminator = None

        if target is not None:
            self.target = target
        if source is not None:
            self.source = source
        if type is not None:
            self.type = type
        if read_only is not None:
            self.read_only = read_only
        if consistency is not None:
            self.consistency = consistency
        if bind_options is not None:
            self.bind_options = bind_options
        if volume_options is not None:
            self.volume_options = volume_options
        if tmpfs_options is not None:
            self.tmpfs_options = tmpfs_options

    @property
    def target(self):
        """Gets the target of this Mount.  # noqa: E501

        Container path.  # noqa: E501

        :return: The target of this Mount.  # noqa: E501
        :rtype: str
        """
        return self._target

    @target.setter
    def target(self, target):
        """Sets the target of this Mount.

        Container path.  # noqa: E501

        :param target: The target of this Mount.  # noqa: E501
        :type: str
        """

        self._target = target

    @property
    def source(self):
        """Gets the source of this Mount.  # noqa: E501

        Mount source (e.g. a volume name, a host path).  # noqa: E501

        :return: The source of this Mount.  # noqa: E501
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """Sets the source of this Mount.

        Mount source (e.g. a volume name, a host path).  # noqa: E501

        :param source: The source of this Mount.  # noqa: E501
        :type: str
        """

        self._source = source

    @property
    def type(self):
        """Gets the type of this Mount.  # noqa: E501

        The mount type. Available types:  - `bind` Mounts a file or directory from the host into the container. Must exist prior to creating the container. - `volume` Creates a volume with the given name and options (or uses a pre-existing volume with the same name and options). These are **not** removed when the container is removed. - `tmpfs` Create a tmpfs with the given options. The mount source cannot be specified for tmpfs. - `npipe` Mounts a named pipe from the host into the container. Must exist prior to creating the container.   # noqa: E501

        :return: The type of this Mount.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Mount.

        The mount type. Available types:  - `bind` Mounts a file or directory from the host into the container. Must exist prior to creating the container. - `volume` Creates a volume with the given name and options (or uses a pre-existing volume with the same name and options). These are **not** removed when the container is removed. - `tmpfs` Create a tmpfs with the given options. The mount source cannot be specified for tmpfs. - `npipe` Mounts a named pipe from the host into the container. Must exist prior to creating the container.   # noqa: E501

        :param type: The type of this Mount.  # noqa: E501
        :type: str
        """
        allowed_values = ["bind", "volume", "tmpfs", "npipe"]  # noqa: E501
        if (self._configuration.client_side_validation and
                type not in allowed_values):
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def read_only(self):
        """Gets the read_only of this Mount.  # noqa: E501

        Whether the mount should be read-only.  # noqa: E501

        :return: The read_only of this Mount.  # noqa: E501
        :rtype: bool
        """
        return self._read_only

    @read_only.setter
    def read_only(self, read_only):
        """Sets the read_only of this Mount.

        Whether the mount should be read-only.  # noqa: E501

        :param read_only: The read_only of this Mount.  # noqa: E501
        :type: bool
        """

        self._read_only = read_only

    @property
    def consistency(self):
        """Gets the consistency of this Mount.  # noqa: E501

        The consistency requirement for the mount: `default`, `consistent`, `cached`, or `delegated`.  # noqa: E501

        :return: The consistency of this Mount.  # noqa: E501
        :rtype: str
        """
        return self._consistency

    @consistency.setter
    def consistency(self, consistency):
        """Sets the consistency of this Mount.

        The consistency requirement for the mount: `default`, `consistent`, `cached`, or `delegated`.  # noqa: E501

        :param consistency: The consistency of this Mount.  # noqa: E501
        :type: str
        """

        self._consistency = consistency

    @property
    def bind_options(self):
        """Gets the bind_options of this Mount.  # noqa: E501


        :return: The bind_options of this Mount.  # noqa: E501
        :rtype: MountBindOptions
        """
        return self._bind_options

    @bind_options.setter
    def bind_options(self, bind_options):
        """Sets the bind_options of this Mount.


        :param bind_options: The bind_options of this Mount.  # noqa: E501
        :type: MountBindOptions
        """

        self._bind_options = bind_options

    @property
    def volume_options(self):
        """Gets the volume_options of this Mount.  # noqa: E501


        :return: The volume_options of this Mount.  # noqa: E501
        :rtype: MountVolumeOptions
        """
        return self._volume_options

    @volume_options.setter
    def volume_options(self, volume_options):
        """Sets the volume_options of this Mount.


        :param volume_options: The volume_options of this Mount.  # noqa: E501
        :type: MountVolumeOptions
        """

        self._volume_options = volume_options

    @property
    def tmpfs_options(self):
        """Gets the tmpfs_options of this Mount.  # noqa: E501


        :return: The tmpfs_options of this Mount.  # noqa: E501
        :rtype: MountTmpfsOptions
        """
        return self._tmpfs_options

    @tmpfs_options.setter
    def tmpfs_options(self, tmpfs_options):
        """Sets the tmpfs_options of this Mount.


        :param tmpfs_options: The tmpfs_options of this Mount.  # noqa: E501
        :type: MountTmpfsOptions
        """

        self._tmpfs_options = tmpfs_options

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Mount, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Mount):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Mount):
            return True

        return self.to_dict() != other.to_dict()
