# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class Network(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'id': 'str',
        'created': 'str',
        'scope': 'str',
        'driver': 'str',
        'enable_i_pv6': 'bool',
        'ipam': 'IPAM',
        'internal': 'bool',
        'attachable': 'bool',
        'ingress': 'bool',
        'containers': 'dict(str, NetworkContainer)',
        'options': 'dict(str, str)',
        'labels': 'dict(str, str)'
    }

    attribute_map = {
        'name': 'Name',
        'id': 'Id',
        'created': 'Created',
        'scope': 'Scope',
        'driver': 'Driver',
        'enable_i_pv6': 'EnableIPv6',
        'ipam': 'IPAM',
        'internal': 'Internal',
        'attachable': 'Attachable',
        'ingress': 'Ingress',
        'containers': 'Containers',
        'options': 'Options',
        'labels': 'Labels'
    }

    def __init__(self, name=None, id=None, created=None, scope=None, driver=None, enable_i_pv6=None, ipam=None, internal=None, attachable=None, ingress=None, containers=None, options=None, labels=None, _configuration=None):  # noqa: E501
        """Network - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._name = None
        self._id = None
        self._created = None
        self._scope = None
        self._driver = None
        self._enable_i_pv6 = None
        self._ipam = None
        self._internal = None
        self._attachable = None
        self._ingress = None
        self._containers = None
        self._options = None
        self._labels = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if id is not None:
            self.id = id
        if created is not None:
            self.created = created
        if scope is not None:
            self.scope = scope
        if driver is not None:
            self.driver = driver
        if enable_i_pv6 is not None:
            self.enable_i_pv6 = enable_i_pv6
        if ipam is not None:
            self.ipam = ipam
        if internal is not None:
            self.internal = internal
        if attachable is not None:
            self.attachable = attachable
        if ingress is not None:
            self.ingress = ingress
        if containers is not None:
            self.containers = containers
        if options is not None:
            self.options = options
        if labels is not None:
            self.labels = labels

    @property
    def name(self):
        """Gets the name of this Network.  # noqa: E501


        :return: The name of this Network.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Network.


        :param name: The name of this Network.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def id(self):
        """Gets the id of this Network.  # noqa: E501


        :return: The id of this Network.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Network.


        :param id: The id of this Network.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def created(self):
        """Gets the created of this Network.  # noqa: E501


        :return: The created of this Network.  # noqa: E501
        :rtype: str
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this Network.


        :param created: The created of this Network.  # noqa: E501
        :type: str
        """

        self._created = created

    @property
    def scope(self):
        """Gets the scope of this Network.  # noqa: E501


        :return: The scope of this Network.  # noqa: E501
        :rtype: str
        """
        return self._scope

    @scope.setter
    def scope(self, scope):
        """Sets the scope of this Network.


        :param scope: The scope of this Network.  # noqa: E501
        :type: str
        """

        self._scope = scope

    @property
    def driver(self):
        """Gets the driver of this Network.  # noqa: E501


        :return: The driver of this Network.  # noqa: E501
        :rtype: str
        """
        return self._driver

    @driver.setter
    def driver(self, driver):
        """Sets the driver of this Network.


        :param driver: The driver of this Network.  # noqa: E501
        :type: str
        """

        self._driver = driver

    @property
    def enable_i_pv6(self):
        """Gets the enable_i_pv6 of this Network.  # noqa: E501


        :return: The enable_i_pv6 of this Network.  # noqa: E501
        :rtype: bool
        """
        return self._enable_i_pv6

    @enable_i_pv6.setter
    def enable_i_pv6(self, enable_i_pv6):
        """Sets the enable_i_pv6 of this Network.


        :param enable_i_pv6: The enable_i_pv6 of this Network.  # noqa: E501
        :type: bool
        """

        self._enable_i_pv6 = enable_i_pv6

    @property
    def ipam(self):
        """Gets the ipam of this Network.  # noqa: E501


        :return: The ipam of this Network.  # noqa: E501
        :rtype: IPAM
        """
        return self._ipam

    @ipam.setter
    def ipam(self, ipam):
        """Sets the ipam of this Network.


        :param ipam: The ipam of this Network.  # noqa: E501
        :type: IPAM
        """

        self._ipam = ipam

    @property
    def internal(self):
        """Gets the internal of this Network.  # noqa: E501


        :return: The internal of this Network.  # noqa: E501
        :rtype: bool
        """
        return self._internal

    @internal.setter
    def internal(self, internal):
        """Sets the internal of this Network.


        :param internal: The internal of this Network.  # noqa: E501
        :type: bool
        """

        self._internal = internal

    @property
    def attachable(self):
        """Gets the attachable of this Network.  # noqa: E501


        :return: The attachable of this Network.  # noqa: E501
        :rtype: bool
        """
        return self._attachable

    @attachable.setter
    def attachable(self, attachable):
        """Sets the attachable of this Network.


        :param attachable: The attachable of this Network.  # noqa: E501
        :type: bool
        """

        self._attachable = attachable

    @property
    def ingress(self):
        """Gets the ingress of this Network.  # noqa: E501


        :return: The ingress of this Network.  # noqa: E501
        :rtype: bool
        """
        return self._ingress

    @ingress.setter
    def ingress(self, ingress):
        """Sets the ingress of this Network.


        :param ingress: The ingress of this Network.  # noqa: E501
        :type: bool
        """

        self._ingress = ingress

    @property
    def containers(self):
        """Gets the containers of this Network.  # noqa: E501


        :return: The containers of this Network.  # noqa: E501
        :rtype: dict(str, NetworkContainer)
        """
        return self._containers

    @containers.setter
    def containers(self, containers):
        """Sets the containers of this Network.


        :param containers: The containers of this Network.  # noqa: E501
        :type: dict(str, NetworkContainer)
        """

        self._containers = containers

    @property
    def options(self):
        """Gets the options of this Network.  # noqa: E501


        :return: The options of this Network.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this Network.


        :param options: The options of this Network.  # noqa: E501
        :type: dict(str, str)
        """

        self._options = options

    @property
    def labels(self):
        """Gets the labels of this Network.  # noqa: E501


        :return: The labels of this Network.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this Network.


        :param labels: The labels of this Network.  # noqa: E501
        :type: dict(str, str)
        """

        self._labels = labels

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Network, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Network):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Network):
            return True

        return self.to_dict() != other.to_dict()
