# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class NetworkCreateRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'check_duplicate': 'bool',
        'driver': 'str',
        'internal': 'bool',
        'attachable': 'bool',
        'ingress': 'bool',
        'ipam': 'IPAM',
        'enable_i_pv6': 'bool',
        'options': 'dict(str, str)',
        'labels': 'dict(str, str)'
    }

    attribute_map = {
        'name': 'Name',
        'check_duplicate': 'CheckDuplicate',
        'driver': 'Driver',
        'internal': 'Internal',
        'attachable': 'Attachable',
        'ingress': 'Ingress',
        'ipam': 'IPAM',
        'enable_i_pv6': 'EnableIPv6',
        'options': 'Options',
        'labels': 'Labels'
    }

    def __init__(self, name=None, check_duplicate=None, driver='bridge', internal=None, attachable=None, ingress=None, ipam=None, enable_i_pv6=None, options=None, labels=None, _configuration=None):  # noqa: E501
        """NetworkCreateRequest - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._name = None
        self._check_duplicate = None
        self._driver = None
        self._internal = None
        self._attachable = None
        self._ingress = None
        self._ipam = None
        self._enable_i_pv6 = None
        self._options = None
        self._labels = None
        self.discriminator = None

        self.name = name
        if check_duplicate is not None:
            self.check_duplicate = check_duplicate
        if driver is not None:
            self.driver = driver
        if internal is not None:
            self.internal = internal
        if attachable is not None:
            self.attachable = attachable
        if ingress is not None:
            self.ingress = ingress
        if ipam is not None:
            self.ipam = ipam
        if enable_i_pv6 is not None:
            self.enable_i_pv6 = enable_i_pv6
        if options is not None:
            self.options = options
        if labels is not None:
            self.labels = labels

    @property
    def name(self):
        """Gets the name of this NetworkCreateRequest.  # noqa: E501

        The network's name.  # noqa: E501

        :return: The name of this NetworkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this NetworkCreateRequest.

        The network's name.  # noqa: E501

        :param name: The name of this NetworkCreateRequest.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def check_duplicate(self):
        """Gets the check_duplicate of this NetworkCreateRequest.  # noqa: E501

        Check for networks with duplicate names. Since Network is primarily keyed based on a random ID and not on the name, and network name is strictly a user-friendly alias to the network which is uniquely identified using ID, there is no guaranteed way to check for duplicates. CheckDuplicate is there to provide a best effort checking of any networks which has the same name but it is not guaranteed to catch all name collisions.   # noqa: E501

        :return: The check_duplicate of this NetworkCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._check_duplicate

    @check_duplicate.setter
    def check_duplicate(self, check_duplicate):
        """Sets the check_duplicate of this NetworkCreateRequest.

        Check for networks with duplicate names. Since Network is primarily keyed based on a random ID and not on the name, and network name is strictly a user-friendly alias to the network which is uniquely identified using ID, there is no guaranteed way to check for duplicates. CheckDuplicate is there to provide a best effort checking of any networks which has the same name but it is not guaranteed to catch all name collisions.   # noqa: E501

        :param check_duplicate: The check_duplicate of this NetworkCreateRequest.  # noqa: E501
        :type: bool
        """

        self._check_duplicate = check_duplicate

    @property
    def driver(self):
        """Gets the driver of this NetworkCreateRequest.  # noqa: E501

        Name of the network driver plugin to use.  # noqa: E501

        :return: The driver of this NetworkCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._driver

    @driver.setter
    def driver(self, driver):
        """Sets the driver of this NetworkCreateRequest.

        Name of the network driver plugin to use.  # noqa: E501

        :param driver: The driver of this NetworkCreateRequest.  # noqa: E501
        :type: str
        """

        self._driver = driver

    @property
    def internal(self):
        """Gets the internal of this NetworkCreateRequest.  # noqa: E501

        Restrict external access to the network.  # noqa: E501

        :return: The internal of this NetworkCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._internal

    @internal.setter
    def internal(self, internal):
        """Sets the internal of this NetworkCreateRequest.

        Restrict external access to the network.  # noqa: E501

        :param internal: The internal of this NetworkCreateRequest.  # noqa: E501
        :type: bool
        """

        self._internal = internal

    @property
    def attachable(self):
        """Gets the attachable of this NetworkCreateRequest.  # noqa: E501

        Globally scoped network is manually attachable by regular containers from workers in swarm mode.   # noqa: E501

        :return: The attachable of this NetworkCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._attachable

    @attachable.setter
    def attachable(self, attachable):
        """Sets the attachable of this NetworkCreateRequest.

        Globally scoped network is manually attachable by regular containers from workers in swarm mode.   # noqa: E501

        :param attachable: The attachable of this NetworkCreateRequest.  # noqa: E501
        :type: bool
        """

        self._attachable = attachable

    @property
    def ingress(self):
        """Gets the ingress of this NetworkCreateRequest.  # noqa: E501

        Ingress network is the network which provides the routing-mesh in swarm mode.   # noqa: E501

        :return: The ingress of this NetworkCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._ingress

    @ingress.setter
    def ingress(self, ingress):
        """Sets the ingress of this NetworkCreateRequest.

        Ingress network is the network which provides the routing-mesh in swarm mode.   # noqa: E501

        :param ingress: The ingress of this NetworkCreateRequest.  # noqa: E501
        :type: bool
        """

        self._ingress = ingress

    @property
    def ipam(self):
        """Gets the ipam of this NetworkCreateRequest.  # noqa: E501

        Optional custom IP scheme for the network.  # noqa: E501

        :return: The ipam of this NetworkCreateRequest.  # noqa: E501
        :rtype: IPAM
        """
        return self._ipam

    @ipam.setter
    def ipam(self, ipam):
        """Sets the ipam of this NetworkCreateRequest.

        Optional custom IP scheme for the network.  # noqa: E501

        :param ipam: The ipam of this NetworkCreateRequest.  # noqa: E501
        :type: IPAM
        """

        self._ipam = ipam

    @property
    def enable_i_pv6(self):
        """Gets the enable_i_pv6 of this NetworkCreateRequest.  # noqa: E501

        Enable IPv6 on the network.  # noqa: E501

        :return: The enable_i_pv6 of this NetworkCreateRequest.  # noqa: E501
        :rtype: bool
        """
        return self._enable_i_pv6

    @enable_i_pv6.setter
    def enable_i_pv6(self, enable_i_pv6):
        """Sets the enable_i_pv6 of this NetworkCreateRequest.

        Enable IPv6 on the network.  # noqa: E501

        :param enable_i_pv6: The enable_i_pv6 of this NetworkCreateRequest.  # noqa: E501
        :type: bool
        """

        self._enable_i_pv6 = enable_i_pv6

    @property
    def options(self):
        """Gets the options of this NetworkCreateRequest.  # noqa: E501

        Network specific options to be used by the drivers.  # noqa: E501

        :return: The options of this NetworkCreateRequest.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this NetworkCreateRequest.

        Network specific options to be used by the drivers.  # noqa: E501

        :param options: The options of this NetworkCreateRequest.  # noqa: E501
        :type: dict(str, str)
        """

        self._options = options

    @property
    def labels(self):
        """Gets the labels of this NetworkCreateRequest.  # noqa: E501

        User-defined key/value metadata.  # noqa: E501

        :return: The labels of this NetworkCreateRequest.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this NetworkCreateRequest.

        User-defined key/value metadata.  # noqa: E501

        :param labels: The labels of this NetworkCreateRequest.  # noqa: E501
        :type: dict(str, str)
        """

        self._labels = labels

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(NetworkCreateRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NetworkCreateRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NetworkCreateRequest):
            return True

        return self.to_dict() != other.to_dict()
