# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class PluginConfig(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'docker_version': 'str',
        'description': 'str',
        'documentation': 'str',
        'interface': 'PluginConfigInterface',
        'entrypoint': 'list[str]',
        'work_dir': 'str',
        'user': 'PluginConfigUser',
        'network': 'PluginConfigNetwork',
        'linux': 'PluginConfigLinux',
        'propagated_mount': 'str',
        'ipc_host': 'bool',
        'pid_host': 'bool',
        'mounts': 'list[PluginMount]',
        'env': 'list[PluginEnv]',
        'args': 'PluginConfigArgs',
        'rootfs': 'PluginConfigRootfs'
    }

    attribute_map = {
        'docker_version': 'DockerVersion',
        'description': 'Description',
        'documentation': 'Documentation',
        'interface': 'Interface',
        'entrypoint': 'Entrypoint',
        'work_dir': 'WorkDir',
        'user': 'User',
        'network': 'Network',
        'linux': 'Linux',
        'propagated_mount': 'PropagatedMount',
        'ipc_host': 'IpcHost',
        'pid_host': 'PidHost',
        'mounts': 'Mounts',
        'env': 'Env',
        'args': 'Args',
        'rootfs': 'rootfs'
    }

    def __init__(self, docker_version=None, description=None, documentation=None, interface=None, entrypoint=None, work_dir=None, user=None, network=None, linux=None, propagated_mount=None, ipc_host=None, pid_host=None, mounts=None, env=None, args=None, rootfs=None, _configuration=None):  # noqa: E501
        """PluginConfig - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._docker_version = None
        self._description = None
        self._documentation = None
        self._interface = None
        self._entrypoint = None
        self._work_dir = None
        self._user = None
        self._network = None
        self._linux = None
        self._propagated_mount = None
        self._ipc_host = None
        self._pid_host = None
        self._mounts = None
        self._env = None
        self._args = None
        self._rootfs = None
        self.discriminator = None

        if docker_version is not None:
            self.docker_version = docker_version
        self.description = description
        self.documentation = documentation
        self.interface = interface
        self.entrypoint = entrypoint
        self.work_dir = work_dir
        if user is not None:
            self.user = user
        self.network = network
        self.linux = linux
        self.propagated_mount = propagated_mount
        self.ipc_host = ipc_host
        self.pid_host = pid_host
        self.mounts = mounts
        self.env = env
        self.args = args
        if rootfs is not None:
            self.rootfs = rootfs

    @property
    def docker_version(self):
        """Gets the docker_version of this PluginConfig.  # noqa: E501

        Docker Version used to create the plugin  # noqa: E501

        :return: The docker_version of this PluginConfig.  # noqa: E501
        :rtype: str
        """
        return self._docker_version

    @docker_version.setter
    def docker_version(self, docker_version):
        """Sets the docker_version of this PluginConfig.

        Docker Version used to create the plugin  # noqa: E501

        :param docker_version: The docker_version of this PluginConfig.  # noqa: E501
        :type: str
        """

        self._docker_version = docker_version

    @property
    def description(self):
        """Gets the description of this PluginConfig.  # noqa: E501


        :return: The description of this PluginConfig.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this PluginConfig.


        :param description: The description of this PluginConfig.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and description is None:
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def documentation(self):
        """Gets the documentation of this PluginConfig.  # noqa: E501


        :return: The documentation of this PluginConfig.  # noqa: E501
        :rtype: str
        """
        return self._documentation

    @documentation.setter
    def documentation(self, documentation):
        """Sets the documentation of this PluginConfig.


        :param documentation: The documentation of this PluginConfig.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and documentation is None:
            raise ValueError("Invalid value for `documentation`, must not be `None`")  # noqa: E501

        self._documentation = documentation

    @property
    def interface(self):
        """Gets the interface of this PluginConfig.  # noqa: E501


        :return: The interface of this PluginConfig.  # noqa: E501
        :rtype: PluginConfigInterface
        """
        return self._interface

    @interface.setter
    def interface(self, interface):
        """Sets the interface of this PluginConfig.


        :param interface: The interface of this PluginConfig.  # noqa: E501
        :type: PluginConfigInterface
        """
        if self._configuration.client_side_validation and interface is None:
            raise ValueError("Invalid value for `interface`, must not be `None`")  # noqa: E501

        self._interface = interface

    @property
    def entrypoint(self):
        """Gets the entrypoint of this PluginConfig.  # noqa: E501


        :return: The entrypoint of this PluginConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._entrypoint

    @entrypoint.setter
    def entrypoint(self, entrypoint):
        """Sets the entrypoint of this PluginConfig.


        :param entrypoint: The entrypoint of this PluginConfig.  # noqa: E501
        :type: list[str]
        """
        if self._configuration.client_side_validation and entrypoint is None:
            raise ValueError("Invalid value for `entrypoint`, must not be `None`")  # noqa: E501

        self._entrypoint = entrypoint

    @property
    def work_dir(self):
        """Gets the work_dir of this PluginConfig.  # noqa: E501


        :return: The work_dir of this PluginConfig.  # noqa: E501
        :rtype: str
        """
        return self._work_dir

    @work_dir.setter
    def work_dir(self, work_dir):
        """Sets the work_dir of this PluginConfig.


        :param work_dir: The work_dir of this PluginConfig.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and work_dir is None:
            raise ValueError("Invalid value for `work_dir`, must not be `None`")  # noqa: E501

        self._work_dir = work_dir

    @property
    def user(self):
        """Gets the user of this PluginConfig.  # noqa: E501


        :return: The user of this PluginConfig.  # noqa: E501
        :rtype: PluginConfigUser
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this PluginConfig.


        :param user: The user of this PluginConfig.  # noqa: E501
        :type: PluginConfigUser
        """

        self._user = user

    @property
    def network(self):
        """Gets the network of this PluginConfig.  # noqa: E501


        :return: The network of this PluginConfig.  # noqa: E501
        :rtype: PluginConfigNetwork
        """
        return self._network

    @network.setter
    def network(self, network):
        """Sets the network of this PluginConfig.


        :param network: The network of this PluginConfig.  # noqa: E501
        :type: PluginConfigNetwork
        """
        if self._configuration.client_side_validation and network is None:
            raise ValueError("Invalid value for `network`, must not be `None`")  # noqa: E501

        self._network = network

    @property
    def linux(self):
        """Gets the linux of this PluginConfig.  # noqa: E501


        :return: The linux of this PluginConfig.  # noqa: E501
        :rtype: PluginConfigLinux
        """
        return self._linux

    @linux.setter
    def linux(self, linux):
        """Sets the linux of this PluginConfig.


        :param linux: The linux of this PluginConfig.  # noqa: E501
        :type: PluginConfigLinux
        """
        if self._configuration.client_side_validation and linux is None:
            raise ValueError("Invalid value for `linux`, must not be `None`")  # noqa: E501

        self._linux = linux

    @property
    def propagated_mount(self):
        """Gets the propagated_mount of this PluginConfig.  # noqa: E501


        :return: The propagated_mount of this PluginConfig.  # noqa: E501
        :rtype: str
        """
        return self._propagated_mount

    @propagated_mount.setter
    def propagated_mount(self, propagated_mount):
        """Sets the propagated_mount of this PluginConfig.


        :param propagated_mount: The propagated_mount of this PluginConfig.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and propagated_mount is None:
            raise ValueError("Invalid value for `propagated_mount`, must not be `None`")  # noqa: E501

        self._propagated_mount = propagated_mount

    @property
    def ipc_host(self):
        """Gets the ipc_host of this PluginConfig.  # noqa: E501


        :return: The ipc_host of this PluginConfig.  # noqa: E501
        :rtype: bool
        """
        return self._ipc_host

    @ipc_host.setter
    def ipc_host(self, ipc_host):
        """Sets the ipc_host of this PluginConfig.


        :param ipc_host: The ipc_host of this PluginConfig.  # noqa: E501
        :type: bool
        """
        if self._configuration.client_side_validation and ipc_host is None:
            raise ValueError("Invalid value for `ipc_host`, must not be `None`")  # noqa: E501

        self._ipc_host = ipc_host

    @property
    def pid_host(self):
        """Gets the pid_host of this PluginConfig.  # noqa: E501


        :return: The pid_host of this PluginConfig.  # noqa: E501
        :rtype: bool
        """
        return self._pid_host

    @pid_host.setter
    def pid_host(self, pid_host):
        """Sets the pid_host of this PluginConfig.


        :param pid_host: The pid_host of this PluginConfig.  # noqa: E501
        :type: bool
        """
        if self._configuration.client_side_validation and pid_host is None:
            raise ValueError("Invalid value for `pid_host`, must not be `None`")  # noqa: E501

        self._pid_host = pid_host

    @property
    def mounts(self):
        """Gets the mounts of this PluginConfig.  # noqa: E501


        :return: The mounts of this PluginConfig.  # noqa: E501
        :rtype: list[PluginMount]
        """
        return self._mounts

    @mounts.setter
    def mounts(self, mounts):
        """Sets the mounts of this PluginConfig.


        :param mounts: The mounts of this PluginConfig.  # noqa: E501
        :type: list[PluginMount]
        """
        if self._configuration.client_side_validation and mounts is None:
            raise ValueError("Invalid value for `mounts`, must not be `None`")  # noqa: E501

        self._mounts = mounts

    @property
    def env(self):
        """Gets the env of this PluginConfig.  # noqa: E501


        :return: The env of this PluginConfig.  # noqa: E501
        :rtype: list[PluginEnv]
        """
        return self._env

    @env.setter
    def env(self, env):
        """Sets the env of this PluginConfig.


        :param env: The env of this PluginConfig.  # noqa: E501
        :type: list[PluginEnv]
        """
        if self._configuration.client_side_validation and env is None:
            raise ValueError("Invalid value for `env`, must not be `None`")  # noqa: E501

        self._env = env

    @property
    def args(self):
        """Gets the args of this PluginConfig.  # noqa: E501


        :return: The args of this PluginConfig.  # noqa: E501
        :rtype: PluginConfigArgs
        """
        return self._args

    @args.setter
    def args(self, args):
        """Sets the args of this PluginConfig.


        :param args: The args of this PluginConfig.  # noqa: E501
        :type: PluginConfigArgs
        """
        if self._configuration.client_side_validation and args is None:
            raise ValueError("Invalid value for `args`, must not be `None`")  # noqa: E501

        self._args = args

    @property
    def rootfs(self):
        """Gets the rootfs of this PluginConfig.  # noqa: E501


        :return: The rootfs of this PluginConfig.  # noqa: E501
        :rtype: PluginConfigRootfs
        """
        return self._rootfs

    @rootfs.setter
    def rootfs(self, rootfs):
        """Sets the rootfs of this PluginConfig.


        :param rootfs: The rootfs of this PluginConfig.  # noqa: E501
        :type: PluginConfigRootfs
        """

        self._rootfs = rootfs

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PluginConfig, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PluginConfig):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PluginConfig):
            return True

        return self.to_dict() != other.to_dict()
