# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class RegistryServiceConfig(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'allow_nondistributable_artifacts_cid_rs': 'list[str]',
        'allow_nondistributable_artifacts_hostnames': 'list[str]',
        'insecure_registry_cid_rs': 'list[str]',
        'index_configs': 'dict(str, IndexInfo)',
        'mirrors': 'list[str]'
    }

    attribute_map = {
        'allow_nondistributable_artifacts_cid_rs': 'AllowNondistributableArtifactsCIDRs',
        'allow_nondistributable_artifacts_hostnames': 'AllowNondistributableArtifactsHostnames',
        'insecure_registry_cid_rs': 'InsecureRegistryCIDRs',
        'index_configs': 'IndexConfigs',
        'mirrors': 'Mirrors'
    }

    def __init__(self, allow_nondistributable_artifacts_cid_rs=None, allow_nondistributable_artifacts_hostnames=None, insecure_registry_cid_rs=None, index_configs=None, mirrors=None, _configuration=None):  # noqa: E501
        """RegistryServiceConfig - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._allow_nondistributable_artifacts_cid_rs = None
        self._allow_nondistributable_artifacts_hostnames = None
        self._insecure_registry_cid_rs = None
        self._index_configs = None
        self._mirrors = None
        self.discriminator = None

        if allow_nondistributable_artifacts_cid_rs is not None:
            self.allow_nondistributable_artifacts_cid_rs = allow_nondistributable_artifacts_cid_rs
        if allow_nondistributable_artifacts_hostnames is not None:
            self.allow_nondistributable_artifacts_hostnames = allow_nondistributable_artifacts_hostnames
        if insecure_registry_cid_rs is not None:
            self.insecure_registry_cid_rs = insecure_registry_cid_rs
        if index_configs is not None:
            self.index_configs = index_configs
        if mirrors is not None:
            self.mirrors = mirrors

    @property
    def allow_nondistributable_artifacts_cid_rs(self):
        """Gets the allow_nondistributable_artifacts_cid_rs of this RegistryServiceConfig.  # noqa: E501

        List of IP ranges to which nondistributable artifacts can be pushed, using the CIDR syntax [RFC 4632](https://tools.ietf.org/html/4632).  Some images (for example, Windows base images) contain artifacts whose distribution is restricted by license. When these images are pushed to a registry, restricted artifacts are not included.  This configuration override this behavior, and enables the daemon to push nondistributable artifacts to all registries whose resolved IP address is within the subnet described by the CIDR syntax.  This option is useful when pushing images containing nondistributable artifacts to a registry on an air-gapped network so hosts on that network can pull the images without connecting to another server.  > **Warning**: Nondistributable artifacts typically have restrictions > on how and where they can be distributed and shared. Only use this > feature to push artifacts to private registries and ensure that you > are in compliance with any terms that cover redistributing > nondistributable artifacts.   # noqa: E501

        :return: The allow_nondistributable_artifacts_cid_rs of this RegistryServiceConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._allow_nondistributable_artifacts_cid_rs

    @allow_nondistributable_artifacts_cid_rs.setter
    def allow_nondistributable_artifacts_cid_rs(self, allow_nondistributable_artifacts_cid_rs):
        """Sets the allow_nondistributable_artifacts_cid_rs of this RegistryServiceConfig.

        List of IP ranges to which nondistributable artifacts can be pushed, using the CIDR syntax [RFC 4632](https://tools.ietf.org/html/4632).  Some images (for example, Windows base images) contain artifacts whose distribution is restricted by license. When these images are pushed to a registry, restricted artifacts are not included.  This configuration override this behavior, and enables the daemon to push nondistributable artifacts to all registries whose resolved IP address is within the subnet described by the CIDR syntax.  This option is useful when pushing images containing nondistributable artifacts to a registry on an air-gapped network so hosts on that network can pull the images without connecting to another server.  > **Warning**: Nondistributable artifacts typically have restrictions > on how and where they can be distributed and shared. Only use this > feature to push artifacts to private registries and ensure that you > are in compliance with any terms that cover redistributing > nondistributable artifacts.   # noqa: E501

        :param allow_nondistributable_artifacts_cid_rs: The allow_nondistributable_artifacts_cid_rs of this RegistryServiceConfig.  # noqa: E501
        :type: list[str]
        """

        self._allow_nondistributable_artifacts_cid_rs = allow_nondistributable_artifacts_cid_rs

    @property
    def allow_nondistributable_artifacts_hostnames(self):
        """Gets the allow_nondistributable_artifacts_hostnames of this RegistryServiceConfig.  # noqa: E501

        List of registry hostnames to which nondistributable artifacts can be pushed, using the format `<hostname>[:<port>]` or `<IP address>[:<port>]`.  Some images (for example, Windows base images) contain artifacts whose distribution is restricted by license. When these images are pushed to a registry, restricted artifacts are not included.  This configuration override this behavior for the specified registries.  This option is useful when pushing images containing nondistributable artifacts to a registry on an air-gapped network so hosts on that network can pull the images without connecting to another server.  > **Warning**: Nondistributable artifacts typically have restrictions > on how and where they can be distributed and shared. Only use this > feature to push artifacts to private registries and ensure that you > are in compliance with any terms that cover redistributing > nondistributable artifacts.   # noqa: E501

        :return: The allow_nondistributable_artifacts_hostnames of this RegistryServiceConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._allow_nondistributable_artifacts_hostnames

    @allow_nondistributable_artifacts_hostnames.setter
    def allow_nondistributable_artifacts_hostnames(self, allow_nondistributable_artifacts_hostnames):
        """Sets the allow_nondistributable_artifacts_hostnames of this RegistryServiceConfig.

        List of registry hostnames to which nondistributable artifacts can be pushed, using the format `<hostname>[:<port>]` or `<IP address>[:<port>]`.  Some images (for example, Windows base images) contain artifacts whose distribution is restricted by license. When these images are pushed to a registry, restricted artifacts are not included.  This configuration override this behavior for the specified registries.  This option is useful when pushing images containing nondistributable artifacts to a registry on an air-gapped network so hosts on that network can pull the images without connecting to another server.  > **Warning**: Nondistributable artifacts typically have restrictions > on how and where they can be distributed and shared. Only use this > feature to push artifacts to private registries and ensure that you > are in compliance with any terms that cover redistributing > nondistributable artifacts.   # noqa: E501

        :param allow_nondistributable_artifacts_hostnames: The allow_nondistributable_artifacts_hostnames of this RegistryServiceConfig.  # noqa: E501
        :type: list[str]
        """

        self._allow_nondistributable_artifacts_hostnames = allow_nondistributable_artifacts_hostnames

    @property
    def insecure_registry_cid_rs(self):
        """Gets the insecure_registry_cid_rs of this RegistryServiceConfig.  # noqa: E501

        List of IP ranges of insecure registries, using the CIDR syntax ([RFC 4632](https://tools.ietf.org/html/4632)). Insecure registries accept un-encrypted (HTTP) and/or untrusted (HTTPS with certificates from unknown CAs) communication.  By default, local registries (`127.0.0.0/8`) are configured as insecure. All other registries are secure. Communicating with an insecure registry is not possible if the daemon assumes that registry is secure.  This configuration override this behavior, insecure communication with registries whose resolved IP address is within the subnet described by the CIDR syntax.  Registries can also be marked insecure by hostname. Those registries are listed under `IndexConfigs` and have their `Secure` field set to `false`.  > **Warning**: Using this option can be useful when running a local > registry, but introduces security vulnerabilities. This option > should therefore ONLY be used for testing purposes. For increased > security, users should add their CA to their system's list of trusted > CAs instead of enabling this option.   # noqa: E501

        :return: The insecure_registry_cid_rs of this RegistryServiceConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._insecure_registry_cid_rs

    @insecure_registry_cid_rs.setter
    def insecure_registry_cid_rs(self, insecure_registry_cid_rs):
        """Sets the insecure_registry_cid_rs of this RegistryServiceConfig.

        List of IP ranges of insecure registries, using the CIDR syntax ([RFC 4632](https://tools.ietf.org/html/4632)). Insecure registries accept un-encrypted (HTTP) and/or untrusted (HTTPS with certificates from unknown CAs) communication.  By default, local registries (`127.0.0.0/8`) are configured as insecure. All other registries are secure. Communicating with an insecure registry is not possible if the daemon assumes that registry is secure.  This configuration override this behavior, insecure communication with registries whose resolved IP address is within the subnet described by the CIDR syntax.  Registries can also be marked insecure by hostname. Those registries are listed under `IndexConfigs` and have their `Secure` field set to `false`.  > **Warning**: Using this option can be useful when running a local > registry, but introduces security vulnerabilities. This option > should therefore ONLY be used for testing purposes. For increased > security, users should add their CA to their system's list of trusted > CAs instead of enabling this option.   # noqa: E501

        :param insecure_registry_cid_rs: The insecure_registry_cid_rs of this RegistryServiceConfig.  # noqa: E501
        :type: list[str]
        """

        self._insecure_registry_cid_rs = insecure_registry_cid_rs

    @property
    def index_configs(self):
        """Gets the index_configs of this RegistryServiceConfig.  # noqa: E501


        :return: The index_configs of this RegistryServiceConfig.  # noqa: E501
        :rtype: dict(str, IndexInfo)
        """
        return self._index_configs

    @index_configs.setter
    def index_configs(self, index_configs):
        """Sets the index_configs of this RegistryServiceConfig.


        :param index_configs: The index_configs of this RegistryServiceConfig.  # noqa: E501
        :type: dict(str, IndexInfo)
        """

        self._index_configs = index_configs

    @property
    def mirrors(self):
        """Gets the mirrors of this RegistryServiceConfig.  # noqa: E501

        List of registry URLs that act as a mirror for the official (`docker.io`) registry.   # noqa: E501

        :return: The mirrors of this RegistryServiceConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._mirrors

    @mirrors.setter
    def mirrors(self, mirrors):
        """Sets the mirrors of this RegistryServiceConfig.

        List of registry URLs that act as a mirror for the official (`docker.io`) registry.   # noqa: E501

        :param mirrors: The mirrors of this RegistryServiceConfig.  # noqa: E501
        :type: list[str]
        """

        self._mirrors = mirrors

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RegistryServiceConfig, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RegistryServiceConfig):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RegistryServiceConfig):
            return True

        return self.to_dict() != other.to_dict()
