# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class ServiceSpec(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'labels': 'dict(str, str)',
        'task_template': 'TaskSpec',
        'mode': 'ServiceSpecMode',
        'update_config': 'ServiceSpecUpdateConfig',
        'rollback_config': 'ServiceSpecRollbackConfig',
        'networks': 'list[NetworkAttachmentConfig]',
        'endpoint_spec': 'EndpointSpec'
    }

    attribute_map = {
        'name': 'Name',
        'labels': 'Labels',
        'task_template': 'TaskTemplate',
        'mode': 'Mode',
        'update_config': 'UpdateConfig',
        'rollback_config': 'RollbackConfig',
        'networks': 'Networks',
        'endpoint_spec': 'EndpointSpec'
    }

    def __init__(self, name=None, labels=None, task_template=None, mode=None, update_config=None, rollback_config=None, networks=None, endpoint_spec=None, _configuration=None):  # noqa: E501
        """ServiceSpec - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._name = None
        self._labels = None
        self._task_template = None
        self._mode = None
        self._update_config = None
        self._rollback_config = None
        self._networks = None
        self._endpoint_spec = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if labels is not None:
            self.labels = labels
        if task_template is not None:
            self.task_template = task_template
        if mode is not None:
            self.mode = mode
        if update_config is not None:
            self.update_config = update_config
        if rollback_config is not None:
            self.rollback_config = rollback_config
        if networks is not None:
            self.networks = networks
        if endpoint_spec is not None:
            self.endpoint_spec = endpoint_spec

    @property
    def name(self):
        """Gets the name of this ServiceSpec.  # noqa: E501

        Name of the service.  # noqa: E501

        :return: The name of this ServiceSpec.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ServiceSpec.

        Name of the service.  # noqa: E501

        :param name: The name of this ServiceSpec.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def labels(self):
        """Gets the labels of this ServiceSpec.  # noqa: E501

        User-defined key/value metadata.  # noqa: E501

        :return: The labels of this ServiceSpec.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this ServiceSpec.

        User-defined key/value metadata.  # noqa: E501

        :param labels: The labels of this ServiceSpec.  # noqa: E501
        :type: dict(str, str)
        """

        self._labels = labels

    @property
    def task_template(self):
        """Gets the task_template of this ServiceSpec.  # noqa: E501


        :return: The task_template of this ServiceSpec.  # noqa: E501
        :rtype: TaskSpec
        """
        return self._task_template

    @task_template.setter
    def task_template(self, task_template):
        """Sets the task_template of this ServiceSpec.


        :param task_template: The task_template of this ServiceSpec.  # noqa: E501
        :type: TaskSpec
        """

        self._task_template = task_template

    @property
    def mode(self):
        """Gets the mode of this ServiceSpec.  # noqa: E501


        :return: The mode of this ServiceSpec.  # noqa: E501
        :rtype: ServiceSpecMode
        """
        return self._mode

    @mode.setter
    def mode(self, mode):
        """Sets the mode of this ServiceSpec.


        :param mode: The mode of this ServiceSpec.  # noqa: E501
        :type: ServiceSpecMode
        """

        self._mode = mode

    @property
    def update_config(self):
        """Gets the update_config of this ServiceSpec.  # noqa: E501


        :return: The update_config of this ServiceSpec.  # noqa: E501
        :rtype: ServiceSpecUpdateConfig
        """
        return self._update_config

    @update_config.setter
    def update_config(self, update_config):
        """Sets the update_config of this ServiceSpec.


        :param update_config: The update_config of this ServiceSpec.  # noqa: E501
        :type: ServiceSpecUpdateConfig
        """

        self._update_config = update_config

    @property
    def rollback_config(self):
        """Gets the rollback_config of this ServiceSpec.  # noqa: E501


        :return: The rollback_config of this ServiceSpec.  # noqa: E501
        :rtype: ServiceSpecRollbackConfig
        """
        return self._rollback_config

    @rollback_config.setter
    def rollback_config(self, rollback_config):
        """Sets the rollback_config of this ServiceSpec.


        :param rollback_config: The rollback_config of this ServiceSpec.  # noqa: E501
        :type: ServiceSpecRollbackConfig
        """

        self._rollback_config = rollback_config

    @property
    def networks(self):
        """Gets the networks of this ServiceSpec.  # noqa: E501

        Specifies which networks the service should attach to.  # noqa: E501

        :return: The networks of this ServiceSpec.  # noqa: E501
        :rtype: list[NetworkAttachmentConfig]
        """
        return self._networks

    @networks.setter
    def networks(self, networks):
        """Sets the networks of this ServiceSpec.

        Specifies which networks the service should attach to.  # noqa: E501

        :param networks: The networks of this ServiceSpec.  # noqa: E501
        :type: list[NetworkAttachmentConfig]
        """

        self._networks = networks

    @property
    def endpoint_spec(self):
        """Gets the endpoint_spec of this ServiceSpec.  # noqa: E501


        :return: The endpoint_spec of this ServiceSpec.  # noqa: E501
        :rtype: EndpointSpec
        """
        return self._endpoint_spec

    @endpoint_spec.setter
    def endpoint_spec(self, endpoint_spec):
        """Sets the endpoint_spec of this ServiceSpec.


        :param endpoint_spec: The endpoint_spec of this ServiceSpec.  # noqa: E501
        :type: EndpointSpec
        """

        self._endpoint_spec = endpoint_spec

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ServiceSpec, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ServiceSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ServiceSpec):
            return True

        return self.to_dict() != other.to_dict()
