# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class SwarmInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'node_id': 'str',
        'node_addr': 'str',
        'local_node_state': 'LocalNodeState',
        'control_available': 'bool',
        'error': 'str',
        'remote_managers': 'list[PeerNode]',
        'nodes': 'int',
        'managers': 'int',
        'cluster': 'ClusterInfo'
    }

    attribute_map = {
        'node_id': 'NodeID',
        'node_addr': 'NodeAddr',
        'local_node_state': 'LocalNodeState',
        'control_available': 'ControlAvailable',
        'error': 'Error',
        'remote_managers': 'RemoteManagers',
        'nodes': 'Nodes',
        'managers': 'Managers',
        'cluster': 'Cluster'
    }

    def __init__(self, node_id='', node_addr='', local_node_state=None, control_available=False, error='', remote_managers=None, nodes=None, managers=None, cluster=None, _configuration=None):  # noqa: E501
        """SwarmInfo - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._node_id = None
        self._node_addr = None
        self._local_node_state = None
        self._control_available = None
        self._error = None
        self._remote_managers = None
        self._nodes = None
        self._managers = None
        self._cluster = None
        self.discriminator = None

        if node_id is not None:
            self.node_id = node_id
        if node_addr is not None:
            self.node_addr = node_addr
        if local_node_state is not None:
            self.local_node_state = local_node_state
        if control_available is not None:
            self.control_available = control_available
        if error is not None:
            self.error = error
        if remote_managers is not None:
            self.remote_managers = remote_managers
        if nodes is not None:
            self.nodes = nodes
        if managers is not None:
            self.managers = managers
        if cluster is not None:
            self.cluster = cluster

    @property
    def node_id(self):
        """Gets the node_id of this SwarmInfo.  # noqa: E501

        Unique identifier of for this node in the swarm.  # noqa: E501

        :return: The node_id of this SwarmInfo.  # noqa: E501
        :rtype: str
        """
        return self._node_id

    @node_id.setter
    def node_id(self, node_id):
        """Sets the node_id of this SwarmInfo.

        Unique identifier of for this node in the swarm.  # noqa: E501

        :param node_id: The node_id of this SwarmInfo.  # noqa: E501
        :type: str
        """

        self._node_id = node_id

    @property
    def node_addr(self):
        """Gets the node_addr of this SwarmInfo.  # noqa: E501

        IP address at which this node can be reached by other nodes in the swarm.   # noqa: E501

        :return: The node_addr of this SwarmInfo.  # noqa: E501
        :rtype: str
        """
        return self._node_addr

    @node_addr.setter
    def node_addr(self, node_addr):
        """Sets the node_addr of this SwarmInfo.

        IP address at which this node can be reached by other nodes in the swarm.   # noqa: E501

        :param node_addr: The node_addr of this SwarmInfo.  # noqa: E501
        :type: str
        """

        self._node_addr = node_addr

    @property
    def local_node_state(self):
        """Gets the local_node_state of this SwarmInfo.  # noqa: E501


        :return: The local_node_state of this SwarmInfo.  # noqa: E501
        :rtype: LocalNodeState
        """
        return self._local_node_state

    @local_node_state.setter
    def local_node_state(self, local_node_state):
        """Sets the local_node_state of this SwarmInfo.


        :param local_node_state: The local_node_state of this SwarmInfo.  # noqa: E501
        :type: LocalNodeState
        """

        self._local_node_state = local_node_state

    @property
    def control_available(self):
        """Gets the control_available of this SwarmInfo.  # noqa: E501


        :return: The control_available of this SwarmInfo.  # noqa: E501
        :rtype: bool
        """
        return self._control_available

    @control_available.setter
    def control_available(self, control_available):
        """Sets the control_available of this SwarmInfo.


        :param control_available: The control_available of this SwarmInfo.  # noqa: E501
        :type: bool
        """

        self._control_available = control_available

    @property
    def error(self):
        """Gets the error of this SwarmInfo.  # noqa: E501


        :return: The error of this SwarmInfo.  # noqa: E501
        :rtype: str
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this SwarmInfo.


        :param error: The error of this SwarmInfo.  # noqa: E501
        :type: str
        """

        self._error = error

    @property
    def remote_managers(self):
        """Gets the remote_managers of this SwarmInfo.  # noqa: E501

        List of ID's and addresses of other managers in the swarm.   # noqa: E501

        :return: The remote_managers of this SwarmInfo.  # noqa: E501
        :rtype: list[PeerNode]
        """
        return self._remote_managers

    @remote_managers.setter
    def remote_managers(self, remote_managers):
        """Sets the remote_managers of this SwarmInfo.

        List of ID's and addresses of other managers in the swarm.   # noqa: E501

        :param remote_managers: The remote_managers of this SwarmInfo.  # noqa: E501
        :type: list[PeerNode]
        """

        self._remote_managers = remote_managers

    @property
    def nodes(self):
        """Gets the nodes of this SwarmInfo.  # noqa: E501

        Total number of nodes in the swarm.  # noqa: E501

        :return: The nodes of this SwarmInfo.  # noqa: E501
        :rtype: int
        """
        return self._nodes

    @nodes.setter
    def nodes(self, nodes):
        """Sets the nodes of this SwarmInfo.

        Total number of nodes in the swarm.  # noqa: E501

        :param nodes: The nodes of this SwarmInfo.  # noqa: E501
        :type: int
        """

        self._nodes = nodes

    @property
    def managers(self):
        """Gets the managers of this SwarmInfo.  # noqa: E501

        Total number of managers in the swarm.  # noqa: E501

        :return: The managers of this SwarmInfo.  # noqa: E501
        :rtype: int
        """
        return self._managers

    @managers.setter
    def managers(self, managers):
        """Sets the managers of this SwarmInfo.

        Total number of managers in the swarm.  # noqa: E501

        :param managers: The managers of this SwarmInfo.  # noqa: E501
        :type: int
        """

        self._managers = managers

    @property
    def cluster(self):
        """Gets the cluster of this SwarmInfo.  # noqa: E501


        :return: The cluster of this SwarmInfo.  # noqa: E501
        :rtype: ClusterInfo
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this SwarmInfo.


        :param cluster: The cluster of this SwarmInfo.  # noqa: E501
        :type: ClusterInfo
        """

        self._cluster = cluster

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SwarmInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SwarmInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SwarmInfo):
            return True

        return self.to_dict() != other.to_dict()
