# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class SwarmInitRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'listen_addr': 'str',
        'advertise_addr': 'str',
        'data_path_addr': 'str',
        'data_path_port': 'int',
        'default_addr_pool': 'list[str]',
        'force_new_cluster': 'bool',
        'subnet_size': 'int',
        'spec': 'SwarmSpec'
    }

    attribute_map = {
        'listen_addr': 'ListenAddr',
        'advertise_addr': 'AdvertiseAddr',
        'data_path_addr': 'DataPathAddr',
        'data_path_port': 'DataPathPort',
        'default_addr_pool': 'DefaultAddrPool',
        'force_new_cluster': 'ForceNewCluster',
        'subnet_size': 'SubnetSize',
        'spec': 'Spec'
    }

    def __init__(self, listen_addr=None, advertise_addr=None, data_path_addr=None, data_path_port=None, default_addr_pool=None, force_new_cluster=None, subnet_size=None, spec=None, _configuration=None):  # noqa: E501
        """SwarmInitRequest - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._listen_addr = None
        self._advertise_addr = None
        self._data_path_addr = None
        self._data_path_port = None
        self._default_addr_pool = None
        self._force_new_cluster = None
        self._subnet_size = None
        self._spec = None
        self.discriminator = None

        if listen_addr is not None:
            self.listen_addr = listen_addr
        if advertise_addr is not None:
            self.advertise_addr = advertise_addr
        if data_path_addr is not None:
            self.data_path_addr = data_path_addr
        if data_path_port is not None:
            self.data_path_port = data_path_port
        if default_addr_pool is not None:
            self.default_addr_pool = default_addr_pool
        if force_new_cluster is not None:
            self.force_new_cluster = force_new_cluster
        if subnet_size is not None:
            self.subnet_size = subnet_size
        if spec is not None:
            self.spec = spec

    @property
    def listen_addr(self):
        """Gets the listen_addr of this SwarmInitRequest.  # noqa: E501

        Listen address used for inter-manager communication, as well as determining the networking interface used for the VXLAN Tunnel Endpoint (VTEP). This can either be an address/port combination in the form `192.168.1.1:4567`, or an interface followed by a port number, like `eth0:4567`. If the port number is omitted, the default swarm listening port is used.   # noqa: E501

        :return: The listen_addr of this SwarmInitRequest.  # noqa: E501
        :rtype: str
        """
        return self._listen_addr

    @listen_addr.setter
    def listen_addr(self, listen_addr):
        """Sets the listen_addr of this SwarmInitRequest.

        Listen address used for inter-manager communication, as well as determining the networking interface used for the VXLAN Tunnel Endpoint (VTEP). This can either be an address/port combination in the form `192.168.1.1:4567`, or an interface followed by a port number, like `eth0:4567`. If the port number is omitted, the default swarm listening port is used.   # noqa: E501

        :param listen_addr: The listen_addr of this SwarmInitRequest.  # noqa: E501
        :type: str
        """

        self._listen_addr = listen_addr

    @property
    def advertise_addr(self):
        """Gets the advertise_addr of this SwarmInitRequest.  # noqa: E501

        Externally reachable address advertised to other nodes. This can either be an address/port combination in the form `192.168.1.1:4567`, or an interface followed by a port number, like `eth0:4567`. If the port number is omitted, the port number from the listen address is used. If `AdvertiseAddr` is not specified, it will be automatically detected when possible.   # noqa: E501

        :return: The advertise_addr of this SwarmInitRequest.  # noqa: E501
        :rtype: str
        """
        return self._advertise_addr

    @advertise_addr.setter
    def advertise_addr(self, advertise_addr):
        """Sets the advertise_addr of this SwarmInitRequest.

        Externally reachable address advertised to other nodes. This can either be an address/port combination in the form `192.168.1.1:4567`, or an interface followed by a port number, like `eth0:4567`. If the port number is omitted, the port number from the listen address is used. If `AdvertiseAddr` is not specified, it will be automatically detected when possible.   # noqa: E501

        :param advertise_addr: The advertise_addr of this SwarmInitRequest.  # noqa: E501
        :type: str
        """

        self._advertise_addr = advertise_addr

    @property
    def data_path_addr(self):
        """Gets the data_path_addr of this SwarmInitRequest.  # noqa: E501

        Address or interface to use for data path traffic (format: `<ip|interface>`), for example,  `192.168.1.1`, or an interface, like `eth0`. If `DataPathAddr` is unspecified, the same address as `AdvertiseAddr` is used.  The `DataPathAddr` specifies the address that global scope network drivers will publish towards other  nodes in order to reach the containers running on this node. Using this parameter it is possible to separate the container data traffic from the management traffic of the cluster.   # noqa: E501

        :return: The data_path_addr of this SwarmInitRequest.  # noqa: E501
        :rtype: str
        """
        return self._data_path_addr

    @data_path_addr.setter
    def data_path_addr(self, data_path_addr):
        """Sets the data_path_addr of this SwarmInitRequest.

        Address or interface to use for data path traffic (format: `<ip|interface>`), for example,  `192.168.1.1`, or an interface, like `eth0`. If `DataPathAddr` is unspecified, the same address as `AdvertiseAddr` is used.  The `DataPathAddr` specifies the address that global scope network drivers will publish towards other  nodes in order to reach the containers running on this node. Using this parameter it is possible to separate the container data traffic from the management traffic of the cluster.   # noqa: E501

        :param data_path_addr: The data_path_addr of this SwarmInitRequest.  # noqa: E501
        :type: str
        """

        self._data_path_addr = data_path_addr

    @property
    def data_path_port(self):
        """Gets the data_path_port of this SwarmInitRequest.  # noqa: E501

        DataPathPort specifies the data path port number for data traffic. Acceptable port range is 1024 to 49151. if no port is set or is set to 0, default port 4789 will be used.   # noqa: E501

        :return: The data_path_port of this SwarmInitRequest.  # noqa: E501
        :rtype: int
        """
        return self._data_path_port

    @data_path_port.setter
    def data_path_port(self, data_path_port):
        """Sets the data_path_port of this SwarmInitRequest.

        DataPathPort specifies the data path port number for data traffic. Acceptable port range is 1024 to 49151. if no port is set or is set to 0, default port 4789 will be used.   # noqa: E501

        :param data_path_port: The data_path_port of this SwarmInitRequest.  # noqa: E501
        :type: int
        """

        self._data_path_port = data_path_port

    @property
    def default_addr_pool(self):
        """Gets the default_addr_pool of this SwarmInitRequest.  # noqa: E501

        Default Address Pool specifies default subnet pools for global scope networks.   # noqa: E501

        :return: The default_addr_pool of this SwarmInitRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._default_addr_pool

    @default_addr_pool.setter
    def default_addr_pool(self, default_addr_pool):
        """Sets the default_addr_pool of this SwarmInitRequest.

        Default Address Pool specifies default subnet pools for global scope networks.   # noqa: E501

        :param default_addr_pool: The default_addr_pool of this SwarmInitRequest.  # noqa: E501
        :type: list[str]
        """

        self._default_addr_pool = default_addr_pool

    @property
    def force_new_cluster(self):
        """Gets the force_new_cluster of this SwarmInitRequest.  # noqa: E501

        Force creation of a new swarm.  # noqa: E501

        :return: The force_new_cluster of this SwarmInitRequest.  # noqa: E501
        :rtype: bool
        """
        return self._force_new_cluster

    @force_new_cluster.setter
    def force_new_cluster(self, force_new_cluster):
        """Sets the force_new_cluster of this SwarmInitRequest.

        Force creation of a new swarm.  # noqa: E501

        :param force_new_cluster: The force_new_cluster of this SwarmInitRequest.  # noqa: E501
        :type: bool
        """

        self._force_new_cluster = force_new_cluster

    @property
    def subnet_size(self):
        """Gets the subnet_size of this SwarmInitRequest.  # noqa: E501

        SubnetSize specifies the subnet size of the networks created from the default subnet pool.   # noqa: E501

        :return: The subnet_size of this SwarmInitRequest.  # noqa: E501
        :rtype: int
        """
        return self._subnet_size

    @subnet_size.setter
    def subnet_size(self, subnet_size):
        """Sets the subnet_size of this SwarmInitRequest.

        SubnetSize specifies the subnet size of the networks created from the default subnet pool.   # noqa: E501

        :param subnet_size: The subnet_size of this SwarmInitRequest.  # noqa: E501
        :type: int
        """

        self._subnet_size = subnet_size

    @property
    def spec(self):
        """Gets the spec of this SwarmInitRequest.  # noqa: E501


        :return: The spec of this SwarmInitRequest.  # noqa: E501
        :rtype: SwarmSpec
        """
        return self._spec

    @spec.setter
    def spec(self, spec):
        """Sets the spec of this SwarmInitRequest.


        :param spec: The spec of this SwarmInitRequest.  # noqa: E501
        :type: SwarmSpec
        """

        self._spec = spec

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SwarmInitRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SwarmInitRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SwarmInitRequest):
            return True

        return self.to_dict() != other.to_dict()
