# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class SwarmJoinRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'listen_addr': 'str',
        'advertise_addr': 'str',
        'data_path_addr': 'str',
        'remote_addrs': 'list[str]',
        'join_token': 'str'
    }

    attribute_map = {
        'listen_addr': 'ListenAddr',
        'advertise_addr': 'AdvertiseAddr',
        'data_path_addr': 'DataPathAddr',
        'remote_addrs': 'RemoteAddrs',
        'join_token': 'JoinToken'
    }

    def __init__(self, listen_addr=None, advertise_addr=None, data_path_addr=None, remote_addrs=None, join_token=None, _configuration=None):  # noqa: E501
        """SwarmJoinRequest - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._listen_addr = None
        self._advertise_addr = None
        self._data_path_addr = None
        self._remote_addrs = None
        self._join_token = None
        self.discriminator = None

        if listen_addr is not None:
            self.listen_addr = listen_addr
        if advertise_addr is not None:
            self.advertise_addr = advertise_addr
        if data_path_addr is not None:
            self.data_path_addr = data_path_addr
        if remote_addrs is not None:
            self.remote_addrs = remote_addrs
        if join_token is not None:
            self.join_token = join_token

    @property
    def listen_addr(self):
        """Gets the listen_addr of this SwarmJoinRequest.  # noqa: E501

        Listen address used for inter-manager communication if the node gets promoted to manager, as well as determining the networking interface used for the VXLAN Tunnel Endpoint (VTEP).   # noqa: E501

        :return: The listen_addr of this SwarmJoinRequest.  # noqa: E501
        :rtype: str
        """
        return self._listen_addr

    @listen_addr.setter
    def listen_addr(self, listen_addr):
        """Sets the listen_addr of this SwarmJoinRequest.

        Listen address used for inter-manager communication if the node gets promoted to manager, as well as determining the networking interface used for the VXLAN Tunnel Endpoint (VTEP).   # noqa: E501

        :param listen_addr: The listen_addr of this SwarmJoinRequest.  # noqa: E501
        :type: str
        """

        self._listen_addr = listen_addr

    @property
    def advertise_addr(self):
        """Gets the advertise_addr of this SwarmJoinRequest.  # noqa: E501

        Externally reachable address advertised to other nodes. This can either be an address/port combination in the form `192.168.1.1:4567`, or an interface followed by a port number, like `eth0:4567`. If the port number is omitted, the port number from the listen address is used. If `AdvertiseAddr` is not specified, it will be automatically detected when possible.   # noqa: E501

        :return: The advertise_addr of this SwarmJoinRequest.  # noqa: E501
        :rtype: str
        """
        return self._advertise_addr

    @advertise_addr.setter
    def advertise_addr(self, advertise_addr):
        """Sets the advertise_addr of this SwarmJoinRequest.

        Externally reachable address advertised to other nodes. This can either be an address/port combination in the form `192.168.1.1:4567`, or an interface followed by a port number, like `eth0:4567`. If the port number is omitted, the port number from the listen address is used. If `AdvertiseAddr` is not specified, it will be automatically detected when possible.   # noqa: E501

        :param advertise_addr: The advertise_addr of this SwarmJoinRequest.  # noqa: E501
        :type: str
        """

        self._advertise_addr = advertise_addr

    @property
    def data_path_addr(self):
        """Gets the data_path_addr of this SwarmJoinRequest.  # noqa: E501

        Address or interface to use for data path traffic (format: `<ip|interface>`), for example,  `192.168.1.1`, or an interface, like `eth0`. If `DataPathAddr` is unspecified, the same address as `AdvertiseAddr` is used.  The `DataPathAddr` specifies the address that global scope network drivers will publish towards other nodes in order to reach the containers running on this node. Using this parameter it is possible to separate the container data traffic from the management traffic of the cluster.   # noqa: E501

        :return: The data_path_addr of this SwarmJoinRequest.  # noqa: E501
        :rtype: str
        """
        return self._data_path_addr

    @data_path_addr.setter
    def data_path_addr(self, data_path_addr):
        """Sets the data_path_addr of this SwarmJoinRequest.

        Address or interface to use for data path traffic (format: `<ip|interface>`), for example,  `192.168.1.1`, or an interface, like `eth0`. If `DataPathAddr` is unspecified, the same address as `AdvertiseAddr` is used.  The `DataPathAddr` specifies the address that global scope network drivers will publish towards other nodes in order to reach the containers running on this node. Using this parameter it is possible to separate the container data traffic from the management traffic of the cluster.   # noqa: E501

        :param data_path_addr: The data_path_addr of this SwarmJoinRequest.  # noqa: E501
        :type: str
        """

        self._data_path_addr = data_path_addr

    @property
    def remote_addrs(self):
        """Gets the remote_addrs of this SwarmJoinRequest.  # noqa: E501

        Addresses of manager nodes already participating in the swarm.   # noqa: E501

        :return: The remote_addrs of this SwarmJoinRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._remote_addrs

    @remote_addrs.setter
    def remote_addrs(self, remote_addrs):
        """Sets the remote_addrs of this SwarmJoinRequest.

        Addresses of manager nodes already participating in the swarm.   # noqa: E501

        :param remote_addrs: The remote_addrs of this SwarmJoinRequest.  # noqa: E501
        :type: list[str]
        """

        self._remote_addrs = remote_addrs

    @property
    def join_token(self):
        """Gets the join_token of this SwarmJoinRequest.  # noqa: E501

        Secret token for joining this swarm.  # noqa: E501

        :return: The join_token of this SwarmJoinRequest.  # noqa: E501
        :rtype: str
        """
        return self._join_token

    @join_token.setter
    def join_token(self, join_token):
        """Sets the join_token of this SwarmJoinRequest.

        Secret token for joining this swarm.  # noqa: E501

        :param join_token: The join_token of this SwarmJoinRequest.  # noqa: E501
        :type: str
        """

        self._join_token = join_token

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SwarmJoinRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SwarmJoinRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SwarmJoinRequest):
            return True

        return self.to_dict() != other.to_dict()
