# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class SwarmSpec(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'labels': 'dict(str, str)',
        'orchestration': 'SwarmSpecOrchestration',
        'raft': 'SwarmSpecRaft',
        'dispatcher': 'SwarmSpecDispatcher',
        'ca_config': 'SwarmSpecCAConfig',
        'encryption_config': 'SwarmSpecEncryptionConfig',
        'task_defaults': 'SwarmSpecTaskDefaults'
    }

    attribute_map = {
        'name': 'Name',
        'labels': 'Labels',
        'orchestration': 'Orchestration',
        'raft': 'Raft',
        'dispatcher': 'Dispatcher',
        'ca_config': 'CAConfig',
        'encryption_config': 'EncryptionConfig',
        'task_defaults': 'TaskDefaults'
    }

    def __init__(self, name=None, labels=None, orchestration=None, raft=None, dispatcher=None, ca_config=None, encryption_config=None, task_defaults=None, _configuration=None):  # noqa: E501
        """SwarmSpec - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._name = None
        self._labels = None
        self._orchestration = None
        self._raft = None
        self._dispatcher = None
        self._ca_config = None
        self._encryption_config = None
        self._task_defaults = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if labels is not None:
            self.labels = labels
        if orchestration is not None:
            self.orchestration = orchestration
        if raft is not None:
            self.raft = raft
        if dispatcher is not None:
            self.dispatcher = dispatcher
        if ca_config is not None:
            self.ca_config = ca_config
        if encryption_config is not None:
            self.encryption_config = encryption_config
        if task_defaults is not None:
            self.task_defaults = task_defaults

    @property
    def name(self):
        """Gets the name of this SwarmSpec.  # noqa: E501

        Name of the swarm.  # noqa: E501

        :return: The name of this SwarmSpec.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SwarmSpec.

        Name of the swarm.  # noqa: E501

        :param name: The name of this SwarmSpec.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def labels(self):
        """Gets the labels of this SwarmSpec.  # noqa: E501

        User-defined key/value metadata.  # noqa: E501

        :return: The labels of this SwarmSpec.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this SwarmSpec.

        User-defined key/value metadata.  # noqa: E501

        :param labels: The labels of this SwarmSpec.  # noqa: E501
        :type: dict(str, str)
        """

        self._labels = labels

    @property
    def orchestration(self):
        """Gets the orchestration of this SwarmSpec.  # noqa: E501


        :return: The orchestration of this SwarmSpec.  # noqa: E501
        :rtype: SwarmSpecOrchestration
        """
        return self._orchestration

    @orchestration.setter
    def orchestration(self, orchestration):
        """Sets the orchestration of this SwarmSpec.


        :param orchestration: The orchestration of this SwarmSpec.  # noqa: E501
        :type: SwarmSpecOrchestration
        """

        self._orchestration = orchestration

    @property
    def raft(self):
        """Gets the raft of this SwarmSpec.  # noqa: E501


        :return: The raft of this SwarmSpec.  # noqa: E501
        :rtype: SwarmSpecRaft
        """
        return self._raft

    @raft.setter
    def raft(self, raft):
        """Sets the raft of this SwarmSpec.


        :param raft: The raft of this SwarmSpec.  # noqa: E501
        :type: SwarmSpecRaft
        """

        self._raft = raft

    @property
    def dispatcher(self):
        """Gets the dispatcher of this SwarmSpec.  # noqa: E501


        :return: The dispatcher of this SwarmSpec.  # noqa: E501
        :rtype: SwarmSpecDispatcher
        """
        return self._dispatcher

    @dispatcher.setter
    def dispatcher(self, dispatcher):
        """Sets the dispatcher of this SwarmSpec.


        :param dispatcher: The dispatcher of this SwarmSpec.  # noqa: E501
        :type: SwarmSpecDispatcher
        """

        self._dispatcher = dispatcher

    @property
    def ca_config(self):
        """Gets the ca_config of this SwarmSpec.  # noqa: E501


        :return: The ca_config of this SwarmSpec.  # noqa: E501
        :rtype: SwarmSpecCAConfig
        """
        return self._ca_config

    @ca_config.setter
    def ca_config(self, ca_config):
        """Sets the ca_config of this SwarmSpec.


        :param ca_config: The ca_config of this SwarmSpec.  # noqa: E501
        :type: SwarmSpecCAConfig
        """

        self._ca_config = ca_config

    @property
    def encryption_config(self):
        """Gets the encryption_config of this SwarmSpec.  # noqa: E501


        :return: The encryption_config of this SwarmSpec.  # noqa: E501
        :rtype: SwarmSpecEncryptionConfig
        """
        return self._encryption_config

    @encryption_config.setter
    def encryption_config(self, encryption_config):
        """Sets the encryption_config of this SwarmSpec.


        :param encryption_config: The encryption_config of this SwarmSpec.  # noqa: E501
        :type: SwarmSpecEncryptionConfig
        """

        self._encryption_config = encryption_config

    @property
    def task_defaults(self):
        """Gets the task_defaults of this SwarmSpec.  # noqa: E501


        :return: The task_defaults of this SwarmSpec.  # noqa: E501
        :rtype: SwarmSpecTaskDefaults
        """
        return self._task_defaults

    @task_defaults.setter
    def task_defaults(self, task_defaults):
        """Sets the task_defaults of this SwarmSpec.


        :param task_defaults: The task_defaults of this SwarmSpec.  # noqa: E501
        :type: SwarmSpecTaskDefaults
        """

        self._task_defaults = task_defaults

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SwarmSpec, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SwarmSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SwarmSpec):
            return True

        return self.to_dict() != other.to_dict()
