# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class SwarmSpecCAConfig(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'node_cert_expiry': 'int',
        'external_c_as': 'list[SwarmSpecCAConfigExternalCAs]',
        'signing_ca_cert': 'str',
        'signing_ca_key': 'str',
        'force_rotate': 'int'
    }

    attribute_map = {
        'node_cert_expiry': 'NodeCertExpiry',
        'external_c_as': 'ExternalCAs',
        'signing_ca_cert': 'SigningCACert',
        'signing_ca_key': 'SigningCAKey',
        'force_rotate': 'ForceRotate'
    }

    def __init__(self, node_cert_expiry=None, external_c_as=None, signing_ca_cert=None, signing_ca_key=None, force_rotate=None, _configuration=None):  # noqa: E501
        """SwarmSpecCAConfig - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._node_cert_expiry = None
        self._external_c_as = None
        self._signing_ca_cert = None
        self._signing_ca_key = None
        self._force_rotate = None
        self.discriminator = None

        if node_cert_expiry is not None:
            self.node_cert_expiry = node_cert_expiry
        if external_c_as is not None:
            self.external_c_as = external_c_as
        if signing_ca_cert is not None:
            self.signing_ca_cert = signing_ca_cert
        if signing_ca_key is not None:
            self.signing_ca_key = signing_ca_key
        if force_rotate is not None:
            self.force_rotate = force_rotate

    @property
    def node_cert_expiry(self):
        """Gets the node_cert_expiry of this SwarmSpecCAConfig.  # noqa: E501

        The duration node certificates are issued for.  # noqa: E501

        :return: The node_cert_expiry of this SwarmSpecCAConfig.  # noqa: E501
        :rtype: int
        """
        return self._node_cert_expiry

    @node_cert_expiry.setter
    def node_cert_expiry(self, node_cert_expiry):
        """Sets the node_cert_expiry of this SwarmSpecCAConfig.

        The duration node certificates are issued for.  # noqa: E501

        :param node_cert_expiry: The node_cert_expiry of this SwarmSpecCAConfig.  # noqa: E501
        :type: int
        """

        self._node_cert_expiry = node_cert_expiry

    @property
    def external_c_as(self):
        """Gets the external_c_as of this SwarmSpecCAConfig.  # noqa: E501

        Configuration for forwarding signing requests to an external certificate authority.   # noqa: E501

        :return: The external_c_as of this SwarmSpecCAConfig.  # noqa: E501
        :rtype: list[SwarmSpecCAConfigExternalCAs]
        """
        return self._external_c_as

    @external_c_as.setter
    def external_c_as(self, external_c_as):
        """Sets the external_c_as of this SwarmSpecCAConfig.

        Configuration for forwarding signing requests to an external certificate authority.   # noqa: E501

        :param external_c_as: The external_c_as of this SwarmSpecCAConfig.  # noqa: E501
        :type: list[SwarmSpecCAConfigExternalCAs]
        """

        self._external_c_as = external_c_as

    @property
    def signing_ca_cert(self):
        """Gets the signing_ca_cert of this SwarmSpecCAConfig.  # noqa: E501

        The desired signing CA certificate for all swarm node TLS leaf certificates, in PEM format.   # noqa: E501

        :return: The signing_ca_cert of this SwarmSpecCAConfig.  # noqa: E501
        :rtype: str
        """
        return self._signing_ca_cert

    @signing_ca_cert.setter
    def signing_ca_cert(self, signing_ca_cert):
        """Sets the signing_ca_cert of this SwarmSpecCAConfig.

        The desired signing CA certificate for all swarm node TLS leaf certificates, in PEM format.   # noqa: E501

        :param signing_ca_cert: The signing_ca_cert of this SwarmSpecCAConfig.  # noqa: E501
        :type: str
        """

        self._signing_ca_cert = signing_ca_cert

    @property
    def signing_ca_key(self):
        """Gets the signing_ca_key of this SwarmSpecCAConfig.  # noqa: E501

        The desired signing CA key for all swarm node TLS leaf certificates, in PEM format.   # noqa: E501

        :return: The signing_ca_key of this SwarmSpecCAConfig.  # noqa: E501
        :rtype: str
        """
        return self._signing_ca_key

    @signing_ca_key.setter
    def signing_ca_key(self, signing_ca_key):
        """Sets the signing_ca_key of this SwarmSpecCAConfig.

        The desired signing CA key for all swarm node TLS leaf certificates, in PEM format.   # noqa: E501

        :param signing_ca_key: The signing_ca_key of this SwarmSpecCAConfig.  # noqa: E501
        :type: str
        """

        self._signing_ca_key = signing_ca_key

    @property
    def force_rotate(self):
        """Gets the force_rotate of this SwarmSpecCAConfig.  # noqa: E501

        An integer whose purpose is to force swarm to generate a new signing CA certificate and key, if none have been specified in `SigningCACert` and `SigningCAKey`   # noqa: E501

        :return: The force_rotate of this SwarmSpecCAConfig.  # noqa: E501
        :rtype: int
        """
        return self._force_rotate

    @force_rotate.setter
    def force_rotate(self, force_rotate):
        """Sets the force_rotate of this SwarmSpecCAConfig.

        An integer whose purpose is to force swarm to generate a new signing CA certificate and key, if none have been specified in `SigningCACert` and `SigningCAKey`   # noqa: E501

        :param force_rotate: The force_rotate of this SwarmSpecCAConfig.  # noqa: E501
        :type: int
        """

        self._force_rotate = force_rotate

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SwarmSpecCAConfig, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SwarmSpecCAConfig):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SwarmSpecCAConfig):
            return True

        return self.to_dict() != other.to_dict()
