# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class SwarmSpecCAConfigExternalCAs(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'protocol': 'str',
        'url': 'str',
        'options': 'dict(str, str)',
        'ca_cert': 'str'
    }

    attribute_map = {
        'protocol': 'Protocol',
        'url': 'URL',
        'options': 'Options',
        'ca_cert': 'CACert'
    }

    def __init__(self, protocol='cfssl', url=None, options=None, ca_cert=None, _configuration=None):  # noqa: E501
        """SwarmSpecCAConfigExternalCAs - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._protocol = None
        self._url = None
        self._options = None
        self._ca_cert = None
        self.discriminator = None

        if protocol is not None:
            self.protocol = protocol
        if url is not None:
            self.url = url
        if options is not None:
            self.options = options
        if ca_cert is not None:
            self.ca_cert = ca_cert

    @property
    def protocol(self):
        """Gets the protocol of this SwarmSpecCAConfigExternalCAs.  # noqa: E501

        Protocol for communication with the external CA (currently only `cfssl` is supported).   # noqa: E501

        :return: The protocol of this SwarmSpecCAConfigExternalCAs.  # noqa: E501
        :rtype: str
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """Sets the protocol of this SwarmSpecCAConfigExternalCAs.

        Protocol for communication with the external CA (currently only `cfssl` is supported).   # noqa: E501

        :param protocol: The protocol of this SwarmSpecCAConfigExternalCAs.  # noqa: E501
        :type: str
        """
        allowed_values = ["cfssl"]  # noqa: E501
        if (self._configuration.client_side_validation and
                protocol not in allowed_values):
            raise ValueError(
                "Invalid value for `protocol` ({0}), must be one of {1}"  # noqa: E501
                .format(protocol, allowed_values)
            )

        self._protocol = protocol

    @property
    def url(self):
        """Gets the url of this SwarmSpecCAConfigExternalCAs.  # noqa: E501

        URL where certificate signing requests should be sent.   # noqa: E501

        :return: The url of this SwarmSpecCAConfigExternalCAs.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this SwarmSpecCAConfigExternalCAs.

        URL where certificate signing requests should be sent.   # noqa: E501

        :param url: The url of this SwarmSpecCAConfigExternalCAs.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def options(self):
        """Gets the options of this SwarmSpecCAConfigExternalCAs.  # noqa: E501

        An object with key/value pairs that are interpreted as protocol-specific options for the external CA driver.   # noqa: E501

        :return: The options of this SwarmSpecCAConfigExternalCAs.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this SwarmSpecCAConfigExternalCAs.

        An object with key/value pairs that are interpreted as protocol-specific options for the external CA driver.   # noqa: E501

        :param options: The options of this SwarmSpecCAConfigExternalCAs.  # noqa: E501
        :type: dict(str, str)
        """

        self._options = options

    @property
    def ca_cert(self):
        """Gets the ca_cert of this SwarmSpecCAConfigExternalCAs.  # noqa: E501

        The root CA certificate (in PEM format) this external CA uses to issue TLS certificates (assumed to be to the current swarm root CA certificate if not provided).   # noqa: E501

        :return: The ca_cert of this SwarmSpecCAConfigExternalCAs.  # noqa: E501
        :rtype: str
        """
        return self._ca_cert

    @ca_cert.setter
    def ca_cert(self, ca_cert):
        """Sets the ca_cert of this SwarmSpecCAConfigExternalCAs.

        The root CA certificate (in PEM format) this external CA uses to issue TLS certificates (assumed to be to the current swarm root CA certificate if not provided).   # noqa: E501

        :param ca_cert: The ca_cert of this SwarmSpecCAConfigExternalCAs.  # noqa: E501
        :type: str
        """

        self._ca_cert = ca_cert

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SwarmSpecCAConfigExternalCAs, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SwarmSpecCAConfigExternalCAs):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SwarmSpecCAConfigExternalCAs):
            return True

        return self.to_dict() != other.to_dict()
