# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class SwarmSpecRaft(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'snapshot_interval': 'int',
        'keep_old_snapshots': 'int',
        'log_entries_for_slow_followers': 'int',
        'election_tick': 'int',
        'heartbeat_tick': 'int'
    }

    attribute_map = {
        'snapshot_interval': 'SnapshotInterval',
        'keep_old_snapshots': 'KeepOldSnapshots',
        'log_entries_for_slow_followers': 'LogEntriesForSlowFollowers',
        'election_tick': 'ElectionTick',
        'heartbeat_tick': 'HeartbeatTick'
    }

    def __init__(self, snapshot_interval=None, keep_old_snapshots=None, log_entries_for_slow_followers=None, election_tick=None, heartbeat_tick=None, _configuration=None):  # noqa: E501
        """SwarmSpecRaft - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._snapshot_interval = None
        self._keep_old_snapshots = None
        self._log_entries_for_slow_followers = None
        self._election_tick = None
        self._heartbeat_tick = None
        self.discriminator = None

        if snapshot_interval is not None:
            self.snapshot_interval = snapshot_interval
        if keep_old_snapshots is not None:
            self.keep_old_snapshots = keep_old_snapshots
        if log_entries_for_slow_followers is not None:
            self.log_entries_for_slow_followers = log_entries_for_slow_followers
        if election_tick is not None:
            self.election_tick = election_tick
        if heartbeat_tick is not None:
            self.heartbeat_tick = heartbeat_tick

    @property
    def snapshot_interval(self):
        """Gets the snapshot_interval of this SwarmSpecRaft.  # noqa: E501

        The number of log entries between snapshots.  # noqa: E501

        :return: The snapshot_interval of this SwarmSpecRaft.  # noqa: E501
        :rtype: int
        """
        return self._snapshot_interval

    @snapshot_interval.setter
    def snapshot_interval(self, snapshot_interval):
        """Sets the snapshot_interval of this SwarmSpecRaft.

        The number of log entries between snapshots.  # noqa: E501

        :param snapshot_interval: The snapshot_interval of this SwarmSpecRaft.  # noqa: E501
        :type: int
        """

        self._snapshot_interval = snapshot_interval

    @property
    def keep_old_snapshots(self):
        """Gets the keep_old_snapshots of this SwarmSpecRaft.  # noqa: E501

        The number of snapshots to keep beyond the current snapshot.   # noqa: E501

        :return: The keep_old_snapshots of this SwarmSpecRaft.  # noqa: E501
        :rtype: int
        """
        return self._keep_old_snapshots

    @keep_old_snapshots.setter
    def keep_old_snapshots(self, keep_old_snapshots):
        """Sets the keep_old_snapshots of this SwarmSpecRaft.

        The number of snapshots to keep beyond the current snapshot.   # noqa: E501

        :param keep_old_snapshots: The keep_old_snapshots of this SwarmSpecRaft.  # noqa: E501
        :type: int
        """

        self._keep_old_snapshots = keep_old_snapshots

    @property
    def log_entries_for_slow_followers(self):
        """Gets the log_entries_for_slow_followers of this SwarmSpecRaft.  # noqa: E501

        The number of log entries to keep around to sync up slow followers after a snapshot is created.   # noqa: E501

        :return: The log_entries_for_slow_followers of this SwarmSpecRaft.  # noqa: E501
        :rtype: int
        """
        return self._log_entries_for_slow_followers

    @log_entries_for_slow_followers.setter
    def log_entries_for_slow_followers(self, log_entries_for_slow_followers):
        """Sets the log_entries_for_slow_followers of this SwarmSpecRaft.

        The number of log entries to keep around to sync up slow followers after a snapshot is created.   # noqa: E501

        :param log_entries_for_slow_followers: The log_entries_for_slow_followers of this SwarmSpecRaft.  # noqa: E501
        :type: int
        """

        self._log_entries_for_slow_followers = log_entries_for_slow_followers

    @property
    def election_tick(self):
        """Gets the election_tick of this SwarmSpecRaft.  # noqa: E501

        The number of ticks that a follower will wait for a message from the leader before becoming a candidate and starting an election. `ElectionTick` must be greater than `HeartbeatTick`.  A tick currently defaults to one second, so these translate directly to seconds currently, but this is NOT guaranteed.   # noqa: E501

        :return: The election_tick of this SwarmSpecRaft.  # noqa: E501
        :rtype: int
        """
        return self._election_tick

    @election_tick.setter
    def election_tick(self, election_tick):
        """Sets the election_tick of this SwarmSpecRaft.

        The number of ticks that a follower will wait for a message from the leader before becoming a candidate and starting an election. `ElectionTick` must be greater than `HeartbeatTick`.  A tick currently defaults to one second, so these translate directly to seconds currently, but this is NOT guaranteed.   # noqa: E501

        :param election_tick: The election_tick of this SwarmSpecRaft.  # noqa: E501
        :type: int
        """

        self._election_tick = election_tick

    @property
    def heartbeat_tick(self):
        """Gets the heartbeat_tick of this SwarmSpecRaft.  # noqa: E501

        The number of ticks between heartbeats. Every HeartbeatTick ticks, the leader will send a heartbeat to the followers.  A tick currently defaults to one second, so these translate directly to seconds currently, but this is NOT guaranteed.   # noqa: E501

        :return: The heartbeat_tick of this SwarmSpecRaft.  # noqa: E501
        :rtype: int
        """
        return self._heartbeat_tick

    @heartbeat_tick.setter
    def heartbeat_tick(self, heartbeat_tick):
        """Sets the heartbeat_tick of this SwarmSpecRaft.

        The number of ticks between heartbeats. Every HeartbeatTick ticks, the leader will send a heartbeat to the followers.  A tick currently defaults to one second, so these translate directly to seconds currently, but this is NOT guaranteed.   # noqa: E501

        :param heartbeat_tick: The heartbeat_tick of this SwarmSpecRaft.  # noqa: E501
        :type: int
        """

        self._heartbeat_tick = heartbeat_tick

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SwarmSpecRaft, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SwarmSpecRaft):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SwarmSpecRaft):
            return True

        return self.to_dict() != other.to_dict()
