# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class SystemEventsResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'type': 'str',
        'action': 'str',
        'actor': 'SystemEventsResponseActor',
        'time': 'int',
        'time_nano': 'int'
    }

    attribute_map = {
        'type': 'Type',
        'action': 'Action',
        'actor': 'Actor',
        'time': 'time',
        'time_nano': 'timeNano'
    }

    def __init__(self, type=None, action=None, actor=None, time=None, time_nano=None, _configuration=None):  # noqa: E501
        """SystemEventsResponse - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._type = None
        self._action = None
        self._actor = None
        self._time = None
        self._time_nano = None
        self.discriminator = None

        if type is not None:
            self.type = type
        if action is not None:
            self.action = action
        if actor is not None:
            self.actor = actor
        if time is not None:
            self.time = time
        if time_nano is not None:
            self.time_nano = time_nano

    @property
    def type(self):
        """Gets the type of this SystemEventsResponse.  # noqa: E501

        The type of object emitting the event  # noqa: E501

        :return: The type of this SystemEventsResponse.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this SystemEventsResponse.

        The type of object emitting the event  # noqa: E501

        :param type: The type of this SystemEventsResponse.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def action(self):
        """Gets the action of this SystemEventsResponse.  # noqa: E501

        The type of event  # noqa: E501

        :return: The action of this SystemEventsResponse.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this SystemEventsResponse.

        The type of event  # noqa: E501

        :param action: The action of this SystemEventsResponse.  # noqa: E501
        :type: str
        """

        self._action = action

    @property
    def actor(self):
        """Gets the actor of this SystemEventsResponse.  # noqa: E501


        :return: The actor of this SystemEventsResponse.  # noqa: E501
        :rtype: SystemEventsResponseActor
        """
        return self._actor

    @actor.setter
    def actor(self, actor):
        """Sets the actor of this SystemEventsResponse.


        :param actor: The actor of this SystemEventsResponse.  # noqa: E501
        :type: SystemEventsResponseActor
        """

        self._actor = actor

    @property
    def time(self):
        """Gets the time of this SystemEventsResponse.  # noqa: E501

        Timestamp of event  # noqa: E501

        :return: The time of this SystemEventsResponse.  # noqa: E501
        :rtype: int
        """
        return self._time

    @time.setter
    def time(self, time):
        """Sets the time of this SystemEventsResponse.

        Timestamp of event  # noqa: E501

        :param time: The time of this SystemEventsResponse.  # noqa: E501
        :type: int
        """

        self._time = time

    @property
    def time_nano(self):
        """Gets the time_nano of this SystemEventsResponse.  # noqa: E501

        Timestamp of event, with nanosecond accuracy  # noqa: E501

        :return: The time_nano of this SystemEventsResponse.  # noqa: E501
        :rtype: int
        """
        return self._time_nano

    @time_nano.setter
    def time_nano(self, time_nano):
        """Sets the time_nano of this SystemEventsResponse.

        Timestamp of event, with nanosecond accuracy  # noqa: E501

        :param time_nano: The time_nano of this SystemEventsResponse.  # noqa: E501
        :type: int
        """

        self._time_nano = time_nano

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SystemEventsResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SystemEventsResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SystemEventsResponse):
            return True

        return self.to_dict() != other.to_dict()
