# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class SystemInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'containers': 'int',
        'containers_running': 'int',
        'containers_paused': 'int',
        'containers_stopped': 'int',
        'images': 'int',
        'driver': 'str',
        'driver_status': 'list[list[str]]',
        'docker_root_dir': 'str',
        'plugins': 'PluginsInfo',
        'memory_limit': 'bool',
        'swap_limit': 'bool',
        'kernel_memory': 'bool',
        'cpu_cfs_period': 'bool',
        'cpu_cfs_quota': 'bool',
        'cpu_shares': 'bool',
        'cpu_set': 'bool',
        'pids_limit': 'bool',
        'oom_kill_disable': 'bool',
        'i_pv4_forwarding': 'bool',
        'bridge_nf_iptables': 'bool',
        'bridge_nf_ip6tables': 'bool',
        'debug': 'bool',
        'n_fd': 'int',
        'n_goroutines': 'int',
        'system_time': 'str',
        'logging_driver': 'str',
        'cgroup_driver': 'str',
        'cgroup_version': 'str',
        'n_events_listener': 'int',
        'kernel_version': 'str',
        'operating_system': 'str',
        'os_version': 'str',
        'os_type': 'str',
        'architecture': 'str',
        'ncpu': 'int',
        'mem_total': 'int',
        'index_server_address': 'str',
        'registry_config': 'RegistryServiceConfig',
        'generic_resources': 'GenericResources',
        'http_proxy': 'str',
        'https_proxy': 'str',
        'no_proxy': 'str',
        'name': 'str',
        'labels': 'list[str]',
        'experimental_build': 'bool',
        'server_version': 'str',
        'cluster_store': 'str',
        'cluster_advertise': 'str',
        'runtimes': 'dict(str, Runtime)',
        'default_runtime': 'str',
        'swarm': 'SwarmInfo',
        'live_restore_enabled': 'bool',
        'isolation': 'str',
        'init_binary': 'str',
        'containerd_commit': 'Commit',
        'runc_commit': 'Commit',
        'init_commit': 'Commit',
        'security_options': 'list[str]',
        'product_license': 'str',
        'default_address_pools': 'list[SystemInfoDefaultAddressPools]',
        'warnings': 'list[str]'
    }

    attribute_map = {
        'id': 'ID',
        'containers': 'Containers',
        'containers_running': 'ContainersRunning',
        'containers_paused': 'ContainersPaused',
        'containers_stopped': 'ContainersStopped',
        'images': 'Images',
        'driver': 'Driver',
        'driver_status': 'DriverStatus',
        'docker_root_dir': 'DockerRootDir',
        'plugins': 'Plugins',
        'memory_limit': 'MemoryLimit',
        'swap_limit': 'SwapLimit',
        'kernel_memory': 'KernelMemory',
        'cpu_cfs_period': 'CpuCfsPeriod',
        'cpu_cfs_quota': 'CpuCfsQuota',
        'cpu_shares': 'CPUShares',
        'cpu_set': 'CPUSet',
        'pids_limit': 'PidsLimit',
        'oom_kill_disable': 'OomKillDisable',
        'i_pv4_forwarding': 'IPv4Forwarding',
        'bridge_nf_iptables': 'BridgeNfIptables',
        'bridge_nf_ip6tables': 'BridgeNfIp6tables',
        'debug': 'Debug',
        'n_fd': 'NFd',
        'n_goroutines': 'NGoroutines',
        'system_time': 'SystemTime',
        'logging_driver': 'LoggingDriver',
        'cgroup_driver': 'CgroupDriver',
        'cgroup_version': 'CgroupVersion',
        'n_events_listener': 'NEventsListener',
        'kernel_version': 'KernelVersion',
        'operating_system': 'OperatingSystem',
        'os_version': 'OSVersion',
        'os_type': 'OSType',
        'architecture': 'Architecture',
        'ncpu': 'NCPU',
        'mem_total': 'MemTotal',
        'index_server_address': 'IndexServerAddress',
        'registry_config': 'RegistryConfig',
        'generic_resources': 'GenericResources',
        'http_proxy': 'HttpProxy',
        'https_proxy': 'HttpsProxy',
        'no_proxy': 'NoProxy',
        'name': 'Name',
        'labels': 'Labels',
        'experimental_build': 'ExperimentalBuild',
        'server_version': 'ServerVersion',
        'cluster_store': 'ClusterStore',
        'cluster_advertise': 'ClusterAdvertise',
        'runtimes': 'Runtimes',
        'default_runtime': 'DefaultRuntime',
        'swarm': 'Swarm',
        'live_restore_enabled': 'LiveRestoreEnabled',
        'isolation': 'Isolation',
        'init_binary': 'InitBinary',
        'containerd_commit': 'ContainerdCommit',
        'runc_commit': 'RuncCommit',
        'init_commit': 'InitCommit',
        'security_options': 'SecurityOptions',
        'product_license': 'ProductLicense',
        'default_address_pools': 'DefaultAddressPools',
        'warnings': 'Warnings'
    }

    def __init__(self, id=None, containers=None, containers_running=None, containers_paused=None, containers_stopped=None, images=None, driver=None, driver_status=None, docker_root_dir=None, plugins=None, memory_limit=None, swap_limit=None, kernel_memory=None, cpu_cfs_period=None, cpu_cfs_quota=None, cpu_shares=None, cpu_set=None, pids_limit=None, oom_kill_disable=None, i_pv4_forwarding=None, bridge_nf_iptables=None, bridge_nf_ip6tables=None, debug=None, n_fd=None, n_goroutines=None, system_time=None, logging_driver=None, cgroup_driver='cgroupfs', cgroup_version='1', n_events_listener=None, kernel_version=None, operating_system=None, os_version=None, os_type=None, architecture=None, ncpu=None, mem_total=None, index_server_address='https://index.docker.io/v1/', registry_config=None, generic_resources=None, http_proxy=None, https_proxy=None, no_proxy=None, name=None, labels=None, experimental_build=None, server_version=None, cluster_store=None, cluster_advertise=None, runtimes=None, default_runtime='runc', swarm=None, live_restore_enabled=False, isolation='default', init_binary=None, containerd_commit=None, runc_commit=None, init_commit=None, security_options=None, product_license=None, default_address_pools=None, warnings=None, _configuration=None):  # noqa: E501
        """SystemInfo - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._id = None
        self._containers = None
        self._containers_running = None
        self._containers_paused = None
        self._containers_stopped = None
        self._images = None
        self._driver = None
        self._driver_status = None
        self._docker_root_dir = None
        self._plugins = None
        self._memory_limit = None
        self._swap_limit = None
        self._kernel_memory = None
        self._cpu_cfs_period = None
        self._cpu_cfs_quota = None
        self._cpu_shares = None
        self._cpu_set = None
        self._pids_limit = None
        self._oom_kill_disable = None
        self._i_pv4_forwarding = None
        self._bridge_nf_iptables = None
        self._bridge_nf_ip6tables = None
        self._debug = None
        self._n_fd = None
        self._n_goroutines = None
        self._system_time = None
        self._logging_driver = None
        self._cgroup_driver = None
        self._cgroup_version = None
        self._n_events_listener = None
        self._kernel_version = None
        self._operating_system = None
        self._os_version = None
        self._os_type = None
        self._architecture = None
        self._ncpu = None
        self._mem_total = None
        self._index_server_address = None
        self._registry_config = None
        self._generic_resources = None
        self._http_proxy = None
        self._https_proxy = None
        self._no_proxy = None
        self._name = None
        self._labels = None
        self._experimental_build = None
        self._server_version = None
        self._cluster_store = None
        self._cluster_advertise = None
        self._runtimes = None
        self._default_runtime = None
        self._swarm = None
        self._live_restore_enabled = None
        self._isolation = None
        self._init_binary = None
        self._containerd_commit = None
        self._runc_commit = None
        self._init_commit = None
        self._security_options = None
        self._product_license = None
        self._default_address_pools = None
        self._warnings = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if containers is not None:
            self.containers = containers
        if containers_running is not None:
            self.containers_running = containers_running
        if containers_paused is not None:
            self.containers_paused = containers_paused
        if containers_stopped is not None:
            self.containers_stopped = containers_stopped
        if images is not None:
            self.images = images
        if driver is not None:
            self.driver = driver
        if driver_status is not None:
            self.driver_status = driver_status
        if docker_root_dir is not None:
            self.docker_root_dir = docker_root_dir
        if plugins is not None:
            self.plugins = plugins
        if memory_limit is not None:
            self.memory_limit = memory_limit
        if swap_limit is not None:
            self.swap_limit = swap_limit
        if kernel_memory is not None:
            self.kernel_memory = kernel_memory
        if cpu_cfs_period is not None:
            self.cpu_cfs_period = cpu_cfs_period
        if cpu_cfs_quota is not None:
            self.cpu_cfs_quota = cpu_cfs_quota
        if cpu_shares is not None:
            self.cpu_shares = cpu_shares
        if cpu_set is not None:
            self.cpu_set = cpu_set
        if pids_limit is not None:
            self.pids_limit = pids_limit
        if oom_kill_disable is not None:
            self.oom_kill_disable = oom_kill_disable
        if i_pv4_forwarding is not None:
            self.i_pv4_forwarding = i_pv4_forwarding
        if bridge_nf_iptables is not None:
            self.bridge_nf_iptables = bridge_nf_iptables
        if bridge_nf_ip6tables is not None:
            self.bridge_nf_ip6tables = bridge_nf_ip6tables
        if debug is not None:
            self.debug = debug
        if n_fd is not None:
            self.n_fd = n_fd
        if n_goroutines is not None:
            self.n_goroutines = n_goroutines
        if system_time is not None:
            self.system_time = system_time
        if logging_driver is not None:
            self.logging_driver = logging_driver
        if cgroup_driver is not None:
            self.cgroup_driver = cgroup_driver
        if cgroup_version is not None:
            self.cgroup_version = cgroup_version
        if n_events_listener is not None:
            self.n_events_listener = n_events_listener
        if kernel_version is not None:
            self.kernel_version = kernel_version
        if operating_system is not None:
            self.operating_system = operating_system
        if os_version is not None:
            self.os_version = os_version
        if os_type is not None:
            self.os_type = os_type
        if architecture is not None:
            self.architecture = architecture
        if ncpu is not None:
            self.ncpu = ncpu
        if mem_total is not None:
            self.mem_total = mem_total
        if index_server_address is not None:
            self.index_server_address = index_server_address
        if registry_config is not None:
            self.registry_config = registry_config
        if generic_resources is not None:
            self.generic_resources = generic_resources
        if http_proxy is not None:
            self.http_proxy = http_proxy
        if https_proxy is not None:
            self.https_proxy = https_proxy
        if no_proxy is not None:
            self.no_proxy = no_proxy
        if name is not None:
            self.name = name
        if labels is not None:
            self.labels = labels
        if experimental_build is not None:
            self.experimental_build = experimental_build
        if server_version is not None:
            self.server_version = server_version
        if cluster_store is not None:
            self.cluster_store = cluster_store
        if cluster_advertise is not None:
            self.cluster_advertise = cluster_advertise
        if runtimes is not None:
            self.runtimes = runtimes
        if default_runtime is not None:
            self.default_runtime = default_runtime
        if swarm is not None:
            self.swarm = swarm
        if live_restore_enabled is not None:
            self.live_restore_enabled = live_restore_enabled
        if isolation is not None:
            self.isolation = isolation
        if init_binary is not None:
            self.init_binary = init_binary
        if containerd_commit is not None:
            self.containerd_commit = containerd_commit
        if runc_commit is not None:
            self.runc_commit = runc_commit
        if init_commit is not None:
            self.init_commit = init_commit
        if security_options is not None:
            self.security_options = security_options
        if product_license is not None:
            self.product_license = product_license
        if default_address_pools is not None:
            self.default_address_pools = default_address_pools
        if warnings is not None:
            self.warnings = warnings

    @property
    def id(self):
        """Gets the id of this SystemInfo.  # noqa: E501

        Unique identifier of the daemon.  <p><br /></p>  > **Note**: The format of the ID itself is not part of the API, and > should not be considered stable.   # noqa: E501

        :return: The id of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SystemInfo.

        Unique identifier of the daemon.  <p><br /></p>  > **Note**: The format of the ID itself is not part of the API, and > should not be considered stable.   # noqa: E501

        :param id: The id of this SystemInfo.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def containers(self):
        """Gets the containers of this SystemInfo.  # noqa: E501

        Total number of containers on the host.  # noqa: E501

        :return: The containers of this SystemInfo.  # noqa: E501
        :rtype: int
        """
        return self._containers

    @containers.setter
    def containers(self, containers):
        """Sets the containers of this SystemInfo.

        Total number of containers on the host.  # noqa: E501

        :param containers: The containers of this SystemInfo.  # noqa: E501
        :type: int
        """

        self._containers = containers

    @property
    def containers_running(self):
        """Gets the containers_running of this SystemInfo.  # noqa: E501

        Number of containers with status `\"running\"`.   # noqa: E501

        :return: The containers_running of this SystemInfo.  # noqa: E501
        :rtype: int
        """
        return self._containers_running

    @containers_running.setter
    def containers_running(self, containers_running):
        """Sets the containers_running of this SystemInfo.

        Number of containers with status `\"running\"`.   # noqa: E501

        :param containers_running: The containers_running of this SystemInfo.  # noqa: E501
        :type: int
        """

        self._containers_running = containers_running

    @property
    def containers_paused(self):
        """Gets the containers_paused of this SystemInfo.  # noqa: E501

        Number of containers with status `\"paused\"`.   # noqa: E501

        :return: The containers_paused of this SystemInfo.  # noqa: E501
        :rtype: int
        """
        return self._containers_paused

    @containers_paused.setter
    def containers_paused(self, containers_paused):
        """Sets the containers_paused of this SystemInfo.

        Number of containers with status `\"paused\"`.   # noqa: E501

        :param containers_paused: The containers_paused of this SystemInfo.  # noqa: E501
        :type: int
        """

        self._containers_paused = containers_paused

    @property
    def containers_stopped(self):
        """Gets the containers_stopped of this SystemInfo.  # noqa: E501

        Number of containers with status `\"stopped\"`.   # noqa: E501

        :return: The containers_stopped of this SystemInfo.  # noqa: E501
        :rtype: int
        """
        return self._containers_stopped

    @containers_stopped.setter
    def containers_stopped(self, containers_stopped):
        """Sets the containers_stopped of this SystemInfo.

        Number of containers with status `\"stopped\"`.   # noqa: E501

        :param containers_stopped: The containers_stopped of this SystemInfo.  # noqa: E501
        :type: int
        """

        self._containers_stopped = containers_stopped

    @property
    def images(self):
        """Gets the images of this SystemInfo.  # noqa: E501

        Total number of images on the host.  Both _tagged_ and _untagged_ (dangling) images are counted.   # noqa: E501

        :return: The images of this SystemInfo.  # noqa: E501
        :rtype: int
        """
        return self._images

    @images.setter
    def images(self, images):
        """Sets the images of this SystemInfo.

        Total number of images on the host.  Both _tagged_ and _untagged_ (dangling) images are counted.   # noqa: E501

        :param images: The images of this SystemInfo.  # noqa: E501
        :type: int
        """

        self._images = images

    @property
    def driver(self):
        """Gets the driver of this SystemInfo.  # noqa: E501

        Name of the storage driver in use.  # noqa: E501

        :return: The driver of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._driver

    @driver.setter
    def driver(self, driver):
        """Sets the driver of this SystemInfo.

        Name of the storage driver in use.  # noqa: E501

        :param driver: The driver of this SystemInfo.  # noqa: E501
        :type: str
        """

        self._driver = driver

    @property
    def driver_status(self):
        """Gets the driver_status of this SystemInfo.  # noqa: E501

        Information specific to the storage driver, provided as \"label\" / \"value\" pairs.  This information is provided by the storage driver, and formatted in a way consistent with the output of `docker info` on the command line.  <p><br /></p>  > **Note**: The information returned in this field, including the > formatting of values and labels, should not be considered stable, > and may change without notice.   # noqa: E501

        :return: The driver_status of this SystemInfo.  # noqa: E501
        :rtype: list[list[str]]
        """
        return self._driver_status

    @driver_status.setter
    def driver_status(self, driver_status):
        """Sets the driver_status of this SystemInfo.

        Information specific to the storage driver, provided as \"label\" / \"value\" pairs.  This information is provided by the storage driver, and formatted in a way consistent with the output of `docker info` on the command line.  <p><br /></p>  > **Note**: The information returned in this field, including the > formatting of values and labels, should not be considered stable, > and may change without notice.   # noqa: E501

        :param driver_status: The driver_status of this SystemInfo.  # noqa: E501
        :type: list[list[str]]
        """

        self._driver_status = driver_status

    @property
    def docker_root_dir(self):
        """Gets the docker_root_dir of this SystemInfo.  # noqa: E501

        Root directory of persistent Docker state.  Defaults to `/var/lib/docker` on Linux, and `C:\\ProgramData\\docker` on Windows.   # noqa: E501

        :return: The docker_root_dir of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._docker_root_dir

    @docker_root_dir.setter
    def docker_root_dir(self, docker_root_dir):
        """Sets the docker_root_dir of this SystemInfo.

        Root directory of persistent Docker state.  Defaults to `/var/lib/docker` on Linux, and `C:\\ProgramData\\docker` on Windows.   # noqa: E501

        :param docker_root_dir: The docker_root_dir of this SystemInfo.  # noqa: E501
        :type: str
        """

        self._docker_root_dir = docker_root_dir

    @property
    def plugins(self):
        """Gets the plugins of this SystemInfo.  # noqa: E501


        :return: The plugins of this SystemInfo.  # noqa: E501
        :rtype: PluginsInfo
        """
        return self._plugins

    @plugins.setter
    def plugins(self, plugins):
        """Sets the plugins of this SystemInfo.


        :param plugins: The plugins of this SystemInfo.  # noqa: E501
        :type: PluginsInfo
        """

        self._plugins = plugins

    @property
    def memory_limit(self):
        """Gets the memory_limit of this SystemInfo.  # noqa: E501

        Indicates if the host has memory limit support enabled.  # noqa: E501

        :return: The memory_limit of this SystemInfo.  # noqa: E501
        :rtype: bool
        """
        return self._memory_limit

    @memory_limit.setter
    def memory_limit(self, memory_limit):
        """Sets the memory_limit of this SystemInfo.

        Indicates if the host has memory limit support enabled.  # noqa: E501

        :param memory_limit: The memory_limit of this SystemInfo.  # noqa: E501
        :type: bool
        """

        self._memory_limit = memory_limit

    @property
    def swap_limit(self):
        """Gets the swap_limit of this SystemInfo.  # noqa: E501

        Indicates if the host has memory swap limit support enabled.  # noqa: E501

        :return: The swap_limit of this SystemInfo.  # noqa: E501
        :rtype: bool
        """
        return self._swap_limit

    @swap_limit.setter
    def swap_limit(self, swap_limit):
        """Sets the swap_limit of this SystemInfo.

        Indicates if the host has memory swap limit support enabled.  # noqa: E501

        :param swap_limit: The swap_limit of this SystemInfo.  # noqa: E501
        :type: bool
        """

        self._swap_limit = swap_limit

    @property
    def kernel_memory(self):
        """Gets the kernel_memory of this SystemInfo.  # noqa: E501

        Indicates if the host has kernel memory limit support enabled.  <p><br /></p>  > **Deprecated**: This field is deprecated as the kernel 5.4 deprecated > `kmem.limit_in_bytes`.   # noqa: E501

        :return: The kernel_memory of this SystemInfo.  # noqa: E501
        :rtype: bool
        """
        return self._kernel_memory

    @kernel_memory.setter
    def kernel_memory(self, kernel_memory):
        """Sets the kernel_memory of this SystemInfo.

        Indicates if the host has kernel memory limit support enabled.  <p><br /></p>  > **Deprecated**: This field is deprecated as the kernel 5.4 deprecated > `kmem.limit_in_bytes`.   # noqa: E501

        :param kernel_memory: The kernel_memory of this SystemInfo.  # noqa: E501
        :type: bool
        """

        self._kernel_memory = kernel_memory

    @property
    def cpu_cfs_period(self):
        """Gets the cpu_cfs_period of this SystemInfo.  # noqa: E501

        Indicates if CPU CFS(Completely Fair Scheduler) period is supported by the host.   # noqa: E501

        :return: The cpu_cfs_period of this SystemInfo.  # noqa: E501
        :rtype: bool
        """
        return self._cpu_cfs_period

    @cpu_cfs_period.setter
    def cpu_cfs_period(self, cpu_cfs_period):
        """Sets the cpu_cfs_period of this SystemInfo.

        Indicates if CPU CFS(Completely Fair Scheduler) period is supported by the host.   # noqa: E501

        :param cpu_cfs_period: The cpu_cfs_period of this SystemInfo.  # noqa: E501
        :type: bool
        """

        self._cpu_cfs_period = cpu_cfs_period

    @property
    def cpu_cfs_quota(self):
        """Gets the cpu_cfs_quota of this SystemInfo.  # noqa: E501

        Indicates if CPU CFS(Completely Fair Scheduler) quota is supported by the host.   # noqa: E501

        :return: The cpu_cfs_quota of this SystemInfo.  # noqa: E501
        :rtype: bool
        """
        return self._cpu_cfs_quota

    @cpu_cfs_quota.setter
    def cpu_cfs_quota(self, cpu_cfs_quota):
        """Sets the cpu_cfs_quota of this SystemInfo.

        Indicates if CPU CFS(Completely Fair Scheduler) quota is supported by the host.   # noqa: E501

        :param cpu_cfs_quota: The cpu_cfs_quota of this SystemInfo.  # noqa: E501
        :type: bool
        """

        self._cpu_cfs_quota = cpu_cfs_quota

    @property
    def cpu_shares(self):
        """Gets the cpu_shares of this SystemInfo.  # noqa: E501

        Indicates if CPU Shares limiting is supported by the host.   # noqa: E501

        :return: The cpu_shares of this SystemInfo.  # noqa: E501
        :rtype: bool
        """
        return self._cpu_shares

    @cpu_shares.setter
    def cpu_shares(self, cpu_shares):
        """Sets the cpu_shares of this SystemInfo.

        Indicates if CPU Shares limiting is supported by the host.   # noqa: E501

        :param cpu_shares: The cpu_shares of this SystemInfo.  # noqa: E501
        :type: bool
        """

        self._cpu_shares = cpu_shares

    @property
    def cpu_set(self):
        """Gets the cpu_set of this SystemInfo.  # noqa: E501

        Indicates if CPUsets (cpuset.cpus, cpuset.mems) are supported by the host.  See [cpuset(7)](https://www.kernel.org/doc/Documentation/cgroup-v1/cpusets.txt)   # noqa: E501

        :return: The cpu_set of this SystemInfo.  # noqa: E501
        :rtype: bool
        """
        return self._cpu_set

    @cpu_set.setter
    def cpu_set(self, cpu_set):
        """Sets the cpu_set of this SystemInfo.

        Indicates if CPUsets (cpuset.cpus, cpuset.mems) are supported by the host.  See [cpuset(7)](https://www.kernel.org/doc/Documentation/cgroup-v1/cpusets.txt)   # noqa: E501

        :param cpu_set: The cpu_set of this SystemInfo.  # noqa: E501
        :type: bool
        """

        self._cpu_set = cpu_set

    @property
    def pids_limit(self):
        """Gets the pids_limit of this SystemInfo.  # noqa: E501

        Indicates if the host kernel has PID limit support enabled.  # noqa: E501

        :return: The pids_limit of this SystemInfo.  # noqa: E501
        :rtype: bool
        """
        return self._pids_limit

    @pids_limit.setter
    def pids_limit(self, pids_limit):
        """Sets the pids_limit of this SystemInfo.

        Indicates if the host kernel has PID limit support enabled.  # noqa: E501

        :param pids_limit: The pids_limit of this SystemInfo.  # noqa: E501
        :type: bool
        """

        self._pids_limit = pids_limit

    @property
    def oom_kill_disable(self):
        """Gets the oom_kill_disable of this SystemInfo.  # noqa: E501

        Indicates if OOM killer disable is supported on the host.  # noqa: E501

        :return: The oom_kill_disable of this SystemInfo.  # noqa: E501
        :rtype: bool
        """
        return self._oom_kill_disable

    @oom_kill_disable.setter
    def oom_kill_disable(self, oom_kill_disable):
        """Sets the oom_kill_disable of this SystemInfo.

        Indicates if OOM killer disable is supported on the host.  # noqa: E501

        :param oom_kill_disable: The oom_kill_disable of this SystemInfo.  # noqa: E501
        :type: bool
        """

        self._oom_kill_disable = oom_kill_disable

    @property
    def i_pv4_forwarding(self):
        """Gets the i_pv4_forwarding of this SystemInfo.  # noqa: E501

        Indicates IPv4 forwarding is enabled.  # noqa: E501

        :return: The i_pv4_forwarding of this SystemInfo.  # noqa: E501
        :rtype: bool
        """
        return self._i_pv4_forwarding

    @i_pv4_forwarding.setter
    def i_pv4_forwarding(self, i_pv4_forwarding):
        """Sets the i_pv4_forwarding of this SystemInfo.

        Indicates IPv4 forwarding is enabled.  # noqa: E501

        :param i_pv4_forwarding: The i_pv4_forwarding of this SystemInfo.  # noqa: E501
        :type: bool
        """

        self._i_pv4_forwarding = i_pv4_forwarding

    @property
    def bridge_nf_iptables(self):
        """Gets the bridge_nf_iptables of this SystemInfo.  # noqa: E501

        Indicates if `bridge-nf-call-iptables` is available on the host.  # noqa: E501

        :return: The bridge_nf_iptables of this SystemInfo.  # noqa: E501
        :rtype: bool
        """
        return self._bridge_nf_iptables

    @bridge_nf_iptables.setter
    def bridge_nf_iptables(self, bridge_nf_iptables):
        """Sets the bridge_nf_iptables of this SystemInfo.

        Indicates if `bridge-nf-call-iptables` is available on the host.  # noqa: E501

        :param bridge_nf_iptables: The bridge_nf_iptables of this SystemInfo.  # noqa: E501
        :type: bool
        """

        self._bridge_nf_iptables = bridge_nf_iptables

    @property
    def bridge_nf_ip6tables(self):
        """Gets the bridge_nf_ip6tables of this SystemInfo.  # noqa: E501

        Indicates if `bridge-nf-call-ip6tables` is available on the host.  # noqa: E501

        :return: The bridge_nf_ip6tables of this SystemInfo.  # noqa: E501
        :rtype: bool
        """
        return self._bridge_nf_ip6tables

    @bridge_nf_ip6tables.setter
    def bridge_nf_ip6tables(self, bridge_nf_ip6tables):
        """Sets the bridge_nf_ip6tables of this SystemInfo.

        Indicates if `bridge-nf-call-ip6tables` is available on the host.  # noqa: E501

        :param bridge_nf_ip6tables: The bridge_nf_ip6tables of this SystemInfo.  # noqa: E501
        :type: bool
        """

        self._bridge_nf_ip6tables = bridge_nf_ip6tables

    @property
    def debug(self):
        """Gets the debug of this SystemInfo.  # noqa: E501

        Indicates if the daemon is running in debug-mode / with debug-level logging enabled.   # noqa: E501

        :return: The debug of this SystemInfo.  # noqa: E501
        :rtype: bool
        """
        return self._debug

    @debug.setter
    def debug(self, debug):
        """Sets the debug of this SystemInfo.

        Indicates if the daemon is running in debug-mode / with debug-level logging enabled.   # noqa: E501

        :param debug: The debug of this SystemInfo.  # noqa: E501
        :type: bool
        """

        self._debug = debug

    @property
    def n_fd(self):
        """Gets the n_fd of this SystemInfo.  # noqa: E501

        The total number of file Descriptors in use by the daemon process.  This information is only returned if debug-mode is enabled.   # noqa: E501

        :return: The n_fd of this SystemInfo.  # noqa: E501
        :rtype: int
        """
        return self._n_fd

    @n_fd.setter
    def n_fd(self, n_fd):
        """Sets the n_fd of this SystemInfo.

        The total number of file Descriptors in use by the daemon process.  This information is only returned if debug-mode is enabled.   # noqa: E501

        :param n_fd: The n_fd of this SystemInfo.  # noqa: E501
        :type: int
        """

        self._n_fd = n_fd

    @property
    def n_goroutines(self):
        """Gets the n_goroutines of this SystemInfo.  # noqa: E501

        The  number of goroutines that currently exist.  This information is only returned if debug-mode is enabled.   # noqa: E501

        :return: The n_goroutines of this SystemInfo.  # noqa: E501
        :rtype: int
        """
        return self._n_goroutines

    @n_goroutines.setter
    def n_goroutines(self, n_goroutines):
        """Sets the n_goroutines of this SystemInfo.

        The  number of goroutines that currently exist.  This information is only returned if debug-mode is enabled.   # noqa: E501

        :param n_goroutines: The n_goroutines of this SystemInfo.  # noqa: E501
        :type: int
        """

        self._n_goroutines = n_goroutines

    @property
    def system_time(self):
        """Gets the system_time of this SystemInfo.  # noqa: E501

        Current system-time in [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format with nano-seconds.   # noqa: E501

        :return: The system_time of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._system_time

    @system_time.setter
    def system_time(self, system_time):
        """Sets the system_time of this SystemInfo.

        Current system-time in [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format with nano-seconds.   # noqa: E501

        :param system_time: The system_time of this SystemInfo.  # noqa: E501
        :type: str
        """

        self._system_time = system_time

    @property
    def logging_driver(self):
        """Gets the logging_driver of this SystemInfo.  # noqa: E501

        The logging driver to use as a default for new containers.   # noqa: E501

        :return: The logging_driver of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._logging_driver

    @logging_driver.setter
    def logging_driver(self, logging_driver):
        """Sets the logging_driver of this SystemInfo.

        The logging driver to use as a default for new containers.   # noqa: E501

        :param logging_driver: The logging_driver of this SystemInfo.  # noqa: E501
        :type: str
        """

        self._logging_driver = logging_driver

    @property
    def cgroup_driver(self):
        """Gets the cgroup_driver of this SystemInfo.  # noqa: E501

        The driver to use for managing cgroups.   # noqa: E501

        :return: The cgroup_driver of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._cgroup_driver

    @cgroup_driver.setter
    def cgroup_driver(self, cgroup_driver):
        """Sets the cgroup_driver of this SystemInfo.

        The driver to use for managing cgroups.   # noqa: E501

        :param cgroup_driver: The cgroup_driver of this SystemInfo.  # noqa: E501
        :type: str
        """
        allowed_values = ["cgroupfs", "systemd", "none"]  # noqa: E501
        if (self._configuration.client_side_validation and
                cgroup_driver not in allowed_values):
            raise ValueError(
                "Invalid value for `cgroup_driver` ({0}), must be one of {1}"  # noqa: E501
                .format(cgroup_driver, allowed_values)
            )

        self._cgroup_driver = cgroup_driver

    @property
    def cgroup_version(self):
        """Gets the cgroup_version of this SystemInfo.  # noqa: E501

        The version of the cgroup.   # noqa: E501

        :return: The cgroup_version of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._cgroup_version

    @cgroup_version.setter
    def cgroup_version(self, cgroup_version):
        """Sets the cgroup_version of this SystemInfo.

        The version of the cgroup.   # noqa: E501

        :param cgroup_version: The cgroup_version of this SystemInfo.  # noqa: E501
        :type: str
        """
        allowed_values = ["1", "2"]  # noqa: E501
        if (self._configuration.client_side_validation and
                cgroup_version not in allowed_values):
            raise ValueError(
                "Invalid value for `cgroup_version` ({0}), must be one of {1}"  # noqa: E501
                .format(cgroup_version, allowed_values)
            )

        self._cgroup_version = cgroup_version

    @property
    def n_events_listener(self):
        """Gets the n_events_listener of this SystemInfo.  # noqa: E501

        Number of event listeners subscribed.  # noqa: E501

        :return: The n_events_listener of this SystemInfo.  # noqa: E501
        :rtype: int
        """
        return self._n_events_listener

    @n_events_listener.setter
    def n_events_listener(self, n_events_listener):
        """Sets the n_events_listener of this SystemInfo.

        Number of event listeners subscribed.  # noqa: E501

        :param n_events_listener: The n_events_listener of this SystemInfo.  # noqa: E501
        :type: int
        """

        self._n_events_listener = n_events_listener

    @property
    def kernel_version(self):
        """Gets the kernel_version of this SystemInfo.  # noqa: E501

        Kernel version of the host.  On Linux, this information obtained from `uname`. On Windows this information is queried from the <kbd>HKEY_LOCAL_MACHINE\\\\SOFTWARE\\\\Microsoft\\\\Windows NT\\\\CurrentVersion\\\\</kbd> registry value, for example _\"10.0 14393 (14393.1198.amd64fre.rs1_release_sec.170427-1353)\"_.   # noqa: E501

        :return: The kernel_version of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._kernel_version

    @kernel_version.setter
    def kernel_version(self, kernel_version):
        """Sets the kernel_version of this SystemInfo.

        Kernel version of the host.  On Linux, this information obtained from `uname`. On Windows this information is queried from the <kbd>HKEY_LOCAL_MACHINE\\\\SOFTWARE\\\\Microsoft\\\\Windows NT\\\\CurrentVersion\\\\</kbd> registry value, for example _\"10.0 14393 (14393.1198.amd64fre.rs1_release_sec.170427-1353)\"_.   # noqa: E501

        :param kernel_version: The kernel_version of this SystemInfo.  # noqa: E501
        :type: str
        """

        self._kernel_version = kernel_version

    @property
    def operating_system(self):
        """Gets the operating_system of this SystemInfo.  # noqa: E501

        Name of the host's operating system, for example: \"Ubuntu 16.04.2 LTS\" or \"Windows Server 2016 Datacenter\"   # noqa: E501

        :return: The operating_system of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._operating_system

    @operating_system.setter
    def operating_system(self, operating_system):
        """Sets the operating_system of this SystemInfo.

        Name of the host's operating system, for example: \"Ubuntu 16.04.2 LTS\" or \"Windows Server 2016 Datacenter\"   # noqa: E501

        :param operating_system: The operating_system of this SystemInfo.  # noqa: E501
        :type: str
        """

        self._operating_system = operating_system

    @property
    def os_version(self):
        """Gets the os_version of this SystemInfo.  # noqa: E501

        Version of the host's operating system  <p><br /></p>  > **Note**: The information returned in this field, including its > very existence, and the formatting of values, should not be considered > stable, and may change without notice.   # noqa: E501

        :return: The os_version of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._os_version

    @os_version.setter
    def os_version(self, os_version):
        """Sets the os_version of this SystemInfo.

        Version of the host's operating system  <p><br /></p>  > **Note**: The information returned in this field, including its > very existence, and the formatting of values, should not be considered > stable, and may change without notice.   # noqa: E501

        :param os_version: The os_version of this SystemInfo.  # noqa: E501
        :type: str
        """

        self._os_version = os_version

    @property
    def os_type(self):
        """Gets the os_type of this SystemInfo.  # noqa: E501

        Generic type of the operating system of the host, as returned by the Go runtime (`GOOS`).  Currently returned values are \"linux\" and \"windows\". A full list of possible values can be found in the [Go documentation](https://golang.org/doc/install/source#environment).   # noqa: E501

        :return: The os_type of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._os_type

    @os_type.setter
    def os_type(self, os_type):
        """Sets the os_type of this SystemInfo.

        Generic type of the operating system of the host, as returned by the Go runtime (`GOOS`).  Currently returned values are \"linux\" and \"windows\". A full list of possible values can be found in the [Go documentation](https://golang.org/doc/install/source#environment).   # noqa: E501

        :param os_type: The os_type of this SystemInfo.  # noqa: E501
        :type: str
        """

        self._os_type = os_type

    @property
    def architecture(self):
        """Gets the architecture of this SystemInfo.  # noqa: E501

        Hardware architecture of the host, as returned by the Go runtime (`GOARCH`).  A full list of possible values can be found in the [Go documentation](https://golang.org/doc/install/source#environment).   # noqa: E501

        :return: The architecture of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._architecture

    @architecture.setter
    def architecture(self, architecture):
        """Sets the architecture of this SystemInfo.

        Hardware architecture of the host, as returned by the Go runtime (`GOARCH`).  A full list of possible values can be found in the [Go documentation](https://golang.org/doc/install/source#environment).   # noqa: E501

        :param architecture: The architecture of this SystemInfo.  # noqa: E501
        :type: str
        """

        self._architecture = architecture

    @property
    def ncpu(self):
        """Gets the ncpu of this SystemInfo.  # noqa: E501

        The number of logical CPUs usable by the daemon.  The number of available CPUs is checked by querying the operating system when the daemon starts. Changes to operating system CPU allocation after the daemon is started are not reflected.   # noqa: E501

        :return: The ncpu of this SystemInfo.  # noqa: E501
        :rtype: int
        """
        return self._ncpu

    @ncpu.setter
    def ncpu(self, ncpu):
        """Sets the ncpu of this SystemInfo.

        The number of logical CPUs usable by the daemon.  The number of available CPUs is checked by querying the operating system when the daemon starts. Changes to operating system CPU allocation after the daemon is started are not reflected.   # noqa: E501

        :param ncpu: The ncpu of this SystemInfo.  # noqa: E501
        :type: int
        """

        self._ncpu = ncpu

    @property
    def mem_total(self):
        """Gets the mem_total of this SystemInfo.  # noqa: E501

        Total amount of physical memory available on the host, in bytes.   # noqa: E501

        :return: The mem_total of this SystemInfo.  # noqa: E501
        :rtype: int
        """
        return self._mem_total

    @mem_total.setter
    def mem_total(self, mem_total):
        """Sets the mem_total of this SystemInfo.

        Total amount of physical memory available on the host, in bytes.   # noqa: E501

        :param mem_total: The mem_total of this SystemInfo.  # noqa: E501
        :type: int
        """

        self._mem_total = mem_total

    @property
    def index_server_address(self):
        """Gets the index_server_address of this SystemInfo.  # noqa: E501

        Address / URL of the index server that is used for image search, and as a default for user authentication for Docker Hub and Docker Cloud.   # noqa: E501

        :return: The index_server_address of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._index_server_address

    @index_server_address.setter
    def index_server_address(self, index_server_address):
        """Sets the index_server_address of this SystemInfo.

        Address / URL of the index server that is used for image search, and as a default for user authentication for Docker Hub and Docker Cloud.   # noqa: E501

        :param index_server_address: The index_server_address of this SystemInfo.  # noqa: E501
        :type: str
        """

        self._index_server_address = index_server_address

    @property
    def registry_config(self):
        """Gets the registry_config of this SystemInfo.  # noqa: E501


        :return: The registry_config of this SystemInfo.  # noqa: E501
        :rtype: RegistryServiceConfig
        """
        return self._registry_config

    @registry_config.setter
    def registry_config(self, registry_config):
        """Sets the registry_config of this SystemInfo.


        :param registry_config: The registry_config of this SystemInfo.  # noqa: E501
        :type: RegistryServiceConfig
        """

        self._registry_config = registry_config

    @property
    def generic_resources(self):
        """Gets the generic_resources of this SystemInfo.  # noqa: E501


        :return: The generic_resources of this SystemInfo.  # noqa: E501
        :rtype: GenericResources
        """
        return self._generic_resources

    @generic_resources.setter
    def generic_resources(self, generic_resources):
        """Sets the generic_resources of this SystemInfo.


        :param generic_resources: The generic_resources of this SystemInfo.  # noqa: E501
        :type: GenericResources
        """

        self._generic_resources = generic_resources

    @property
    def http_proxy(self):
        """Gets the http_proxy of this SystemInfo.  # noqa: E501

        HTTP-proxy configured for the daemon. This value is obtained from the [`HTTP_PROXY`](https://www.gnu.org/software/wget/manual/html_node/Proxies.html) environment variable. Credentials ([user info component](https://tools.ietf.org/html/rfc3986#section-3.2.1)) in the proxy URL are masked in the API response.  Containers do not automatically inherit this configuration.   # noqa: E501

        :return: The http_proxy of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._http_proxy

    @http_proxy.setter
    def http_proxy(self, http_proxy):
        """Sets the http_proxy of this SystemInfo.

        HTTP-proxy configured for the daemon. This value is obtained from the [`HTTP_PROXY`](https://www.gnu.org/software/wget/manual/html_node/Proxies.html) environment variable. Credentials ([user info component](https://tools.ietf.org/html/rfc3986#section-3.2.1)) in the proxy URL are masked in the API response.  Containers do not automatically inherit this configuration.   # noqa: E501

        :param http_proxy: The http_proxy of this SystemInfo.  # noqa: E501
        :type: str
        """

        self._http_proxy = http_proxy

    @property
    def https_proxy(self):
        """Gets the https_proxy of this SystemInfo.  # noqa: E501

        HTTPS-proxy configured for the daemon. This value is obtained from the [`HTTPS_PROXY`](https://www.gnu.org/software/wget/manual/html_node/Proxies.html) environment variable. Credentials ([user info component](https://tools.ietf.org/html/rfc3986#section-3.2.1)) in the proxy URL are masked in the API response.  Containers do not automatically inherit this configuration.   # noqa: E501

        :return: The https_proxy of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._https_proxy

    @https_proxy.setter
    def https_proxy(self, https_proxy):
        """Sets the https_proxy of this SystemInfo.

        HTTPS-proxy configured for the daemon. This value is obtained from the [`HTTPS_PROXY`](https://www.gnu.org/software/wget/manual/html_node/Proxies.html) environment variable. Credentials ([user info component](https://tools.ietf.org/html/rfc3986#section-3.2.1)) in the proxy URL are masked in the API response.  Containers do not automatically inherit this configuration.   # noqa: E501

        :param https_proxy: The https_proxy of this SystemInfo.  # noqa: E501
        :type: str
        """

        self._https_proxy = https_proxy

    @property
    def no_proxy(self):
        """Gets the no_proxy of this SystemInfo.  # noqa: E501

        Comma-separated list of domain extensions for which no proxy should be used. This value is obtained from the [`NO_PROXY`](https://www.gnu.org/software/wget/manual/html_node/Proxies.html) environment variable.  Containers do not automatically inherit this configuration.   # noqa: E501

        :return: The no_proxy of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._no_proxy

    @no_proxy.setter
    def no_proxy(self, no_proxy):
        """Sets the no_proxy of this SystemInfo.

        Comma-separated list of domain extensions for which no proxy should be used. This value is obtained from the [`NO_PROXY`](https://www.gnu.org/software/wget/manual/html_node/Proxies.html) environment variable.  Containers do not automatically inherit this configuration.   # noqa: E501

        :param no_proxy: The no_proxy of this SystemInfo.  # noqa: E501
        :type: str
        """

        self._no_proxy = no_proxy

    @property
    def name(self):
        """Gets the name of this SystemInfo.  # noqa: E501

        Hostname of the host.  # noqa: E501

        :return: The name of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SystemInfo.

        Hostname of the host.  # noqa: E501

        :param name: The name of this SystemInfo.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def labels(self):
        """Gets the labels of this SystemInfo.  # noqa: E501

        User-defined labels (key/value metadata) as set on the daemon.  <p><br /></p>  > **Note**: When part of a Swarm, nodes can both have _daemon_ labels, > set through the daemon configuration, and _node_ labels, set from a > manager node in the Swarm. Node labels are not included in this > field. Node labels can be retrieved using the `/nodes/(id)` endpoint > on a manager node in the Swarm.   # noqa: E501

        :return: The labels of this SystemInfo.  # noqa: E501
        :rtype: list[str]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this SystemInfo.

        User-defined labels (key/value metadata) as set on the daemon.  <p><br /></p>  > **Note**: When part of a Swarm, nodes can both have _daemon_ labels, > set through the daemon configuration, and _node_ labels, set from a > manager node in the Swarm. Node labels are not included in this > field. Node labels can be retrieved using the `/nodes/(id)` endpoint > on a manager node in the Swarm.   # noqa: E501

        :param labels: The labels of this SystemInfo.  # noqa: E501
        :type: list[str]
        """

        self._labels = labels

    @property
    def experimental_build(self):
        """Gets the experimental_build of this SystemInfo.  # noqa: E501

        Indicates if experimental features are enabled on the daemon.   # noqa: E501

        :return: The experimental_build of this SystemInfo.  # noqa: E501
        :rtype: bool
        """
        return self._experimental_build

    @experimental_build.setter
    def experimental_build(self, experimental_build):
        """Sets the experimental_build of this SystemInfo.

        Indicates if experimental features are enabled on the daemon.   # noqa: E501

        :param experimental_build: The experimental_build of this SystemInfo.  # noqa: E501
        :type: bool
        """

        self._experimental_build = experimental_build

    @property
    def server_version(self):
        """Gets the server_version of this SystemInfo.  # noqa: E501

        Version string of the daemon.  > **Note**: the [standalone Swarm API](https://docs.docker.com/swarm/swarm-api/) > returns the Swarm version instead of the daemon  version, for example > `swarm/1.2.8`.   # noqa: E501

        :return: The server_version of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._server_version

    @server_version.setter
    def server_version(self, server_version):
        """Sets the server_version of this SystemInfo.

        Version string of the daemon.  > **Note**: the [standalone Swarm API](https://docs.docker.com/swarm/swarm-api/) > returns the Swarm version instead of the daemon  version, for example > `swarm/1.2.8`.   # noqa: E501

        :param server_version: The server_version of this SystemInfo.  # noqa: E501
        :type: str
        """

        self._server_version = server_version

    @property
    def cluster_store(self):
        """Gets the cluster_store of this SystemInfo.  # noqa: E501

        URL of the distributed storage backend.   The storage backend is used for multihost networking (to store network and endpoint information) and by the node discovery mechanism.  <p><br /></p>  > **Deprecated**: This field is only propagated when using standalone Swarm > mode, and overlay networking using an external k/v store. Overlay > networks with Swarm mode enabled use the built-in raft store, and > this field will be empty.   # noqa: E501

        :return: The cluster_store of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._cluster_store

    @cluster_store.setter
    def cluster_store(self, cluster_store):
        """Sets the cluster_store of this SystemInfo.

        URL of the distributed storage backend.   The storage backend is used for multihost networking (to store network and endpoint information) and by the node discovery mechanism.  <p><br /></p>  > **Deprecated**: This field is only propagated when using standalone Swarm > mode, and overlay networking using an external k/v store. Overlay > networks with Swarm mode enabled use the built-in raft store, and > this field will be empty.   # noqa: E501

        :param cluster_store: The cluster_store of this SystemInfo.  # noqa: E501
        :type: str
        """

        self._cluster_store = cluster_store

    @property
    def cluster_advertise(self):
        """Gets the cluster_advertise of this SystemInfo.  # noqa: E501

        The network endpoint that the Engine advertises for the purpose of node discovery. ClusterAdvertise is a `host:port` combination on which the daemon is reachable by other hosts.  <p><br /></p>  > **Deprecated**: This field is only propagated when using standalone Swarm > mode, and overlay networking using an external k/v store. Overlay > networks with Swarm mode enabled use the built-in raft store, and > this field will be empty.   # noqa: E501

        :return: The cluster_advertise of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._cluster_advertise

    @cluster_advertise.setter
    def cluster_advertise(self, cluster_advertise):
        """Sets the cluster_advertise of this SystemInfo.

        The network endpoint that the Engine advertises for the purpose of node discovery. ClusterAdvertise is a `host:port` combination on which the daemon is reachable by other hosts.  <p><br /></p>  > **Deprecated**: This field is only propagated when using standalone Swarm > mode, and overlay networking using an external k/v store. Overlay > networks with Swarm mode enabled use the built-in raft store, and > this field will be empty.   # noqa: E501

        :param cluster_advertise: The cluster_advertise of this SystemInfo.  # noqa: E501
        :type: str
        """

        self._cluster_advertise = cluster_advertise

    @property
    def runtimes(self):
        """Gets the runtimes of this SystemInfo.  # noqa: E501

        List of [OCI compliant](https://github.com/opencontainers/runtime-spec) runtimes configured on the daemon. Keys hold the \"name\" used to reference the runtime.  The Docker daemon relies on an OCI compliant runtime (invoked via the `containerd` daemon) as its interface to the Linux kernel namespaces, cgroups, and SELinux.  The default runtime is `runc`, and automatically configured. Additional runtimes can be configured by the user and will be listed here.   # noqa: E501

        :return: The runtimes of this SystemInfo.  # noqa: E501
        :rtype: dict(str, Runtime)
        """
        return self._runtimes

    @runtimes.setter
    def runtimes(self, runtimes):
        """Sets the runtimes of this SystemInfo.

        List of [OCI compliant](https://github.com/opencontainers/runtime-spec) runtimes configured on the daemon. Keys hold the \"name\" used to reference the runtime.  The Docker daemon relies on an OCI compliant runtime (invoked via the `containerd` daemon) as its interface to the Linux kernel namespaces, cgroups, and SELinux.  The default runtime is `runc`, and automatically configured. Additional runtimes can be configured by the user and will be listed here.   # noqa: E501

        :param runtimes: The runtimes of this SystemInfo.  # noqa: E501
        :type: dict(str, Runtime)
        """

        self._runtimes = runtimes

    @property
    def default_runtime(self):
        """Gets the default_runtime of this SystemInfo.  # noqa: E501

        Name of the default OCI runtime that is used when starting containers.  The default can be overridden per-container at create time.   # noqa: E501

        :return: The default_runtime of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._default_runtime

    @default_runtime.setter
    def default_runtime(self, default_runtime):
        """Sets the default_runtime of this SystemInfo.

        Name of the default OCI runtime that is used when starting containers.  The default can be overridden per-container at create time.   # noqa: E501

        :param default_runtime: The default_runtime of this SystemInfo.  # noqa: E501
        :type: str
        """

        self._default_runtime = default_runtime

    @property
    def swarm(self):
        """Gets the swarm of this SystemInfo.  # noqa: E501


        :return: The swarm of this SystemInfo.  # noqa: E501
        :rtype: SwarmInfo
        """
        return self._swarm

    @swarm.setter
    def swarm(self, swarm):
        """Sets the swarm of this SystemInfo.


        :param swarm: The swarm of this SystemInfo.  # noqa: E501
        :type: SwarmInfo
        """

        self._swarm = swarm

    @property
    def live_restore_enabled(self):
        """Gets the live_restore_enabled of this SystemInfo.  # noqa: E501

        Indicates if live restore is enabled.  If enabled, containers are kept running when the daemon is shutdown or upon daemon start if running containers are detected.   # noqa: E501

        :return: The live_restore_enabled of this SystemInfo.  # noqa: E501
        :rtype: bool
        """
        return self._live_restore_enabled

    @live_restore_enabled.setter
    def live_restore_enabled(self, live_restore_enabled):
        """Sets the live_restore_enabled of this SystemInfo.

        Indicates if live restore is enabled.  If enabled, containers are kept running when the daemon is shutdown or upon daemon start if running containers are detected.   # noqa: E501

        :param live_restore_enabled: The live_restore_enabled of this SystemInfo.  # noqa: E501
        :type: bool
        """

        self._live_restore_enabled = live_restore_enabled

    @property
    def isolation(self):
        """Gets the isolation of this SystemInfo.  # noqa: E501

        Represents the isolation technology to use as a default for containers. The supported values are platform-specific.  If no isolation value is specified on daemon start, on Windows client, the default is `hyperv`, and on Windows server, the default is `process`.  This option is currently not used on other platforms.   # noqa: E501

        :return: The isolation of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._isolation

    @isolation.setter
    def isolation(self, isolation):
        """Sets the isolation of this SystemInfo.

        Represents the isolation technology to use as a default for containers. The supported values are platform-specific.  If no isolation value is specified on daemon start, on Windows client, the default is `hyperv`, and on Windows server, the default is `process`.  This option is currently not used on other platforms.   # noqa: E501

        :param isolation: The isolation of this SystemInfo.  # noqa: E501
        :type: str
        """
        allowed_values = ["default", "hyperv", "process"]  # noqa: E501
        if (self._configuration.client_side_validation and
                isolation not in allowed_values):
            raise ValueError(
                "Invalid value for `isolation` ({0}), must be one of {1}"  # noqa: E501
                .format(isolation, allowed_values)
            )

        self._isolation = isolation

    @property
    def init_binary(self):
        """Gets the init_binary of this SystemInfo.  # noqa: E501

        Name and, optional, path of the `docker-init` binary.  If the path is omitted, the daemon searches the host's `$PATH` for the binary and uses the first result.   # noqa: E501

        :return: The init_binary of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._init_binary

    @init_binary.setter
    def init_binary(self, init_binary):
        """Sets the init_binary of this SystemInfo.

        Name and, optional, path of the `docker-init` binary.  If the path is omitted, the daemon searches the host's `$PATH` for the binary and uses the first result.   # noqa: E501

        :param init_binary: The init_binary of this SystemInfo.  # noqa: E501
        :type: str
        """

        self._init_binary = init_binary

    @property
    def containerd_commit(self):
        """Gets the containerd_commit of this SystemInfo.  # noqa: E501


        :return: The containerd_commit of this SystemInfo.  # noqa: E501
        :rtype: Commit
        """
        return self._containerd_commit

    @containerd_commit.setter
    def containerd_commit(self, containerd_commit):
        """Sets the containerd_commit of this SystemInfo.


        :param containerd_commit: The containerd_commit of this SystemInfo.  # noqa: E501
        :type: Commit
        """

        self._containerd_commit = containerd_commit

    @property
    def runc_commit(self):
        """Gets the runc_commit of this SystemInfo.  # noqa: E501


        :return: The runc_commit of this SystemInfo.  # noqa: E501
        :rtype: Commit
        """
        return self._runc_commit

    @runc_commit.setter
    def runc_commit(self, runc_commit):
        """Sets the runc_commit of this SystemInfo.


        :param runc_commit: The runc_commit of this SystemInfo.  # noqa: E501
        :type: Commit
        """

        self._runc_commit = runc_commit

    @property
    def init_commit(self):
        """Gets the init_commit of this SystemInfo.  # noqa: E501


        :return: The init_commit of this SystemInfo.  # noqa: E501
        :rtype: Commit
        """
        return self._init_commit

    @init_commit.setter
    def init_commit(self, init_commit):
        """Sets the init_commit of this SystemInfo.


        :param init_commit: The init_commit of this SystemInfo.  # noqa: E501
        :type: Commit
        """

        self._init_commit = init_commit

    @property
    def security_options(self):
        """Gets the security_options of this SystemInfo.  # noqa: E501

        List of security features that are enabled on the daemon, such as apparmor, seccomp, SELinux, user-namespaces (userns), and rootless.  Additional configuration options for each security feature may be present, and are included as a comma-separated list of key/value pairs.   # noqa: E501

        :return: The security_options of this SystemInfo.  # noqa: E501
        :rtype: list[str]
        """
        return self._security_options

    @security_options.setter
    def security_options(self, security_options):
        """Sets the security_options of this SystemInfo.

        List of security features that are enabled on the daemon, such as apparmor, seccomp, SELinux, user-namespaces (userns), and rootless.  Additional configuration options for each security feature may be present, and are included as a comma-separated list of key/value pairs.   # noqa: E501

        :param security_options: The security_options of this SystemInfo.  # noqa: E501
        :type: list[str]
        """

        self._security_options = security_options

    @property
    def product_license(self):
        """Gets the product_license of this SystemInfo.  # noqa: E501

        Reports a summary of the product license on the daemon.  If a commercial license has been applied to the daemon, information such as number of nodes, and expiration are included.   # noqa: E501

        :return: The product_license of this SystemInfo.  # noqa: E501
        :rtype: str
        """
        return self._product_license

    @product_license.setter
    def product_license(self, product_license):
        """Sets the product_license of this SystemInfo.

        Reports a summary of the product license on the daemon.  If a commercial license has been applied to the daemon, information such as number of nodes, and expiration are included.   # noqa: E501

        :param product_license: The product_license of this SystemInfo.  # noqa: E501
        :type: str
        """

        self._product_license = product_license

    @property
    def default_address_pools(self):
        """Gets the default_address_pools of this SystemInfo.  # noqa: E501

        List of custom default address pools for local networks, which can be specified in the daemon.json file or dockerd option.  Example: a Base \"10.10.0.0/16\" with Size 24 will define the set of 256 10.10.[0-255].0/24 address pools.   # noqa: E501

        :return: The default_address_pools of this SystemInfo.  # noqa: E501
        :rtype: list[SystemInfoDefaultAddressPools]
        """
        return self._default_address_pools

    @default_address_pools.setter
    def default_address_pools(self, default_address_pools):
        """Sets the default_address_pools of this SystemInfo.

        List of custom default address pools for local networks, which can be specified in the daemon.json file or dockerd option.  Example: a Base \"10.10.0.0/16\" with Size 24 will define the set of 256 10.10.[0-255].0/24 address pools.   # noqa: E501

        :param default_address_pools: The default_address_pools of this SystemInfo.  # noqa: E501
        :type: list[SystemInfoDefaultAddressPools]
        """

        self._default_address_pools = default_address_pools

    @property
    def warnings(self):
        """Gets the warnings of this SystemInfo.  # noqa: E501

        List of warnings / informational messages about missing features, or issues related to the daemon configuration.  These messages can be printed by the client as information to the user.   # noqa: E501

        :return: The warnings of this SystemInfo.  # noqa: E501
        :rtype: list[str]
        """
        return self._warnings

    @warnings.setter
    def warnings(self, warnings):
        """Sets the warnings of this SystemInfo.

        List of warnings / informational messages about missing features, or issues related to the daemon configuration.  These messages can be printed by the client as information to the user.   # noqa: E501

        :param warnings: The warnings of this SystemInfo.  # noqa: E501
        :type: list[str]
        """

        self._warnings = warnings

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SystemInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SystemInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SystemInfo):
            return True

        return self.to_dict() != other.to_dict()
