# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class SystemVersion(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'platform': 'SystemVersionPlatform',
        'components': 'list[SystemVersionComponents]',
        'version': 'str',
        'api_version': 'str',
        'min_api_version': 'str',
        'git_commit': 'str',
        'go_version': 'str',
        'os': 'str',
        'arch': 'str',
        'kernel_version': 'str',
        'experimental': 'bool',
        'build_time': 'str'
    }

    attribute_map = {
        'platform': 'Platform',
        'components': 'Components',
        'version': 'Version',
        'api_version': 'ApiVersion',
        'min_api_version': 'MinAPIVersion',
        'git_commit': 'GitCommit',
        'go_version': 'GoVersion',
        'os': 'Os',
        'arch': 'Arch',
        'kernel_version': 'KernelVersion',
        'experimental': 'Experimental',
        'build_time': 'BuildTime'
    }

    def __init__(self, platform=None, components=None, version=None, api_version=None, min_api_version=None, git_commit=None, go_version=None, os=None, arch=None, kernel_version=None, experimental=None, build_time=None, _configuration=None):  # noqa: E501
        """SystemVersion - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._platform = None
        self._components = None
        self._version = None
        self._api_version = None
        self._min_api_version = None
        self._git_commit = None
        self._go_version = None
        self._os = None
        self._arch = None
        self._kernel_version = None
        self._experimental = None
        self._build_time = None
        self.discriminator = None

        if platform is not None:
            self.platform = platform
        if components is not None:
            self.components = components
        if version is not None:
            self.version = version
        if api_version is not None:
            self.api_version = api_version
        if min_api_version is not None:
            self.min_api_version = min_api_version
        if git_commit is not None:
            self.git_commit = git_commit
        if go_version is not None:
            self.go_version = go_version
        if os is not None:
            self.os = os
        if arch is not None:
            self.arch = arch
        if kernel_version is not None:
            self.kernel_version = kernel_version
        if experimental is not None:
            self.experimental = experimental
        if build_time is not None:
            self.build_time = build_time

    @property
    def platform(self):
        """Gets the platform of this SystemVersion.  # noqa: E501


        :return: The platform of this SystemVersion.  # noqa: E501
        :rtype: SystemVersionPlatform
        """
        return self._platform

    @platform.setter
    def platform(self, platform):
        """Sets the platform of this SystemVersion.


        :param platform: The platform of this SystemVersion.  # noqa: E501
        :type: SystemVersionPlatform
        """

        self._platform = platform

    @property
    def components(self):
        """Gets the components of this SystemVersion.  # noqa: E501

        Information about system components   # noqa: E501

        :return: The components of this SystemVersion.  # noqa: E501
        :rtype: list[SystemVersionComponents]
        """
        return self._components

    @components.setter
    def components(self, components):
        """Sets the components of this SystemVersion.

        Information about system components   # noqa: E501

        :param components: The components of this SystemVersion.  # noqa: E501
        :type: list[SystemVersionComponents]
        """

        self._components = components

    @property
    def version(self):
        """Gets the version of this SystemVersion.  # noqa: E501

        The version of the daemon  # noqa: E501

        :return: The version of this SystemVersion.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this SystemVersion.

        The version of the daemon  # noqa: E501

        :param version: The version of this SystemVersion.  # noqa: E501
        :type: str
        """

        self._version = version

    @property
    def api_version(self):
        """Gets the api_version of this SystemVersion.  # noqa: E501

        The default (and highest) API version that is supported by the daemon   # noqa: E501

        :return: The api_version of this SystemVersion.  # noqa: E501
        :rtype: str
        """
        return self._api_version

    @api_version.setter
    def api_version(self, api_version):
        """Sets the api_version of this SystemVersion.

        The default (and highest) API version that is supported by the daemon   # noqa: E501

        :param api_version: The api_version of this SystemVersion.  # noqa: E501
        :type: str
        """

        self._api_version = api_version

    @property
    def min_api_version(self):
        """Gets the min_api_version of this SystemVersion.  # noqa: E501

        The minimum API version that is supported by the daemon   # noqa: E501

        :return: The min_api_version of this SystemVersion.  # noqa: E501
        :rtype: str
        """
        return self._min_api_version

    @min_api_version.setter
    def min_api_version(self, min_api_version):
        """Sets the min_api_version of this SystemVersion.

        The minimum API version that is supported by the daemon   # noqa: E501

        :param min_api_version: The min_api_version of this SystemVersion.  # noqa: E501
        :type: str
        """

        self._min_api_version = min_api_version

    @property
    def git_commit(self):
        """Gets the git_commit of this SystemVersion.  # noqa: E501

        The Git commit of the source code that was used to build the daemon   # noqa: E501

        :return: The git_commit of this SystemVersion.  # noqa: E501
        :rtype: str
        """
        return self._git_commit

    @git_commit.setter
    def git_commit(self, git_commit):
        """Sets the git_commit of this SystemVersion.

        The Git commit of the source code that was used to build the daemon   # noqa: E501

        :param git_commit: The git_commit of this SystemVersion.  # noqa: E501
        :type: str
        """

        self._git_commit = git_commit

    @property
    def go_version(self):
        """Gets the go_version of this SystemVersion.  # noqa: E501

        The version Go used to compile the daemon, and the version of the Go runtime in use.   # noqa: E501

        :return: The go_version of this SystemVersion.  # noqa: E501
        :rtype: str
        """
        return self._go_version

    @go_version.setter
    def go_version(self, go_version):
        """Sets the go_version of this SystemVersion.

        The version Go used to compile the daemon, and the version of the Go runtime in use.   # noqa: E501

        :param go_version: The go_version of this SystemVersion.  # noqa: E501
        :type: str
        """

        self._go_version = go_version

    @property
    def os(self):
        """Gets the os of this SystemVersion.  # noqa: E501

        The operating system that the daemon is running on (\"linux\" or \"windows\")   # noqa: E501

        :return: The os of this SystemVersion.  # noqa: E501
        :rtype: str
        """
        return self._os

    @os.setter
    def os(self, os):
        """Sets the os of this SystemVersion.

        The operating system that the daemon is running on (\"linux\" or \"windows\")   # noqa: E501

        :param os: The os of this SystemVersion.  # noqa: E501
        :type: str
        """

        self._os = os

    @property
    def arch(self):
        """Gets the arch of this SystemVersion.  # noqa: E501

        The architecture that the daemon is running on   # noqa: E501

        :return: The arch of this SystemVersion.  # noqa: E501
        :rtype: str
        """
        return self._arch

    @arch.setter
    def arch(self, arch):
        """Sets the arch of this SystemVersion.

        The architecture that the daemon is running on   # noqa: E501

        :param arch: The arch of this SystemVersion.  # noqa: E501
        :type: str
        """

        self._arch = arch

    @property
    def kernel_version(self):
        """Gets the kernel_version of this SystemVersion.  # noqa: E501

        The kernel version (`uname -r`) that the daemon is running on.  This field is omitted when empty.   # noqa: E501

        :return: The kernel_version of this SystemVersion.  # noqa: E501
        :rtype: str
        """
        return self._kernel_version

    @kernel_version.setter
    def kernel_version(self, kernel_version):
        """Sets the kernel_version of this SystemVersion.

        The kernel version (`uname -r`) that the daemon is running on.  This field is omitted when empty.   # noqa: E501

        :param kernel_version: The kernel_version of this SystemVersion.  # noqa: E501
        :type: str
        """

        self._kernel_version = kernel_version

    @property
    def experimental(self):
        """Gets the experimental of this SystemVersion.  # noqa: E501

        Indicates if the daemon is started with experimental features enabled.  This field is omitted when empty / false.   # noqa: E501

        :return: The experimental of this SystemVersion.  # noqa: E501
        :rtype: bool
        """
        return self._experimental

    @experimental.setter
    def experimental(self, experimental):
        """Sets the experimental of this SystemVersion.

        Indicates if the daemon is started with experimental features enabled.  This field is omitted when empty / false.   # noqa: E501

        :param experimental: The experimental of this SystemVersion.  # noqa: E501
        :type: bool
        """

        self._experimental = experimental

    @property
    def build_time(self):
        """Gets the build_time of this SystemVersion.  # noqa: E501

        The date and time that the daemon was compiled.   # noqa: E501

        :return: The build_time of this SystemVersion.  # noqa: E501
        :rtype: str
        """
        return self._build_time

    @build_time.setter
    def build_time(self, build_time):
        """Sets the build_time of this SystemVersion.

        The date and time that the daemon was compiled.   # noqa: E501

        :param build_time: The build_time of this SystemVersion.  # noqa: E501
        :type: str
        """

        self._build_time = build_time

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SystemVersion, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SystemVersion):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SystemVersion):
            return True

        return self.to_dict() != other.to_dict()
