# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class Task(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'version': 'ObjectVersion',
        'created_at': 'str',
        'updated_at': 'str',
        'name': 'str',
        'labels': 'dict(str, str)',
        'spec': 'TaskSpec',
        'service_id': 'str',
        'slot': 'int',
        'node_id': 'str',
        'assigned_generic_resources': 'GenericResources',
        'status': 'TaskStatus',
        'desired_state': 'TaskState',
        'job_iteration': 'ObjectVersion'
    }

    attribute_map = {
        'id': 'ID',
        'version': 'Version',
        'created_at': 'CreatedAt',
        'updated_at': 'UpdatedAt',
        'name': 'Name',
        'labels': 'Labels',
        'spec': 'Spec',
        'service_id': 'ServiceID',
        'slot': 'Slot',
        'node_id': 'NodeID',
        'assigned_generic_resources': 'AssignedGenericResources',
        'status': 'Status',
        'desired_state': 'DesiredState',
        'job_iteration': 'JobIteration'
    }

    def __init__(self, id=None, version=None, created_at=None, updated_at=None, name=None, labels=None, spec=None, service_id=None, slot=None, node_id=None, assigned_generic_resources=None, status=None, desired_state=None, job_iteration=None, _configuration=None):  # noqa: E501
        """Task - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._id = None
        self._version = None
        self._created_at = None
        self._updated_at = None
        self._name = None
        self._labels = None
        self._spec = None
        self._service_id = None
        self._slot = None
        self._node_id = None
        self._assigned_generic_resources = None
        self._status = None
        self._desired_state = None
        self._job_iteration = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if version is not None:
            self.version = version
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        if name is not None:
            self.name = name
        if labels is not None:
            self.labels = labels
        if spec is not None:
            self.spec = spec
        if service_id is not None:
            self.service_id = service_id
        if slot is not None:
            self.slot = slot
        if node_id is not None:
            self.node_id = node_id
        if assigned_generic_resources is not None:
            self.assigned_generic_resources = assigned_generic_resources
        if status is not None:
            self.status = status
        if desired_state is not None:
            self.desired_state = desired_state
        if job_iteration is not None:
            self.job_iteration = job_iteration

    @property
    def id(self):
        """Gets the id of this Task.  # noqa: E501

        The ID of the task.  # noqa: E501

        :return: The id of this Task.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Task.

        The ID of the task.  # noqa: E501

        :param id: The id of this Task.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def version(self):
        """Gets the version of this Task.  # noqa: E501


        :return: The version of this Task.  # noqa: E501
        :rtype: ObjectVersion
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this Task.


        :param version: The version of this Task.  # noqa: E501
        :type: ObjectVersion
        """

        self._version = version

    @property
    def created_at(self):
        """Gets the created_at of this Task.  # noqa: E501


        :return: The created_at of this Task.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Task.


        :param created_at: The created_at of this Task.  # noqa: E501
        :type: str
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this Task.  # noqa: E501


        :return: The updated_at of this Task.  # noqa: E501
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this Task.


        :param updated_at: The updated_at of this Task.  # noqa: E501
        :type: str
        """

        self._updated_at = updated_at

    @property
    def name(self):
        """Gets the name of this Task.  # noqa: E501

        Name of the task.  # noqa: E501

        :return: The name of this Task.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Task.

        Name of the task.  # noqa: E501

        :param name: The name of this Task.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def labels(self):
        """Gets the labels of this Task.  # noqa: E501

        User-defined key/value metadata.  # noqa: E501

        :return: The labels of this Task.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this Task.

        User-defined key/value metadata.  # noqa: E501

        :param labels: The labels of this Task.  # noqa: E501
        :type: dict(str, str)
        """

        self._labels = labels

    @property
    def spec(self):
        """Gets the spec of this Task.  # noqa: E501


        :return: The spec of this Task.  # noqa: E501
        :rtype: TaskSpec
        """
        return self._spec

    @spec.setter
    def spec(self, spec):
        """Sets the spec of this Task.


        :param spec: The spec of this Task.  # noqa: E501
        :type: TaskSpec
        """

        self._spec = spec

    @property
    def service_id(self):
        """Gets the service_id of this Task.  # noqa: E501

        The ID of the service this task is part of.  # noqa: E501

        :return: The service_id of this Task.  # noqa: E501
        :rtype: str
        """
        return self._service_id

    @service_id.setter
    def service_id(self, service_id):
        """Sets the service_id of this Task.

        The ID of the service this task is part of.  # noqa: E501

        :param service_id: The service_id of this Task.  # noqa: E501
        :type: str
        """

        self._service_id = service_id

    @property
    def slot(self):
        """Gets the slot of this Task.  # noqa: E501


        :return: The slot of this Task.  # noqa: E501
        :rtype: int
        """
        return self._slot

    @slot.setter
    def slot(self, slot):
        """Sets the slot of this Task.


        :param slot: The slot of this Task.  # noqa: E501
        :type: int
        """

        self._slot = slot

    @property
    def node_id(self):
        """Gets the node_id of this Task.  # noqa: E501

        The ID of the node that this task is on.  # noqa: E501

        :return: The node_id of this Task.  # noqa: E501
        :rtype: str
        """
        return self._node_id

    @node_id.setter
    def node_id(self, node_id):
        """Sets the node_id of this Task.

        The ID of the node that this task is on.  # noqa: E501

        :param node_id: The node_id of this Task.  # noqa: E501
        :type: str
        """

        self._node_id = node_id

    @property
    def assigned_generic_resources(self):
        """Gets the assigned_generic_resources of this Task.  # noqa: E501


        :return: The assigned_generic_resources of this Task.  # noqa: E501
        :rtype: GenericResources
        """
        return self._assigned_generic_resources

    @assigned_generic_resources.setter
    def assigned_generic_resources(self, assigned_generic_resources):
        """Sets the assigned_generic_resources of this Task.


        :param assigned_generic_resources: The assigned_generic_resources of this Task.  # noqa: E501
        :type: GenericResources
        """

        self._assigned_generic_resources = assigned_generic_resources

    @property
    def status(self):
        """Gets the status of this Task.  # noqa: E501


        :return: The status of this Task.  # noqa: E501
        :rtype: TaskStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Task.


        :param status: The status of this Task.  # noqa: E501
        :type: TaskStatus
        """

        self._status = status

    @property
    def desired_state(self):
        """Gets the desired_state of this Task.  # noqa: E501


        :return: The desired_state of this Task.  # noqa: E501
        :rtype: TaskState
        """
        return self._desired_state

    @desired_state.setter
    def desired_state(self, desired_state):
        """Sets the desired_state of this Task.


        :param desired_state: The desired_state of this Task.  # noqa: E501
        :type: TaskState
        """

        self._desired_state = desired_state

    @property
    def job_iteration(self):
        """Gets the job_iteration of this Task.  # noqa: E501

        If the Service this Task belongs to is a job-mode service, contains the JobIteration of the Service this Task was created for. Absent if the Task was created for a Replicated or Global Service.   # noqa: E501

        :return: The job_iteration of this Task.  # noqa: E501
        :rtype: ObjectVersion
        """
        return self._job_iteration

    @job_iteration.setter
    def job_iteration(self, job_iteration):
        """Sets the job_iteration of this Task.

        If the Service this Task belongs to is a job-mode service, contains the JobIteration of the Service this Task was created for. Absent if the Task was created for a Replicated or Global Service.   # noqa: E501

        :param job_iteration: The job_iteration of this Task.  # noqa: E501
        :type: ObjectVersion
        """

        self._job_iteration = job_iteration

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Task, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Task):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Task):
            return True

        return self.to_dict() != other.to_dict()
