# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class TaskSpec(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'plugin_spec': 'TaskSpecPluginSpec',
        'container_spec': 'TaskSpecContainerSpec',
        'network_attachment_spec': 'TaskSpecNetworkAttachmentSpec',
        'resources': 'TaskSpecResources',
        'restart_policy': 'TaskSpecRestartPolicy',
        'placement': 'TaskSpecPlacement',
        'force_update': 'int',
        'runtime': 'str',
        'networks': 'list[NetworkAttachmentConfig]',
        'log_driver': 'TaskSpecLogDriver'
    }

    attribute_map = {
        'plugin_spec': 'PluginSpec',
        'container_spec': 'ContainerSpec',
        'network_attachment_spec': 'NetworkAttachmentSpec',
        'resources': 'Resources',
        'restart_policy': 'RestartPolicy',
        'placement': 'Placement',
        'force_update': 'ForceUpdate',
        'runtime': 'Runtime',
        'networks': 'Networks',
        'log_driver': 'LogDriver'
    }

    def __init__(self, plugin_spec=None, container_spec=None, network_attachment_spec=None, resources=None, restart_policy=None, placement=None, force_update=None, runtime=None, networks=None, log_driver=None, _configuration=None):  # noqa: E501
        """TaskSpec - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._plugin_spec = None
        self._container_spec = None
        self._network_attachment_spec = None
        self._resources = None
        self._restart_policy = None
        self._placement = None
        self._force_update = None
        self._runtime = None
        self._networks = None
        self._log_driver = None
        self.discriminator = None

        if plugin_spec is not None:
            self.plugin_spec = plugin_spec
        if container_spec is not None:
            self.container_spec = container_spec
        if network_attachment_spec is not None:
            self.network_attachment_spec = network_attachment_spec
        if resources is not None:
            self.resources = resources
        if restart_policy is not None:
            self.restart_policy = restart_policy
        if placement is not None:
            self.placement = placement
        if force_update is not None:
            self.force_update = force_update
        if runtime is not None:
            self.runtime = runtime
        if networks is not None:
            self.networks = networks
        if log_driver is not None:
            self.log_driver = log_driver

    @property
    def plugin_spec(self):
        """Gets the plugin_spec of this TaskSpec.  # noqa: E501


        :return: The plugin_spec of this TaskSpec.  # noqa: E501
        :rtype: TaskSpecPluginSpec
        """
        return self._plugin_spec

    @plugin_spec.setter
    def plugin_spec(self, plugin_spec):
        """Sets the plugin_spec of this TaskSpec.


        :param plugin_spec: The plugin_spec of this TaskSpec.  # noqa: E501
        :type: TaskSpecPluginSpec
        """

        self._plugin_spec = plugin_spec

    @property
    def container_spec(self):
        """Gets the container_spec of this TaskSpec.  # noqa: E501


        :return: The container_spec of this TaskSpec.  # noqa: E501
        :rtype: TaskSpecContainerSpec
        """
        return self._container_spec

    @container_spec.setter
    def container_spec(self, container_spec):
        """Sets the container_spec of this TaskSpec.


        :param container_spec: The container_spec of this TaskSpec.  # noqa: E501
        :type: TaskSpecContainerSpec
        """

        self._container_spec = container_spec

    @property
    def network_attachment_spec(self):
        """Gets the network_attachment_spec of this TaskSpec.  # noqa: E501


        :return: The network_attachment_spec of this TaskSpec.  # noqa: E501
        :rtype: TaskSpecNetworkAttachmentSpec
        """
        return self._network_attachment_spec

    @network_attachment_spec.setter
    def network_attachment_spec(self, network_attachment_spec):
        """Sets the network_attachment_spec of this TaskSpec.


        :param network_attachment_spec: The network_attachment_spec of this TaskSpec.  # noqa: E501
        :type: TaskSpecNetworkAttachmentSpec
        """

        self._network_attachment_spec = network_attachment_spec

    @property
    def resources(self):
        """Gets the resources of this TaskSpec.  # noqa: E501


        :return: The resources of this TaskSpec.  # noqa: E501
        :rtype: TaskSpecResources
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """Sets the resources of this TaskSpec.


        :param resources: The resources of this TaskSpec.  # noqa: E501
        :type: TaskSpecResources
        """

        self._resources = resources

    @property
    def restart_policy(self):
        """Gets the restart_policy of this TaskSpec.  # noqa: E501


        :return: The restart_policy of this TaskSpec.  # noqa: E501
        :rtype: TaskSpecRestartPolicy
        """
        return self._restart_policy

    @restart_policy.setter
    def restart_policy(self, restart_policy):
        """Sets the restart_policy of this TaskSpec.


        :param restart_policy: The restart_policy of this TaskSpec.  # noqa: E501
        :type: TaskSpecRestartPolicy
        """

        self._restart_policy = restart_policy

    @property
    def placement(self):
        """Gets the placement of this TaskSpec.  # noqa: E501


        :return: The placement of this TaskSpec.  # noqa: E501
        :rtype: TaskSpecPlacement
        """
        return self._placement

    @placement.setter
    def placement(self, placement):
        """Sets the placement of this TaskSpec.


        :param placement: The placement of this TaskSpec.  # noqa: E501
        :type: TaskSpecPlacement
        """

        self._placement = placement

    @property
    def force_update(self):
        """Gets the force_update of this TaskSpec.  # noqa: E501

        A counter that triggers an update even if no relevant parameters have been changed.   # noqa: E501

        :return: The force_update of this TaskSpec.  # noqa: E501
        :rtype: int
        """
        return self._force_update

    @force_update.setter
    def force_update(self, force_update):
        """Sets the force_update of this TaskSpec.

        A counter that triggers an update even if no relevant parameters have been changed.   # noqa: E501

        :param force_update: The force_update of this TaskSpec.  # noqa: E501
        :type: int
        """

        self._force_update = force_update

    @property
    def runtime(self):
        """Gets the runtime of this TaskSpec.  # noqa: E501

        Runtime is the type of runtime specified for the task executor.   # noqa: E501

        :return: The runtime of this TaskSpec.  # noqa: E501
        :rtype: str
        """
        return self._runtime

    @runtime.setter
    def runtime(self, runtime):
        """Sets the runtime of this TaskSpec.

        Runtime is the type of runtime specified for the task executor.   # noqa: E501

        :param runtime: The runtime of this TaskSpec.  # noqa: E501
        :type: str
        """

        self._runtime = runtime

    @property
    def networks(self):
        """Gets the networks of this TaskSpec.  # noqa: E501

        Specifies which networks the service should attach to.  # noqa: E501

        :return: The networks of this TaskSpec.  # noqa: E501
        :rtype: list[NetworkAttachmentConfig]
        """
        return self._networks

    @networks.setter
    def networks(self, networks):
        """Sets the networks of this TaskSpec.

        Specifies which networks the service should attach to.  # noqa: E501

        :param networks: The networks of this TaskSpec.  # noqa: E501
        :type: list[NetworkAttachmentConfig]
        """

        self._networks = networks

    @property
    def log_driver(self):
        """Gets the log_driver of this TaskSpec.  # noqa: E501


        :return: The log_driver of this TaskSpec.  # noqa: E501
        :rtype: TaskSpecLogDriver
        """
        return self._log_driver

    @log_driver.setter
    def log_driver(self, log_driver):
        """Sets the log_driver of this TaskSpec.


        :param log_driver: The log_driver of this TaskSpec.  # noqa: E501
        :type: TaskSpecLogDriver
        """

        self._log_driver = log_driver

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TaskSpec, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TaskSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TaskSpec):
            return True

        return self.to_dict() != other.to_dict()
