# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class TaskSpecContainerSpec(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'image': 'str',
        'labels': 'dict(str, str)',
        'command': 'list[str]',
        'args': 'list[str]',
        'hostname': 'str',
        'env': 'list[str]',
        'dir': 'str',
        'user': 'str',
        'groups': 'list[str]',
        'privileges': 'TaskSpecContainerSpecPrivileges',
        'tty': 'bool',
        'open_stdin': 'bool',
        'read_only': 'bool',
        'mounts': 'list[Mount]',
        'stop_signal': 'str',
        'stop_grace_period': 'int',
        'health_check': 'HealthConfig',
        'hosts': 'list[str]',
        'dns_config': 'TaskSpecContainerSpecDNSConfig',
        'secrets': 'list[TaskSpecContainerSpecSecrets]',
        'configs': 'list[TaskSpecContainerSpecConfigs]',
        'isolation': 'str',
        'init': 'bool',
        'sysctls': 'dict(str, str)',
        'capability_add': 'list[str]',
        'capability_drop': 'list[str]',
        'ulimits': 'list[ResourcesUlimits]'
    }

    attribute_map = {
        'image': 'Image',
        'labels': 'Labels',
        'command': 'Command',
        'args': 'Args',
        'hostname': 'Hostname',
        'env': 'Env',
        'dir': 'Dir',
        'user': 'User',
        'groups': 'Groups',
        'privileges': 'Privileges',
        'tty': 'TTY',
        'open_stdin': 'OpenStdin',
        'read_only': 'ReadOnly',
        'mounts': 'Mounts',
        'stop_signal': 'StopSignal',
        'stop_grace_period': 'StopGracePeriod',
        'health_check': 'HealthCheck',
        'hosts': 'Hosts',
        'dns_config': 'DNSConfig',
        'secrets': 'Secrets',
        'configs': 'Configs',
        'isolation': 'Isolation',
        'init': 'Init',
        'sysctls': 'Sysctls',
        'capability_add': 'CapabilityAdd',
        'capability_drop': 'CapabilityDrop',
        'ulimits': 'Ulimits'
    }

    def __init__(self, image=None, labels=None, command=None, args=None, hostname=None, env=None, dir=None, user=None, groups=None, privileges=None, tty=None, open_stdin=None, read_only=None, mounts=None, stop_signal=None, stop_grace_period=None, health_check=None, hosts=None, dns_config=None, secrets=None, configs=None, isolation=None, init=None, sysctls=None, capability_add=None, capability_drop=None, ulimits=None, _configuration=None):  # noqa: E501
        """TaskSpecContainerSpec - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._image = None
        self._labels = None
        self._command = None
        self._args = None
        self._hostname = None
        self._env = None
        self._dir = None
        self._user = None
        self._groups = None
        self._privileges = None
        self._tty = None
        self._open_stdin = None
        self._read_only = None
        self._mounts = None
        self._stop_signal = None
        self._stop_grace_period = None
        self._health_check = None
        self._hosts = None
        self._dns_config = None
        self._secrets = None
        self._configs = None
        self._isolation = None
        self._init = None
        self._sysctls = None
        self._capability_add = None
        self._capability_drop = None
        self._ulimits = None
        self.discriminator = None

        if image is not None:
            self.image = image
        if labels is not None:
            self.labels = labels
        if command is not None:
            self.command = command
        if args is not None:
            self.args = args
        if hostname is not None:
            self.hostname = hostname
        if env is not None:
            self.env = env
        if dir is not None:
            self.dir = dir
        if user is not None:
            self.user = user
        if groups is not None:
            self.groups = groups
        if privileges is not None:
            self.privileges = privileges
        if tty is not None:
            self.tty = tty
        if open_stdin is not None:
            self.open_stdin = open_stdin
        if read_only is not None:
            self.read_only = read_only
        if mounts is not None:
            self.mounts = mounts
        if stop_signal is not None:
            self.stop_signal = stop_signal
        if stop_grace_period is not None:
            self.stop_grace_period = stop_grace_period
        if health_check is not None:
            self.health_check = health_check
        if hosts is not None:
            self.hosts = hosts
        if dns_config is not None:
            self.dns_config = dns_config
        if secrets is not None:
            self.secrets = secrets
        if configs is not None:
            self.configs = configs
        if isolation is not None:
            self.isolation = isolation
        if init is not None:
            self.init = init
        if sysctls is not None:
            self.sysctls = sysctls
        if capability_add is not None:
            self.capability_add = capability_add
        if capability_drop is not None:
            self.capability_drop = capability_drop
        if ulimits is not None:
            self.ulimits = ulimits

    @property
    def image(self):
        """Gets the image of this TaskSpecContainerSpec.  # noqa: E501

        The image name to use for the container  # noqa: E501

        :return: The image of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this TaskSpecContainerSpec.

        The image name to use for the container  # noqa: E501

        :param image: The image of this TaskSpecContainerSpec.  # noqa: E501
        :type: str
        """

        self._image = image

    @property
    def labels(self):
        """Gets the labels of this TaskSpecContainerSpec.  # noqa: E501

        User-defined key/value data.  # noqa: E501

        :return: The labels of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this TaskSpecContainerSpec.

        User-defined key/value data.  # noqa: E501

        :param labels: The labels of this TaskSpecContainerSpec.  # noqa: E501
        :type: dict(str, str)
        """

        self._labels = labels

    @property
    def command(self):
        """Gets the command of this TaskSpecContainerSpec.  # noqa: E501

        The command to be run in the image.  # noqa: E501

        :return: The command of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: list[str]
        """
        return self._command

    @command.setter
    def command(self, command):
        """Sets the command of this TaskSpecContainerSpec.

        The command to be run in the image.  # noqa: E501

        :param command: The command of this TaskSpecContainerSpec.  # noqa: E501
        :type: list[str]
        """

        self._command = command

    @property
    def args(self):
        """Gets the args of this TaskSpecContainerSpec.  # noqa: E501

        Arguments to the command.  # noqa: E501

        :return: The args of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: list[str]
        """
        return self._args

    @args.setter
    def args(self, args):
        """Sets the args of this TaskSpecContainerSpec.

        Arguments to the command.  # noqa: E501

        :param args: The args of this TaskSpecContainerSpec.  # noqa: E501
        :type: list[str]
        """

        self._args = args

    @property
    def hostname(self):
        """Gets the hostname of this TaskSpecContainerSpec.  # noqa: E501

        The hostname to use for the container, as a valid [RFC 1123](https://tools.ietf.org/html/rfc1123) hostname.   # noqa: E501

        :return: The hostname of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname):
        """Sets the hostname of this TaskSpecContainerSpec.

        The hostname to use for the container, as a valid [RFC 1123](https://tools.ietf.org/html/rfc1123) hostname.   # noqa: E501

        :param hostname: The hostname of this TaskSpecContainerSpec.  # noqa: E501
        :type: str
        """

        self._hostname = hostname

    @property
    def env(self):
        """Gets the env of this TaskSpecContainerSpec.  # noqa: E501

        A list of environment variables in the form `VAR=value`.   # noqa: E501

        :return: The env of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: list[str]
        """
        return self._env

    @env.setter
    def env(self, env):
        """Sets the env of this TaskSpecContainerSpec.

        A list of environment variables in the form `VAR=value`.   # noqa: E501

        :param env: The env of this TaskSpecContainerSpec.  # noqa: E501
        :type: list[str]
        """

        self._env = env

    @property
    def dir(self):
        """Gets the dir of this TaskSpecContainerSpec.  # noqa: E501

        The working directory for commands to run in.  # noqa: E501

        :return: The dir of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: str
        """
        return self._dir

    @dir.setter
    def dir(self, dir):
        """Sets the dir of this TaskSpecContainerSpec.

        The working directory for commands to run in.  # noqa: E501

        :param dir: The dir of this TaskSpecContainerSpec.  # noqa: E501
        :type: str
        """

        self._dir = dir

    @property
    def user(self):
        """Gets the user of this TaskSpecContainerSpec.  # noqa: E501

        The user inside the container.  # noqa: E501

        :return: The user of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this TaskSpecContainerSpec.

        The user inside the container.  # noqa: E501

        :param user: The user of this TaskSpecContainerSpec.  # noqa: E501
        :type: str
        """

        self._user = user

    @property
    def groups(self):
        """Gets the groups of this TaskSpecContainerSpec.  # noqa: E501

        A list of additional groups that the container process will run as.   # noqa: E501

        :return: The groups of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: list[str]
        """
        return self._groups

    @groups.setter
    def groups(self, groups):
        """Sets the groups of this TaskSpecContainerSpec.

        A list of additional groups that the container process will run as.   # noqa: E501

        :param groups: The groups of this TaskSpecContainerSpec.  # noqa: E501
        :type: list[str]
        """

        self._groups = groups

    @property
    def privileges(self):
        """Gets the privileges of this TaskSpecContainerSpec.  # noqa: E501


        :return: The privileges of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: TaskSpecContainerSpecPrivileges
        """
        return self._privileges

    @privileges.setter
    def privileges(self, privileges):
        """Sets the privileges of this TaskSpecContainerSpec.


        :param privileges: The privileges of this TaskSpecContainerSpec.  # noqa: E501
        :type: TaskSpecContainerSpecPrivileges
        """

        self._privileges = privileges

    @property
    def tty(self):
        """Gets the tty of this TaskSpecContainerSpec.  # noqa: E501

        Whether a pseudo-TTY should be allocated.  # noqa: E501

        :return: The tty of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: bool
        """
        return self._tty

    @tty.setter
    def tty(self, tty):
        """Sets the tty of this TaskSpecContainerSpec.

        Whether a pseudo-TTY should be allocated.  # noqa: E501

        :param tty: The tty of this TaskSpecContainerSpec.  # noqa: E501
        :type: bool
        """

        self._tty = tty

    @property
    def open_stdin(self):
        """Gets the open_stdin of this TaskSpecContainerSpec.  # noqa: E501

        Open `stdin`  # noqa: E501

        :return: The open_stdin of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: bool
        """
        return self._open_stdin

    @open_stdin.setter
    def open_stdin(self, open_stdin):
        """Sets the open_stdin of this TaskSpecContainerSpec.

        Open `stdin`  # noqa: E501

        :param open_stdin: The open_stdin of this TaskSpecContainerSpec.  # noqa: E501
        :type: bool
        """

        self._open_stdin = open_stdin

    @property
    def read_only(self):
        """Gets the read_only of this TaskSpecContainerSpec.  # noqa: E501

        Mount the container's root filesystem as read only.  # noqa: E501

        :return: The read_only of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: bool
        """
        return self._read_only

    @read_only.setter
    def read_only(self, read_only):
        """Sets the read_only of this TaskSpecContainerSpec.

        Mount the container's root filesystem as read only.  # noqa: E501

        :param read_only: The read_only of this TaskSpecContainerSpec.  # noqa: E501
        :type: bool
        """

        self._read_only = read_only

    @property
    def mounts(self):
        """Gets the mounts of this TaskSpecContainerSpec.  # noqa: E501

        Specification for mounts to be added to containers created as part of the service.   # noqa: E501

        :return: The mounts of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: list[Mount]
        """
        return self._mounts

    @mounts.setter
    def mounts(self, mounts):
        """Sets the mounts of this TaskSpecContainerSpec.

        Specification for mounts to be added to containers created as part of the service.   # noqa: E501

        :param mounts: The mounts of this TaskSpecContainerSpec.  # noqa: E501
        :type: list[Mount]
        """

        self._mounts = mounts

    @property
    def stop_signal(self):
        """Gets the stop_signal of this TaskSpecContainerSpec.  # noqa: E501

        Signal to stop the container.  # noqa: E501

        :return: The stop_signal of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: str
        """
        return self._stop_signal

    @stop_signal.setter
    def stop_signal(self, stop_signal):
        """Sets the stop_signal of this TaskSpecContainerSpec.

        Signal to stop the container.  # noqa: E501

        :param stop_signal: The stop_signal of this TaskSpecContainerSpec.  # noqa: E501
        :type: str
        """

        self._stop_signal = stop_signal

    @property
    def stop_grace_period(self):
        """Gets the stop_grace_period of this TaskSpecContainerSpec.  # noqa: E501

        Amount of time to wait for the container to terminate before forcefully killing it.   # noqa: E501

        :return: The stop_grace_period of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: int
        """
        return self._stop_grace_period

    @stop_grace_period.setter
    def stop_grace_period(self, stop_grace_period):
        """Sets the stop_grace_period of this TaskSpecContainerSpec.

        Amount of time to wait for the container to terminate before forcefully killing it.   # noqa: E501

        :param stop_grace_period: The stop_grace_period of this TaskSpecContainerSpec.  # noqa: E501
        :type: int
        """

        self._stop_grace_period = stop_grace_period

    @property
    def health_check(self):
        """Gets the health_check of this TaskSpecContainerSpec.  # noqa: E501


        :return: The health_check of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: HealthConfig
        """
        return self._health_check

    @health_check.setter
    def health_check(self, health_check):
        """Sets the health_check of this TaskSpecContainerSpec.


        :param health_check: The health_check of this TaskSpecContainerSpec.  # noqa: E501
        :type: HealthConfig
        """

        self._health_check = health_check

    @property
    def hosts(self):
        """Gets the hosts of this TaskSpecContainerSpec.  # noqa: E501

        A list of hostname/IP mappings to add to the container's `hosts` file. The format of extra hosts is specified in the [hosts(5)](http://man7.org/linux/man-pages/man5/hosts.5.html) man page:      IP_address canonical_hostname [aliases...]   # noqa: E501

        :return: The hosts of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: list[str]
        """
        return self._hosts

    @hosts.setter
    def hosts(self, hosts):
        """Sets the hosts of this TaskSpecContainerSpec.

        A list of hostname/IP mappings to add to the container's `hosts` file. The format of extra hosts is specified in the [hosts(5)](http://man7.org/linux/man-pages/man5/hosts.5.html) man page:      IP_address canonical_hostname [aliases...]   # noqa: E501

        :param hosts: The hosts of this TaskSpecContainerSpec.  # noqa: E501
        :type: list[str]
        """

        self._hosts = hosts

    @property
    def dns_config(self):
        """Gets the dns_config of this TaskSpecContainerSpec.  # noqa: E501


        :return: The dns_config of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: TaskSpecContainerSpecDNSConfig
        """
        return self._dns_config

    @dns_config.setter
    def dns_config(self, dns_config):
        """Sets the dns_config of this TaskSpecContainerSpec.


        :param dns_config: The dns_config of this TaskSpecContainerSpec.  # noqa: E501
        :type: TaskSpecContainerSpecDNSConfig
        """

        self._dns_config = dns_config

    @property
    def secrets(self):
        """Gets the secrets of this TaskSpecContainerSpec.  # noqa: E501

        Secrets contains references to zero or more secrets that will be exposed to the service.   # noqa: E501

        :return: The secrets of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: list[TaskSpecContainerSpecSecrets]
        """
        return self._secrets

    @secrets.setter
    def secrets(self, secrets):
        """Sets the secrets of this TaskSpecContainerSpec.

        Secrets contains references to zero or more secrets that will be exposed to the service.   # noqa: E501

        :param secrets: The secrets of this TaskSpecContainerSpec.  # noqa: E501
        :type: list[TaskSpecContainerSpecSecrets]
        """

        self._secrets = secrets

    @property
    def configs(self):
        """Gets the configs of this TaskSpecContainerSpec.  # noqa: E501

        Configs contains references to zero or more configs that will be exposed to the service.   # noqa: E501

        :return: The configs of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: list[TaskSpecContainerSpecConfigs]
        """
        return self._configs

    @configs.setter
    def configs(self, configs):
        """Sets the configs of this TaskSpecContainerSpec.

        Configs contains references to zero or more configs that will be exposed to the service.   # noqa: E501

        :param configs: The configs of this TaskSpecContainerSpec.  # noqa: E501
        :type: list[TaskSpecContainerSpecConfigs]
        """

        self._configs = configs

    @property
    def isolation(self):
        """Gets the isolation of this TaskSpecContainerSpec.  # noqa: E501

        Isolation technology of the containers running the service. (Windows only)   # noqa: E501

        :return: The isolation of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: str
        """
        return self._isolation

    @isolation.setter
    def isolation(self, isolation):
        """Sets the isolation of this TaskSpecContainerSpec.

        Isolation technology of the containers running the service. (Windows only)   # noqa: E501

        :param isolation: The isolation of this TaskSpecContainerSpec.  # noqa: E501
        :type: str
        """
        allowed_values = ["default", "process", "hyperv"]  # noqa: E501
        if (self._configuration.client_side_validation and
                isolation not in allowed_values):
            raise ValueError(
                "Invalid value for `isolation` ({0}), must be one of {1}"  # noqa: E501
                .format(isolation, allowed_values)
            )

        self._isolation = isolation

    @property
    def init(self):
        """Gets the init of this TaskSpecContainerSpec.  # noqa: E501

        Run an init inside the container that forwards signals and reaps processes. This field is omitted if empty, and the default (as configured on the daemon) is used.   # noqa: E501

        :return: The init of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: bool
        """
        return self._init

    @init.setter
    def init(self, init):
        """Sets the init of this TaskSpecContainerSpec.

        Run an init inside the container that forwards signals and reaps processes. This field is omitted if empty, and the default (as configured on the daemon) is used.   # noqa: E501

        :param init: The init of this TaskSpecContainerSpec.  # noqa: E501
        :type: bool
        """

        self._init = init

    @property
    def sysctls(self):
        """Gets the sysctls of this TaskSpecContainerSpec.  # noqa: E501

        Set kernel namedspaced parameters (sysctls) in the container. The Sysctls option on services accepts the same sysctls as the are supported on containers. Note that while the same sysctls are supported, no guarantees or checks are made about their suitability for a clustered environment, and it's up to the user to determine whether a given sysctl will work properly in a Service.   # noqa: E501

        :return: The sysctls of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._sysctls

    @sysctls.setter
    def sysctls(self, sysctls):
        """Sets the sysctls of this TaskSpecContainerSpec.

        Set kernel namedspaced parameters (sysctls) in the container. The Sysctls option on services accepts the same sysctls as the are supported on containers. Note that while the same sysctls are supported, no guarantees or checks are made about their suitability for a clustered environment, and it's up to the user to determine whether a given sysctl will work properly in a Service.   # noqa: E501

        :param sysctls: The sysctls of this TaskSpecContainerSpec.  # noqa: E501
        :type: dict(str, str)
        """

        self._sysctls = sysctls

    @property
    def capability_add(self):
        """Gets the capability_add of this TaskSpecContainerSpec.  # noqa: E501

        A list of kernel capabilities to add to the default set for the container.   # noqa: E501

        :return: The capability_add of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: list[str]
        """
        return self._capability_add

    @capability_add.setter
    def capability_add(self, capability_add):
        """Sets the capability_add of this TaskSpecContainerSpec.

        A list of kernel capabilities to add to the default set for the container.   # noqa: E501

        :param capability_add: The capability_add of this TaskSpecContainerSpec.  # noqa: E501
        :type: list[str]
        """

        self._capability_add = capability_add

    @property
    def capability_drop(self):
        """Gets the capability_drop of this TaskSpecContainerSpec.  # noqa: E501

        A list of kernel capabilities to drop from the default set for the container.   # noqa: E501

        :return: The capability_drop of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: list[str]
        """
        return self._capability_drop

    @capability_drop.setter
    def capability_drop(self, capability_drop):
        """Sets the capability_drop of this TaskSpecContainerSpec.

        A list of kernel capabilities to drop from the default set for the container.   # noqa: E501

        :param capability_drop: The capability_drop of this TaskSpecContainerSpec.  # noqa: E501
        :type: list[str]
        """

        self._capability_drop = capability_drop

    @property
    def ulimits(self):
        """Gets the ulimits of this TaskSpecContainerSpec.  # noqa: E501

        A list of resource limits to set in the container. For example: `{\"Name\": \"nofile\", \"Soft\": 1024, \"Hard\": 2048}`\"   # noqa: E501

        :return: The ulimits of this TaskSpecContainerSpec.  # noqa: E501
        :rtype: list[ResourcesUlimits]
        """
        return self._ulimits

    @ulimits.setter
    def ulimits(self, ulimits):
        """Sets the ulimits of this TaskSpecContainerSpec.

        A list of resource limits to set in the container. For example: `{\"Name\": \"nofile\", \"Soft\": 1024, \"Hard\": 2048}`\"   # noqa: E501

        :param ulimits: The ulimits of this TaskSpecContainerSpec.  # noqa: E501
        :type: list[ResourcesUlimits]
        """

        self._ulimits = ulimits

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TaskSpecContainerSpec, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TaskSpecContainerSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TaskSpecContainerSpec):
            return True

        return self.to_dict() != other.to_dict()
