# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class TaskSpecPlacement(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'constraints': 'list[str]',
        'preferences': 'list[TaskSpecPlacementPreferences]',
        'max_replicas': 'int',
        'platforms': 'list[Platform]'
    }

    attribute_map = {
        'constraints': 'Constraints',
        'preferences': 'Preferences',
        'max_replicas': 'MaxReplicas',
        'platforms': 'Platforms'
    }

    def __init__(self, constraints=None, preferences=None, max_replicas=0, platforms=None, _configuration=None):  # noqa: E501
        """TaskSpecPlacement - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._constraints = None
        self._preferences = None
        self._max_replicas = None
        self._platforms = None
        self.discriminator = None

        if constraints is not None:
            self.constraints = constraints
        if preferences is not None:
            self.preferences = preferences
        if max_replicas is not None:
            self.max_replicas = max_replicas
        if platforms is not None:
            self.platforms = platforms

    @property
    def constraints(self):
        """Gets the constraints of this TaskSpecPlacement.  # noqa: E501

        An array of constraint expressions to limit the set of nodes where a task can be scheduled. Constraint expressions can either use a _match_ (`==`) or _exclude_ (`!=`) rule. Multiple constraints find nodes that satisfy every expression (AND match). Constraints can match node or Docker Engine labels as follows:  node attribute       | matches                        | example ---------------------|--------------------------------|----------------------------------------------- `node.id`            | Node ID                        | `node.id==2ivku8v2gvtg4` `node.hostname`      | Node hostname                  | `node.hostname!=node-2` `node.role`          | Node role (`manager`/`worker`) | `node.role==manager` `node.platform.os`   | Node operating system          | `node.platform.os==windows` `node.platform.arch` | Node architecture              | `node.platform.arch==x86_64` `node.labels`        | User-defined node labels       | `node.labels.security==high` `engine.labels`      | Docker Engine's labels         | `engine.labels.operatingsystem==ubuntu-14.04`  `engine.labels` apply to Docker Engine labels like operating system, drivers, etc. Swarm administrators add `node.labels` for operational purposes by using the [`node update endpoint`](#operation/NodeUpdate).   # noqa: E501

        :return: The constraints of this TaskSpecPlacement.  # noqa: E501
        :rtype: list[str]
        """
        return self._constraints

    @constraints.setter
    def constraints(self, constraints):
        """Sets the constraints of this TaskSpecPlacement.

        An array of constraint expressions to limit the set of nodes where a task can be scheduled. Constraint expressions can either use a _match_ (`==`) or _exclude_ (`!=`) rule. Multiple constraints find nodes that satisfy every expression (AND match). Constraints can match node or Docker Engine labels as follows:  node attribute       | matches                        | example ---------------------|--------------------------------|----------------------------------------------- `node.id`            | Node ID                        | `node.id==2ivku8v2gvtg4` `node.hostname`      | Node hostname                  | `node.hostname!=node-2` `node.role`          | Node role (`manager`/`worker`) | `node.role==manager` `node.platform.os`   | Node operating system          | `node.platform.os==windows` `node.platform.arch` | Node architecture              | `node.platform.arch==x86_64` `node.labels`        | User-defined node labels       | `node.labels.security==high` `engine.labels`      | Docker Engine's labels         | `engine.labels.operatingsystem==ubuntu-14.04`  `engine.labels` apply to Docker Engine labels like operating system, drivers, etc. Swarm administrators add `node.labels` for operational purposes by using the [`node update endpoint`](#operation/NodeUpdate).   # noqa: E501

        :param constraints: The constraints of this TaskSpecPlacement.  # noqa: E501
        :type: list[str]
        """

        self._constraints = constraints

    @property
    def preferences(self):
        """Gets the preferences of this TaskSpecPlacement.  # noqa: E501

        Preferences provide a way to make the scheduler aware of factors such as topology. They are provided in order from highest to lowest precedence.   # noqa: E501

        :return: The preferences of this TaskSpecPlacement.  # noqa: E501
        :rtype: list[TaskSpecPlacementPreferences]
        """
        return self._preferences

    @preferences.setter
    def preferences(self, preferences):
        """Sets the preferences of this TaskSpecPlacement.

        Preferences provide a way to make the scheduler aware of factors such as topology. They are provided in order from highest to lowest precedence.   # noqa: E501

        :param preferences: The preferences of this TaskSpecPlacement.  # noqa: E501
        :type: list[TaskSpecPlacementPreferences]
        """

        self._preferences = preferences

    @property
    def max_replicas(self):
        """Gets the max_replicas of this TaskSpecPlacement.  # noqa: E501

        Maximum number of replicas for per node (default value is 0, which is unlimited)   # noqa: E501

        :return: The max_replicas of this TaskSpecPlacement.  # noqa: E501
        :rtype: int
        """
        return self._max_replicas

    @max_replicas.setter
    def max_replicas(self, max_replicas):
        """Sets the max_replicas of this TaskSpecPlacement.

        Maximum number of replicas for per node (default value is 0, which is unlimited)   # noqa: E501

        :param max_replicas: The max_replicas of this TaskSpecPlacement.  # noqa: E501
        :type: int
        """

        self._max_replicas = max_replicas

    @property
    def platforms(self):
        """Gets the platforms of this TaskSpecPlacement.  # noqa: E501

        Platforms stores all the platforms that the service's image can run on. This field is used in the platform filter for scheduling. If empty, then the platform filter is off, meaning there are no scheduling restrictions.   # noqa: E501

        :return: The platforms of this TaskSpecPlacement.  # noqa: E501
        :rtype: list[Platform]
        """
        return self._platforms

    @platforms.setter
    def platforms(self, platforms):
        """Sets the platforms of this TaskSpecPlacement.

        Platforms stores all the platforms that the service's image can run on. This field is used in the platform filter for scheduling. If empty, then the platform filter is off, meaning there are no scheduling restrictions.   # noqa: E501

        :param platforms: The platforms of this TaskSpecPlacement.  # noqa: E501
        :type: list[Platform]
        """

        self._platforms = platforms

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TaskSpecPlacement, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TaskSpecPlacement):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TaskSpecPlacement):
            return True

        return self.to_dict() != other.to_dict()
