# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class Volume(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'driver': 'str',
        'mountpoint': 'str',
        'created_at': 'str',
        'status': 'dict(str, object)',
        'labels': 'dict(str, str)',
        'scope': 'str',
        'options': 'dict(str, str)',
        'usage_data': 'VolumeUsageData'
    }

    attribute_map = {
        'name': 'Name',
        'driver': 'Driver',
        'mountpoint': 'Mountpoint',
        'created_at': 'CreatedAt',
        'status': 'Status',
        'labels': 'Labels',
        'scope': 'Scope',
        'options': 'Options',
        'usage_data': 'UsageData'
    }

    def __init__(self, name=None, driver=None, mountpoint=None, created_at=None, status=None, labels=None, scope='local', options=None, usage_data=None, _configuration=None):  # noqa: E501
        """Volume - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._name = None
        self._driver = None
        self._mountpoint = None
        self._created_at = None
        self._status = None
        self._labels = None
        self._scope = None
        self._options = None
        self._usage_data = None
        self.discriminator = None

        self.name = name
        self.driver = driver
        self.mountpoint = mountpoint
        if created_at is not None:
            self.created_at = created_at
        if status is not None:
            self.status = status
        self.labels = labels
        self.scope = scope
        self.options = options
        if usage_data is not None:
            self.usage_data = usage_data

    @property
    def name(self):
        """Gets the name of this Volume.  # noqa: E501

        Name of the volume.  # noqa: E501

        :return: The name of this Volume.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Volume.

        Name of the volume.  # noqa: E501

        :param name: The name of this Volume.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def driver(self):
        """Gets the driver of this Volume.  # noqa: E501

        Name of the volume driver used by the volume.  # noqa: E501

        :return: The driver of this Volume.  # noqa: E501
        :rtype: str
        """
        return self._driver

    @driver.setter
    def driver(self, driver):
        """Sets the driver of this Volume.

        Name of the volume driver used by the volume.  # noqa: E501

        :param driver: The driver of this Volume.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and driver is None:
            raise ValueError("Invalid value for `driver`, must not be `None`")  # noqa: E501

        self._driver = driver

    @property
    def mountpoint(self):
        """Gets the mountpoint of this Volume.  # noqa: E501

        Mount path of the volume on the host.  # noqa: E501

        :return: The mountpoint of this Volume.  # noqa: E501
        :rtype: str
        """
        return self._mountpoint

    @mountpoint.setter
    def mountpoint(self, mountpoint):
        """Sets the mountpoint of this Volume.

        Mount path of the volume on the host.  # noqa: E501

        :param mountpoint: The mountpoint of this Volume.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and mountpoint is None:
            raise ValueError("Invalid value for `mountpoint`, must not be `None`")  # noqa: E501

        self._mountpoint = mountpoint

    @property
    def created_at(self):
        """Gets the created_at of this Volume.  # noqa: E501

        Date/Time the volume was created.  # noqa: E501

        :return: The created_at of this Volume.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Volume.

        Date/Time the volume was created.  # noqa: E501

        :param created_at: The created_at of this Volume.  # noqa: E501
        :type: str
        """

        self._created_at = created_at

    @property
    def status(self):
        """Gets the status of this Volume.  # noqa: E501

        Low-level details about the volume, provided by the volume driver. Details are returned as a map with key/value pairs: `{\"key\":\"value\",\"key2\":\"value2\"}`.  The `Status` field is optional, and is omitted if the volume driver does not support this feature.   # noqa: E501

        :return: The status of this Volume.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Volume.

        Low-level details about the volume, provided by the volume driver. Details are returned as a map with key/value pairs: `{\"key\":\"value\",\"key2\":\"value2\"}`.  The `Status` field is optional, and is omitted if the volume driver does not support this feature.   # noqa: E501

        :param status: The status of this Volume.  # noqa: E501
        :type: dict(str, object)
        """

        self._status = status

    @property
    def labels(self):
        """Gets the labels of this Volume.  # noqa: E501

        User-defined key/value metadata.  # noqa: E501

        :return: The labels of this Volume.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this Volume.

        User-defined key/value metadata.  # noqa: E501

        :param labels: The labels of this Volume.  # noqa: E501
        :type: dict(str, str)
        """
        if self._configuration.client_side_validation and labels is None:
            raise ValueError("Invalid value for `labels`, must not be `None`")  # noqa: E501

        self._labels = labels

    @property
    def scope(self):
        """Gets the scope of this Volume.  # noqa: E501

        The level at which the volume exists. Either `global` for cluster-wide, or `local` for machine level.   # noqa: E501

        :return: The scope of this Volume.  # noqa: E501
        :rtype: str
        """
        return self._scope

    @scope.setter
    def scope(self, scope):
        """Sets the scope of this Volume.

        The level at which the volume exists. Either `global` for cluster-wide, or `local` for machine level.   # noqa: E501

        :param scope: The scope of this Volume.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and scope is None:
            raise ValueError("Invalid value for `scope`, must not be `None`")  # noqa: E501
        allowed_values = ["local", "global"]  # noqa: E501
        if (self._configuration.client_side_validation and
                scope not in allowed_values):
            raise ValueError(
                "Invalid value for `scope` ({0}), must be one of {1}"  # noqa: E501
                .format(scope, allowed_values)
            )

        self._scope = scope

    @property
    def options(self):
        """Gets the options of this Volume.  # noqa: E501

        The driver specific options used when creating the volume.   # noqa: E501

        :return: The options of this Volume.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this Volume.

        The driver specific options used when creating the volume.   # noqa: E501

        :param options: The options of this Volume.  # noqa: E501
        :type: dict(str, str)
        """
        if self._configuration.client_side_validation and options is None:
            raise ValueError("Invalid value for `options`, must not be `None`")  # noqa: E501

        self._options = options

    @property
    def usage_data(self):
        """Gets the usage_data of this Volume.  # noqa: E501


        :return: The usage_data of this Volume.  # noqa: E501
        :rtype: VolumeUsageData
        """
        return self._usage_data

    @usage_data.setter
    def usage_data(self, usage_data):
        """Sets the usage_data of this Volume.


        :param usage_data: The usage_data of this Volume.  # noqa: E501
        :type: VolumeUsageData
        """

        self._usage_data = usage_data

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Volume, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Volume):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Volume):
            return True

        return self.to_dict() != other.to_dict()
