# coding: utf-8

"""
    Docker Engine API

    The Engine API is an HTTP API served by Docker Engine. It is the API the Docker client uses to communicate with the Engine, so everything the Docker client can do can be done with the API.  Most of the client's commands map directly to API endpoints (e.g. `docker ps` is `GET /containers/json`). The notable exception is running containers, which consists of several API calls.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format:  ``` {   \"message\": \"page not found\" } ```  # Versioning  The API is usually changed in each release, so API calls are versioned to ensure that clients don't break. To lock to a specific version of the API, you prefix the URL with its version, for example, call `/v1.30/info` to use the v1.30 version of the `/info` endpoint. If the API version specified in the URL is not supported by the daemon, a HTTP `400 Bad Request` error message is returned.  If you omit the version-prefix, the current version of the API (v1.42) is used. For example, calling `/info` is the same as calling `/v1.42/info`. Using the API without a version-prefix is deprecated and will be removed in a future release.  Engine releases in the near future should support this version of the API, so your client will continue to work even if it is talking to a newer Engine.  The API uses an open schema model, which means server may add extra properties to responses. Likewise, the server will ignore any extra query parameters and request body properties. When you write clients, you need to ignore additional properties in responses to ensure they do not break when talking to newer daemons.   # Authentication  Authentication for registries is handled client side. The client has to send authentication details to various endpoints that need to communicate with registries, such as `POST /images/(name)/push`. These are sent as `X-Registry-Auth` header as a [base64url encoded](https://tools.ietf.org/html/rfc4648#section-5) (JSON) string with the following structure:  ``` {   \"username\": \"string\",   \"password\": \"string\",   \"email\": \"string\",   \"serveraddress\": \"string\" } ```  The `serveraddress` is a domain/IP without a protocol. Throughout this structure, double quotes are required.  If you have already got an identity token from the [`/auth` endpoint](#operation/SystemAuth), you can just pass this instead of credentials:  ``` {   \"identitytoken\": \"9cbaf023786cd7...\" } ```   # noqa: E501

    OpenAPI spec version: 1.42
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import unittest

import jgreenepack
from jgreenepack.api.container_api import ContainerApi  # noqa: E501
from jgreenepack.rest import ApiException


class TestContainerApi(unittest.TestCase):
    """ContainerApi unit test stubs"""

    def setUp(self):
        self.api = jgreenepack.api.container_api.ContainerApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_container_archive(self):
        """Test case for container_archive

        Get an archive of a filesystem resource in a container  # noqa: E501
        """
        pass

    def test_container_archive_info(self):
        """Test case for container_archive_info

        Get information about files in a container  # noqa: E501
        """
        pass

    def test_container_attach(self):
        """Test case for container_attach

        Attach to a container  # noqa: E501
        """
        pass

    def test_container_attach_websocket(self):
        """Test case for container_attach_websocket

        Attach to a container via a websocket  # noqa: E501
        """
        pass

    def test_container_changes(self):
        """Test case for container_changes

        Get changes on a container’s filesystem  # noqa: E501
        """
        pass

    def test_container_create(self):
        """Test case for container_create

        Create a container  # noqa: E501
        """
        pass

    def test_container_delete(self):
        """Test case for container_delete

        Remove a container  # noqa: E501
        """
        pass

    def test_container_export(self):
        """Test case for container_export

        Export a container  # noqa: E501
        """
        pass

    def test_container_inspect(self):
        """Test case for container_inspect

        Inspect a container  # noqa: E501
        """
        pass

    def test_container_kill(self):
        """Test case for container_kill

        Kill a container  # noqa: E501
        """
        pass

    def test_container_list(self):
        """Test case for container_list

        List containers  # noqa: E501
        """
        pass

    def test_container_logs(self):
        """Test case for container_logs

        Get container logs  # noqa: E501
        """
        pass

    def test_container_pause(self):
        """Test case for container_pause

        Pause a container  # noqa: E501
        """
        pass

    def test_container_prune(self):
        """Test case for container_prune

        Delete stopped containers  # noqa: E501
        """
        pass

    def test_container_rename(self):
        """Test case for container_rename

        Rename a container  # noqa: E501
        """
        pass

    def test_container_resize(self):
        """Test case for container_resize

        Resize a container TTY  # noqa: E501
        """
        pass

    def test_container_restart(self):
        """Test case for container_restart

        Restart a container  # noqa: E501
        """
        pass

    def test_container_start(self):
        """Test case for container_start

        Start a container  # noqa: E501
        """
        pass

    def test_container_stats(self):
        """Test case for container_stats

        Get container stats based on resource usage  # noqa: E501
        """
        pass

    def test_container_stop(self):
        """Test case for container_stop

        Stop a container  # noqa: E501
        """
        pass

    def test_container_top(self):
        """Test case for container_top

        List processes running inside a container  # noqa: E501
        """
        pass

    def test_container_unpause(self):
        """Test case for container_unpause

        Unpause a container  # noqa: E501
        """
        pass

    def test_container_update(self):
        """Test case for container_update

        Update a container  # noqa: E501
        """
        pass

    def test_container_wait(self):
        """Test case for container_wait

        Wait for a container  # noqa: E501
        """
        pass

    def test_put_container_archive(self):
        """Test case for put_container_archive

        Extract an archive of files or folders to a directory in a container  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
