# coding: utf-8

"""
    Browse API

    <p>The Browse API has the following resources:</p>   <ul> <li><b> item_summary: </b> Lets shoppers search for specific items by keyword, GTIN, category, charity, product, or item aspects and refine the results by using filters, such as aspects, compatibility, and fields values.</li>  <li><b> search_by_image: </b><a href=\"https://developer.ebay.com/api-docs/static/versioning.html#experimental \" target=\"_blank\"><img src=\"/cms/img/docs/experimental-icon.svg\" class=\"legend-icon experimental-icon\" alt=\"Experimental Release\" title=\"Experimental Release\" />&nbsp;(Experimental)</a> Lets shoppers search for specific items by image. You can refine the results by using URI parameters and filters.</li>   <li><b> item: </b> <ul><li>Lets you retrieve the details of a specific item or all the items in an item group, which is an item with variations such as color and size and check if a product is compatible with the specified item, such as if a specific car is compatible with a specific part.</li> <li>Provides a bridge between the eBay legacy APIs, such as <b> Finding</b>, and the RESTful APIs, which use different formats for the item IDs.</li>  </ul> </li>  <li> <b> shopping_cart: </b> <a href=\"https://developer.ebay.com/api-docs/static/versioning.html#experimental \" target=\"_blank\"><img src=\"/cms/img/docs/experimental-icon.svg\" class=\"legend-icon experimental-icon\" alt=\"Experimental Release\" title=\"Experimental Release\" />&nbsp;(Experimental)</a> <a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited \" target=\"_blank\"> <img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\" title=\"Limited Release\"  alt=\"Limited Release\" />(Limited Release)</a> Provides the ability for eBay members to see the contents of their eBay cart, and add, remove, and change the quantity of items in their eBay cart.&nbsp;&nbsp;<b> Note: </b> This resource is not available in the eBay API Explorer.</li></ul>       <p>The <b> item_summary</b>, <b> search_by_image</b>, and <b> item</b> resource calls require an <a href=\"/api-docs/static/oauth-client-credentials-grant.html\">Application access token</a>. The <b> shopping_cart</b> resource calls require a <a href=\"/api-docs/static/oauth-authorization-code-grant.html\">User access token</a>.</p>  # noqa: E501

    OpenAPI spec version: v1.13.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Item(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'additional_images': 'list[Image]',
        'addon_services': 'list[AddonService]',
        'adult_only': 'bool',
        'age_group': 'str',
        'authenticity_guarantee': 'AuthenticityGuaranteeProgram',
        'authenticity_verification': 'AuthenticityVerificationProgram',
        'available_coupons': 'list[AvailableCoupon]',
        'bid_count': 'int',
        'brand': 'str',
        'buying_options': 'list[str]',
        'category_id': 'str',
        'category_path': 'str',
        'color': 'str',
        'condition': 'str',
        'condition_description': 'str',
        'condition_id': 'str',
        'current_bid_price': 'ConvertedAmount',
        'description': 'str',
        'eco_participation_fee': 'ConvertedAmount',
        'eligible_for_inline_checkout': 'bool',
        'enabled_for_guest_checkout': 'bool',
        'energy_efficiency_class': 'str',
        'epid': 'str',
        'estimated_availabilities': 'list[EstimatedAvailability]',
        'gender': 'str',
        'gtin': 'str',
        'image': 'Image',
        'inferred_epid': 'str',
        'item_affiliate_web_url': 'str',
        'item_end_date': 'str',
        'item_id': 'str',
        'item_location': 'Address',
        'item_web_url': 'str',
        'legacy_item_id': 'str',
        'listing_marketplace_id': 'str',
        'localized_aspects': 'list[TypedNameValue]',
        'lot_size': 'int',
        'marketing_price': 'MarketingPrice',
        'material': 'str',
        'minimum_price_to_bid': 'ConvertedAmount',
        'mpn': 'str',
        'pattern': 'str',
        'payment_methods': 'list[PaymentMethod]',
        'price': 'ConvertedAmount',
        'price_display_condition': 'str',
        'primary_item_group': 'ItemGroupSummary',
        'primary_product_review_rating': 'ReviewRating',
        'priority_listing': 'bool',
        'product': 'Product',
        'product_fiche_web_url': 'str',
        'qualified_programs': 'list[str]',
        'quantity_limit_per_buyer': 'int',
        'reserve_price_met': 'bool',
        'return_terms': 'ItemReturnTerms',
        'seller': 'SellerDetail',
        'seller_custom_policies': 'list[SellerCustomPolicy]',
        'seller_item_revision': 'str',
        'shipping_options': 'list[ShippingOption]',
        'ship_to_locations': 'ShipToLocations',
        'short_description': 'str',
        'size': 'str',
        'size_system': 'str',
        'size_type': 'str',
        'subtitle': 'str',
        'taxes': 'list[Taxes]',
        'title': 'str',
        'top_rated_buying_experience': 'bool',
        'tyre_label_image_url': 'str',
        'unique_bidder_count': 'int',
        'unit_price': 'ConvertedAmount',
        'unit_pricing_measure': 'str',
        'warnings': 'list[Error]',
        'watch_count': 'int'
    }

    attribute_map = {
        'additional_images': 'additionalImages',
        'addon_services': 'addonServices',
        'adult_only': 'adultOnly',
        'age_group': 'ageGroup',
        'authenticity_guarantee': 'authenticityGuarantee',
        'authenticity_verification': 'authenticityVerification',
        'available_coupons': 'availableCoupons',
        'bid_count': 'bidCount',
        'brand': 'brand',
        'buying_options': 'buyingOptions',
        'category_id': 'categoryId',
        'category_path': 'categoryPath',
        'color': 'color',
        'condition': 'condition',
        'condition_description': 'conditionDescription',
        'condition_id': 'conditionId',
        'current_bid_price': 'currentBidPrice',
        'description': 'description',
        'eco_participation_fee': 'ecoParticipationFee',
        'eligible_for_inline_checkout': 'eligibleForInlineCheckout',
        'enabled_for_guest_checkout': 'enabledForGuestCheckout',
        'energy_efficiency_class': 'energyEfficiencyClass',
        'epid': 'epid',
        'estimated_availabilities': 'estimatedAvailabilities',
        'gender': 'gender',
        'gtin': 'gtin',
        'image': 'image',
        'inferred_epid': 'inferredEpid',
        'item_affiliate_web_url': 'itemAffiliateWebUrl',
        'item_end_date': 'itemEndDate',
        'item_id': 'itemId',
        'item_location': 'itemLocation',
        'item_web_url': 'itemWebUrl',
        'legacy_item_id': 'legacyItemId',
        'listing_marketplace_id': 'listingMarketplaceId',
        'localized_aspects': 'localizedAspects',
        'lot_size': 'lotSize',
        'marketing_price': 'marketingPrice',
        'material': 'material',
        'minimum_price_to_bid': 'minimumPriceToBid',
        'mpn': 'mpn',
        'pattern': 'pattern',
        'payment_methods': 'paymentMethods',
        'price': 'price',
        'price_display_condition': 'priceDisplayCondition',
        'primary_item_group': 'primaryItemGroup',
        'primary_product_review_rating': 'primaryProductReviewRating',
        'priority_listing': 'priorityListing',
        'product': 'product',
        'product_fiche_web_url': 'productFicheWebUrl',
        'qualified_programs': 'qualifiedPrograms',
        'quantity_limit_per_buyer': 'quantityLimitPerBuyer',
        'reserve_price_met': 'reservePriceMet',
        'return_terms': 'returnTerms',
        'seller': 'seller',
        'seller_custom_policies': 'sellerCustomPolicies',
        'seller_item_revision': 'sellerItemRevision',
        'shipping_options': 'shippingOptions',
        'ship_to_locations': 'shipToLocations',
        'short_description': 'shortDescription',
        'size': 'size',
        'size_system': 'sizeSystem',
        'size_type': 'sizeType',
        'subtitle': 'subtitle',
        'taxes': 'taxes',
        'title': 'title',
        'top_rated_buying_experience': 'topRatedBuyingExperience',
        'tyre_label_image_url': 'tyreLabelImageUrl',
        'unique_bidder_count': 'uniqueBidderCount',
        'unit_price': 'unitPrice',
        'unit_pricing_measure': 'unitPricingMeasure',
        'warnings': 'warnings',
        'watch_count': 'watchCount'
    }

    def __init__(self, additional_images=None, addon_services=None, adult_only=None, age_group=None, authenticity_guarantee=None, authenticity_verification=None, available_coupons=None, bid_count=None, brand=None, buying_options=None, category_id=None, category_path=None, color=None, condition=None, condition_description=None, condition_id=None, current_bid_price=None, description=None, eco_participation_fee=None, eligible_for_inline_checkout=None, enabled_for_guest_checkout=None, energy_efficiency_class=None, epid=None, estimated_availabilities=None, gender=None, gtin=None, image=None, inferred_epid=None, item_affiliate_web_url=None, item_end_date=None, item_id=None, item_location=None, item_web_url=None, legacy_item_id=None, listing_marketplace_id=None, localized_aspects=None, lot_size=None, marketing_price=None, material=None, minimum_price_to_bid=None, mpn=None, pattern=None, payment_methods=None, price=None, price_display_condition=None, primary_item_group=None, primary_product_review_rating=None, priority_listing=None, product=None, product_fiche_web_url=None, qualified_programs=None, quantity_limit_per_buyer=None, reserve_price_met=None, return_terms=None, seller=None, seller_custom_policies=None, seller_item_revision=None, shipping_options=None, ship_to_locations=None, short_description=None, size=None, size_system=None, size_type=None, subtitle=None, taxes=None, title=None, top_rated_buying_experience=None, tyre_label_image_url=None, unique_bidder_count=None, unit_price=None, unit_pricing_measure=None, warnings=None, watch_count=None):  # noqa: E501
        """Item - a model defined in Swagger"""  # noqa: E501
        self._additional_images = None
        self._addon_services = None
        self._adult_only = None
        self._age_group = None
        self._authenticity_guarantee = None
        self._authenticity_verification = None
        self._available_coupons = None
        self._bid_count = None
        self._brand = None
        self._buying_options = None
        self._category_id = None
        self._category_path = None
        self._color = None
        self._condition = None
        self._condition_description = None
        self._condition_id = None
        self._current_bid_price = None
        self._description = None
        self._eco_participation_fee = None
        self._eligible_for_inline_checkout = None
        self._enabled_for_guest_checkout = None
        self._energy_efficiency_class = None
        self._epid = None
        self._estimated_availabilities = None
        self._gender = None
        self._gtin = None
        self._image = None
        self._inferred_epid = None
        self._item_affiliate_web_url = None
        self._item_end_date = None
        self._item_id = None
        self._item_location = None
        self._item_web_url = None
        self._legacy_item_id = None
        self._listing_marketplace_id = None
        self._localized_aspects = None
        self._lot_size = None
        self._marketing_price = None
        self._material = None
        self._minimum_price_to_bid = None
        self._mpn = None
        self._pattern = None
        self._payment_methods = None
        self._price = None
        self._price_display_condition = None
        self._primary_item_group = None
        self._primary_product_review_rating = None
        self._priority_listing = None
        self._product = None
        self._product_fiche_web_url = None
        self._qualified_programs = None
        self._quantity_limit_per_buyer = None
        self._reserve_price_met = None
        self._return_terms = None
        self._seller = None
        self._seller_custom_policies = None
        self._seller_item_revision = None
        self._shipping_options = None
        self._ship_to_locations = None
        self._short_description = None
        self._size = None
        self._size_system = None
        self._size_type = None
        self._subtitle = None
        self._taxes = None
        self._title = None
        self._top_rated_buying_experience = None
        self._tyre_label_image_url = None
        self._unique_bidder_count = None
        self._unit_price = None
        self._unit_pricing_measure = None
        self._warnings = None
        self._watch_count = None
        self.discriminator = None
        if additional_images is not None:
            self.additional_images = additional_images
        if addon_services is not None:
            self.addon_services = addon_services
        if adult_only is not None:
            self.adult_only = adult_only
        if age_group is not None:
            self.age_group = age_group
        if authenticity_guarantee is not None:
            self.authenticity_guarantee = authenticity_guarantee
        if authenticity_verification is not None:
            self.authenticity_verification = authenticity_verification
        if available_coupons is not None:
            self.available_coupons = available_coupons
        if bid_count is not None:
            self.bid_count = bid_count
        if brand is not None:
            self.brand = brand
        if buying_options is not None:
            self.buying_options = buying_options
        if category_id is not None:
            self.category_id = category_id
        if category_path is not None:
            self.category_path = category_path
        if color is not None:
            self.color = color
        if condition is not None:
            self.condition = condition
        if condition_description is not None:
            self.condition_description = condition_description
        if condition_id is not None:
            self.condition_id = condition_id
        if current_bid_price is not None:
            self.current_bid_price = current_bid_price
        if description is not None:
            self.description = description
        if eco_participation_fee is not None:
            self.eco_participation_fee = eco_participation_fee
        if eligible_for_inline_checkout is not None:
            self.eligible_for_inline_checkout = eligible_for_inline_checkout
        if enabled_for_guest_checkout is not None:
            self.enabled_for_guest_checkout = enabled_for_guest_checkout
        if energy_efficiency_class is not None:
            self.energy_efficiency_class = energy_efficiency_class
        if epid is not None:
            self.epid = epid
        if estimated_availabilities is not None:
            self.estimated_availabilities = estimated_availabilities
        if gender is not None:
            self.gender = gender
        if gtin is not None:
            self.gtin = gtin
        if image is not None:
            self.image = image
        if inferred_epid is not None:
            self.inferred_epid = inferred_epid
        if item_affiliate_web_url is not None:
            self.item_affiliate_web_url = item_affiliate_web_url
        if item_end_date is not None:
            self.item_end_date = item_end_date
        if item_id is not None:
            self.item_id = item_id
        if item_location is not None:
            self.item_location = item_location
        if item_web_url is not None:
            self.item_web_url = item_web_url
        if legacy_item_id is not None:
            self.legacy_item_id = legacy_item_id
        if listing_marketplace_id is not None:
            self.listing_marketplace_id = listing_marketplace_id
        if localized_aspects is not None:
            self.localized_aspects = localized_aspects
        if lot_size is not None:
            self.lot_size = lot_size
        if marketing_price is not None:
            self.marketing_price = marketing_price
        if material is not None:
            self.material = material
        if minimum_price_to_bid is not None:
            self.minimum_price_to_bid = minimum_price_to_bid
        if mpn is not None:
            self.mpn = mpn
        if pattern is not None:
            self.pattern = pattern
        if payment_methods is not None:
            self.payment_methods = payment_methods
        if price is not None:
            self.price = price
        if price_display_condition is not None:
            self.price_display_condition = price_display_condition
        if primary_item_group is not None:
            self.primary_item_group = primary_item_group
        if primary_product_review_rating is not None:
            self.primary_product_review_rating = primary_product_review_rating
        if priority_listing is not None:
            self.priority_listing = priority_listing
        if product is not None:
            self.product = product
        if product_fiche_web_url is not None:
            self.product_fiche_web_url = product_fiche_web_url
        if qualified_programs is not None:
            self.qualified_programs = qualified_programs
        if quantity_limit_per_buyer is not None:
            self.quantity_limit_per_buyer = quantity_limit_per_buyer
        if reserve_price_met is not None:
            self.reserve_price_met = reserve_price_met
        if return_terms is not None:
            self.return_terms = return_terms
        if seller is not None:
            self.seller = seller
        if seller_custom_policies is not None:
            self.seller_custom_policies = seller_custom_policies
        if seller_item_revision is not None:
            self.seller_item_revision = seller_item_revision
        if shipping_options is not None:
            self.shipping_options = shipping_options
        if ship_to_locations is not None:
            self.ship_to_locations = ship_to_locations
        if short_description is not None:
            self.short_description = short_description
        if size is not None:
            self.size = size
        if size_system is not None:
            self.size_system = size_system
        if size_type is not None:
            self.size_type = size_type
        if subtitle is not None:
            self.subtitle = subtitle
        if taxes is not None:
            self.taxes = taxes
        if title is not None:
            self.title = title
        if top_rated_buying_experience is not None:
            self.top_rated_buying_experience = top_rated_buying_experience
        if tyre_label_image_url is not None:
            self.tyre_label_image_url = tyre_label_image_url
        if unique_bidder_count is not None:
            self.unique_bidder_count = unique_bidder_count
        if unit_price is not None:
            self.unit_price = unit_price
        if unit_pricing_measure is not None:
            self.unit_pricing_measure = unit_pricing_measure
        if warnings is not None:
            self.warnings = warnings
        if watch_count is not None:
            self.watch_count = watch_count

    @property
    def additional_images(self):
        """Gets the additional_images of this Item.  # noqa: E501

        An array of containers with the URLs for the images that are in addition to the primary image.  The primary image is returned in the <b> image.imageUrl</b> field.  # noqa: E501

        :return: The additional_images of this Item.  # noqa: E501
        :rtype: list[Image]
        """
        return self._additional_images

    @additional_images.setter
    def additional_images(self, additional_images):
        """Sets the additional_images of this Item.

        An array of containers with the URLs for the images that are in addition to the primary image.  The primary image is returned in the <b> image.imageUrl</b> field.  # noqa: E501

        :param additional_images: The additional_images of this Item.  # noqa: E501
        :type: list[Image]
        """

        self._additional_images = additional_images

    @property
    def addon_services(self):
        """Gets the addon_services of this Item.  # noqa: E501

        A list of add-on services that may be selected for the item or that may apply automatically.  # noqa: E501

        :return: The addon_services of this Item.  # noqa: E501
        :rtype: list[AddonService]
        """
        return self._addon_services

    @addon_services.setter
    def addon_services(self, addon_services):
        """Sets the addon_services of this Item.

        A list of add-on services that may be selected for the item or that may apply automatically.  # noqa: E501

        :param addon_services: The addon_services of this Item.  # noqa: E501
        :type: list[AddonService]
        """

        self._addon_services = addon_services

    @property
    def adult_only(self):
        """Gets the adult_only of this Item.  # noqa: E501

        This indicates if the item is for  adults only. For more information about adult-only items on eBay, see <a href=\"https://pages.ebay.com/help/policies/adult-only.html\" target=\"_blank\">Adult items policy</a> for sellers and <a href=\"https://www.ebay.com/help/terms-conditions/default/searching-adult-items?id=4661\" target=\"_blank\">Adult-Only items on eBay</a> for buyers.  # noqa: E501

        :return: The adult_only of this Item.  # noqa: E501
        :rtype: bool
        """
        return self._adult_only

    @adult_only.setter
    def adult_only(self, adult_only):
        """Sets the adult_only of this Item.

        This indicates if the item is for  adults only. For more information about adult-only items on eBay, see <a href=\"https://pages.ebay.com/help/policies/adult-only.html\" target=\"_blank\">Adult items policy</a> for sellers and <a href=\"https://www.ebay.com/help/terms-conditions/default/searching-adult-items?id=4661\" target=\"_blank\">Adult-Only items on eBay</a> for buyers.  # noqa: E501

        :param adult_only: The adult_only of this Item.  # noqa: E501
        :type: bool
        """

        self._adult_only = adult_only

    @property
    def age_group(self):
        """Gets the age_group of this Item.  # noqa: E501

        (Primary Item Aspect) The age group for which the product is recommended. For example, newborn, infant, toddler, kids, adult, etc. All the item aspects, including this aspect, are returned in the <b> localizedAspects</b> container.  # noqa: E501

        :return: The age_group of this Item.  # noqa: E501
        :rtype: str
        """
        return self._age_group

    @age_group.setter
    def age_group(self, age_group):
        """Sets the age_group of this Item.

        (Primary Item Aspect) The age group for which the product is recommended. For example, newborn, infant, toddler, kids, adult, etc. All the item aspects, including this aspect, are returned in the <b> localizedAspects</b> container.  # noqa: E501

        :param age_group: The age_group of this Item.  # noqa: E501
        :type: str
        """

        self._age_group = age_group

    @property
    def authenticity_guarantee(self):
        """Gets the authenticity_guarantee of this Item.  # noqa: E501


        :return: The authenticity_guarantee of this Item.  # noqa: E501
        :rtype: AuthenticityGuaranteeProgram
        """
        return self._authenticity_guarantee

    @authenticity_guarantee.setter
    def authenticity_guarantee(self, authenticity_guarantee):
        """Sets the authenticity_guarantee of this Item.


        :param authenticity_guarantee: The authenticity_guarantee of this Item.  # noqa: E501
        :type: AuthenticityGuaranteeProgram
        """

        self._authenticity_guarantee = authenticity_guarantee

    @property
    def authenticity_verification(self):
        """Gets the authenticity_verification of this Item.  # noqa: E501


        :return: The authenticity_verification of this Item.  # noqa: E501
        :rtype: AuthenticityVerificationProgram
        """
        return self._authenticity_verification

    @authenticity_verification.setter
    def authenticity_verification(self, authenticity_verification):
        """Sets the authenticity_verification of this Item.


        :param authenticity_verification: The authenticity_verification of this Item.  # noqa: E501
        :type: AuthenticityVerificationProgram
        """

        self._authenticity_verification = authenticity_verification

    @property
    def available_coupons(self):
        """Gets the available_coupons of this Item.  # noqa: E501

        A list of available coupons for the item.  # noqa: E501

        :return: The available_coupons of this Item.  # noqa: E501
        :rtype: list[AvailableCoupon]
        """
        return self._available_coupons

    @available_coupons.setter
    def available_coupons(self, available_coupons):
        """Sets the available_coupons of this Item.

        A list of available coupons for the item.  # noqa: E501

        :param available_coupons: The available_coupons of this Item.  # noqa: E501
        :type: list[AvailableCoupon]
        """

        self._available_coupons = available_coupons

    @property
    def bid_count(self):
        """Gets the bid_count of this Item.  # noqa: E501

        This integer value indicates the total number of bids that have been placed against an auction item. This field is returned only for auction items.  # noqa: E501

        :return: The bid_count of this Item.  # noqa: E501
        :rtype: int
        """
        return self._bid_count

    @bid_count.setter
    def bid_count(self, bid_count):
        """Sets the bid_count of this Item.

        This integer value indicates the total number of bids that have been placed against an auction item. This field is returned only for auction items.  # noqa: E501

        :param bid_count: The bid_count of this Item.  # noqa: E501
        :type: int
        """

        self._bid_count = bid_count

    @property
    def brand(self):
        """Gets the brand of this Item.  # noqa: E501

        (Primary Item Aspect) The name brand of the item, such as Nike, Apple, etc.  All the item aspects, including this aspect, are returned in the <b> localizedAspects</b> container.  # noqa: E501

        :return: The brand of this Item.  # noqa: E501
        :rtype: str
        """
        return self._brand

    @brand.setter
    def brand(self, brand):
        """Sets the brand of this Item.

        (Primary Item Aspect) The name brand of the item, such as Nike, Apple, etc.  All the item aspects, including this aspect, are returned in the <b> localizedAspects</b> container.  # noqa: E501

        :param brand: The brand of this Item.  # noqa: E501
        :type: str
        """

        self._brand = brand

    @property
    def buying_options(self):
        """Gets the buying_options of this Item.  # noqa: E501

        A comma separated list of all the purchase options available for the item. The values returned are:  <ul> <li><code>FIXED_PRICE</code> - Indicates the buyer can purchase the item for a set price using the Buy It Now button. </li>  <li><code>AUCTION</code> - Indicates the buyer can place a bid for the item. After the first bid is placed, this becomes a live auction item and is the only buying option for this item.</li>  <li><code>BEST_OFFER</code> - Indicates the buyer can send the seller a price they're willing to pay for the item. The seller can accept, reject, or send a counter offer. For more information on how this works, see <a href=\"https://www.ebay.com/help/buying/buy-now/making-best-offer?id=4019 \">Making a Best Offer</a>.</li> </ul> Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :return: The buying_options of this Item.  # noqa: E501
        :rtype: list[str]
        """
        return self._buying_options

    @buying_options.setter
    def buying_options(self, buying_options):
        """Sets the buying_options of this Item.

        A comma separated list of all the purchase options available for the item. The values returned are:  <ul> <li><code>FIXED_PRICE</code> - Indicates the buyer can purchase the item for a set price using the Buy It Now button. </li>  <li><code>AUCTION</code> - Indicates the buyer can place a bid for the item. After the first bid is placed, this becomes a live auction item and is the only buying option for this item.</li>  <li><code>BEST_OFFER</code> - Indicates the buyer can send the seller a price they're willing to pay for the item. The seller can accept, reject, or send a counter offer. For more information on how this works, see <a href=\"https://www.ebay.com/help/buying/buy-now/making-best-offer?id=4019 \">Making a Best Offer</a>.</li> </ul> Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :param buying_options: The buying_options of this Item.  # noqa: E501
        :type: list[str]
        """

        self._buying_options = buying_options

    @property
    def category_id(self):
        """Gets the category_id of this Item.  # noqa: E501

        The ID of the leaf category for this item. A leaf category is the lowest level in that category and has no children.  # noqa: E501

        :return: The category_id of this Item.  # noqa: E501
        :rtype: str
        """
        return self._category_id

    @category_id.setter
    def category_id(self, category_id):
        """Sets the category_id of this Item.

        The ID of the leaf category for this item. A leaf category is the lowest level in that category and has no children.  # noqa: E501

        :param category_id: The category_id of this Item.  # noqa: E501
        :type: str
        """

        self._category_id = category_id

    @property
    def category_path(self):
        """Gets the category_path of this Item.  # noqa: E501

        Text that shows the category hierarchy of the item. For example: Computers/Tablets &amp; Networking, Laptops &amp; Netbooks, PC Laptops &amp; Netbooks  # noqa: E501

        :return: The category_path of this Item.  # noqa: E501
        :rtype: str
        """
        return self._category_path

    @category_path.setter
    def category_path(self, category_path):
        """Sets the category_path of this Item.

        Text that shows the category hierarchy of the item. For example: Computers/Tablets &amp; Networking, Laptops &amp; Netbooks, PC Laptops &amp; Netbooks  # noqa: E501

        :param category_path: The category_path of this Item.  # noqa: E501
        :type: str
        """

        self._category_path = category_path

    @property
    def color(self):
        """Gets the color of this Item.  # noqa: E501

        (Primary Item Aspect) Text describing the color of the item.  All the item aspects, including this aspect, are returned in the <b> localizedAspects</b> container.  # noqa: E501

        :return: The color of this Item.  # noqa: E501
        :rtype: str
        """
        return self._color

    @color.setter
    def color(self, color):
        """Sets the color of this Item.

        (Primary Item Aspect) Text describing the color of the item.  All the item aspects, including this aspect, are returned in the <b> localizedAspects</b> container.  # noqa: E501

        :param color: The color of this Item.  # noqa: E501
        :type: str
        """

        self._color = color

    @property
    def condition(self):
        """Gets the condition of this Item.  # noqa: E501

        A short text description for the condition of the item, such as New or Used. For a list of condition names, see <a href=\"https://developer.ebay.com/devzone/finding/callref/enums/conditionIdList.html \" target=\"_blank\">Item Condition IDs and Names</a>.  <br /><br />Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :return: The condition of this Item.  # noqa: E501
        :rtype: str
        """
        return self._condition

    @condition.setter
    def condition(self, condition):
        """Sets the condition of this Item.

        A short text description for the condition of the item, such as New or Used. For a list of condition names, see <a href=\"https://developer.ebay.com/devzone/finding/callref/enums/conditionIdList.html \" target=\"_blank\">Item Condition IDs and Names</a>.  <br /><br />Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :param condition: The condition of this Item.  # noqa: E501
        :type: str
        """

        self._condition = condition

    @property
    def condition_description(self):
        """Gets the condition_description of this Item.  # noqa: E501

        A full text description for the condition of the item. This field elaborates on the value specified in the <b>condition</b> field and provides full details for the condition of the item.  # noqa: E501

        :return: The condition_description of this Item.  # noqa: E501
        :rtype: str
        """
        return self._condition_description

    @condition_description.setter
    def condition_description(self, condition_description):
        """Sets the condition_description of this Item.

        A full text description for the condition of the item. This field elaborates on the value specified in the <b>condition</b> field and provides full details for the condition of the item.  # noqa: E501

        :param condition_description: The condition_description of this Item.  # noqa: E501
        :type: str
        """

        self._condition_description = condition_description

    @property
    def condition_id(self):
        """Gets the condition_id of this Item.  # noqa: E501

        The identifier of the condition of the item. For example, 1000 is the identifier for NEW. For a list of condition names and IDs, see <a href=\"https://developer.ebay.com/devzone/finding/callref/enums/conditionIdList.html \" target=\"_blank\">Item Condition IDs and Names</a>. <br /><br />Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :return: The condition_id of this Item.  # noqa: E501
        :rtype: str
        """
        return self._condition_id

    @condition_id.setter
    def condition_id(self, condition_id):
        """Sets the condition_id of this Item.

        The identifier of the condition of the item. For example, 1000 is the identifier for NEW. For a list of condition names and IDs, see <a href=\"https://developer.ebay.com/devzone/finding/callref/enums/conditionIdList.html \" target=\"_blank\">Item Condition IDs and Names</a>. <br /><br />Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :param condition_id: The condition_id of this Item.  # noqa: E501
        :type: str
        """

        self._condition_id = condition_id

    @property
    def current_bid_price(self):
        """Gets the current_bid_price of this Item.  # noqa: E501


        :return: The current_bid_price of this Item.  # noqa: E501
        :rtype: ConvertedAmount
        """
        return self._current_bid_price

    @current_bid_price.setter
    def current_bid_price(self, current_bid_price):
        """Sets the current_bid_price of this Item.


        :param current_bid_price: The current_bid_price of this Item.  # noqa: E501
        :type: ConvertedAmount
        """

        self._current_bid_price = current_bid_price

    @property
    def description(self):
        """Gets the description of this Item.  # noqa: E501

        The full description of the item that was created by the seller. This can be plain text or rich content and can be very large.  # noqa: E501

        :return: The description of this Item.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Item.

        The full description of the item that was created by the seller. This can be plain text or rich content and can be very large.  # noqa: E501

        :param description: The description of this Item.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def eco_participation_fee(self):
        """Gets the eco_participation_fee of this Item.  # noqa: E501


        :return: The eco_participation_fee of this Item.  # noqa: E501
        :rtype: ConvertedAmount
        """
        return self._eco_participation_fee

    @eco_participation_fee.setter
    def eco_participation_fee(self, eco_participation_fee):
        """Sets the eco_participation_fee of this Item.


        :param eco_participation_fee: The eco_participation_fee of this Item.  # noqa: E501
        :type: ConvertedAmount
        """

        self._eco_participation_fee = eco_participation_fee

    @property
    def eligible_for_inline_checkout(self):
        """Gets the eligible_for_inline_checkout of this Item.  # noqa: E501

        This field indicates if the item can be purchased using the Buy <a href=\"/api-docs/buy/order/resources/methods\">Order API</a>. <ul> <li>If the value of this field is <code>true</code>, this indicates that the item can be purchased using the <b> Order API</b>. </li>  <li>If the value of this field is <code>false</code>, this indicates that the item cannot be purchased using the <b> Order API</b> and must be purchased on the eBay site.</li> </ul>  # noqa: E501

        :return: The eligible_for_inline_checkout of this Item.  # noqa: E501
        :rtype: bool
        """
        return self._eligible_for_inline_checkout

    @eligible_for_inline_checkout.setter
    def eligible_for_inline_checkout(self, eligible_for_inline_checkout):
        """Sets the eligible_for_inline_checkout of this Item.

        This field indicates if the item can be purchased using the Buy <a href=\"/api-docs/buy/order/resources/methods\">Order API</a>. <ul> <li>If the value of this field is <code>true</code>, this indicates that the item can be purchased using the <b> Order API</b>. </li>  <li>If the value of this field is <code>false</code>, this indicates that the item cannot be purchased using the <b> Order API</b> and must be purchased on the eBay site.</li> </ul>  # noqa: E501

        :param eligible_for_inline_checkout: The eligible_for_inline_checkout of this Item.  # noqa: E501
        :type: bool
        """

        self._eligible_for_inline_checkout = eligible_for_inline_checkout

    @property
    def enabled_for_guest_checkout(self):
        """Gets the enabled_for_guest_checkout of this Item.  # noqa: E501

        This indicates if the item can be purchased using Guest Checkout in the <a href=\"/api-docs/buy/order/resources/methods\">Order API</a>. You can use this flag to exclude items from your inventory that are not eligible for Guest Checkout, such as gift cards.  # noqa: E501

        :return: The enabled_for_guest_checkout of this Item.  # noqa: E501
        :rtype: bool
        """
        return self._enabled_for_guest_checkout

    @enabled_for_guest_checkout.setter
    def enabled_for_guest_checkout(self, enabled_for_guest_checkout):
        """Sets the enabled_for_guest_checkout of this Item.

        This indicates if the item can be purchased using Guest Checkout in the <a href=\"/api-docs/buy/order/resources/methods\">Order API</a>. You can use this flag to exclude items from your inventory that are not eligible for Guest Checkout, such as gift cards.  # noqa: E501

        :param enabled_for_guest_checkout: The enabled_for_guest_checkout of this Item.  # noqa: E501
        :type: bool
        """

        self._enabled_for_guest_checkout = enabled_for_guest_checkout

    @property
    def energy_efficiency_class(self):
        """Gets the energy_efficiency_class of this Item.  # noqa: E501

        This indicates the <a href=\"https://en.wikipedia.org/wiki/European_Union_energy_label \">European energy efficiency</a> rating (EEK) of the item. This field is returned only if the seller specified the energy efficiency rating. <br /><br />The rating is a set of energy efficiency classes from A to G, where 'A' is the most energy efficient and 'G' is the least efficient. This rating helps buyers choose between various models. <br /><br />When the manufacturer's specifications for this item are available, the link to this information is returned in the <b> productFicheWebUrl</b> field.  # noqa: E501

        :return: The energy_efficiency_class of this Item.  # noqa: E501
        :rtype: str
        """
        return self._energy_efficiency_class

    @energy_efficiency_class.setter
    def energy_efficiency_class(self, energy_efficiency_class):
        """Sets the energy_efficiency_class of this Item.

        This indicates the <a href=\"https://en.wikipedia.org/wiki/European_Union_energy_label \">European energy efficiency</a> rating (EEK) of the item. This field is returned only if the seller specified the energy efficiency rating. <br /><br />The rating is a set of energy efficiency classes from A to G, where 'A' is the most energy efficient and 'G' is the least efficient. This rating helps buyers choose between various models. <br /><br />When the manufacturer's specifications for this item are available, the link to this information is returned in the <b> productFicheWebUrl</b> field.  # noqa: E501

        :param energy_efficiency_class: The energy_efficiency_class of this Item.  # noqa: E501
        :type: str
        """

        self._energy_efficiency_class = energy_efficiency_class

    @property
    def epid(self):
        """Gets the epid of this Item.  # noqa: E501

        An EPID is the eBay product identifier of a product from the eBay product catalog.  This indicates the product in which the item belongs.  # noqa: E501

        :return: The epid of this Item.  # noqa: E501
        :rtype: str
        """
        return self._epid

    @epid.setter
    def epid(self, epid):
        """Sets the epid of this Item.

        An EPID is the eBay product identifier of a product from the eBay product catalog.  This indicates the product in which the item belongs.  # noqa: E501

        :param epid: The epid of this Item.  # noqa: E501
        :type: str
        """

        self._epid = epid

    @property
    def estimated_availabilities(self):
        """Gets the estimated_availabilities of this Item.  # noqa: E501

        The estimated number of this item that are available for purchase. Because the quantity of an item can change several times within a second, it is impossible to return the exact quantity. So instead of returning quantity, the estimated availability of the item is returned.  # noqa: E501

        :return: The estimated_availabilities of this Item.  # noqa: E501
        :rtype: list[EstimatedAvailability]
        """
        return self._estimated_availabilities

    @estimated_availabilities.setter
    def estimated_availabilities(self, estimated_availabilities):
        """Sets the estimated_availabilities of this Item.

        The estimated number of this item that are available for purchase. Because the quantity of an item can change several times within a second, it is impossible to return the exact quantity. So instead of returning quantity, the estimated availability of the item is returned.  # noqa: E501

        :param estimated_availabilities: The estimated_availabilities of this Item.  # noqa: E501
        :type: list[EstimatedAvailability]
        """

        self._estimated_availabilities = estimated_availabilities

    @property
    def gender(self):
        """Gets the gender of this Item.  # noqa: E501

        (Primary Item Aspect) The gender for the item. This is used for items that could vary by gender, such as clothing. For example: male, female, or unisex. All the item aspects, including this aspect, are returned in the <b> localizedAspects</b> container.  # noqa: E501

        :return: The gender of this Item.  # noqa: E501
        :rtype: str
        """
        return self._gender

    @gender.setter
    def gender(self, gender):
        """Sets the gender of this Item.

        (Primary Item Aspect) The gender for the item. This is used for items that could vary by gender, such as clothing. For example: male, female, or unisex. All the item aspects, including this aspect, are returned in the <b> localizedAspects</b> container.  # noqa: E501

        :param gender: The gender of this Item.  # noqa: E501
        :type: str
        """

        self._gender = gender

    @property
    def gtin(self):
        """Gets the gtin of this Item.  # noqa: E501

        The unique Global Trade Item number of the item as defined by <a href=\"https://www.gtin.info \" target=\"_blank\">https://www.gtin.info</a>. This can be a UPC (Universal Product Code), EAN (European Article Number), or an ISBN (International Standard Book Number) value.  # noqa: E501

        :return: The gtin of this Item.  # noqa: E501
        :rtype: str
        """
        return self._gtin

    @gtin.setter
    def gtin(self, gtin):
        """Sets the gtin of this Item.

        The unique Global Trade Item number of the item as defined by <a href=\"https://www.gtin.info \" target=\"_blank\">https://www.gtin.info</a>. This can be a UPC (Universal Product Code), EAN (European Article Number), or an ISBN (International Standard Book Number) value.  # noqa: E501

        :param gtin: The gtin of this Item.  # noqa: E501
        :type: str
        """

        self._gtin = gtin

    @property
    def image(self):
        """Gets the image of this Item.  # noqa: E501


        :return: The image of this Item.  # noqa: E501
        :rtype: Image
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this Item.


        :param image: The image of this Item.  # noqa: E501
        :type: Image
        """

        self._image = image

    @property
    def inferred_epid(self):
        """Gets the inferred_epid of this Item.  # noqa: E501

        The ePID (eBay Product ID of a product from the eBay product catalog) for the item, which has been programmatically determined by eBay using the item's title, aspects, and other data. <br /><br />If the seller provided an ePID for the item, the seller's value is returned in the <b> epid</b> field. <br /><br /><span class=\"tablenote\"><b> Note: </b> This field is returned only for authorized Partners.</span>  # noqa: E501

        :return: The inferred_epid of this Item.  # noqa: E501
        :rtype: str
        """
        return self._inferred_epid

    @inferred_epid.setter
    def inferred_epid(self, inferred_epid):
        """Sets the inferred_epid of this Item.

        The ePID (eBay Product ID of a product from the eBay product catalog) for the item, which has been programmatically determined by eBay using the item's title, aspects, and other data. <br /><br />If the seller provided an ePID for the item, the seller's value is returned in the <b> epid</b> field. <br /><br /><span class=\"tablenote\"><b> Note: </b> This field is returned only for authorized Partners.</span>  # noqa: E501

        :param inferred_epid: The inferred_epid of this Item.  # noqa: E501
        :type: str
        """

        self._inferred_epid = inferred_epid

    @property
    def item_affiliate_web_url(self):
        """Gets the item_affiliate_web_url of this Item.  # noqa: E501

        The URL of the View Item page of the item, which includes the affiliate tracking ID. This field is only returned if the eBay partner enables affiliate tracking for the item by including the  <a href=\"/api-docs/buy/static/api-browse.html#Headers\"><code>X-EBAY-C-ENDUSERCTX</code></a> request header in the method.  <br /> <br /><span class=\"tablenote\"><b>Note: </b> eBay Partner Network, in order to be commissioned for your sales, you must use this URL to forward your buyer to the ebay.com site. </span>  # noqa: E501

        :return: The item_affiliate_web_url of this Item.  # noqa: E501
        :rtype: str
        """
        return self._item_affiliate_web_url

    @item_affiliate_web_url.setter
    def item_affiliate_web_url(self, item_affiliate_web_url):
        """Sets the item_affiliate_web_url of this Item.

        The URL of the View Item page of the item, which includes the affiliate tracking ID. This field is only returned if the eBay partner enables affiliate tracking for the item by including the  <a href=\"/api-docs/buy/static/api-browse.html#Headers\"><code>X-EBAY-C-ENDUSERCTX</code></a> request header in the method.  <br /> <br /><span class=\"tablenote\"><b>Note: </b> eBay Partner Network, in order to be commissioned for your sales, you must use this URL to forward your buyer to the ebay.com site. </span>  # noqa: E501

        :param item_affiliate_web_url: The item_affiliate_web_url of this Item.  # noqa: E501
        :type: str
        """

        self._item_affiliate_web_url = item_affiliate_web_url

    @property
    def item_end_date(self):
        """Gets the item_end_date of this Item.  # noqa: E501

        This timestamp indicates the date and time up to which the item can be purchased.  This value is returned in UTC format (yyyy-MM-ddThh:mm:ss.sssZ), which you can convert into the local time of the buyer.<br /><br /><span class=\"tablenote\"><b> Note: </b>This field is only returned for auction listings.</span>  # noqa: E501

        :return: The item_end_date of this Item.  # noqa: E501
        :rtype: str
        """
        return self._item_end_date

    @item_end_date.setter
    def item_end_date(self, item_end_date):
        """Sets the item_end_date of this Item.

        This timestamp indicates the date and time up to which the item can be purchased.  This value is returned in UTC format (yyyy-MM-ddThh:mm:ss.sssZ), which you can convert into the local time of the buyer.<br /><br /><span class=\"tablenote\"><b> Note: </b>This field is only returned for auction listings.</span>  # noqa: E501

        :param item_end_date: The item_end_date of this Item.  # noqa: E501
        :type: str
        """

        self._item_end_date = item_end_date

    @property
    def item_id(self):
        """Gets the item_id of this Item.  # noqa: E501

        The unique RESTful identifier of the item.  # noqa: E501

        :return: The item_id of this Item.  # noqa: E501
        :rtype: str
        """
        return self._item_id

    @item_id.setter
    def item_id(self, item_id):
        """Sets the item_id of this Item.

        The unique RESTful identifier of the item.  # noqa: E501

        :param item_id: The item_id of this Item.  # noqa: E501
        :type: str
        """

        self._item_id = item_id

    @property
    def item_location(self):
        """Gets the item_location of this Item.  # noqa: E501


        :return: The item_location of this Item.  # noqa: E501
        :rtype: Address
        """
        return self._item_location

    @item_location.setter
    def item_location(self, item_location):
        """Sets the item_location of this Item.


        :param item_location: The item_location of this Item.  # noqa: E501
        :type: Address
        """

        self._item_location = item_location

    @property
    def item_web_url(self):
        """Gets the item_web_url of this Item.  # noqa: E501

        The URL of the View Item page of the item. This enables you to include a \"Report Item on eBay\" link that takes the buyer to the View Item page on eBay. From there they can report any issues regarding this item to eBay.  # noqa: E501

        :return: The item_web_url of this Item.  # noqa: E501
        :rtype: str
        """
        return self._item_web_url

    @item_web_url.setter
    def item_web_url(self, item_web_url):
        """Sets the item_web_url of this Item.

        The URL of the View Item page of the item. This enables you to include a \"Report Item on eBay\" link that takes the buyer to the View Item page on eBay. From there they can report any issues regarding this item to eBay.  # noqa: E501

        :param item_web_url: The item_web_url of this Item.  # noqa: E501
        :type: str
        """

        self._item_web_url = item_web_url

    @property
    def legacy_item_id(self):
        """Gets the legacy_item_id of this Item.  # noqa: E501

        The unique identifier of the eBay listing that contains the item. This is the traditional/legacy ID that is often seen in the URL of the listing View Item page.  # noqa: E501

        :return: The legacy_item_id of this Item.  # noqa: E501
        :rtype: str
        """
        return self._legacy_item_id

    @legacy_item_id.setter
    def legacy_item_id(self, legacy_item_id):
        """Sets the legacy_item_id of this Item.

        The unique identifier of the eBay listing that contains the item. This is the traditional/legacy ID that is often seen in the URL of the listing View Item page.  # noqa: E501

        :param legacy_item_id: The legacy_item_id of this Item.  # noqa: E501
        :type: str
        """

        self._legacy_item_id = legacy_item_id

    @property
    def listing_marketplace_id(self):
        """Gets the listing_marketplace_id of this Item.  # noqa: E501

        The ID of the eBay marketplace where the item is listed. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/browse/types/ba:MarketplaceIdEnum'>eBay API documentation</a>  # noqa: E501

        :return: The listing_marketplace_id of this Item.  # noqa: E501
        :rtype: str
        """
        return self._listing_marketplace_id

    @listing_marketplace_id.setter
    def listing_marketplace_id(self, listing_marketplace_id):
        """Sets the listing_marketplace_id of this Item.

        The ID of the eBay marketplace where the item is listed. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/browse/types/ba:MarketplaceIdEnum'>eBay API documentation</a>  # noqa: E501

        :param listing_marketplace_id: The listing_marketplace_id of this Item.  # noqa: E501
        :type: str
        """

        self._listing_marketplace_id = listing_marketplace_id

    @property
    def localized_aspects(self):
        """Gets the localized_aspects of this Item.  # noqa: E501

        An array of containers that show the complete list of the aspect name/value pairs that describe the variation of the item.  # noqa: E501

        :return: The localized_aspects of this Item.  # noqa: E501
        :rtype: list[TypedNameValue]
        """
        return self._localized_aspects

    @localized_aspects.setter
    def localized_aspects(self, localized_aspects):
        """Sets the localized_aspects of this Item.

        An array of containers that show the complete list of the aspect name/value pairs that describe the variation of the item.  # noqa: E501

        :param localized_aspects: The localized_aspects of this Item.  # noqa: E501
        :type: list[TypedNameValue]
        """

        self._localized_aspects = localized_aspects

    @property
    def lot_size(self):
        """Gets the lot_size of this Item.  # noqa: E501

        The number of items in a lot. In other words, a lot size is the number of items that are being sold together.  <br /><br />A lot is a set of two or more items included in a single listing that must be purchased together in a single order line item. All the items in the lot are the same but there can be multiple items in a single lot,  such as the package of batteries shown in the example below.   <br /><br /><table border=\"1\"> <tr> <tr>  <th>Item</th>  <th>Lot Definition</th> <th>Lot Size</th></tr>  <tr>  <td>A package of 24 AA batteries</td>  <td>A box of 10 packages</td>  <td>10  </td> </tr>  <tr>  <td>A P235/75-15 Goodyear tire </td>  <td>4 tires  </td>  <td>4  </td> </tr> <tr> <td>Fashion Jewelry Rings  </td> <td>Package of 100 assorted rings  </td> <td>100 </td> </tr></table>  <br /><br /><span class=\"tablenote\"><b>Note: </b>  Lots are not supported in all categories.  </span>  # noqa: E501

        :return: The lot_size of this Item.  # noqa: E501
        :rtype: int
        """
        return self._lot_size

    @lot_size.setter
    def lot_size(self, lot_size):
        """Sets the lot_size of this Item.

        The number of items in a lot. In other words, a lot size is the number of items that are being sold together.  <br /><br />A lot is a set of two or more items included in a single listing that must be purchased together in a single order line item. All the items in the lot are the same but there can be multiple items in a single lot,  such as the package of batteries shown in the example below.   <br /><br /><table border=\"1\"> <tr> <tr>  <th>Item</th>  <th>Lot Definition</th> <th>Lot Size</th></tr>  <tr>  <td>A package of 24 AA batteries</td>  <td>A box of 10 packages</td>  <td>10  </td> </tr>  <tr>  <td>A P235/75-15 Goodyear tire </td>  <td>4 tires  </td>  <td>4  </td> </tr> <tr> <td>Fashion Jewelry Rings  </td> <td>Package of 100 assorted rings  </td> <td>100 </td> </tr></table>  <br /><br /><span class=\"tablenote\"><b>Note: </b>  Lots are not supported in all categories.  </span>  # noqa: E501

        :param lot_size: The lot_size of this Item.  # noqa: E501
        :type: int
        """

        self._lot_size = lot_size

    @property
    def marketing_price(self):
        """Gets the marketing_price of this Item.  # noqa: E501


        :return: The marketing_price of this Item.  # noqa: E501
        :rtype: MarketingPrice
        """
        return self._marketing_price

    @marketing_price.setter
    def marketing_price(self, marketing_price):
        """Sets the marketing_price of this Item.


        :param marketing_price: The marketing_price of this Item.  # noqa: E501
        :type: MarketingPrice
        """

        self._marketing_price = marketing_price

    @property
    def material(self):
        """Gets the material of this Item.  # noqa: E501

        (Primary Item Aspect) Text describing what the item is made of. For example, silk. All the item aspects, including this aspect, are returned in the <b> localizedAspects</b> container.  # noqa: E501

        :return: The material of this Item.  # noqa: E501
        :rtype: str
        """
        return self._material

    @material.setter
    def material(self, material):
        """Sets the material of this Item.

        (Primary Item Aspect) Text describing what the item is made of. For example, silk. All the item aspects, including this aspect, are returned in the <b> localizedAspects</b> container.  # noqa: E501

        :param material: The material of this Item.  # noqa: E501
        :type: str
        """

        self._material = material

    @property
    def minimum_price_to_bid(self):
        """Gets the minimum_price_to_bid of this Item.  # noqa: E501


        :return: The minimum_price_to_bid of this Item.  # noqa: E501
        :rtype: ConvertedAmount
        """
        return self._minimum_price_to_bid

    @minimum_price_to_bid.setter
    def minimum_price_to_bid(self, minimum_price_to_bid):
        """Sets the minimum_price_to_bid of this Item.


        :param minimum_price_to_bid: The minimum_price_to_bid of this Item.  # noqa: E501
        :type: ConvertedAmount
        """

        self._minimum_price_to_bid = minimum_price_to_bid

    @property
    def mpn(self):
        """Gets the mpn of this Item.  # noqa: E501

        The manufacturer's part number, which is a unique number that identifies a specific product. To identify the product, this is always used along with brand.  # noqa: E501

        :return: The mpn of this Item.  # noqa: E501
        :rtype: str
        """
        return self._mpn

    @mpn.setter
    def mpn(self, mpn):
        """Sets the mpn of this Item.

        The manufacturer's part number, which is a unique number that identifies a specific product. To identify the product, this is always used along with brand.  # noqa: E501

        :param mpn: The mpn of this Item.  # noqa: E501
        :type: str
        """

        self._mpn = mpn

    @property
    def pattern(self):
        """Gets the pattern of this Item.  # noqa: E501

        (Primary Item Aspect) Text describing the pattern used on the item. For example, paisley. All the item aspects, including this aspect, are returned in the <b> localizedAspects</b> container.  # noqa: E501

        :return: The pattern of this Item.  # noqa: E501
        :rtype: str
        """
        return self._pattern

    @pattern.setter
    def pattern(self, pattern):
        """Sets the pattern of this Item.

        (Primary Item Aspect) Text describing the pattern used on the item. For example, paisley. All the item aspects, including this aspect, are returned in the <b> localizedAspects</b> container.  # noqa: E501

        :param pattern: The pattern of this Item.  # noqa: E501
        :type: str
        """

        self._pattern = pattern

    @property
    def payment_methods(self):
        """Gets the payment_methods of this Item.  # noqa: E501

        The payment methods for the item, including the payment method types, brands, and instructions for the buyer.  # noqa: E501

        :return: The payment_methods of this Item.  # noqa: E501
        :rtype: list[PaymentMethod]
        """
        return self._payment_methods

    @payment_methods.setter
    def payment_methods(self, payment_methods):
        """Sets the payment_methods of this Item.

        The payment methods for the item, including the payment method types, brands, and instructions for the buyer.  # noqa: E501

        :param payment_methods: The payment_methods of this Item.  # noqa: E501
        :type: list[PaymentMethod]
        """

        self._payment_methods = payment_methods

    @property
    def price(self):
        """Gets the price of this Item.  # noqa: E501


        :return: The price of this Item.  # noqa: E501
        :rtype: ConvertedAmount
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this Item.


        :param price: The price of this Item.  # noqa: E501
        :type: ConvertedAmount
        """

        self._price = price

    @property
    def price_display_condition(self):
        """Gets the price_display_condition of this Item.  # noqa: E501

        Indicates when in the buying flow the item's price can appear for minimum advertised price (MAP) items, which is the lowest price a retailer can advertise/show for this item. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/browse/types/gct:PriceDisplayConditionEnum'>eBay API documentation</a>  # noqa: E501

        :return: The price_display_condition of this Item.  # noqa: E501
        :rtype: str
        """
        return self._price_display_condition

    @price_display_condition.setter
    def price_display_condition(self, price_display_condition):
        """Sets the price_display_condition of this Item.

        Indicates when in the buying flow the item's price can appear for minimum advertised price (MAP) items, which is the lowest price a retailer can advertise/show for this item. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/browse/types/gct:PriceDisplayConditionEnum'>eBay API documentation</a>  # noqa: E501

        :param price_display_condition: The price_display_condition of this Item.  # noqa: E501
        :type: str
        """

        self._price_display_condition = price_display_condition

    @property
    def primary_item_group(self):
        """Gets the primary_item_group of this Item.  # noqa: E501


        :return: The primary_item_group of this Item.  # noqa: E501
        :rtype: ItemGroupSummary
        """
        return self._primary_item_group

    @primary_item_group.setter
    def primary_item_group(self, primary_item_group):
        """Sets the primary_item_group of this Item.


        :param primary_item_group: The primary_item_group of this Item.  # noqa: E501
        :type: ItemGroupSummary
        """

        self._primary_item_group = primary_item_group

    @property
    def primary_product_review_rating(self):
        """Gets the primary_product_review_rating of this Item.  # noqa: E501


        :return: The primary_product_review_rating of this Item.  # noqa: E501
        :rtype: ReviewRating
        """
        return self._primary_product_review_rating

    @primary_product_review_rating.setter
    def primary_product_review_rating(self, primary_product_review_rating):
        """Sets the primary_product_review_rating of this Item.


        :param primary_product_review_rating: The primary_product_review_rating of this Item.  # noqa: E501
        :type: ReviewRating
        """

        self._primary_product_review_rating = primary_product_review_rating

    @property
    def priority_listing(self):
        """Gets the priority_listing of this Item.  # noqa: E501

        This field is returned as <code>true</code> if the listing is part of a Promoted Listing campaign. Promoted Listings are available to Above Standard and Top Rated sellers with recent sales activity.<br /><br />For more information, see <a href=\"https://pages.ebay.com/seller-center/listing-and-marketing/promoted-listings.html \" target=\"_blank\">Promoted Listings</a>.  # noqa: E501

        :return: The priority_listing of this Item.  # noqa: E501
        :rtype: bool
        """
        return self._priority_listing

    @priority_listing.setter
    def priority_listing(self, priority_listing):
        """Sets the priority_listing of this Item.

        This field is returned as <code>true</code> if the listing is part of a Promoted Listing campaign. Promoted Listings are available to Above Standard and Top Rated sellers with recent sales activity.<br /><br />For more information, see <a href=\"https://pages.ebay.com/seller-center/listing-and-marketing/promoted-listings.html \" target=\"_blank\">Promoted Listings</a>.  # noqa: E501

        :param priority_listing: The priority_listing of this Item.  # noqa: E501
        :type: bool
        """

        self._priority_listing = priority_listing

    @property
    def product(self):
        """Gets the product of this Item.  # noqa: E501


        :return: The product of this Item.  # noqa: E501
        :rtype: Product
        """
        return self._product

    @product.setter
    def product(self, product):
        """Sets the product of this Item.


        :param product: The product of this Item.  # noqa: E501
        :type: Product
        """

        self._product = product

    @property
    def product_fiche_web_url(self):
        """Gets the product_fiche_web_url of this Item.  # noqa: E501

        The URL of a page containing the manufacturer's specification of this item, which helps buyers make a purchasing decision. This information is available only for items that include the European energy efficiency rating (EEK) but is not available for <em> all</em> items with an EEK rating and is returned only if this information is available. The EEK rating of the item is returned in the <b> energyEfficiencyClass</b> field.  # noqa: E501

        :return: The product_fiche_web_url of this Item.  # noqa: E501
        :rtype: str
        """
        return self._product_fiche_web_url

    @product_fiche_web_url.setter
    def product_fiche_web_url(self, product_fiche_web_url):
        """Sets the product_fiche_web_url of this Item.

        The URL of a page containing the manufacturer's specification of this item, which helps buyers make a purchasing decision. This information is available only for items that include the European energy efficiency rating (EEK) but is not available for <em> all</em> items with an EEK rating and is returned only if this information is available. The EEK rating of the item is returned in the <b> energyEfficiencyClass</b> field.  # noqa: E501

        :param product_fiche_web_url: The product_fiche_web_url of this Item.  # noqa: E501
        :type: str
        """

        self._product_fiche_web_url = product_fiche_web_url

    @property
    def qualified_programs(self):
        """Gets the qualified_programs of this Item.  # noqa: E501

        An array of the qualified programs available for the item, such as EBAY_PLUS, AUTHENTICITY_GUARANTEE, and AUTHENTICITY_VERIFICATION.<br /><br />eBay Plus is a premium account option for buyers, which provides benefits such as fast free domestic shipping and free returns on selected items. Top-Rated eBay sellers must opt in to eBay Plus to be able to offer the program on qualifying listings. Sellers must commit to next-day delivery of those items.<br /><br /><span class=\"tablenote\"><b>Note: </b> eBay Plus is available only to buyers in Germany, Austria, and Australia marketplaces.</span><br /><br />The eBay <a href=\"https://pages.ebay.com/authenticity-guarantee/ \" target=\"_blank\">Authenticity Guarantee</a> program enables third-party authenticators to perform authentication verification inspections on items such as watches and sneakers.  # noqa: E501

        :return: The qualified_programs of this Item.  # noqa: E501
        :rtype: list[str]
        """
        return self._qualified_programs

    @qualified_programs.setter
    def qualified_programs(self, qualified_programs):
        """Sets the qualified_programs of this Item.

        An array of the qualified programs available for the item, such as EBAY_PLUS, AUTHENTICITY_GUARANTEE, and AUTHENTICITY_VERIFICATION.<br /><br />eBay Plus is a premium account option for buyers, which provides benefits such as fast free domestic shipping and free returns on selected items. Top-Rated eBay sellers must opt in to eBay Plus to be able to offer the program on qualifying listings. Sellers must commit to next-day delivery of those items.<br /><br /><span class=\"tablenote\"><b>Note: </b> eBay Plus is available only to buyers in Germany, Austria, and Australia marketplaces.</span><br /><br />The eBay <a href=\"https://pages.ebay.com/authenticity-guarantee/ \" target=\"_blank\">Authenticity Guarantee</a> program enables third-party authenticators to perform authentication verification inspections on items such as watches and sneakers.  # noqa: E501

        :param qualified_programs: The qualified_programs of this Item.  # noqa: E501
        :type: list[str]
        """

        self._qualified_programs = qualified_programs

    @property
    def quantity_limit_per_buyer(self):
        """Gets the quantity_limit_per_buyer of this Item.  # noqa: E501

        The maximum number for a specific item that one buyer can purchase.  # noqa: E501

        :return: The quantity_limit_per_buyer of this Item.  # noqa: E501
        :rtype: int
        """
        return self._quantity_limit_per_buyer

    @quantity_limit_per_buyer.setter
    def quantity_limit_per_buyer(self, quantity_limit_per_buyer):
        """Sets the quantity_limit_per_buyer of this Item.

        The maximum number for a specific item that one buyer can purchase.  # noqa: E501

        :param quantity_limit_per_buyer: The quantity_limit_per_buyer of this Item.  # noqa: E501
        :type: int
        """

        self._quantity_limit_per_buyer = quantity_limit_per_buyer

    @property
    def reserve_price_met(self):
        """Gets the reserve_price_met of this Item.  # noqa: E501

        This indicates if the reserve price of the item has been met. A reserve price is set by the seller and is the minimum amount the seller is willing to sell the item for. <p>If the highest bid is not equal to or higher than the reserve price when the auction ends, the listing ends and the item is not sold.</p> <p><b> Note: </b>This is returned only for auctions that have a reserve price.</p>  # noqa: E501

        :return: The reserve_price_met of this Item.  # noqa: E501
        :rtype: bool
        """
        return self._reserve_price_met

    @reserve_price_met.setter
    def reserve_price_met(self, reserve_price_met):
        """Sets the reserve_price_met of this Item.

        This indicates if the reserve price of the item has been met. A reserve price is set by the seller and is the minimum amount the seller is willing to sell the item for. <p>If the highest bid is not equal to or higher than the reserve price when the auction ends, the listing ends and the item is not sold.</p> <p><b> Note: </b>This is returned only for auctions that have a reserve price.</p>  # noqa: E501

        :param reserve_price_met: The reserve_price_met of this Item.  # noqa: E501
        :type: bool
        """

        self._reserve_price_met = reserve_price_met

    @property
    def return_terms(self):
        """Gets the return_terms of this Item.  # noqa: E501


        :return: The return_terms of this Item.  # noqa: E501
        :rtype: ItemReturnTerms
        """
        return self._return_terms

    @return_terms.setter
    def return_terms(self, return_terms):
        """Sets the return_terms of this Item.


        :param return_terms: The return_terms of this Item.  # noqa: E501
        :type: ItemReturnTerms
        """

        self._return_terms = return_terms

    @property
    def seller(self):
        """Gets the seller of this Item.  # noqa: E501


        :return: The seller of this Item.  # noqa: E501
        :rtype: SellerDetail
        """
        return self._seller

    @seller.setter
    def seller(self, seller):
        """Sets the seller of this Item.


        :param seller: The seller of this Item.  # noqa: E501
        :type: SellerDetail
        """

        self._seller = seller

    @property
    def seller_custom_policies(self):
        """Gets the seller_custom_policies of this Item.  # noqa: E501

        A list of the custom policies that are applied to a listing.  # noqa: E501

        :return: The seller_custom_policies of this Item.  # noqa: E501
        :rtype: list[SellerCustomPolicy]
        """
        return self._seller_custom_policies

    @seller_custom_policies.setter
    def seller_custom_policies(self, seller_custom_policies):
        """Sets the seller_custom_policies of this Item.

        A list of the custom policies that are applied to a listing.  # noqa: E501

        :param seller_custom_policies: The seller_custom_policies of this Item.  # noqa: E501
        :type: list[SellerCustomPolicy]
        """

        self._seller_custom_policies = seller_custom_policies

    @property
    def seller_item_revision(self):
        """Gets the seller_item_revision of this Item.  # noqa: E501

        An identifier generated/incremented when a seller revises the item. There are two types of item revisions: <ul><li>Seller changes, such as changing the title</li>  <li>eBay system changes, such as changing the quantity when an item is purchased</li></ul> This ID is changed <em> only</em> when the seller makes a change to the item. This means you cannot use this value to determine if the quantity has changed.  # noqa: E501

        :return: The seller_item_revision of this Item.  # noqa: E501
        :rtype: str
        """
        return self._seller_item_revision

    @seller_item_revision.setter
    def seller_item_revision(self, seller_item_revision):
        """Sets the seller_item_revision of this Item.

        An identifier generated/incremented when a seller revises the item. There are two types of item revisions: <ul><li>Seller changes, such as changing the title</li>  <li>eBay system changes, such as changing the quantity when an item is purchased</li></ul> This ID is changed <em> only</em> when the seller makes a change to the item. This means you cannot use this value to determine if the quantity has changed.  # noqa: E501

        :param seller_item_revision: The seller_item_revision of this Item.  # noqa: E501
        :type: str
        """

        self._seller_item_revision = seller_item_revision

    @property
    def shipping_options(self):
        """Gets the shipping_options of this Item.  # noqa: E501

        An array of shipping options containers that have the details about cost, carrier, etc. of one shipping option.   # noqa: E501

        :return: The shipping_options of this Item.  # noqa: E501
        :rtype: list[ShippingOption]
        """
        return self._shipping_options

    @shipping_options.setter
    def shipping_options(self, shipping_options):
        """Sets the shipping_options of this Item.

        An array of shipping options containers that have the details about cost, carrier, etc. of one shipping option.   # noqa: E501

        :param shipping_options: The shipping_options of this Item.  # noqa: E501
        :type: list[ShippingOption]
        """

        self._shipping_options = shipping_options

    @property
    def ship_to_locations(self):
        """Gets the ship_to_locations of this Item.  # noqa: E501


        :return: The ship_to_locations of this Item.  # noqa: E501
        :rtype: ShipToLocations
        """
        return self._ship_to_locations

    @ship_to_locations.setter
    def ship_to_locations(self, ship_to_locations):
        """Sets the ship_to_locations of this Item.


        :param ship_to_locations: The ship_to_locations of this Item.  # noqa: E501
        :type: ShipToLocations
        """

        self._ship_to_locations = ship_to_locations

    @property
    def short_description(self):
        """Gets the short_description of this Item.  # noqa: E501

        This text string is derived from the item condition and the item aspects (such as size, color, capacity, model, brand, etc.).  # noqa: E501

        :return: The short_description of this Item.  # noqa: E501
        :rtype: str
        """
        return self._short_description

    @short_description.setter
    def short_description(self, short_description):
        """Sets the short_description of this Item.

        This text string is derived from the item condition and the item aspects (such as size, color, capacity, model, brand, etc.).  # noqa: E501

        :param short_description: The short_description of this Item.  # noqa: E501
        :type: str
        """

        self._short_description = short_description

    @property
    def size(self):
        """Gets the size of this Item.  # noqa: E501

        (Primary Item Aspect) The size of the item. For example, '7' for a size 7 shoe. All the item aspects, including this aspect, are returned in the <b> localizedAspects</b> container.  # noqa: E501

        :return: The size of this Item.  # noqa: E501
        :rtype: str
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this Item.

        (Primary Item Aspect) The size of the item. For example, '7' for a size 7 shoe. All the item aspects, including this aspect, are returned in the <b> localizedAspects</b> container.  # noqa: E501

        :param size: The size of this Item.  # noqa: E501
        :type: str
        """

        self._size = size

    @property
    def size_system(self):
        """Gets the size_system of this Item.  # noqa: E501

        (Primary Item Aspect) The sizing system of the country.  All the item aspects, including this aspect, are returned in the <b> localizedAspects</b> container. <br /><br /><b> Valid Values: </b> <br />AU (Australia),  <br />BR (Brazil), <br />CN (China),  <br />DE (Germany),  <br />EU (European Union),  <br /> FR (France), <br /> IT (Italy),  <br />JP (Japan), <br />MX (Mexico),  <br />US (USA), <br /> UK (United Kingdom) <br /><br />Code so that your app gracefully handles any future changes to this list.   # noqa: E501

        :return: The size_system of this Item.  # noqa: E501
        :rtype: str
        """
        return self._size_system

    @size_system.setter
    def size_system(self, size_system):
        """Sets the size_system of this Item.

        (Primary Item Aspect) The sizing system of the country.  All the item aspects, including this aspect, are returned in the <b> localizedAspects</b> container. <br /><br /><b> Valid Values: </b> <br />AU (Australia),  <br />BR (Brazil), <br />CN (China),  <br />DE (Germany),  <br />EU (European Union),  <br /> FR (France), <br /> IT (Italy),  <br />JP (Japan), <br />MX (Mexico),  <br />US (USA), <br /> UK (United Kingdom) <br /><br />Code so that your app gracefully handles any future changes to this list.   # noqa: E501

        :param size_system: The size_system of this Item.  # noqa: E501
        :type: str
        """

        self._size_system = size_system

    @property
    def size_type(self):
        """Gets the size_type of this Item.  # noqa: E501

        (Primary Item Aspect) Text describing a size group in which the item would be included, such as regular, petite, plus, big-and-tall or maternity. All the item aspects, including this aspect, are returned in the <b> localizedAspects</b> container.  # noqa: E501

        :return: The size_type of this Item.  # noqa: E501
        :rtype: str
        """
        return self._size_type

    @size_type.setter
    def size_type(self, size_type):
        """Sets the size_type of this Item.

        (Primary Item Aspect) Text describing a size group in which the item would be included, such as regular, petite, plus, big-and-tall or maternity. All the item aspects, including this aspect, are returned in the <b> localizedAspects</b> container.  # noqa: E501

        :param size_type: The size_type of this Item.  # noqa: E501
        :type: str
        """

        self._size_type = size_type

    @property
    def subtitle(self):
        """Gets the subtitle of this Item.  # noqa: E501

        A subtitle is optional and allows the seller to provide more information about the product, possibly including keywords that may assist with search results.  # noqa: E501

        :return: The subtitle of this Item.  # noqa: E501
        :rtype: str
        """
        return self._subtitle

    @subtitle.setter
    def subtitle(self, subtitle):
        """Sets the subtitle of this Item.

        A subtitle is optional and allows the seller to provide more information about the product, possibly including keywords that may assist with search results.  # noqa: E501

        :param subtitle: The subtitle of this Item.  # noqa: E501
        :type: str
        """

        self._subtitle = subtitle

    @property
    def taxes(self):
        """Gets the taxes of this Item.  # noqa: E501

        The container for the tax information for the item.  # noqa: E501

        :return: The taxes of this Item.  # noqa: E501
        :rtype: list[Taxes]
        """
        return self._taxes

    @taxes.setter
    def taxes(self, taxes):
        """Sets the taxes of this Item.

        The container for the tax information for the item.  # noqa: E501

        :param taxes: The taxes of this Item.  # noqa: E501
        :type: list[Taxes]
        """

        self._taxes = taxes

    @property
    def title(self):
        """Gets the title of this Item.  # noqa: E501

        The seller-created title of the item. <br><br><b> Maximum Length: </b> 80 characters  # noqa: E501

        :return: The title of this Item.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this Item.

        The seller-created title of the item. <br><br><b> Maximum Length: </b> 80 characters  # noqa: E501

        :param title: The title of this Item.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def top_rated_buying_experience(self):
        """Gets the top_rated_buying_experience of this Item.  # noqa: E501

        This indicates if the item a top-rated plus item. There are three benefits of a top-rated plus item: a  minimum 30-day money-back return policy, shipping the items in 1 business day with tracking provided, and the added comfort of knowing this item is from experienced sellers with the highest buyer ratings. See the <a href=\"https://pages.ebay.com/topratedplus/index.html\" target=\"_blank\">Top Rated Plus Items </a> and <a href=\"https://pages.ebay.com/help/sell/top-rated.html\" target=\"_blank\">Becoming a Top Rated Seller and qualifying for Top Rated Plus</a> help topics for more information.  # noqa: E501

        :return: The top_rated_buying_experience of this Item.  # noqa: E501
        :rtype: bool
        """
        return self._top_rated_buying_experience

    @top_rated_buying_experience.setter
    def top_rated_buying_experience(self, top_rated_buying_experience):
        """Sets the top_rated_buying_experience of this Item.

        This indicates if the item a top-rated plus item. There are three benefits of a top-rated plus item: a  minimum 30-day money-back return policy, shipping the items in 1 business day with tracking provided, and the added comfort of knowing this item is from experienced sellers with the highest buyer ratings. See the <a href=\"https://pages.ebay.com/topratedplus/index.html\" target=\"_blank\">Top Rated Plus Items </a> and <a href=\"https://pages.ebay.com/help/sell/top-rated.html\" target=\"_blank\">Becoming a Top Rated Seller and qualifying for Top Rated Plus</a> help topics for more information.  # noqa: E501

        :param top_rated_buying_experience: The top_rated_buying_experience of this Item.  # noqa: E501
        :type: bool
        """

        self._top_rated_buying_experience = top_rated_buying_experience

    @property
    def tyre_label_image_url(self):
        """Gets the tyre_label_image_url of this Item.  # noqa: E501

        The URL to the image that shows the information on the tyre label.  # noqa: E501

        :return: The tyre_label_image_url of this Item.  # noqa: E501
        :rtype: str
        """
        return self._tyre_label_image_url

    @tyre_label_image_url.setter
    def tyre_label_image_url(self, tyre_label_image_url):
        """Sets the tyre_label_image_url of this Item.

        The URL to the image that shows the information on the tyre label.  # noqa: E501

        :param tyre_label_image_url: The tyre_label_image_url of this Item.  # noqa: E501
        :type: str
        """

        self._tyre_label_image_url = tyre_label_image_url

    @property
    def unique_bidder_count(self):
        """Gets the unique_bidder_count of this Item.  # noqa: E501

        This integer value indicates the number of different eBay users who have placed one or more bids on an auction item. This field is only applicable to auction items.  # noqa: E501

        :return: The unique_bidder_count of this Item.  # noqa: E501
        :rtype: int
        """
        return self._unique_bidder_count

    @unique_bidder_count.setter
    def unique_bidder_count(self, unique_bidder_count):
        """Sets the unique_bidder_count of this Item.

        This integer value indicates the number of different eBay users who have placed one or more bids on an auction item. This field is only applicable to auction items.  # noqa: E501

        :param unique_bidder_count: The unique_bidder_count of this Item.  # noqa: E501
        :type: int
        """

        self._unique_bidder_count = unique_bidder_count

    @property
    def unit_price(self):
        """Gets the unit_price of this Item.  # noqa: E501


        :return: The unit_price of this Item.  # noqa: E501
        :rtype: ConvertedAmount
        """
        return self._unit_price

    @unit_price.setter
    def unit_price(self, unit_price):
        """Sets the unit_price of this Item.


        :param unit_price: The unit_price of this Item.  # noqa: E501
        :type: ConvertedAmount
        """

        self._unit_price = unit_price

    @property
    def unit_pricing_measure(self):
        """Gets the unit_pricing_measure of this Item.  # noqa: E501

        The designation, such as size, weight, volume, count, etc., that was used to specify the quantity of the item.  This helps buyers compare prices. <br /><br />For example, the following tells the buyer that the item is 7.99 per 100 grams. <br /><br /><code>\"unitPricingMeasure\": \"100g\",<br /> \"unitPrice\": {<br />&nbsp;&nbsp;\"value\": \"7.99\",<br />&nbsp;&nbsp;\"currency\": \"GBP\"</code>  # noqa: E501

        :return: The unit_pricing_measure of this Item.  # noqa: E501
        :rtype: str
        """
        return self._unit_pricing_measure

    @unit_pricing_measure.setter
    def unit_pricing_measure(self, unit_pricing_measure):
        """Sets the unit_pricing_measure of this Item.

        The designation, such as size, weight, volume, count, etc., that was used to specify the quantity of the item.  This helps buyers compare prices. <br /><br />For example, the following tells the buyer that the item is 7.99 per 100 grams. <br /><br /><code>\"unitPricingMeasure\": \"100g\",<br /> \"unitPrice\": {<br />&nbsp;&nbsp;\"value\": \"7.99\",<br />&nbsp;&nbsp;\"currency\": \"GBP\"</code>  # noqa: E501

        :param unit_pricing_measure: The unit_pricing_measure of this Item.  # noqa: E501
        :type: str
        """

        self._unit_pricing_measure = unit_pricing_measure

    @property
    def warnings(self):
        """Gets the warnings of this Item.  # noqa: E501

        An array of warning messages. These types of errors do not prevent the method from executing but should be checked.  # noqa: E501

        :return: The warnings of this Item.  # noqa: E501
        :rtype: list[Error]
        """
        return self._warnings

    @warnings.setter
    def warnings(self, warnings):
        """Sets the warnings of this Item.

        An array of warning messages. These types of errors do not prevent the method from executing but should be checked.  # noqa: E501

        :param warnings: The warnings of this Item.  # noqa: E501
        :type: list[Error]
        """

        self._warnings = warnings

    @property
    def watch_count(self):
        """Gets the watch_count of this Item.  # noqa: E501

        The number of users that have added the item to their watch list.<br /><br /><span class=\"tablenote\"> <strong>Note:</strong> This field is restricted to applications that have been granted permission to access this feature. You must submit an <a href=\"https://developer.ebay.com/my/support/tickets?tab=app-check \">App Check ticket</a> to request this access. In the App Check form, add a note to the <b>Application Title/Summary</b> and/or <b>Application Details</b> fields that you want access to Watch Count data in the Browse API.</span>  # noqa: E501

        :return: The watch_count of this Item.  # noqa: E501
        :rtype: int
        """
        return self._watch_count

    @watch_count.setter
    def watch_count(self, watch_count):
        """Sets the watch_count of this Item.

        The number of users that have added the item to their watch list.<br /><br /><span class=\"tablenote\"> <strong>Note:</strong> This field is restricted to applications that have been granted permission to access this feature. You must submit an <a href=\"https://developer.ebay.com/my/support/tickets?tab=app-check \">App Check ticket</a> to request this access. In the App Check form, add a note to the <b>Application Title/Summary</b> and/or <b>Application Details</b> fields that you want access to Watch Count data in the Browse API.</span>  # noqa: E501

        :param watch_count: The watch_count of this Item.  # noqa: E501
        :type: int
        """

        self._watch_count = watch_count

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Item, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Item):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
