# coding: utf-8

"""
    Browse API

    <p>The Browse API has the following resources:</p>   <ul> <li><b> item_summary: </b> Lets shoppers search for specific items by keyword, GTIN, category, charity, product, or item aspects and refine the results by using filters, such as aspects, compatibility, and fields values.</li>  <li><b> search_by_image: </b><a href=\"https://developer.ebay.com/api-docs/static/versioning.html#experimental \" target=\"_blank\"><img src=\"/cms/img/docs/experimental-icon.svg\" class=\"legend-icon experimental-icon\" alt=\"Experimental Release\" title=\"Experimental Release\" />&nbsp;(Experimental)</a> Lets shoppers search for specific items by image. You can refine the results by using URI parameters and filters.</li>   <li><b> item: </b> <ul><li>Lets you retrieve the details of a specific item or all the items in an item group, which is an item with variations such as color and size and check if a product is compatible with the specified item, such as if a specific car is compatible with a specific part.</li> <li>Provides a bridge between the eBay legacy APIs, such as <b> Finding</b>, and the RESTful APIs, which use different formats for the item IDs.</li>  </ul> </li>  <li> <b> shopping_cart: </b> <a href=\"https://developer.ebay.com/api-docs/static/versioning.html#experimental \" target=\"_blank\"><img src=\"/cms/img/docs/experimental-icon.svg\" class=\"legend-icon experimental-icon\" alt=\"Experimental Release\" title=\"Experimental Release\" />&nbsp;(Experimental)</a> <a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited \" target=\"_blank\"> <img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\" title=\"Limited Release\"  alt=\"Limited Release\" />(Limited Release)</a> Provides the ability for eBay members to see the contents of their eBay cart, and add, remove, and change the quantity of items in their eBay cart.&nbsp;&nbsp;<b> Note: </b> This resource is not available in the eBay API Explorer.</li></ul>       <p>The <b> item_summary</b>, <b> search_by_image</b>, and <b> item</b> resource calls require an <a href=\"/api-docs/static/oauth-client-credentials-grant.html\">Application access token</a>. The <b> shopping_cart</b> resource calls require a <a href=\"/api-docs/static/oauth-authorization-code-grant.html\">User access token</a>.</p>  # noqa: E501

    OpenAPI spec version: v1.13.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RemoteShopcartResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cart_items': 'list[CartItem]',
        'cart_subtotal': 'Amount',
        'cart_web_url': 'str',
        'unavailable_cart_items': 'list[CartItem]',
        'warnings': 'list[Error]'
    }

    attribute_map = {
        'cart_items': 'cartItems',
        'cart_subtotal': 'cartSubtotal',
        'cart_web_url': 'cartWebUrl',
        'unavailable_cart_items': 'unavailableCartItems',
        'warnings': 'warnings'
    }

    def __init__(self, cart_items=None, cart_subtotal=None, cart_web_url=None, unavailable_cart_items=None, warnings=None):  # noqa: E501
        """RemoteShopcartResponse - a model defined in Swagger"""  # noqa: E501
        self._cart_items = None
        self._cart_subtotal = None
        self._cart_web_url = None
        self._unavailable_cart_items = None
        self._warnings = None
        self.discriminator = None
        if cart_items is not None:
            self.cart_items = cart_items
        if cart_subtotal is not None:
            self.cart_subtotal = cart_subtotal
        if cart_web_url is not None:
            self.cart_web_url = cart_web_url
        if unavailable_cart_items is not None:
            self.unavailable_cart_items = unavailable_cart_items
        if warnings is not None:
            self.warnings = warnings

    @property
    def cart_items(self):
        """Gets the cart_items of this RemoteShopcartResponse.  # noqa: E501

        An array of the items in the member's eBay cart.  # noqa: E501

        :return: The cart_items of this RemoteShopcartResponse.  # noqa: E501
        :rtype: list[CartItem]
        """
        return self._cart_items

    @cart_items.setter
    def cart_items(self, cart_items):
        """Sets the cart_items of this RemoteShopcartResponse.

        An array of the items in the member's eBay cart.  # noqa: E501

        :param cart_items: The cart_items of this RemoteShopcartResponse.  # noqa: E501
        :type: list[CartItem]
        """

        self._cart_items = cart_items

    @property
    def cart_subtotal(self):
        """Gets the cart_subtotal of this RemoteShopcartResponse.  # noqa: E501


        :return: The cart_subtotal of this RemoteShopcartResponse.  # noqa: E501
        :rtype: Amount
        """
        return self._cart_subtotal

    @cart_subtotal.setter
    def cart_subtotal(self, cart_subtotal):
        """Sets the cart_subtotal of this RemoteShopcartResponse.


        :param cart_subtotal: The cart_subtotal of this RemoteShopcartResponse.  # noqa: E501
        :type: Amount
        """

        self._cart_subtotal = cart_subtotal

    @property
    def cart_web_url(self):
        """Gets the cart_web_url of this RemoteShopcartResponse.  # noqa: E501

        The URL of the member's eBay cart.  # noqa: E501

        :return: The cart_web_url of this RemoteShopcartResponse.  # noqa: E501
        :rtype: str
        """
        return self._cart_web_url

    @cart_web_url.setter
    def cart_web_url(self, cart_web_url):
        """Sets the cart_web_url of this RemoteShopcartResponse.

        The URL of the member's eBay cart.  # noqa: E501

        :param cart_web_url: The cart_web_url of this RemoteShopcartResponse.  # noqa: E501
        :type: str
        """

        self._cart_web_url = cart_web_url

    @property
    def unavailable_cart_items(self):
        """Gets the unavailable_cart_items of this RemoteShopcartResponse.  # noqa: E501

        An array of items in the cart that are unavailable. This can be for a variety of reasons such as, when the listing has ended or the item is out of stock. Because a cart never expires, these items will remain in the cart until they are removed.  # noqa: E501

        :return: The unavailable_cart_items of this RemoteShopcartResponse.  # noqa: E501
        :rtype: list[CartItem]
        """
        return self._unavailable_cart_items

    @unavailable_cart_items.setter
    def unavailable_cart_items(self, unavailable_cart_items):
        """Sets the unavailable_cart_items of this RemoteShopcartResponse.

        An array of items in the cart that are unavailable. This can be for a variety of reasons such as, when the listing has ended or the item is out of stock. Because a cart never expires, these items will remain in the cart until they are removed.  # noqa: E501

        :param unavailable_cart_items: The unavailable_cart_items of this RemoteShopcartResponse.  # noqa: E501
        :type: list[CartItem]
        """

        self._unavailable_cart_items = unavailable_cart_items

    @property
    def warnings(self):
        """Gets the warnings of this RemoteShopcartResponse.  # noqa: E501

        An array of warning messages. These type of errors do not prevent the call from executing but should be checked.  # noqa: E501

        :return: The warnings of this RemoteShopcartResponse.  # noqa: E501
        :rtype: list[Error]
        """
        return self._warnings

    @warnings.setter
    def warnings(self, warnings):
        """Sets the warnings of this RemoteShopcartResponse.

        An array of warning messages. These type of errors do not prevent the call from executing but should be checked.  # noqa: E501

        :param warnings: The warnings of this RemoteShopcartResponse.  # noqa: E501
        :type: list[Error]
        """

        self._warnings = warnings

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RemoteShopcartResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RemoteShopcartResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
