# coding: utf-8

"""
    Browse API

    <p>The Browse API has the following resources:</p>   <ul> <li><b> item_summary: </b> Lets shoppers search for specific items by keyword, GTIN, category, charity, product, or item aspects and refine the results by using filters, such as aspects, compatibility, and fields values.</li>  <li><b> search_by_image: </b><a href=\"https://developer.ebay.com/api-docs/static/versioning.html#experimental \" target=\"_blank\"><img src=\"/cms/img/docs/experimental-icon.svg\" class=\"legend-icon experimental-icon\" alt=\"Experimental Release\" title=\"Experimental Release\" />&nbsp;(Experimental)</a> Lets shoppers search for specific items by image. You can refine the results by using URI parameters and filters.</li>   <li><b> item: </b> <ul><li>Lets you retrieve the details of a specific item or all the items in an item group, which is an item with variations such as color and size and check if a product is compatible with the specified item, such as if a specific car is compatible with a specific part.</li> <li>Provides a bridge between the eBay legacy APIs, such as <b> Finding</b>, and the RESTful APIs, which use different formats for the item IDs.</li>  </ul> </li>  <li> <b> shopping_cart: </b> <a href=\"https://developer.ebay.com/api-docs/static/versioning.html#experimental \" target=\"_blank\"><img src=\"/cms/img/docs/experimental-icon.svg\" class=\"legend-icon experimental-icon\" alt=\"Experimental Release\" title=\"Experimental Release\" />&nbsp;(Experimental)</a> <a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited \" target=\"_blank\"> <img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\" title=\"Limited Release\"  alt=\"Limited Release\" />(Limited Release)</a> Provides the ability for eBay members to see the contents of their eBay cart, and add, remove, and change the quantity of items in their eBay cart.&nbsp;&nbsp;<b> Note: </b> This resource is not available in the eBay API Explorer.</li></ul>       <p>The <b> item_summary</b>, <b> search_by_image</b>, and <b> item</b> resource calls require an <a href=\"/api-docs/static/oauth-client-credentials-grant.html\">Application access token</a>. The <b> shopping_cart</b> resource calls require a <a href=\"/api-docs/static/oauth-authorization-code-grant.html\">User access token</a>.</p>  # noqa: E501

    OpenAPI spec version: v1.13.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class SellerDetail(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'feedback_percentage': 'str',
        'feedback_score': 'int',
        'seller_account_type': 'str',
        'seller_legal_info': 'SellerLegalInfo',
        'username': 'str'
    }

    attribute_map = {
        'feedback_percentage': 'feedbackPercentage',
        'feedback_score': 'feedbackScore',
        'seller_account_type': 'sellerAccountType',
        'seller_legal_info': 'sellerLegalInfo',
        'username': 'username'
    }

    def __init__(self, feedback_percentage=None, feedback_score=None, seller_account_type=None, seller_legal_info=None, username=None):  # noqa: E501
        """SellerDetail - a model defined in Swagger"""  # noqa: E501
        self._feedback_percentage = None
        self._feedback_score = None
        self._seller_account_type = None
        self._seller_legal_info = None
        self._username = None
        self.discriminator = None
        if feedback_percentage is not None:
            self.feedback_percentage = feedback_percentage
        if feedback_score is not None:
            self.feedback_score = feedback_score
        if seller_account_type is not None:
            self.seller_account_type = seller_account_type
        if seller_legal_info is not None:
            self.seller_legal_info = seller_legal_info
        if username is not None:
            self.username = username

    @property
    def feedback_percentage(self):
        """Gets the feedback_percentage of this SellerDetail.  # noqa: E501

        The percentage of the total positive feedback.  # noqa: E501

        :return: The feedback_percentage of this SellerDetail.  # noqa: E501
        :rtype: str
        """
        return self._feedback_percentage

    @feedback_percentage.setter
    def feedback_percentage(self, feedback_percentage):
        """Sets the feedback_percentage of this SellerDetail.

        The percentage of the total positive feedback.  # noqa: E501

        :param feedback_percentage: The feedback_percentage of this SellerDetail.  # noqa: E501
        :type: str
        """

        self._feedback_percentage = feedback_percentage

    @property
    def feedback_score(self):
        """Gets the feedback_score of this SellerDetail.  # noqa: E501

        The feedback score of the seller. This value is based on the ratings from eBay members that bought items from this seller.  # noqa: E501

        :return: The feedback_score of this SellerDetail.  # noqa: E501
        :rtype: int
        """
        return self._feedback_score

    @feedback_score.setter
    def feedback_score(self, feedback_score):
        """Sets the feedback_score of this SellerDetail.

        The feedback score of the seller. This value is based on the ratings from eBay members that bought items from this seller.  # noqa: E501

        :param feedback_score: The feedback_score of this SellerDetail.  # noqa: E501
        :type: int
        """

        self._feedback_score = feedback_score

    @property
    def seller_account_type(self):
        """Gets the seller_account_type of this SellerDetail.  # noqa: E501

        This indicates if the seller is a business or an individual. This is determined when the seller registers with eBay. If they register for a business account, this value will be BUSINESS. If they register for a private account, this value will be INDIVIDUAL. This designation is required by the tax laws in the following countries:  <br /><br /> This field is returned only on the following sites. <br /><br />EBAY_AT, EBAY_BE, EBAY_CH, EBAY_DE, EBAY_ES, EBAY_FR, EBAY_GB, EBAY_IE, EBAY_IT, EBAY_PL <br /><br /><b> Valid Values:</b> BUSINESS or INDIVIDUAL <br /><br />Code so that your app gracefully handles any future changes to this list.   # noqa: E501

        :return: The seller_account_type of this SellerDetail.  # noqa: E501
        :rtype: str
        """
        return self._seller_account_type

    @seller_account_type.setter
    def seller_account_type(self, seller_account_type):
        """Sets the seller_account_type of this SellerDetail.

        This indicates if the seller is a business or an individual. This is determined when the seller registers with eBay. If they register for a business account, this value will be BUSINESS. If they register for a private account, this value will be INDIVIDUAL. This designation is required by the tax laws in the following countries:  <br /><br /> This field is returned only on the following sites. <br /><br />EBAY_AT, EBAY_BE, EBAY_CH, EBAY_DE, EBAY_ES, EBAY_FR, EBAY_GB, EBAY_IE, EBAY_IT, EBAY_PL <br /><br /><b> Valid Values:</b> BUSINESS or INDIVIDUAL <br /><br />Code so that your app gracefully handles any future changes to this list.   # noqa: E501

        :param seller_account_type: The seller_account_type of this SellerDetail.  # noqa: E501
        :type: str
        """

        self._seller_account_type = seller_account_type

    @property
    def seller_legal_info(self):
        """Gets the seller_legal_info of this SellerDetail.  # noqa: E501


        :return: The seller_legal_info of this SellerDetail.  # noqa: E501
        :rtype: SellerLegalInfo
        """
        return self._seller_legal_info

    @seller_legal_info.setter
    def seller_legal_info(self, seller_legal_info):
        """Sets the seller_legal_info of this SellerDetail.


        :param seller_legal_info: The seller_legal_info of this SellerDetail.  # noqa: E501
        :type: SellerLegalInfo
        """

        self._seller_legal_info = seller_legal_info

    @property
    def username(self):
        """Gets the username of this SellerDetail.  # noqa: E501

        The user name created by the seller for use on eBay.  # noqa: E501

        :return: The username of this SellerDetail.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this SellerDetail.

        The user name created by the seller for use on eBay.  # noqa: E501

        :param username: The username of this SellerDetail.  # noqa: E501
        :type: str
        """

        self._username = username

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SellerDetail, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SellerDetail):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
