# coding: utf-8

"""
    Item Feed Service

    <span class=\"tablenote\"><b>Note:</b> This is a <a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited \" target=\"_blank\"> <img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\" title=\"Limited Release\"  alt=\"Limited Release\" />(Limited Release)</a> API available only to select developers approved by business units.</span><br /><br />The Feed API provides the ability to download TSV_GZIP feed files containing eBay items and an hourly snapshot file of the items that have changed within an hour for a specific category, date and marketplace. <p>In addition to the API, there is an open source <a href=\"https://github.com/eBay/FeedSDK \" target=\"_blank\">Feed SDK</a> written in Java that downloads, combines files into a single file when needed, and unzips the entire feed file. It also lets you specify field filters to curate the items in the file.</p>  # noqa: E501

    OpenAPI spec version: v1_beta.31.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ItemSnapshot(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'item_id': 'str',
        'availability': 'str',
        'title': 'str',
        'image_url': 'str',
        'category': 'str',
        'category_id': 'str',
        'buying_options': 'str',
        'seller_username': 'str',
        'seller_feedback_percentage': 'str',
        'seller_feedback_score': 'str',
        'gtin': 'str',
        'brand': 'str',
        'mpn': 'str',
        'epid': 'str',
        'condition_id': 'str',
        'condition': 'str',
        'price_value': 'str',
        'price_currency': 'str',
        'primary_item_group_id': 'str',
        'primary_item_group_type': 'str',
        'item_end_date': 'str',
        'seller_item_revision': 'str',
        'item_location_country': 'str',
        'localized_aspects': 'str',
        'seller_trust_level': 'str',
        'image_altering_prohibited': 'bool',
        'estimated_available_quantity': 'int',
        'availability_threshold_type': 'str',
        'availability_threshold': 'int',
        'item_snapshot_date': 'str',
        'original_price_value': 'str',
        'original_price_currency': 'str',
        'discount_amount': 'str',
        'discount_percentage': 'str',
        'returns_accepted': 'bool',
        'return_period_value': 'int',
        'return_period_unit': 'str',
        'refund_method': 'str',
        'return_method': 'str',
        'return_shipping_cost_payer': 'str',
        'energy_efficiency_class': 'str',
        'additional_image_urls': 'str',
        'delivery_options': 'str',
        'ship_to_included_regions': 'str',
        'ship_to_excluded_regions': 'str',
        'accepted_payment_methods': 'str',
        'qualified_programs': 'str',
        'lot_size': 'int',
        'shipping_carrier_code': 'str',
        'shipping_service_code': 'str',
        'shipping_type': 'str',
        'shipping_cost': 'str',
        'shipping_cost_type': 'str',
        'additional_shipping_cost_per_unit': 'str',
        'quantity_used_for_estimate': 'int',
        'unit_price': 'str',
        'unit_pricing_measure': 'str',
        'inferred_epid': 'str',
        'item_creation_date': 'str',
        'legacy_item_id': 'str',
        'alerts': 'str',
        'seller_account_type': 'str',
        'tyre_label_image_url': 'str',
        'age_group': 'str',
        'color': 'str',
        'pattern': 'str',
        'size': 'str',
        'gender': 'str',
        'material': 'str',
        'total_units': 'str',
        'default_image_url': 'str',
        'item_web_url': 'str',
        'item_affiliate_web_url': 'str',
        'description': 'str',
        'change_metadata': 'str',
        'eco_participation_fee_value': 'str',
        'eco_participation_fee_currency': 'str',
        'take_back_policy_label': 'str',
        'take_back_policy_description': 'str',
        'authenticity_guarantee_service_id': 'str',
        'authenticity_guarantee_selection': 'str',
        'authenticity_guarantee_fee_value': 'str',
        'authenticity_guarantee_fee_currency': 'str'
    }

    attribute_map = {
        'item_id': 'itemId',
        'availability': 'availability',
        'title': 'title',
        'image_url': 'imageUrl',
        'category': 'category',
        'category_id': 'categoryId',
        'buying_options': 'buyingOptions',
        'seller_username': 'sellerUsername',
        'seller_feedback_percentage': 'sellerFeedbackPercentage',
        'seller_feedback_score': 'sellerFeedbackScore',
        'gtin': 'gtin',
        'brand': 'brand',
        'mpn': 'mpn',
        'epid': 'epid',
        'condition_id': 'conditionId',
        'condition': 'condition',
        'price_value': 'priceValue',
        'price_currency': 'priceCurrency',
        'primary_item_group_id': 'primaryItemGroupId',
        'primary_item_group_type': 'primaryItemGroupType',
        'item_end_date': 'itemEndDate',
        'seller_item_revision': 'sellerItemRevision',
        'item_location_country': 'itemLocationCountry',
        'localized_aspects': 'localizedAspects',
        'seller_trust_level': 'sellerTrustLevel',
        'image_altering_prohibited': 'imageAlteringProhibited',
        'estimated_available_quantity': 'estimatedAvailableQuantity',
        'availability_threshold_type': 'availabilityThresholdType',
        'availability_threshold': 'availabilityThreshold',
        'item_snapshot_date': 'itemSnapshotDate',
        'original_price_value': 'originalPriceValue',
        'original_price_currency': 'originalPriceCurrency',
        'discount_amount': 'discountAmount',
        'discount_percentage': 'discountPercentage',
        'returns_accepted': 'returnsAccepted',
        'return_period_value': 'returnPeriodValue',
        'return_period_unit': 'returnPeriodUnit',
        'refund_method': 'refundMethod',
        'return_method': 'returnMethod',
        'return_shipping_cost_payer': 'returnShippingCostPayer',
        'energy_efficiency_class': 'energyEfficiencyClass',
        'additional_image_urls': 'additionalImageUrls',
        'delivery_options': 'deliveryOptions',
        'ship_to_included_regions': 'shipToIncludedRegions',
        'ship_to_excluded_regions': 'shipToExcludedRegions',
        'accepted_payment_methods': 'acceptedPaymentMethods',
        'qualified_programs': 'qualifiedPrograms',
        'lot_size': 'lotSize',
        'shipping_carrier_code': 'shippingCarrierCode',
        'shipping_service_code': 'shippingServiceCode',
        'shipping_type': 'shippingType',
        'shipping_cost': 'shippingCost',
        'shipping_cost_type': 'shippingCostType',
        'additional_shipping_cost_per_unit': 'additionalShippingCostPerUnit',
        'quantity_used_for_estimate': 'quantityUsedForEstimate',
        'unit_price': 'unitPrice',
        'unit_pricing_measure': 'unitPricingMeasure',
        'inferred_epid': 'inferredEpid',
        'item_creation_date': 'itemCreationDate',
        'legacy_item_id': 'legacyItemId',
        'alerts': 'alerts',
        'seller_account_type': 'sellerAccountType',
        'tyre_label_image_url': 'tyreLabelImageUrl',
        'age_group': 'ageGroup',
        'color': 'color',
        'pattern': 'pattern',
        'size': 'size',
        'gender': 'gender',
        'material': 'material',
        'total_units': 'totalUnits',
        'default_image_url': 'defaultImageUrl',
        'item_web_url': 'itemWebUrl',
        'item_affiliate_web_url': 'itemAffiliateWebUrl',
        'description': 'description',
        'change_metadata': 'changeMetadata',
        'eco_participation_fee_value': 'ecoParticipationFeeValue',
        'eco_participation_fee_currency': 'ecoParticipationFeeCurrency',
        'take_back_policy_label': 'takeBackPolicyLabel',
        'take_back_policy_description': 'takeBackPolicyDescription',
        'authenticity_guarantee_service_id': 'authenticityGuaranteeServiceId',
        'authenticity_guarantee_selection': 'authenticityGuaranteeSelection',
        'authenticity_guarantee_fee_value': 'authenticityGuaranteeFeeValue',
        'authenticity_guarantee_fee_currency': 'authenticityGuaranteeFeeCurrency'
    }

    def __init__(self, item_id=None, availability=None, title=None, image_url=None, category=None, category_id=None, buying_options=None, seller_username=None, seller_feedback_percentage=None, seller_feedback_score=None, gtin=None, brand=None, mpn=None, epid=None, condition_id=None, condition=None, price_value=None, price_currency=None, primary_item_group_id=None, primary_item_group_type=None, item_end_date=None, seller_item_revision=None, item_location_country=None, localized_aspects=None, seller_trust_level=None, image_altering_prohibited=None, estimated_available_quantity=None, availability_threshold_type=None, availability_threshold=None, item_snapshot_date=None, original_price_value=None, original_price_currency=None, discount_amount=None, discount_percentage=None, returns_accepted=None, return_period_value=None, return_period_unit=None, refund_method=None, return_method=None, return_shipping_cost_payer=None, energy_efficiency_class=None, additional_image_urls=None, delivery_options=None, ship_to_included_regions=None, ship_to_excluded_regions=None, accepted_payment_methods=None, qualified_programs=None, lot_size=None, shipping_carrier_code=None, shipping_service_code=None, shipping_type=None, shipping_cost=None, shipping_cost_type=None, additional_shipping_cost_per_unit=None, quantity_used_for_estimate=None, unit_price=None, unit_pricing_measure=None, inferred_epid=None, item_creation_date=None, legacy_item_id=None, alerts=None, seller_account_type=None, tyre_label_image_url=None, age_group=None, color=None, pattern=None, size=None, gender=None, material=None, total_units=None, default_image_url=None, item_web_url=None, item_affiliate_web_url=None, description=None, change_metadata=None, eco_participation_fee_value=None, eco_participation_fee_currency=None, take_back_policy_label=None, take_back_policy_description=None, authenticity_guarantee_service_id=None, authenticity_guarantee_selection=None, authenticity_guarantee_fee_value=None, authenticity_guarantee_fee_currency=None):  # noqa: E501
        """ItemSnapshot - a model defined in Swagger"""  # noqa: E501
        self._item_id = None
        self._availability = None
        self._title = None
        self._image_url = None
        self._category = None
        self._category_id = None
        self._buying_options = None
        self._seller_username = None
        self._seller_feedback_percentage = None
        self._seller_feedback_score = None
        self._gtin = None
        self._brand = None
        self._mpn = None
        self._epid = None
        self._condition_id = None
        self._condition = None
        self._price_value = None
        self._price_currency = None
        self._primary_item_group_id = None
        self._primary_item_group_type = None
        self._item_end_date = None
        self._seller_item_revision = None
        self._item_location_country = None
        self._localized_aspects = None
        self._seller_trust_level = None
        self._image_altering_prohibited = None
        self._estimated_available_quantity = None
        self._availability_threshold_type = None
        self._availability_threshold = None
        self._item_snapshot_date = None
        self._original_price_value = None
        self._original_price_currency = None
        self._discount_amount = None
        self._discount_percentage = None
        self._returns_accepted = None
        self._return_period_value = None
        self._return_period_unit = None
        self._refund_method = None
        self._return_method = None
        self._return_shipping_cost_payer = None
        self._energy_efficiency_class = None
        self._additional_image_urls = None
        self._delivery_options = None
        self._ship_to_included_regions = None
        self._ship_to_excluded_regions = None
        self._accepted_payment_methods = None
        self._qualified_programs = None
        self._lot_size = None
        self._shipping_carrier_code = None
        self._shipping_service_code = None
        self._shipping_type = None
        self._shipping_cost = None
        self._shipping_cost_type = None
        self._additional_shipping_cost_per_unit = None
        self._quantity_used_for_estimate = None
        self._unit_price = None
        self._unit_pricing_measure = None
        self._inferred_epid = None
        self._item_creation_date = None
        self._legacy_item_id = None
        self._alerts = None
        self._seller_account_type = None
        self._tyre_label_image_url = None
        self._age_group = None
        self._color = None
        self._pattern = None
        self._size = None
        self._gender = None
        self._material = None
        self._total_units = None
        self._default_image_url = None
        self._item_web_url = None
        self._item_affiliate_web_url = None
        self._description = None
        self._change_metadata = None
        self._eco_participation_fee_value = None
        self._eco_participation_fee_currency = None
        self._take_back_policy_label = None
        self._take_back_policy_description = None
        self._authenticity_guarantee_service_id = None
        self._authenticity_guarantee_selection = None
        self._authenticity_guarantee_fee_value = None
        self._authenticity_guarantee_fee_currency = None
        self.discriminator = None
        if item_id is not None:
            self.item_id = item_id
        if availability is not None:
            self.availability = availability
        if title is not None:
            self.title = title
        if image_url is not None:
            self.image_url = image_url
        if category is not None:
            self.category = category
        if category_id is not None:
            self.category_id = category_id
        if buying_options is not None:
            self.buying_options = buying_options
        if seller_username is not None:
            self.seller_username = seller_username
        if seller_feedback_percentage is not None:
            self.seller_feedback_percentage = seller_feedback_percentage
        if seller_feedback_score is not None:
            self.seller_feedback_score = seller_feedback_score
        if gtin is not None:
            self.gtin = gtin
        if brand is not None:
            self.brand = brand
        if mpn is not None:
            self.mpn = mpn
        if epid is not None:
            self.epid = epid
        if condition_id is not None:
            self.condition_id = condition_id
        if condition is not None:
            self.condition = condition
        if price_value is not None:
            self.price_value = price_value
        if price_currency is not None:
            self.price_currency = price_currency
        if primary_item_group_id is not None:
            self.primary_item_group_id = primary_item_group_id
        if primary_item_group_type is not None:
            self.primary_item_group_type = primary_item_group_type
        if item_end_date is not None:
            self.item_end_date = item_end_date
        if seller_item_revision is not None:
            self.seller_item_revision = seller_item_revision
        if item_location_country is not None:
            self.item_location_country = item_location_country
        if localized_aspects is not None:
            self.localized_aspects = localized_aspects
        if seller_trust_level is not None:
            self.seller_trust_level = seller_trust_level
        if image_altering_prohibited is not None:
            self.image_altering_prohibited = image_altering_prohibited
        if estimated_available_quantity is not None:
            self.estimated_available_quantity = estimated_available_quantity
        if availability_threshold_type is not None:
            self.availability_threshold_type = availability_threshold_type
        if availability_threshold is not None:
            self.availability_threshold = availability_threshold
        if item_snapshot_date is not None:
            self.item_snapshot_date = item_snapshot_date
        if original_price_value is not None:
            self.original_price_value = original_price_value
        if original_price_currency is not None:
            self.original_price_currency = original_price_currency
        if discount_amount is not None:
            self.discount_amount = discount_amount
        if discount_percentage is not None:
            self.discount_percentage = discount_percentage
        if returns_accepted is not None:
            self.returns_accepted = returns_accepted
        if return_period_value is not None:
            self.return_period_value = return_period_value
        if return_period_unit is not None:
            self.return_period_unit = return_period_unit
        if refund_method is not None:
            self.refund_method = refund_method
        if return_method is not None:
            self.return_method = return_method
        if return_shipping_cost_payer is not None:
            self.return_shipping_cost_payer = return_shipping_cost_payer
        if energy_efficiency_class is not None:
            self.energy_efficiency_class = energy_efficiency_class
        if additional_image_urls is not None:
            self.additional_image_urls = additional_image_urls
        if delivery_options is not None:
            self.delivery_options = delivery_options
        if ship_to_included_regions is not None:
            self.ship_to_included_regions = ship_to_included_regions
        if ship_to_excluded_regions is not None:
            self.ship_to_excluded_regions = ship_to_excluded_regions
        if accepted_payment_methods is not None:
            self.accepted_payment_methods = accepted_payment_methods
        if qualified_programs is not None:
            self.qualified_programs = qualified_programs
        if lot_size is not None:
            self.lot_size = lot_size
        if shipping_carrier_code is not None:
            self.shipping_carrier_code = shipping_carrier_code
        if shipping_service_code is not None:
            self.shipping_service_code = shipping_service_code
        if shipping_type is not None:
            self.shipping_type = shipping_type
        if shipping_cost is not None:
            self.shipping_cost = shipping_cost
        if shipping_cost_type is not None:
            self.shipping_cost_type = shipping_cost_type
        if additional_shipping_cost_per_unit is not None:
            self.additional_shipping_cost_per_unit = additional_shipping_cost_per_unit
        if quantity_used_for_estimate is not None:
            self.quantity_used_for_estimate = quantity_used_for_estimate
        if unit_price is not None:
            self.unit_price = unit_price
        if unit_pricing_measure is not None:
            self.unit_pricing_measure = unit_pricing_measure
        if inferred_epid is not None:
            self.inferred_epid = inferred_epid
        if item_creation_date is not None:
            self.item_creation_date = item_creation_date
        if legacy_item_id is not None:
            self.legacy_item_id = legacy_item_id
        if alerts is not None:
            self.alerts = alerts
        if seller_account_type is not None:
            self.seller_account_type = seller_account_type
        if tyre_label_image_url is not None:
            self.tyre_label_image_url = tyre_label_image_url
        if age_group is not None:
            self.age_group = age_group
        if color is not None:
            self.color = color
        if pattern is not None:
            self.pattern = pattern
        if size is not None:
            self.size = size
        if gender is not None:
            self.gender = gender
        if material is not None:
            self.material = material
        if total_units is not None:
            self.total_units = total_units
        if default_image_url is not None:
            self.default_image_url = default_image_url
        if item_web_url is not None:
            self.item_web_url = item_web_url
        if item_affiliate_web_url is not None:
            self.item_affiliate_web_url = item_affiliate_web_url
        if description is not None:
            self.description = description
        if change_metadata is not None:
            self.change_metadata = change_metadata
        if eco_participation_fee_value is not None:
            self.eco_participation_fee_value = eco_participation_fee_value
        if eco_participation_fee_currency is not None:
            self.eco_participation_fee_currency = eco_participation_fee_currency
        if take_back_policy_label is not None:
            self.take_back_policy_label = take_back_policy_label
        if take_back_policy_description is not None:
            self.take_back_policy_description = take_back_policy_description
        if authenticity_guarantee_service_id is not None:
            self.authenticity_guarantee_service_id = authenticity_guarantee_service_id
        if authenticity_guarantee_selection is not None:
            self.authenticity_guarantee_selection = authenticity_guarantee_selection
        if authenticity_guarantee_fee_value is not None:
            self.authenticity_guarantee_fee_value = authenticity_guarantee_fee_value
        if authenticity_guarantee_fee_currency is not None:
            self.authenticity_guarantee_fee_currency = authenticity_guarantee_fee_currency

    @property
    def item_id(self):
        """Gets the item_id of this ItemSnapshot.  # noqa: E501

        The unique identifier of an item in eBay RESTful format. An example would be <code>v1|1**********2|4**********2</code>.  # noqa: E501

        :return: The item_id of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._item_id

    @item_id.setter
    def item_id(self, item_id):
        """Sets the item_id of this ItemSnapshot.

        The unique identifier of an item in eBay RESTful format. An example would be <code>v1|1**********2|4**********2</code>.  # noqa: E501

        :param item_id: The item_id of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._item_id = item_id

    @property
    def availability(self):
        """Gets the availability of this ItemSnapshot.  # noqa: E501

        An enumeration value representing the item's availability (possibility of being purchased). <br /><br /><b>Values: </b>    <ul>  <li>AVAILABLE</li>    <li>TEMPORARILY_UNAVAILABLE</li>     <li>UNAVAILABLE</li> </ul>  Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:AvailabilityEnum'>eBay API documentation</a>  # noqa: E501

        :return: The availability of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._availability

    @availability.setter
    def availability(self, availability):
        """Sets the availability of this ItemSnapshot.

        An enumeration value representing the item's availability (possibility of being purchased). <br /><br /><b>Values: </b>    <ul>  <li>AVAILABLE</li>    <li>TEMPORARILY_UNAVAILABLE</li>     <li>UNAVAILABLE</li> </ul>  Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:AvailabilityEnum'>eBay API documentation</a>  # noqa: E501

        :param availability: The availability of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._availability = availability

    @property
    def title(self):
        """Gets the title of this ItemSnapshot.  # noqa: E501

        The seller created title of the item. This text is an escaped string when special characters are present, using the following rules:</p>   <ul>       <li>Double quotes (&#34;) and backslashes (&#92;) in the Title are escaped with a backslash (&#92;) character</li>      <li>If there are any tabs (&#92;t), double quotes (&#34;), or backslashes (&#92;) in the Title, the entire Title will be wrapped in double quotes.</li>   </ul>   <p><b>For example</b></p>   <p>Before:</p>   <p><code>Misty Rainforest Modern Masters 2017 MTG Magic Fetch Land Free Ship W<b>&#92;</b>Tracking</code>   </p>   <p><code>Marvel Legends HULK 8<b>&#34;</b> Figure Avengers Age of Ultron Studios 6<b>&#34;</b> Series</code>   </p>   <p>After:</p>   <p><code>&#34;Misty Rainforest Modern Masters 2017 MTG Magic Fetch Land Free Ship W<b>&#92;&#92;</b> Tracking&#34;</code>   </p>   <p><code>&#34;Marvel Legends HULK 8<b>&#92;&#34;</b> Figure Avengers Age of Ultron Studios 6<b>&#92;&#34;</b> Series<b>&#34;</b> </code>   </p>  # noqa: E501

        :return: The title of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this ItemSnapshot.

        The seller created title of the item. This text is an escaped string when special characters are present, using the following rules:</p>   <ul>       <li>Double quotes (&#34;) and backslashes (&#92;) in the Title are escaped with a backslash (&#92;) character</li>      <li>If there are any tabs (&#92;t), double quotes (&#34;), or backslashes (&#92;) in the Title, the entire Title will be wrapped in double quotes.</li>   </ul>   <p><b>For example</b></p>   <p>Before:</p>   <p><code>Misty Rainforest Modern Masters 2017 MTG Magic Fetch Land Free Ship W<b>&#92;</b>Tracking</code>   </p>   <p><code>Marvel Legends HULK 8<b>&#34;</b> Figure Avengers Age of Ultron Studios 6<b>&#34;</b> Series</code>   </p>   <p>After:</p>   <p><code>&#34;Misty Rainforest Modern Masters 2017 MTG Magic Fetch Land Free Ship W<b>&#92;&#92;</b> Tracking&#34;</code>   </p>   <p><code>&#34;Marvel Legends HULK 8<b>&#92;&#34;</b> Figure Avengers Age of Ultron Studios 6<b>&#92;&#34;</b> Series<b>&#34;</b> </code>   </p>  # noqa: E501

        :param title: The title of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def image_url(self):
        """Gets the image_url of this ItemSnapshot.  # noqa: E501

        The URL to the primary image of the item.  This is the URL of the largest image available based on what the seller submitted.   # noqa: E501

        :return: The image_url of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._image_url

    @image_url.setter
    def image_url(self, image_url):
        """Sets the image_url of this ItemSnapshot.

        The URL to the primary image of the item.  This is the URL of the largest image available based on what the seller submitted.   # noqa: E501

        :param image_url: The image_url of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._image_url = image_url

    @property
    def category(self):
        """Gets the category of this ItemSnapshot.  # noqa: E501

        The label of the category of the item. For example: <b> Toys & Hobbies|Action Figures|Comic Book Heroes </b>.   # noqa: E501

        :return: The category of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this ItemSnapshot.

        The label of the category of the item. For example: <b> Toys & Hobbies|Action Figures|Comic Book Heroes </b>.   # noqa: E501

        :param category: The category of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._category = category

    @property
    def category_id(self):
        """Gets the category_id of this ItemSnapshot.  # noqa: E501

        The ID of the category of the item. For example: The ID for Toys & Hobbies|Action Figures|Comic Book Heroes is <code>158671</code>.  # noqa: E501

        :return: The category_id of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._category_id

    @category_id.setter
    def category_id(self, category_id):
        """Sets the category_id of this ItemSnapshot.

        The ID of the category of the item. For example: The ID for Toys & Hobbies|Action Figures|Comic Book Heroes is <code>158671</code>.  # noqa: E501

        :param category_id: The category_id of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._category_id = category_id

    @property
    def buying_options(self):
        """Gets the buying_options of this ItemSnapshot.  # noqa: E501

        A comma separated list of the purchase options available for the item. Currently the only supported option is <code>FIXED_PRICE</code>.  # noqa: E501

        :return: The buying_options of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._buying_options

    @buying_options.setter
    def buying_options(self, buying_options):
        """Sets the buying_options of this ItemSnapshot.

        A comma separated list of the purchase options available for the item. Currently the only supported option is <code>FIXED_PRICE</code>.  # noqa: E501

        :param buying_options: The buying_options of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._buying_options = buying_options

    @property
    def seller_username(self):
        """Gets the seller_username of this ItemSnapshot.  # noqa: E501

        The seller's eBay user name.  # noqa: E501

        :return: The seller_username of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._seller_username

    @seller_username.setter
    def seller_username(self, seller_username):
        """Sets the seller_username of this ItemSnapshot.

        The seller's eBay user name.  # noqa: E501

        :param seller_username: The seller_username of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._seller_username = seller_username

    @property
    def seller_feedback_percentage(self):
        """Gets the seller_feedback_percentage of this ItemSnapshot.  # noqa: E501

        The percentage of the seller's total positive feedback.  # noqa: E501

        :return: The seller_feedback_percentage of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._seller_feedback_percentage

    @seller_feedback_percentage.setter
    def seller_feedback_percentage(self, seller_feedback_percentage):
        """Sets the seller_feedback_percentage of this ItemSnapshot.

        The percentage of the seller's total positive feedback.  # noqa: E501

        :param seller_feedback_percentage: The seller_feedback_percentage of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._seller_feedback_percentage = seller_feedback_percentage

    @property
    def seller_feedback_score(self):
        """Gets the seller_feedback_score of this ItemSnapshot.  # noqa: E501

        The feedback score of the seller. This value is based on the ratings from eBay members that bought items from this seller.  # noqa: E501

        :return: The seller_feedback_score of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._seller_feedback_score

    @seller_feedback_score.setter
    def seller_feedback_score(self, seller_feedback_score):
        """Sets the seller_feedback_score of this ItemSnapshot.

        The feedback score of the seller. This value is based on the ratings from eBay members that bought items from this seller.  # noqa: E501

        :param seller_feedback_score: The seller_feedback_score of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._seller_feedback_score = seller_feedback_score

    @property
    def gtin(self):
        """Gets the gtin of this ItemSnapshot.  # noqa: E501

        The unique Global Trade Item Number of the item as defined by <a href=\"https://www.gtin.info \" target=\"_blank\">https://www.gtin.info</a>. This can be a UPC (Universal Product Code), EAN (European Article Number), or an ISBN (International Standard Book Number) value.  # noqa: E501

        :return: The gtin of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._gtin

    @gtin.setter
    def gtin(self, gtin):
        """Sets the gtin of this ItemSnapshot.

        The unique Global Trade Item Number of the item as defined by <a href=\"https://www.gtin.info \" target=\"_blank\">https://www.gtin.info</a>. This can be a UPC (Universal Product Code), EAN (European Article Number), or an ISBN (International Standard Book Number) value.  # noqa: E501

        :param gtin: The gtin of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._gtin = gtin

    @property
    def brand(self):
        """Gets the brand of this ItemSnapshot.  # noqa: E501

        The name brand of the item, such as Nike, Apple, etc.  # noqa: E501

        :return: The brand of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._brand

    @brand.setter
    def brand(self, brand):
        """Sets the brand of this ItemSnapshot.

        The name brand of the item, such as Nike, Apple, etc.  # noqa: E501

        :param brand: The brand of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._brand = brand

    @property
    def mpn(self):
        """Gets the mpn of this ItemSnapshot.  # noqa: E501

        The manufacturer part number, which is a number that is used in combination with <b> brand</b> to identify a product.  # noqa: E501

        :return: The mpn of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._mpn

    @mpn.setter
    def mpn(self, mpn):
        """Sets the mpn of this ItemSnapshot.

        The manufacturer part number, which is a number that is used in combination with <b> brand</b> to identify a product.  # noqa: E501

        :param mpn: The mpn of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._mpn = mpn

    @property
    def epid(self):
        """Gets the epid of this ItemSnapshot.  # noqa: E501

        The eBay product identifier of a product from the eBay product catalog. You can use this value in the Browse API <a href=\"/api-docs/buy/browse/resources/item_summary/methods/search\">search</a> method to retrieve items for this product and in the <a href=\"/api-docs/buy/marketing/resources/methods\">Marketing API</a> methods to retrieve 'also viewed' and 'also bought' products to encourage up-selling and cross-selling.  # noqa: E501

        :return: The epid of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._epid

    @epid.setter
    def epid(self, epid):
        """Sets the epid of this ItemSnapshot.

        The eBay product identifier of a product from the eBay product catalog. You can use this value in the Browse API <a href=\"/api-docs/buy/browse/resources/item_summary/methods/search\">search</a> method to retrieve items for this product and in the <a href=\"/api-docs/buy/marketing/resources/methods\">Marketing API</a> methods to retrieve 'also viewed' and 'also bought' products to encourage up-selling and cross-selling.  # noqa: E501

        :param epid: The epid of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._epid = epid

    @property
    def condition_id(self):
        """Gets the condition_id of this ItemSnapshot.  # noqa: E501

        The identifier of the condition of the item. For example, 1000 is the identifier for NEW. For a list of condition names and IDs, see <a href=\"https://developer.ebay.com/devzone/finding/callref/enums/conditionIdList.html \" target=\"_blank\">Item Condition IDs and Names</a>.<br /><br />Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :return: The condition_id of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._condition_id

    @condition_id.setter
    def condition_id(self, condition_id):
        """Sets the condition_id of this ItemSnapshot.

        The identifier of the condition of the item. For example, 1000 is the identifier for NEW. For a list of condition names and IDs, see <a href=\"https://developer.ebay.com/devzone/finding/callref/enums/conditionIdList.html \" target=\"_blank\">Item Condition IDs and Names</a>.<br /><br />Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :param condition_id: The condition_id of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._condition_id = condition_id

    @property
    def condition(self):
        """Gets the condition of this ItemSnapshot.  # noqa: E501

        The text describing the condition of the item, such as New or Used. For a list of condition names, see <a href=\"https://developer.ebay.com/devzone/finding/callref/enums/conditionIdList.html \" target=\"_blank\">Item Condition IDs and Names</a>.  # noqa: E501

        :return: The condition of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._condition

    @condition.setter
    def condition(self, condition):
        """Sets the condition of this ItemSnapshot.

        The text describing the condition of the item, such as New or Used. For a list of condition names, see <a href=\"https://developer.ebay.com/devzone/finding/callref/enums/conditionIdList.html \" target=\"_blank\">Item Condition IDs and Names</a>.  # noqa: E501

        :param condition: The condition of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._condition = condition

    @property
    def price_value(self):
        """Gets the price_value of this ItemSnapshot.  # noqa: E501

        The price of the item, which can be a discounted price. <br /><br /><span class=\"tablenote\"><b> Note: </b>The price includes the value-added tax (VAT) for applicable jurisdictions when requested from supported marketplaces. In this case, users must pass the <a href=\"/api-docs/static/rest-request-components.html#HTTP\"><code>X-EBAY-C-MARKETPLACE-ID</code></a> request header specifying the supported marketplace (such as <code>EBAY_GB</code>) to see the VAT-inclusive pricing. For more information on VAT, refer to <a href=\"https://www.ebay.co.uk/help/listings/default/vat-obligations-eu?id=4650&st=12&pos=1&query=Your%20VAT%20obligations%20in%20the%20EU&intent=VAT\">VAT Obligations in the EU</a>.</span>  # noqa: E501

        :return: The price_value of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._price_value

    @price_value.setter
    def price_value(self, price_value):
        """Sets the price_value of this ItemSnapshot.

        The price of the item, which can be a discounted price. <br /><br /><span class=\"tablenote\"><b> Note: </b>The price includes the value-added tax (VAT) for applicable jurisdictions when requested from supported marketplaces. In this case, users must pass the <a href=\"/api-docs/static/rest-request-components.html#HTTP\"><code>X-EBAY-C-MARKETPLACE-ID</code></a> request header specifying the supported marketplace (such as <code>EBAY_GB</code>) to see the VAT-inclusive pricing. For more information on VAT, refer to <a href=\"https://www.ebay.co.uk/help/listings/default/vat-obligations-eu?id=4650&st=12&pos=1&query=Your%20VAT%20obligations%20in%20the%20EU&intent=VAT\">VAT Obligations in the EU</a>.</span>  # noqa: E501

        :param price_value: The price_value of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._price_value = price_value

    @property
    def price_currency(self):
        """Gets the price_currency of this ItemSnapshot.  # noqa: E501

        The currency used for the price of the item. Generally, this is the currency used by the country of the eBay site offering the item. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/bas:CurrencyCodeEnum'>eBay API documentation</a>  # noqa: E501

        :return: The price_currency of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._price_currency

    @price_currency.setter
    def price_currency(self, price_currency):
        """Sets the price_currency of this ItemSnapshot.

        The currency used for the price of the item. Generally, this is the currency used by the country of the eBay site offering the item. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/bas:CurrencyCodeEnum'>eBay API documentation</a>  # noqa: E501

        :param price_currency: The price_currency of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._price_currency = price_currency

    @property
    def primary_item_group_id(self):
        """Gets the primary_item_group_id of this ItemSnapshot.  # noqa: E501

        The unique identifier for the item group that contains this item. An item group is an item that has various aspect differences, such as color, size, storage capacity, etc.  # noqa: E501

        :return: The primary_item_group_id of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._primary_item_group_id

    @primary_item_group_id.setter
    def primary_item_group_id(self, primary_item_group_id):
        """Sets the primary_item_group_id of this ItemSnapshot.

        The unique identifier for the item group that contains this item. An item group is an item that has various aspect differences, such as color, size, storage capacity, etc.  # noqa: E501

        :param primary_item_group_id: The primary_item_group_id of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._primary_item_group_id = primary_item_group_id

    @property
    def primary_item_group_type(self):
        """Gets the primary_item_group_type of this ItemSnapshot.  # noqa: E501

        The item group type. Supported value: <code>SELLER_DEFINED_VARIATIONS</code>, indicates that the item group was created by the seller. <br /><br />Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :return: The primary_item_group_type of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._primary_item_group_type

    @primary_item_group_type.setter
    def primary_item_group_type(self, primary_item_group_type):
        """Sets the primary_item_group_type of this ItemSnapshot.

        The item group type. Supported value: <code>SELLER_DEFINED_VARIATIONS</code>, indicates that the item group was created by the seller. <br /><br />Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :param primary_item_group_type: The primary_item_group_type of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._primary_item_group_type = primary_item_group_type

    @property
    def item_end_date(self):
        """Gets the item_end_date of this ItemSnapshot.  # noqa: E501

        A timestamp indicating when the item's sale period will end based on its start date and duration. For Good 'Tail Cancelled items, no value is returned in this column. <br /><br /><b> Format: </b> UTC (yyyy-MM-ddThh:mm:ss.sssZ).  # noqa: E501

        :return: The item_end_date of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._item_end_date

    @item_end_date.setter
    def item_end_date(self, item_end_date):
        """Sets the item_end_date of this ItemSnapshot.

        A timestamp indicating when the item's sale period will end based on its start date and duration. For Good 'Tail Cancelled items, no value is returned in this column. <br /><br /><b> Format: </b> UTC (yyyy-MM-ddThh:mm:ss.sssZ).  # noqa: E501

        :param item_end_date: The item_end_date of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._item_end_date = item_end_date

    @property
    def seller_item_revision(self):
        """Gets the seller_item_revision of this ItemSnapshot.  # noqa: E501

        An identifier generated/incremented when a seller revises the item. There are two types of item revisions: <ul><li>Seller changes, such as changing the title</li>  <li>eBay system changes, such as changing the quantity when an item is purchased</li></ul> This ID is changed <i> only</i> when the seller makes a change to the item.  # noqa: E501

        :return: The seller_item_revision of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._seller_item_revision

    @seller_item_revision.setter
    def seller_item_revision(self, seller_item_revision):
        """Sets the seller_item_revision of this ItemSnapshot.

        An identifier generated/incremented when a seller revises the item. There are two types of item revisions: <ul><li>Seller changes, such as changing the title</li>  <li>eBay system changes, such as changing the quantity when an item is purchased</li></ul> This ID is changed <i> only</i> when the seller makes a change to the item.  # noqa: E501

        :param seller_item_revision: The seller_item_revision of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._seller_item_revision = seller_item_revision

    @property
    def item_location_country(self):
        """Gets the item_location_country of this ItemSnapshot.  # noqa: E501

        The country where the item is physically located.  # noqa: E501

        :return: The item_location_country of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._item_location_country

    @item_location_country.setter
    def item_location_country(self, item_location_country):
        """Sets the item_location_country of this ItemSnapshot.

        The country where the item is physically located.  # noqa: E501

        :param item_location_country: The item_location_country of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._item_location_country = item_location_country

    @property
    def localized_aspects(self):
        """Gets the localized_aspects of this ItemSnapshot.  # noqa: E501

        A semicolon separated list of the name/value pairs for the aspects of the item, which are BASE64 encoded. The aspect label is separated by a pipe (|), the aspect name and value are separated by a colon (:) and the name/value pairs are separated by a semicolon (;). <p><b> Example without Label</b></p>    <p>&nbsp;&nbsp;<b> Encoded Format:</b> <br />&nbsp;&nbsp;&nbsp;<code><em>encodedName</em>:<em>encodedValue</em>;<em>encodedName</em>:<em>encodedValue</em>;<em>encodedName</em>:<em>encodedValue</em></code> </p>       <p>&nbsp;&nbsp;<b> Encoded Example</b> (The delimiters are <b style=\"font-family: 'Arial Black';\">emphasized</b>):    <br />&nbsp;&nbsp;&nbsp;<code>U2l6ZQ==<b style=\"font-family: 'Arial Black';\">:</b>WEw=<b style=\"font-family: 'Arial Black';\">;</b>Q29sb3I=<b style=\"font-family: 'Arial Black';\">:</b>UmVk<b style=\"font-family: 'Arial Black';\">;</b>U2xlZXZlcw==<b style=\"font-family: 'Arial Black';\">:</b>TG9uZw==</code> </p>    <p>&nbsp;&nbsp;<b> Decoded: </b> <br />&nbsp;&nbsp;&nbsp;Size:XL;Color:Red;Sleeves:Long </p>        <p><br /><b> Example with Label</b></p>    <p>&nbsp;&nbsp;<b> Encoded Format:</b>   <br />&nbsp;&nbsp;&nbsp;<code><em>encodedLabel</em>|<em>encodedName</em>:<em>encodedValue</em>;<em>encodedName</em>:<em>encodedValue</em>;<em>encodedLabel</em>|</code></p>       <p>&nbsp;&nbsp;<b> Encoded Example</b> (The delimiters are <b style=\"font-family: 'Arial Black';\">emphasized</b>):  <br />&nbsp;&nbsp;&nbsp;<code>UHJvZHVjdCBJZGVudGlmaWVycw==<b style=\"font-family: 'Arial Black';\">|</b>R1RJTg==<b style=\"font-family: 'Arial Black';\">:</b>MDE5MDE5ODA2NjYzMw==<b style=\"font-family: 'Arial Black';\">;</b>QlJBTkQ=<b style=\"font-family: 'Arial Black';\">:</b>QXBwbGU=<b style=\"font-family: 'Arial Black';\">;</b>UHJvZHVjdCBLZXkgRmVhdHVyZXM=<b style=\"font-family: 'Arial Black';\">|</b>TW9kZWw=<b style=\"font-family: 'Arial Black';\">:</b>aVBob25lIDc=</code> </p>        <p>&nbsp;&nbsp;<b> Decoded: </b> <br />&nbsp;&nbsp;&nbsp;Product Identifiers|GTIN:0190198066633;BRAND:Apple;Product Key Features|Model:iPhone 7</p>        <p><span class=\"tablenote\"><b>Note: </b> The separators (<code> |  :  ; </code>) are <i> not</i> encoded. You must decode each label, name, and value separately. You cannot decode the entire string.</b></p> <p>For more information, see <a href=\"/api-docs/buy/static/api-feed.html#encoded-aspects\">Encoded Aspects</a> in the Buying Integration Guide.</p>  # noqa: E501

        :return: The localized_aspects of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._localized_aspects

    @localized_aspects.setter
    def localized_aspects(self, localized_aspects):
        """Sets the localized_aspects of this ItemSnapshot.

        A semicolon separated list of the name/value pairs for the aspects of the item, which are BASE64 encoded. The aspect label is separated by a pipe (|), the aspect name and value are separated by a colon (:) and the name/value pairs are separated by a semicolon (;). <p><b> Example without Label</b></p>    <p>&nbsp;&nbsp;<b> Encoded Format:</b> <br />&nbsp;&nbsp;&nbsp;<code><em>encodedName</em>:<em>encodedValue</em>;<em>encodedName</em>:<em>encodedValue</em>;<em>encodedName</em>:<em>encodedValue</em></code> </p>       <p>&nbsp;&nbsp;<b> Encoded Example</b> (The delimiters are <b style=\"font-family: 'Arial Black';\">emphasized</b>):    <br />&nbsp;&nbsp;&nbsp;<code>U2l6ZQ==<b style=\"font-family: 'Arial Black';\">:</b>WEw=<b style=\"font-family: 'Arial Black';\">;</b>Q29sb3I=<b style=\"font-family: 'Arial Black';\">:</b>UmVk<b style=\"font-family: 'Arial Black';\">;</b>U2xlZXZlcw==<b style=\"font-family: 'Arial Black';\">:</b>TG9uZw==</code> </p>    <p>&nbsp;&nbsp;<b> Decoded: </b> <br />&nbsp;&nbsp;&nbsp;Size:XL;Color:Red;Sleeves:Long </p>        <p><br /><b> Example with Label</b></p>    <p>&nbsp;&nbsp;<b> Encoded Format:</b>   <br />&nbsp;&nbsp;&nbsp;<code><em>encodedLabel</em>|<em>encodedName</em>:<em>encodedValue</em>;<em>encodedName</em>:<em>encodedValue</em>;<em>encodedLabel</em>|</code></p>       <p>&nbsp;&nbsp;<b> Encoded Example</b> (The delimiters are <b style=\"font-family: 'Arial Black';\">emphasized</b>):  <br />&nbsp;&nbsp;&nbsp;<code>UHJvZHVjdCBJZGVudGlmaWVycw==<b style=\"font-family: 'Arial Black';\">|</b>R1RJTg==<b style=\"font-family: 'Arial Black';\">:</b>MDE5MDE5ODA2NjYzMw==<b style=\"font-family: 'Arial Black';\">;</b>QlJBTkQ=<b style=\"font-family: 'Arial Black';\">:</b>QXBwbGU=<b style=\"font-family: 'Arial Black';\">;</b>UHJvZHVjdCBLZXkgRmVhdHVyZXM=<b style=\"font-family: 'Arial Black';\">|</b>TW9kZWw=<b style=\"font-family: 'Arial Black';\">:</b>aVBob25lIDc=</code> </p>        <p>&nbsp;&nbsp;<b> Decoded: </b> <br />&nbsp;&nbsp;&nbsp;Product Identifiers|GTIN:0190198066633;BRAND:Apple;Product Key Features|Model:iPhone 7</p>        <p><span class=\"tablenote\"><b>Note: </b> The separators (<code> |  :  ; </code>) are <i> not</i> encoded. You must decode each label, name, and value separately. You cannot decode the entire string.</b></p> <p>For more information, see <a href=\"/api-docs/buy/static/api-feed.html#encoded-aspects\">Encoded Aspects</a> in the Buying Integration Guide.</p>  # noqa: E501

        :param localized_aspects: The localized_aspects of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._localized_aspects = localized_aspects

    @property
    def seller_trust_level(self):
        """Gets the seller_trust_level of this ItemSnapshot.  # noqa: E501

        An enumeration value representing the eBay status of the seller. <br /><br /><b>Valid Values:</b> <code>TOP_RATED</code>, <code>ABOVE_STANDARD</code>, or an empty value. <br /><br />An empty value indicates a return of anything other than <code>TOP_RATED</code> or <code>ABOVE_STANDARD</code>.<br /><br />Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:SellerTrustLevelEnum'>eBay API documentation</a>  # noqa: E501

        :return: The seller_trust_level of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._seller_trust_level

    @seller_trust_level.setter
    def seller_trust_level(self, seller_trust_level):
        """Sets the seller_trust_level of this ItemSnapshot.

        An enumeration value representing the eBay status of the seller. <br /><br /><b>Valid Values:</b> <code>TOP_RATED</code>, <code>ABOVE_STANDARD</code>, or an empty value. <br /><br />An empty value indicates a return of anything other than <code>TOP_RATED</code> or <code>ABOVE_STANDARD</code>.<br /><br />Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:SellerTrustLevelEnum'>eBay API documentation</a>  # noqa: E501

        :param seller_trust_level: The seller_trust_level of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._seller_trust_level = seller_trust_level

    @property
    def image_altering_prohibited(self):
        """Gets the image_altering_prohibited of this ItemSnapshot.  # noqa: E501

        A boolean that indicates whether the images can be altered. If the value is <code>true</code>, you cannot modify the image. <p><span class=\"tablenote\"><b>Note: </b> Due to image licensing agreements and other legal concerns, modification (including resizing) of some images is strictly prohibited. These images are for display as-is only. </span></p>  # noqa: E501

        :return: The image_altering_prohibited of this ItemSnapshot.  # noqa: E501
        :rtype: bool
        """
        return self._image_altering_prohibited

    @image_altering_prohibited.setter
    def image_altering_prohibited(self, image_altering_prohibited):
        """Sets the image_altering_prohibited of this ItemSnapshot.

        A boolean that indicates whether the images can be altered. If the value is <code>true</code>, you cannot modify the image. <p><span class=\"tablenote\"><b>Note: </b> Due to image licensing agreements and other legal concerns, modification (including resizing) of some images is strictly prohibited. These images are for display as-is only. </span></p>  # noqa: E501

        :param image_altering_prohibited: The image_altering_prohibited of this ItemSnapshot.  # noqa: E501
        :type: bool
        """

        self._image_altering_prohibited = image_altering_prohibited

    @property
    def estimated_available_quantity(self):
        """Gets the estimated_available_quantity of this ItemSnapshot.  # noqa: E501

        The estimated number of this item that are available for purchase. Because the quantity of an item can change several times within a second, it is impossible to return the exact quantity. So instead of returning quantity, the estimated availability of the item is returned.  # noqa: E501

        :return: The estimated_available_quantity of this ItemSnapshot.  # noqa: E501
        :rtype: int
        """
        return self._estimated_available_quantity

    @estimated_available_quantity.setter
    def estimated_available_quantity(self, estimated_available_quantity):
        """Sets the estimated_available_quantity of this ItemSnapshot.

        The estimated number of this item that are available for purchase. Because the quantity of an item can change several times within a second, it is impossible to return the exact quantity. So instead of returning quantity, the estimated availability of the item is returned.  # noqa: E501

        :param estimated_available_quantity: The estimated_available_quantity of this ItemSnapshot.  # noqa: E501
        :type: int
        """

        self._estimated_available_quantity = estimated_available_quantity

    @property
    def availability_threshold_type(self):
        """Gets the availability_threshold_type of this ItemSnapshot.  # noqa: E501

        <a name=\"display-item-quantity\"></a> This column has a value only when the seller sets their <b>Display Item Quantity</b> preference to <b> Display \"More than 10 available\" in your listing (if applicable)</b>. The value of this column will be <code> MORE_THAN</code>. This indicates that the seller has more than the 'Display Item Quantity', which is 10, in stock for this item.    <br /><br /> The following are the <b>Display Item Quantity</b> preferences the seller can set. <br /><ul><li> <b> Display \"More than 10 available\" in your listing (if applicable)</b> <br />If the seller enables this preference, this column will have a value as long as there are more than 10 of this item in inventory. If the quantity is equal to 10 or drops below 10, this column will be null and the estimated quantity of the item is returned in the <b> estimatedAvailableQuantity</b> column. </li> <li> <b> Display the exact quantity in your items</b> <br />If the seller enables this preference, the <b> availabilityThresholdType</b> and <b> availabilityThreshold</b> columns will be null  and the estimated quantity of the item is returned in the <b> estimatedAvailableQuantity</b> column.<br /><br /><b>Note: </b> Because the quantity of an item can change several times within a second, it is impossible to return the exact quantity. </li></ul>   <br />Code so that your app gracefully handles any future changes to these preferences. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:AvailabilityThresholdEnum'>eBay API documentation</a>  # noqa: E501

        :return: The availability_threshold_type of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._availability_threshold_type

    @availability_threshold_type.setter
    def availability_threshold_type(self, availability_threshold_type):
        """Sets the availability_threshold_type of this ItemSnapshot.

        <a name=\"display-item-quantity\"></a> This column has a value only when the seller sets their <b>Display Item Quantity</b> preference to <b> Display \"More than 10 available\" in your listing (if applicable)</b>. The value of this column will be <code> MORE_THAN</code>. This indicates that the seller has more than the 'Display Item Quantity', which is 10, in stock for this item.    <br /><br /> The following are the <b>Display Item Quantity</b> preferences the seller can set. <br /><ul><li> <b> Display \"More than 10 available\" in your listing (if applicable)</b> <br />If the seller enables this preference, this column will have a value as long as there are more than 10 of this item in inventory. If the quantity is equal to 10 or drops below 10, this column will be null and the estimated quantity of the item is returned in the <b> estimatedAvailableQuantity</b> column. </li> <li> <b> Display the exact quantity in your items</b> <br />If the seller enables this preference, the <b> availabilityThresholdType</b> and <b> availabilityThreshold</b> columns will be null  and the estimated quantity of the item is returned in the <b> estimatedAvailableQuantity</b> column.<br /><br /><b>Note: </b> Because the quantity of an item can change several times within a second, it is impossible to return the exact quantity. </li></ul>   <br />Code so that your app gracefully handles any future changes to these preferences. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:AvailabilityThresholdEnum'>eBay API documentation</a>  # noqa: E501

        :param availability_threshold_type: The availability_threshold_type of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._availability_threshold_type = availability_threshold_type

    @property
    def availability_threshold(self):
        """Gets the availability_threshold of this ItemSnapshot.  # noqa: E501

        This column has a value only when the seller sets their '<a href=\"#display-item-quantity\">display item quantity</a>' preference to <b> Display \"More than 10 available\" in your listing (if applicable)</b>. The value of this column will be \"10\", which is the threshold value. <br /><br />Code so that your app gracefully handles any future changes to this value.  # noqa: E501

        :return: The availability_threshold of this ItemSnapshot.  # noqa: E501
        :rtype: int
        """
        return self._availability_threshold

    @availability_threshold.setter
    def availability_threshold(self, availability_threshold):
        """Sets the availability_threshold of this ItemSnapshot.

        This column has a value only when the seller sets their '<a href=\"#display-item-quantity\">display item quantity</a>' preference to <b> Display \"More than 10 available\" in your listing (if applicable)</b>. The value of this column will be \"10\", which is the threshold value. <br /><br />Code so that your app gracefully handles any future changes to this value.  # noqa: E501

        :param availability_threshold: The availability_threshold of this ItemSnapshot.  # noqa: E501
        :type: int
        """

        self._availability_threshold = availability_threshold

    @property
    def item_snapshot_date(self):
        """Gets the item_snapshot_date of this ItemSnapshot.  # noqa: E501

        This timestamp denotes the date and time the changes for that item were picked up and added to the snapshot feed file. <br /><br />For example, let's say you have a snapshot feed file and also ran the <b> getItem</b> method. When you compare the same item information from the two sources, you see that the price in the <b> getItem</b> method response is different from the price in the snapshot feed file. By knowing the date and time you submitted the <b> getItem</b> method, you can use the <b> itemSnapshotDate</b> data to determine which price is the most current for this item.  # noqa: E501

        :return: The item_snapshot_date of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._item_snapshot_date

    @item_snapshot_date.setter
    def item_snapshot_date(self, item_snapshot_date):
        """Sets the item_snapshot_date of this ItemSnapshot.

        This timestamp denotes the date and time the changes for that item were picked up and added to the snapshot feed file. <br /><br />For example, let's say you have a snapshot feed file and also ran the <b> getItem</b> method. When you compare the same item information from the two sources, you see that the price in the <b> getItem</b> method response is different from the price in the snapshot feed file. By knowing the date and time you submitted the <b> getItem</b> method, you can use the <b> itemSnapshotDate</b> data to determine which price is the most current for this item.  # noqa: E501

        :param item_snapshot_date: The item_snapshot_date of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._item_snapshot_date = item_snapshot_date

    @property
    def original_price_value(self):
        """Gets the original_price_value of this ItemSnapshot.  # noqa: E501

        The original selling price of the item. This lets you surface a strikethrough price for the item.   # noqa: E501

        :return: The original_price_value of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._original_price_value

    @original_price_value.setter
    def original_price_value(self, original_price_value):
        """Sets the original_price_value of this ItemSnapshot.

        The original selling price of the item. This lets you surface a strikethrough price for the item.   # noqa: E501

        :param original_price_value: The original_price_value of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._original_price_value = original_price_value

    @property
    def original_price_currency(self):
        """Gets the original_price_currency of this ItemSnapshot.  # noqa: E501

        The currency of the <b> originalPriceValue</b> of the item and the <b> discountAmount</b>.  For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/bas:CurrencyCodeEnum'>eBay API documentation</a>  # noqa: E501

        :return: The original_price_currency of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._original_price_currency

    @original_price_currency.setter
    def original_price_currency(self, original_price_currency):
        """Sets the original_price_currency of this ItemSnapshot.

        The currency of the <b> originalPriceValue</b> of the item and the <b> discountAmount</b>.  For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/bas:CurrencyCodeEnum'>eBay API documentation</a>  # noqa: E501

        :param original_price_currency: The original_price_currency of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._original_price_currency = original_price_currency

    @property
    def discount_amount(self):
        """Gets the discount_amount of this ItemSnapshot.  # noqa: E501

        The calculated amount of the discount (<b>originalPriceValue</b> - <b>priceValue</b>). For example,  if <b>originalPriceValue</b> is 70 and <b>priceValue</b> is 56, this value would be 14. <br /><br /><b>Note:</b> The currency shown in <b>originalPriceCurrency</b> is used for both <b>discountAmount</b> and <b>originalPriceCurrency</b>.  # noqa: E501

        :return: The discount_amount of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._discount_amount

    @discount_amount.setter
    def discount_amount(self, discount_amount):
        """Sets the discount_amount of this ItemSnapshot.

        The calculated amount of the discount (<b>originalPriceValue</b> - <b>priceValue</b>). For example,  if <b>originalPriceValue</b> is 70 and <b>priceValue</b> is 56, this value would be 14. <br /><br /><b>Note:</b> The currency shown in <b>originalPriceCurrency</b> is used for both <b>discountAmount</b> and <b>originalPriceCurrency</b>.  # noqa: E501

        :param discount_amount: The discount_amount of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._discount_amount = discount_amount

    @property
    def discount_percentage(self):
        """Gets the discount_percentage of this ItemSnapshot.  # noqa: E501

        The calculated discount percentage. For example, if <b> originalPriceValue</b> is 70 and <b> discountAmount</b> is 14, this value will be 20.  # noqa: E501

        :return: The discount_percentage of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._discount_percentage

    @discount_percentage.setter
    def discount_percentage(self, discount_percentage):
        """Sets the discount_percentage of this ItemSnapshot.

        The calculated discount percentage. For example, if <b> originalPriceValue</b> is 70 and <b> discountAmount</b> is 14, this value will be 20.  # noqa: E501

        :param discount_percentage: The discount_percentage of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._discount_percentage = discount_percentage

    @property
    def returns_accepted(self):
        """Gets the returns_accepted of this ItemSnapshot.  # noqa: E501

        Indicates whether the seller accepts returns for the item.  # noqa: E501

        :return: The returns_accepted of this ItemSnapshot.  # noqa: E501
        :rtype: bool
        """
        return self._returns_accepted

    @returns_accepted.setter
    def returns_accepted(self, returns_accepted):
        """Sets the returns_accepted of this ItemSnapshot.

        Indicates whether the seller accepts returns for the item.  # noqa: E501

        :param returns_accepted: The returns_accepted of this ItemSnapshot.  # noqa: E501
        :type: bool
        """

        self._returns_accepted = returns_accepted

    @property
    def return_period_value(self):
        """Gets the return_period_value of this ItemSnapshot.  # noqa: E501

        The amount of days that the buyer has to return the item after the purchase date. For example, if this value is <code>30</code>, the return period is 30 days.  # noqa: E501

        :return: The return_period_value of this ItemSnapshot.  # noqa: E501
        :rtype: int
        """
        return self._return_period_value

    @return_period_value.setter
    def return_period_value(self, return_period_value):
        """Sets the return_period_value of this ItemSnapshot.

        The amount of days that the buyer has to return the item after the purchase date. For example, if this value is <code>30</code>, the return period is 30 days.  # noqa: E501

        :param return_period_value: The return_period_value of this ItemSnapshot.  # noqa: E501
        :type: int
        """

        self._return_period_value = return_period_value

    @property
    def return_period_unit(self):
        """Gets the return_period_unit of this ItemSnapshot.  # noqa: E501

        An enumeration value that indicates the period of time being used to measure the duration, such as business days, months, or years. <br /><br /><b>TimeDurationUnitEnum</b> is a common type shared by multiple eBay APIs and fields to express the time unit, but for return period duration, this value will always be <code>DAY</code>. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/bas:TimeDurationUnitEnum'>eBay API documentation</a>  # noqa: E501

        :return: The return_period_unit of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._return_period_unit

    @return_period_unit.setter
    def return_period_unit(self, return_period_unit):
        """Sets the return_period_unit of this ItemSnapshot.

        An enumeration value that indicates the period of time being used to measure the duration, such as business days, months, or years. <br /><br /><b>TimeDurationUnitEnum</b> is a common type shared by multiple eBay APIs and fields to express the time unit, but for return period duration, this value will always be <code>DAY</code>. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/bas:TimeDurationUnitEnum'>eBay API documentation</a>  # noqa: E501

        :param return_period_unit: The return_period_unit of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._return_period_unit = return_period_unit

    @property
    def refund_method(self):
        """Gets the refund_method of this ItemSnapshot.  # noqa: E501

        An enumeration value representing how a buyer is refunded when an item is returned. <br /><br />Code so that your app gracefully handles any future changes to this list.  For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:RefundMethodEnum'>eBay API documentation</a>  # noqa: E501

        :return: The refund_method of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._refund_method

    @refund_method.setter
    def refund_method(self, refund_method):
        """Sets the refund_method of this ItemSnapshot.

        An enumeration value representing how a buyer is refunded when an item is returned. <br /><br />Code so that your app gracefully handles any future changes to this list.  For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:RefundMethodEnum'>eBay API documentation</a>  # noqa: E501

        :param refund_method: The refund_method of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._refund_method = refund_method

    @property
    def return_method(self):
        """Gets the return_method of this ItemSnapshot.  # noqa: E501

        An enumeration value that indicates the alternative methods for a full refund when an item is returned. This column will have data if the seller offers the buyer an item replacement or exchange instead of a monetary refund. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:ReturnMethodEnum'>eBay API documentation</a>  # noqa: E501

        :return: The return_method of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._return_method

    @return_method.setter
    def return_method(self, return_method):
        """Sets the return_method of this ItemSnapshot.

        An enumeration value that indicates the alternative methods for a full refund when an item is returned. This column will have data if the seller offers the buyer an item replacement or exchange instead of a monetary refund. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:ReturnMethodEnum'>eBay API documentation</a>  # noqa: E501

        :param return_method: The return_method of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._return_method = return_method

    @property
    def return_shipping_cost_payer(self):
        """Gets the return_shipping_cost_payer of this ItemSnapshot.  # noqa: E501

        An enumeration value that indicates the party responsible for the return shipping costs when an item is returned. <br /><br /><b>Valid Values: </b> <code>BUYER</code> or <code>SELLER</code> <br /><br />Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:ReturnShippingCostPayerEnum'>eBay API documentation</a>  # noqa: E501

        :return: The return_shipping_cost_payer of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._return_shipping_cost_payer

    @return_shipping_cost_payer.setter
    def return_shipping_cost_payer(self, return_shipping_cost_payer):
        """Sets the return_shipping_cost_payer of this ItemSnapshot.

        An enumeration value that indicates the party responsible for the return shipping costs when an item is returned. <br /><br /><b>Valid Values: </b> <code>BUYER</code> or <code>SELLER</code> <br /><br />Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:ReturnShippingCostPayerEnum'>eBay API documentation</a>  # noqa: E501

        :param return_shipping_cost_payer: The return_shipping_cost_payer of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._return_shipping_cost_payer = return_shipping_cost_payer

    @property
    def energy_efficiency_class(self):
        """Gets the energy_efficiency_class of this ItemSnapshot.  # noqa: E501

        Indicates the <a href=\"https://en.wikipedia.org/wiki/European_Union_energy_label\">European energy efficiency</a> rating (EEK) of the item. This field is returned only if the seller specified the energy efficiency rating. <br /><br />The rating is a set of energy efficiency classes from A to G, where 'A' is the most energy efficient and 'G' is the least efficient. This rating helps buyers choose between various models. <br /><br />To retrieve the manufacturer's specifications for this item, when they are available, use the <a href=\"/api-docs/buy/browse/resources/item/methods/getItem\">getItem</a> method in the Browse API. The information is returned in the <b> productFicheWebUrl</b> field.  # noqa: E501

        :return: The energy_efficiency_class of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._energy_efficiency_class

    @energy_efficiency_class.setter
    def energy_efficiency_class(self, energy_efficiency_class):
        """Sets the energy_efficiency_class of this ItemSnapshot.

        Indicates the <a href=\"https://en.wikipedia.org/wiki/European_Union_energy_label\">European energy efficiency</a> rating (EEK) of the item. This field is returned only if the seller specified the energy efficiency rating. <br /><br />The rating is a set of energy efficiency classes from A to G, where 'A' is the most energy efficient and 'G' is the least efficient. This rating helps buyers choose between various models. <br /><br />To retrieve the manufacturer's specifications for this item, when they are available, use the <a href=\"/api-docs/buy/browse/resources/item/methods/getItem\">getItem</a> method in the Browse API. The information is returned in the <b> productFicheWebUrl</b> field.  # noqa: E501

        :param energy_efficiency_class: The energy_efficiency_class of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._energy_efficiency_class = energy_efficiency_class

    @property
    def additional_image_urls(self):
        """Gets the additional_image_urls of this ItemSnapshot.  # noqa: E501

        A pipe separated (<code>|</code>) list of URLs for the additional images of the item. These images are in addition to the primary image, which is returned in the <b>imageUrl</b> column. <b>Note: </b> This column can contain multiple values.  # noqa: E501

        :return: The additional_image_urls of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._additional_image_urls

    @additional_image_urls.setter
    def additional_image_urls(self, additional_image_urls):
        """Sets the additional_image_urls of this ItemSnapshot.

        A pipe separated (<code>|</code>) list of URLs for the additional images of the item. These images are in addition to the primary image, which is returned in the <b>imageUrl</b> column. <b>Note: </b> This column can contain multiple values.  # noqa: E501

        :param additional_image_urls: The additional_image_urls of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._additional_image_urls = additional_image_urls

    @property
    def delivery_options(self):
        """Gets the delivery_options of this ItemSnapshot.  # noqa: E501

        A comma-separated list of available delivery options. This column lets you filter out items than cannot be shipped to the buyer. <br /><br /><b>Valid Values</b>: SHIP_TO_HOME, SELLER_ARRANGED_LOCAL_PICKUP, IN_STORE_PICKUP, and PICKUP_DROP_OFF. <br /><br />Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:DeliveryOptionsEnum'>eBay API documentation</a>  # noqa: E501

        :return: The delivery_options of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._delivery_options

    @delivery_options.setter
    def delivery_options(self, delivery_options):
        """Sets the delivery_options of this ItemSnapshot.

        A comma-separated list of available delivery options. This column lets you filter out items than cannot be shipped to the buyer. <br /><br /><b>Valid Values</b>: SHIP_TO_HOME, SELLER_ARRANGED_LOCAL_PICKUP, IN_STORE_PICKUP, and PICKUP_DROP_OFF. <br /><br />Code so that your app gracefully handles any future changes to this list. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:DeliveryOptionsEnum'>eBay API documentation</a>  # noqa: E501

        :param delivery_options: The delivery_options of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._delivery_options = delivery_options

    @property
    def ship_to_included_regions(self):
        """Gets the ship_to_included_regions of this ItemSnapshot.  # noqa: E501

        A pipe (<code>|</code>) separated alphabetical list of the geographic countries and regions where the seller will ship the item. <br /><br />If a region is specified, you will need to subtract any countries and regions returned in the <b> shipToExcludedRegions</b> column to fully understand where the seller will ship. <br /><br />The COUNTRY: list is separated from the REGION: list with a semicolon (<code>;</code>).       <br /><br /><b> Format Example: </b> <br /> <code>COUNTRY:US|BM|GL|MX|PM;REGION:AFRICA|ASIA|CENTRAL_AMERICA_AND_CARIBBEAN|EUROPE|MIDDLE_EAST|OCEANIA|SOUTH_AMERICA|SOUTHEAST_ASIA;</code>  <br /><br /><b> Country Values: </b> The two-letter <a href=\"https://www.iso.org/iso-3166-country-codes.html\">ISO 3166</a> standard code of the country.       <br /><br /><b> Region Values: </b> AFRICA, AMERICAS, ANTARCTIC, ARCTIC, ASIA, AUSTRALIA, CENTRAL_AMERICA_AND_CARIBBEAN, EUROPE, EURO_UNION, GREATER_CHINA, MIDDLE_EAST, NORTH_AMERICA, OCEANIA, REST_OF_ASIA, SOUTHEAST_ASIA, SOUTH_AMERICA, WORLDWIDE <br /><br />Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :return: The ship_to_included_regions of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._ship_to_included_regions

    @ship_to_included_regions.setter
    def ship_to_included_regions(self, ship_to_included_regions):
        """Sets the ship_to_included_regions of this ItemSnapshot.

        A pipe (<code>|</code>) separated alphabetical list of the geographic countries and regions where the seller will ship the item. <br /><br />If a region is specified, you will need to subtract any countries and regions returned in the <b> shipToExcludedRegions</b> column to fully understand where the seller will ship. <br /><br />The COUNTRY: list is separated from the REGION: list with a semicolon (<code>;</code>).       <br /><br /><b> Format Example: </b> <br /> <code>COUNTRY:US|BM|GL|MX|PM;REGION:AFRICA|ASIA|CENTRAL_AMERICA_AND_CARIBBEAN|EUROPE|MIDDLE_EAST|OCEANIA|SOUTH_AMERICA|SOUTHEAST_ASIA;</code>  <br /><br /><b> Country Values: </b> The two-letter <a href=\"https://www.iso.org/iso-3166-country-codes.html\">ISO 3166</a> standard code of the country.       <br /><br /><b> Region Values: </b> AFRICA, AMERICAS, ANTARCTIC, ARCTIC, ASIA, AUSTRALIA, CENTRAL_AMERICA_AND_CARIBBEAN, EUROPE, EURO_UNION, GREATER_CHINA, MIDDLE_EAST, NORTH_AMERICA, OCEANIA, REST_OF_ASIA, SOUTHEAST_ASIA, SOUTH_AMERICA, WORLDWIDE <br /><br />Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :param ship_to_included_regions: The ship_to_included_regions of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._ship_to_included_regions = ship_to_included_regions

    @property
    def ship_to_excluded_regions(self):
        """Gets the ship_to_excluded_regions of this ItemSnapshot.  # noqa: E501

        A pipe (<code>|</code>) separated alphabetical list of the geographic countries and regions where the item cannot be shipped. These countries and regions refine (restrict) the <b> shipToIncludedRegions</b> list.  <br /><br />The COUNTRY: list is separated from the REGION: list with a semicolon (<code>;</code>).       <br /><br /><b> Format Example: </b> <br /> <code>COUNTRY:US|BM|GL|MX|PM;REGION:AFRICA|ASIA|CENTRAL_AMERICA_AND_CARIBBEAN|EUROPE|MIDDLE_EAST|OCEANIA|SOUTH_AMERICA|SOUTHEAST_ASIA;</code>  <br /><br /><b> Country Values: </b> The two-letter <a href=\"https://www.iso.org/iso-3166-country-codes.html\">ISO 3166</a> standard code of the country.       <br /><br /><b> Region Values: </b> AFRICA, AMERICAS, ANTARCTIC, ARCTIC, ASIA, AUSTRALIA, CENTRAL_AMERICA_AND_CARIBBEAN, EUROPE, EURO_UNION, GREATER_CHINA, MIDDLE_EAST, NORTH_AMERICA, OCEANIA, REST_OF_ASIA, SOUTHEAST_ASIA, SOUTH_AMERICA, WORLDWIDE <br /><br />Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :return: The ship_to_excluded_regions of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._ship_to_excluded_regions

    @ship_to_excluded_regions.setter
    def ship_to_excluded_regions(self, ship_to_excluded_regions):
        """Sets the ship_to_excluded_regions of this ItemSnapshot.

        A pipe (<code>|</code>) separated alphabetical list of the geographic countries and regions where the item cannot be shipped. These countries and regions refine (restrict) the <b> shipToIncludedRegions</b> list.  <br /><br />The COUNTRY: list is separated from the REGION: list with a semicolon (<code>;</code>).       <br /><br /><b> Format Example: </b> <br /> <code>COUNTRY:US|BM|GL|MX|PM;REGION:AFRICA|ASIA|CENTRAL_AMERICA_AND_CARIBBEAN|EUROPE|MIDDLE_EAST|OCEANIA|SOUTH_AMERICA|SOUTHEAST_ASIA;</code>  <br /><br /><b> Country Values: </b> The two-letter <a href=\"https://www.iso.org/iso-3166-country-codes.html\">ISO 3166</a> standard code of the country.       <br /><br /><b> Region Values: </b> AFRICA, AMERICAS, ANTARCTIC, ARCTIC, ASIA, AUSTRALIA, CENTRAL_AMERICA_AND_CARIBBEAN, EUROPE, EURO_UNION, GREATER_CHINA, MIDDLE_EAST, NORTH_AMERICA, OCEANIA, REST_OF_ASIA, SOUTHEAST_ASIA, SOUTH_AMERICA, WORLDWIDE <br /><br />Code so that your app gracefully handles any future changes to this list.  # noqa: E501

        :param ship_to_excluded_regions: The ship_to_excluded_regions of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._ship_to_excluded_regions = ship_to_excluded_regions

    @property
    def accepted_payment_methods(self):
        """Gets the accepted_payment_methods of this ItemSnapshot.  # noqa: E501

        This field is returned empty. For a list of payment methods available for a marketplace, see eBay help pages or the actual View Item page.  # noqa: E501

        :return: The accepted_payment_methods of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._accepted_payment_methods

    @accepted_payment_methods.setter
    def accepted_payment_methods(self, accepted_payment_methods):
        """Sets the accepted_payment_methods of this ItemSnapshot.

        This field is returned empty. For a list of payment methods available for a marketplace, see eBay help pages or the actual View Item page.  # noqa: E501

        :param accepted_payment_methods: The accepted_payment_methods of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._accepted_payment_methods = accepted_payment_methods

    @property
    def qualified_programs(self):
        """Gets the qualified_programs of this ItemSnapshot.  # noqa: E501

        A pipe separated list of the qualified programs available for the item, such as EBAY_PLUS and AUTHENTICITY_GUARANTEE.  <br /><br />eBay Plus is a premium account option for buyers, which provides benefits such as fast free domestic shipping and free returns on selected items. Top-Rated eBay sellers must opt in to eBay Plus to be able to offer the program on qualifying listings. Sellers must commit to next-day delivery of those items.  <span class=\"tablenote\"><b>Note: </b> eBay Plus is available only to buyers in Germany, Austria, and Australia marketplaces. </span><br /><br />The eBay Authenticity Guarantee program enables third-party authenticators to perform authentication verification inspections on items such as watches and sneakers.  # noqa: E501

        :return: The qualified_programs of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._qualified_programs

    @qualified_programs.setter
    def qualified_programs(self, qualified_programs):
        """Sets the qualified_programs of this ItemSnapshot.

        A pipe separated list of the qualified programs available for the item, such as EBAY_PLUS and AUTHENTICITY_GUARANTEE.  <br /><br />eBay Plus is a premium account option for buyers, which provides benefits such as fast free domestic shipping and free returns on selected items. Top-Rated eBay sellers must opt in to eBay Plus to be able to offer the program on qualifying listings. Sellers must commit to next-day delivery of those items.  <span class=\"tablenote\"><b>Note: </b> eBay Plus is available only to buyers in Germany, Austria, and Australia marketplaces. </span><br /><br />The eBay Authenticity Guarantee program enables third-party authenticators to perform authentication verification inspections on items such as watches and sneakers.  # noqa: E501

        :param qualified_programs: The qualified_programs of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._qualified_programs = qualified_programs

    @property
    def lot_size(self):
        """Gets the lot_size of this ItemSnapshot.  # noqa: E501

        The number of items in a lot. In other words, a lot size is the number of items that are being sold together.  <br /><br />A lot is a set of two or more items included in a single listing that must be purchased together in a single order line item. All the items in the lot are the same but there can be multiple items in a single lot,  such as the package of batteries shown in the example below.   <br /><br /><table border=\"1\"> <tr> <tr>  <th>Item</th>  <th>Lot Definition</th> <th>Lot Size</th></tr>  <tr>  <td>A package of 24 AA batteries</td>  <td>A box of 10 packages</td>  <td>10  </td> </tr>  <tr>  <td>A P235/75-15 Goodyear tire </td>  <td>4 tires  </td>  <td>4  </td> </tr> <tr> <td>Fashion Jewelry Rings  </td> <td>Package of 100 assorted rings  </td> <td>100 </td> </tr></table>  <br /><br /><span class=\"tablenote\"><b>Note: </b>  Lots are not supported in all categories.  </span>  # noqa: E501

        :return: The lot_size of this ItemSnapshot.  # noqa: E501
        :rtype: int
        """
        return self._lot_size

    @lot_size.setter
    def lot_size(self, lot_size):
        """Sets the lot_size of this ItemSnapshot.

        The number of items in a lot. In other words, a lot size is the number of items that are being sold together.  <br /><br />A lot is a set of two or more items included in a single listing that must be purchased together in a single order line item. All the items in the lot are the same but there can be multiple items in a single lot,  such as the package of batteries shown in the example below.   <br /><br /><table border=\"1\"> <tr> <tr>  <th>Item</th>  <th>Lot Definition</th> <th>Lot Size</th></tr>  <tr>  <td>A package of 24 AA batteries</td>  <td>A box of 10 packages</td>  <td>10  </td> </tr>  <tr>  <td>A P235/75-15 Goodyear tire </td>  <td>4 tires  </td>  <td>4  </td> </tr> <tr> <td>Fashion Jewelry Rings  </td> <td>Package of 100 assorted rings  </td> <td>100 </td> </tr></table>  <br /><br /><span class=\"tablenote\"><b>Note: </b>  Lots are not supported in all categories.  </span>  # noqa: E501

        :param lot_size: The lot_size of this ItemSnapshot.  # noqa: E501
        :type: int
        """

        self._lot_size = lot_size

    @property
    def shipping_carrier_code(self):
        """Gets the shipping_carrier_code of this ItemSnapshot.  # noqa: E501

        The name of the shipping provider, such as FedEx, or USPS.  # noqa: E501

        :return: The shipping_carrier_code of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._shipping_carrier_code

    @shipping_carrier_code.setter
    def shipping_carrier_code(self, shipping_carrier_code):
        """Sets the shipping_carrier_code of this ItemSnapshot.

        The name of the shipping provider, such as FedEx, or USPS.  # noqa: E501

        :param shipping_carrier_code: The shipping_carrier_code of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._shipping_carrier_code = shipping_carrier_code

    @property
    def shipping_service_code(self):
        """Gets the shipping_service_code of this ItemSnapshot.  # noqa: E501

        The type of shipping service. For example, USPS First Class.  # noqa: E501

        :return: The shipping_service_code of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._shipping_service_code

    @shipping_service_code.setter
    def shipping_service_code(self, shipping_service_code):
        """Sets the shipping_service_code of this ItemSnapshot.

        The type of shipping service. For example, USPS First Class.  # noqa: E501

        :param shipping_service_code: The shipping_service_code of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._shipping_service_code = shipping_service_code

    @property
    def shipping_type(self):
        """Gets the shipping_type of this ItemSnapshot.  # noqa: E501

        The type of a shipping option, such as EXPEDITED, ONE_DAY, STANDARD, ECONOMY, PICKUP, etc.  # noqa: E501

        :return: The shipping_type of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._shipping_type

    @shipping_type.setter
    def shipping_type(self, shipping_type):
        """Sets the shipping_type of this ItemSnapshot.

        The type of a shipping option, such as EXPEDITED, ONE_DAY, STANDARD, ECONOMY, PICKUP, etc.  # noqa: E501

        :param shipping_type: The shipping_type of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._shipping_type = shipping_type

    @property
    def shipping_cost(self):
        """Gets the shipping_cost of this ItemSnapshot.  # noqa: E501

        The final shipping cost for all the items after all discounts are applied.<br /><br /><span class=\"tablenote\"><b> Note: </b>The price includes the value-added tax (VAT) for applicable jurisdictions when requested from supported marketplaces. In this case, users must pass the <a href=\"/api-docs/static/rest-request-components.html#HTTP\"><code>X-EBAY-C-MARKETPLACE-ID</code></a> request header specifying the supported marketplace (such as <code>EBAY_GB</code>) to see the VAT-inclusive pricing. For more information on VAT, refer to <a href=\"https://www.ebay.co.uk/help/listings/default/vat-obligations-eu?id=4650&st=12&pos=1&query=Your%20VAT%20obligations%20in%20the%20EU&intent=VAT\">VAT Obligations in the EU</a>.</span>  # noqa: E501

        :return: The shipping_cost of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._shipping_cost

    @shipping_cost.setter
    def shipping_cost(self, shipping_cost):
        """Sets the shipping_cost of this ItemSnapshot.

        The final shipping cost for all the items after all discounts are applied.<br /><br /><span class=\"tablenote\"><b> Note: </b>The price includes the value-added tax (VAT) for applicable jurisdictions when requested from supported marketplaces. In this case, users must pass the <a href=\"/api-docs/static/rest-request-components.html#HTTP\"><code>X-EBAY-C-MARKETPLACE-ID</code></a> request header specifying the supported marketplace (such as <code>EBAY_GB</code>) to see the VAT-inclusive pricing. For more information on VAT, refer to <a href=\"https://www.ebay.co.uk/help/listings/default/vat-obligations-eu?id=4650&st=12&pos=1&query=Your%20VAT%20obligations%20in%20the%20EU&intent=VAT\">VAT Obligations in the EU</a>.</span>  # noqa: E501

        :param shipping_cost: The shipping_cost of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._shipping_cost = shipping_cost

    @property
    def shipping_cost_type(self):
        """Gets the shipping_cost_type of this ItemSnapshot.  # noqa: E501

        Indicates the class of the shipping cost. <br /><br /><b> Valid Values: </b> FIXED or CALCULATED <br /><br />Code so that your app gracefully handles any future changes to this list.   # noqa: E501

        :return: The shipping_cost_type of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._shipping_cost_type

    @shipping_cost_type.setter
    def shipping_cost_type(self, shipping_cost_type):
        """Sets the shipping_cost_type of this ItemSnapshot.

        Indicates the class of the shipping cost. <br /><br /><b> Valid Values: </b> FIXED or CALCULATED <br /><br />Code so that your app gracefully handles any future changes to this list.   # noqa: E501

        :param shipping_cost_type: The shipping_cost_type of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._shipping_cost_type = shipping_cost_type

    @property
    def additional_shipping_cost_per_unit(self):
        """Gets the additional_shipping_cost_per_unit of this ItemSnapshot.  # noqa: E501

        Any per item additional shipping costs for a multi-item purchase. For example, let's say the shipping cost for a power cord is $3. But for an additional cord, the shipping cost is only $1. So if you bought 3 cords, the <b> shippingCost</b> would be $3 and this value would be $2 ($1 for each additional item).  # noqa: E501

        :return: The additional_shipping_cost_per_unit of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._additional_shipping_cost_per_unit

    @additional_shipping_cost_per_unit.setter
    def additional_shipping_cost_per_unit(self, additional_shipping_cost_per_unit):
        """Sets the additional_shipping_cost_per_unit of this ItemSnapshot.

        Any per item additional shipping costs for a multi-item purchase. For example, let's say the shipping cost for a power cord is $3. But for an additional cord, the shipping cost is only $1. So if you bought 3 cords, the <b> shippingCost</b> would be $3 and this value would be $2 ($1 for each additional item).  # noqa: E501

        :param additional_shipping_cost_per_unit: The additional_shipping_cost_per_unit of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._additional_shipping_cost_per_unit = additional_shipping_cost_per_unit

    @property
    def quantity_used_for_estimate(self):
        """Gets the quantity_used_for_estimate of this ItemSnapshot.  # noqa: E501

        The number of items used when calculating the shipping estimation information.  # noqa: E501

        :return: The quantity_used_for_estimate of this ItemSnapshot.  # noqa: E501
        :rtype: int
        """
        return self._quantity_used_for_estimate

    @quantity_used_for_estimate.setter
    def quantity_used_for_estimate(self, quantity_used_for_estimate):
        """Sets the quantity_used_for_estimate of this ItemSnapshot.

        The number of items used when calculating the shipping estimation information.  # noqa: E501

        :param quantity_used_for_estimate: The quantity_used_for_estimate of this ItemSnapshot.  # noqa: E501
        :type: int
        """

        self._quantity_used_for_estimate = quantity_used_for_estimate

    @property
    def unit_price(self):
        """Gets the unit_price of this ItemSnapshot.  # noqa: E501

        This is the price per unit for the item. Some European countries require listings for certain types of products to include the price per unit so buyers can accurately compare prices.   <br /><br />For example: <br /><br /><code>\"unitPricingMeasure\": \"100g\",<br /> \"unitPrice\": {<br />&nbsp;&nbsp;\"value\": \"7.99\",<br />&nbsp;&nbsp;\"currency\": \"GBP\"</code>  # noqa: E501

        :return: The unit_price of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._unit_price

    @unit_price.setter
    def unit_price(self, unit_price):
        """Sets the unit_price of this ItemSnapshot.

        This is the price per unit for the item. Some European countries require listings for certain types of products to include the price per unit so buyers can accurately compare prices.   <br /><br />For example: <br /><br /><code>\"unitPricingMeasure\": \"100g\",<br /> \"unitPrice\": {<br />&nbsp;&nbsp;\"value\": \"7.99\",<br />&nbsp;&nbsp;\"currency\": \"GBP\"</code>  # noqa: E501

        :param unit_price: The unit_price of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._unit_price = unit_price

    @property
    def unit_pricing_measure(self):
        """Gets the unit_pricing_measure of this ItemSnapshot.  # noqa: E501

        The designation, such as size, weight, volume, count, etc., that was used to specify the quantity of the item.  This helps buyers compare prices. <br /><br />For example, the following tells the buyer that the item is 7.99 per 100 grams. <br /><br /><code>\"unitPricingMeasure\": \"100g\",<br /> \"unitPrice\": {<br />&nbsp;&nbsp;\"value\": \"7.99\",<br />&nbsp;&nbsp;\"currency\": \"GBP\"</code>  # noqa: E501

        :return: The unit_pricing_measure of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._unit_pricing_measure

    @unit_pricing_measure.setter
    def unit_pricing_measure(self, unit_pricing_measure):
        """Sets the unit_pricing_measure of this ItemSnapshot.

        The designation, such as size, weight, volume, count, etc., that was used to specify the quantity of the item.  This helps buyers compare prices. <br /><br />For example, the following tells the buyer that the item is 7.99 per 100 grams. <br /><br /><code>\"unitPricingMeasure\": \"100g\",<br /> \"unitPrice\": {<br />&nbsp;&nbsp;\"value\": \"7.99\",<br />&nbsp;&nbsp;\"currency\": \"GBP\"</code>  # noqa: E501

        :param unit_pricing_measure: The unit_pricing_measure of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._unit_pricing_measure = unit_pricing_measure

    @property
    def inferred_epid(self):
        """Gets the inferred_epid of this ItemSnapshot.  # noqa: E501

        The ePID (eBay Product ID of a product in the eBay product catalog) for the item, which has been programmatically determined by eBay using the item's title, aspects, and other data. <br /><br />If the seller actually provided an ePID at listing time for the item, the ePID value is returned in the <b>epid</b> column instead.  # noqa: E501

        :return: The inferred_epid of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._inferred_epid

    @inferred_epid.setter
    def inferred_epid(self, inferred_epid):
        """Sets the inferred_epid of this ItemSnapshot.

        The ePID (eBay Product ID of a product in the eBay product catalog) for the item, which has been programmatically determined by eBay using the item's title, aspects, and other data. <br /><br />If the seller actually provided an ePID at listing time for the item, the ePID value is returned in the <b>epid</b> column instead.  # noqa: E501

        :param inferred_epid: The inferred_epid of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._inferred_epid = inferred_epid

    @property
    def item_creation_date(self):
        """Gets the item_creation_date of this ItemSnapshot.  # noqa: E501

        A timestamp indicating when the item was created. The format is UTC (<code>yyyy-MM-ddThh:mm:ss.sssZ</code>).  # noqa: E501

        :return: The item_creation_date of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._item_creation_date

    @item_creation_date.setter
    def item_creation_date(self, item_creation_date):
        """Sets the item_creation_date of this ItemSnapshot.

        A timestamp indicating when the item was created. The format is UTC (<code>yyyy-MM-ddThh:mm:ss.sssZ</code>).  # noqa: E501

        :param item_creation_date: The item_creation_date of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._item_creation_date = item_creation_date

    @property
    def legacy_item_id(self):
        """Gets the legacy_item_id of this ItemSnapshot.  # noqa: E501

        The unique identifier of the eBay listing that contains the item. This is the traditional/legacy ID that is often seen in the URL of the listing View Item page.  # noqa: E501

        :return: The legacy_item_id of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._legacy_item_id

    @legacy_item_id.setter
    def legacy_item_id(self, legacy_item_id):
        """Sets the legacy_item_id of this ItemSnapshot.

        The unique identifier of the eBay listing that contains the item. This is the traditional/legacy ID that is often seen in the URL of the listing View Item page.  # noqa: E501

        :param legacy_item_id: The legacy_item_id of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._legacy_item_id = legacy_item_id

    @property
    def alerts(self):
        """Gets the alerts of this ItemSnapshot.  # noqa: E501

        A pipe-separated list of alerts available for the item.<br /><br />For example, if the <code>DELAYED_DELIVERY</code> alert was returned for an item, it would indicate a delay in shipping by the seller.  # noqa: E501

        :return: The alerts of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._alerts

    @alerts.setter
    def alerts(self, alerts):
        """Sets the alerts of this ItemSnapshot.

        A pipe-separated list of alerts available for the item.<br /><br />For example, if the <code>DELAYED_DELIVERY</code> alert was returned for an item, it would indicate a delay in shipping by the seller.  # noqa: E501

        :param alerts: The alerts of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._alerts = alerts

    @property
    def seller_account_type(self):
        """Gets the seller_account_type of this ItemSnapshot.  # noqa: E501

        A string value that specifies whether the seller is a business or an individual. This is determined when the seller registers with eBay. If the seller registers for a business account, the value returned in this field will be <code>BUSINESS</code>. If the seller registers for a private account, the value returned in this field will be <code>INDIVIDUAL</code>.<br /><br /><span class=\"tablenote\"><b>Note:</b> This designation is required by the tax laws in some countries.</span><br /><br />This field is returned only on the following sites: EBAY_AT, EBAY_BE, EBAY_CH, EBAY_DE, EBAY_ES, EBAY_FR, EBAY_GB, EBAY_IE, EBAY_IT, and EBAY_PL.<br /><br />Code so that your app gracefully handles any future changes to this list.<br /><br /><b>Valid Values:</b> <code>BUSINESS</code> or <code>INDIVIDUAL</code>  # noqa: E501

        :return: The seller_account_type of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._seller_account_type

    @seller_account_type.setter
    def seller_account_type(self, seller_account_type):
        """Sets the seller_account_type of this ItemSnapshot.

        A string value that specifies whether the seller is a business or an individual. This is determined when the seller registers with eBay. If the seller registers for a business account, the value returned in this field will be <code>BUSINESS</code>. If the seller registers for a private account, the value returned in this field will be <code>INDIVIDUAL</code>.<br /><br /><span class=\"tablenote\"><b>Note:</b> This designation is required by the tax laws in some countries.</span><br /><br />This field is returned only on the following sites: EBAY_AT, EBAY_BE, EBAY_CH, EBAY_DE, EBAY_ES, EBAY_FR, EBAY_GB, EBAY_IE, EBAY_IT, and EBAY_PL.<br /><br />Code so that your app gracefully handles any future changes to this list.<br /><br /><b>Valid Values:</b> <code>BUSINESS</code> or <code>INDIVIDUAL</code>  # noqa: E501

        :param seller_account_type: The seller_account_type of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._seller_account_type = seller_account_type

    @property
    def tyre_label_image_url(self):
        """Gets the tyre_label_image_url of this ItemSnapshot.  # noqa: E501

        The URL to the image that shows the information on the tyre label.  # noqa: E501

        :return: The tyre_label_image_url of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._tyre_label_image_url

    @tyre_label_image_url.setter
    def tyre_label_image_url(self, tyre_label_image_url):
        """Sets the tyre_label_image_url of this ItemSnapshot.

        The URL to the image that shows the information on the tyre label.  # noqa: E501

        :param tyre_label_image_url: The tyre_label_image_url of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._tyre_label_image_url = tyre_label_image_url

    @property
    def age_group(self):
        """Gets the age_group of this ItemSnapshot.  # noqa: E501

        The age group that the product is recommended for. <br /><br /><b>Valid values:</b> <code>newborn</code>, <code>infant</code>, <code>toddler</code>, <code>kids</code>, <code>adult</code>.  # noqa: E501

        :return: The age_group of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._age_group

    @age_group.setter
    def age_group(self, age_group):
        """Sets the age_group of this ItemSnapshot.

        The age group that the product is recommended for. <br /><br /><b>Valid values:</b> <code>newborn</code>, <code>infant</code>, <code>toddler</code>, <code>kids</code>, <code>adult</code>.  # noqa: E501

        :param age_group: The age_group of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._age_group = age_group

    @property
    def color(self):
        """Gets the color of this ItemSnapshot.  # noqa: E501

        The color of the item.  # noqa: E501

        :return: The color of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._color

    @color.setter
    def color(self, color):
        """Sets the color of this ItemSnapshot.

        The color of the item.  # noqa: E501

        :param color: The color of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._color = color

    @property
    def pattern(self):
        """Gets the pattern of this ItemSnapshot.  # noqa: E501

        (Primary Item Aspect) Text describing the pattern used on the item. For example, paisley.<br /><br /><b>Note:</b> All the item aspects, including this aspect, are returned in the localizedAspects container.  # noqa: E501

        :return: The pattern of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._pattern

    @pattern.setter
    def pattern(self, pattern):
        """Sets the pattern of this ItemSnapshot.

        (Primary Item Aspect) Text describing the pattern used on the item. For example, paisley.<br /><br /><b>Note:</b> All the item aspects, including this aspect, are returned in the localizedAspects container.  # noqa: E501

        :param pattern: The pattern of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._pattern = pattern

    @property
    def size(self):
        """Gets the size of this ItemSnapshot.  # noqa: E501

        The size of the item.  # noqa: E501

        :return: The size of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this ItemSnapshot.

        The size of the item.  # noqa: E501

        :param size: The size of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._size = size

    @property
    def gender(self):
        """Gets the gender of this ItemSnapshot.  # noqa: E501

        In cases where items could vary by gender, this specifies which gender the product is for. <br /><br /><b>Valid values:</b> <code>male</code>, <code>female</code>, <code>unisex</code>.  # noqa: E501

        :return: The gender of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._gender

    @gender.setter
    def gender(self, gender):
        """Sets the gender of this ItemSnapshot.

        In cases where items could vary by gender, this specifies which gender the product is for. <br /><br /><b>Valid values:</b> <code>male</code>, <code>female</code>, <code>unisex</code>.  # noqa: E501

        :param gender: The gender of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._gender = gender

    @property
    def material(self):
        """Gets the material of this ItemSnapshot.  # noqa: E501

        The material that the item is made of.  # noqa: E501

        :return: The material of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._material

    @material.setter
    def material(self, material):
        """Sets the material of this ItemSnapshot.

        The material that the item is made of.  # noqa: E501

        :param material: The material of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._material = material

    @property
    def total_units(self):
        """Gets the total_units of this ItemSnapshot.  # noqa: E501

        For an item that is priced by the unit, the total number of units that are on offer. For example, if the item is priced by the meter and 50 cm is on offer, the <b>totalUnits</b> would be 0.5 m.  # noqa: E501

        :return: The total_units of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._total_units

    @total_units.setter
    def total_units(self, total_units):
        """Sets the total_units of this ItemSnapshot.

        For an item that is priced by the unit, the total number of units that are on offer. For example, if the item is priced by the meter and 50 cm is on offer, the <b>totalUnits</b> would be 0.5 m.  # noqa: E501

        :param total_units: The total_units of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._total_units = total_units

    @property
    def default_image_url(self):
        """Gets the default_image_url of this ItemSnapshot.  # noqa: E501

        URL to the gallery or default image of the item. The other images of the item are returned in the <b>additionalImageUrls</b> field.<br /><br /><b>For example</b><br /><br /><code>https://i.ebayimg.com/00/s/M********w/z/W********p/$_1.JPG?set_id=8********F</code>  # noqa: E501

        :return: The default_image_url of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._default_image_url

    @default_image_url.setter
    def default_image_url(self, default_image_url):
        """Sets the default_image_url of this ItemSnapshot.

        URL to the gallery or default image of the item. The other images of the item are returned in the <b>additionalImageUrls</b> field.<br /><br /><b>For example</b><br /><br /><code>https://i.ebayimg.com/00/s/M********w/z/W********p/$_1.JPG?set_id=8********F</code>  # noqa: E501

        :param default_image_url: The default_image_url of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._default_image_url = default_image_url

    @property
    def item_web_url(self):
        """Gets the item_web_url of this ItemSnapshot.  # noqa: E501

        The URL of the View Item page of the item. <br/><br /><b>For example:</b><br /><br /><b>Single SKU:</b><br /><code>https://www.ebay.de/itm/2********0</code><br /><br /><b>MSKU:</b><br /><code>https://www.ebay.com/itm/2********9?var=5********2</code>  # noqa: E501

        :return: The item_web_url of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._item_web_url

    @item_web_url.setter
    def item_web_url(self, item_web_url):
        """Sets the item_web_url of this ItemSnapshot.

        The URL of the View Item page of the item. <br/><br /><b>For example:</b><br /><br /><b>Single SKU:</b><br /><code>https://www.ebay.de/itm/2********0</code><br /><br /><b>MSKU:</b><br /><code>https://www.ebay.com/itm/2********9?var=5********2</code>  # noqa: E501

        :param item_web_url: The item_web_url of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._item_web_url = item_web_url

    @property
    def item_affiliate_web_url(self):
        """Gets the item_affiliate_web_url of this ItemSnapshot.  # noqa: E501

        The URL of the View Item page of the item, with the affiliate tracking ID appended to it.<br /><br /><b>For example</b><br /><br /><code>https://www.ebay.de/itm/2********0?mkevt=1&mkcid=1&mkrid=707-53477-19255-0&campid=CAMPAIGNID&toolid=2***6&customid=CUSTOMID</code>  # noqa: E501

        :return: The item_affiliate_web_url of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._item_affiliate_web_url

    @item_affiliate_web_url.setter
    def item_affiliate_web_url(self, item_affiliate_web_url):
        """Sets the item_affiliate_web_url of this ItemSnapshot.

        The URL of the View Item page of the item, with the affiliate tracking ID appended to it.<br /><br /><b>For example</b><br /><br /><code>https://www.ebay.de/itm/2********0?mkevt=1&mkcid=1&mkrid=707-53477-19255-0&campid=CAMPAIGNID&toolid=2***6&customid=CUSTOMID</code>  # noqa: E501

        :param item_affiliate_web_url: The item_affiliate_web_url of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._item_affiliate_web_url = item_affiliate_web_url

    @property
    def description(self):
        """Gets the description of this ItemSnapshot.  # noqa: E501

        The seller created description of the item.<br /><br /><b>For example:</b><br /><br /><code>Brand-new, unused, and unworn. Not in original packaging.</code>  # noqa: E501

        :return: The description of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ItemSnapshot.

        The seller created description of the item.<br /><br /><b>For example:</b><br /><br /><code>Brand-new, unused, and unworn. Not in original packaging.</code>  # noqa: E501

        :param description: The description of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def change_metadata(self):
        """Gets the change_metadata of this ItemSnapshot.  # noqa: E501

        Status change indicator of the listing.<br /><br /><b>Values:</b> <ul><li><code>PRICE_CHANGE</code></li><li><code>QUANTITY_CHANGE</code></li><li><code>TITLE_CHANGE</code></li><li><code>DELETED</code></li><li><code>NEW</code></li><li><code>ENDED</code></li></ul>  # noqa: E501

        :return: The change_metadata of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._change_metadata

    @change_metadata.setter
    def change_metadata(self, change_metadata):
        """Sets the change_metadata of this ItemSnapshot.

        Status change indicator of the listing.<br /><br /><b>Values:</b> <ul><li><code>PRICE_CHANGE</code></li><li><code>QUANTITY_CHANGE</code></li><li><code>TITLE_CHANGE</code></li><li><code>DELETED</code></li><li><code>NEW</code></li><li><code>ENDED</code></li></ul>  # noqa: E501

        :param change_metadata: The change_metadata of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._change_metadata = change_metadata

    @property
    def eco_participation_fee_value(self):
        """Gets the eco_participation_fee_value of this ItemSnapshot.  # noqa: E501

        The amount of the Eco Participation Fee, a fee paid toward the eventual disposal of the purchased item.  # noqa: E501

        :return: The eco_participation_fee_value of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._eco_participation_fee_value

    @eco_participation_fee_value.setter
    def eco_participation_fee_value(self, eco_participation_fee_value):
        """Sets the eco_participation_fee_value of this ItemSnapshot.

        The amount of the Eco Participation Fee, a fee paid toward the eventual disposal of the purchased item.  # noqa: E501

        :param eco_participation_fee_value: The eco_participation_fee_value of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._eco_participation_fee_value = eco_participation_fee_value

    @property
    def eco_participation_fee_currency(self):
        """Gets the eco_participation_fee_currency of this ItemSnapshot.  # noqa: E501

        The currency in which the Eco Participation Fee for the item is paid.  # noqa: E501

        :return: The eco_participation_fee_currency of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._eco_participation_fee_currency

    @eco_participation_fee_currency.setter
    def eco_participation_fee_currency(self, eco_participation_fee_currency):
        """Sets the eco_participation_fee_currency of this ItemSnapshot.

        The currency in which the Eco Participation Fee for the item is paid.  # noqa: E501

        :param eco_participation_fee_currency: The eco_participation_fee_currency of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._eco_participation_fee_currency = eco_participation_fee_currency

    @property
    def take_back_policy_label(self):
        """Gets the take_back_policy_label of this ItemSnapshot.  # noqa: E501

        The seller-defined label of the TAKE_BACK custom policy for the item. A TAKE_BACK policy describes the seller's regulatory responsibility to take back a purchased item for disposal when the buyer purchases a new one.  # noqa: E501

        :return: The take_back_policy_label of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._take_back_policy_label

    @take_back_policy_label.setter
    def take_back_policy_label(self, take_back_policy_label):
        """Sets the take_back_policy_label of this ItemSnapshot.

        The seller-defined label of the TAKE_BACK custom policy for the item. A TAKE_BACK policy describes the seller's regulatory responsibility to take back a purchased item for disposal when the buyer purchases a new one.  # noqa: E501

        :param take_back_policy_label: The take_back_policy_label of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._take_back_policy_label = take_back_policy_label

    @property
    def take_back_policy_description(self):
        """Gets the take_back_policy_description of this ItemSnapshot.  # noqa: E501

        The seller-defined description of the TAKE_BACK custom policy for the item.  # noqa: E501

        :return: The take_back_policy_description of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._take_back_policy_description

    @take_back_policy_description.setter
    def take_back_policy_description(self, take_back_policy_description):
        """Sets the take_back_policy_description of this ItemSnapshot.

        The seller-defined description of the TAKE_BACK custom policy for the item.  # noqa: E501

        :param take_back_policy_description: The take_back_policy_description of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._take_back_policy_description = take_back_policy_description

    @property
    def authenticity_guarantee_service_id(self):
        """Gets the authenticity_guarantee_service_id of this ItemSnapshot.  # noqa: E501

        The unique identifier for the Authenticity Guarantee service associated with the item.  # noqa: E501

        :return: The authenticity_guarantee_service_id of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._authenticity_guarantee_service_id

    @authenticity_guarantee_service_id.setter
    def authenticity_guarantee_service_id(self, authenticity_guarantee_service_id):
        """Sets the authenticity_guarantee_service_id of this ItemSnapshot.

        The unique identifier for the Authenticity Guarantee service associated with the item.  # noqa: E501

        :param authenticity_guarantee_service_id: The authenticity_guarantee_service_id of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._authenticity_guarantee_service_id = authenticity_guarantee_service_id

    @property
    def authenticity_guarantee_selection(self):
        """Gets the authenticity_guarantee_selection of this ItemSnapshot.  # noqa: E501

        An indication of whether the Authenticity Guarantee service is optional or mandatory for the item. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:OptionalityEnum'>eBay API documentation</a>  # noqa: E501

        :return: The authenticity_guarantee_selection of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._authenticity_guarantee_selection

    @authenticity_guarantee_selection.setter
    def authenticity_guarantee_selection(self, authenticity_guarantee_selection):
        """Sets the authenticity_guarantee_selection of this ItemSnapshot.

        An indication of whether the Authenticity Guarantee service is optional or mandatory for the item. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/buy/feed/types/api:OptionalityEnum'>eBay API documentation</a>  # noqa: E501

        :param authenticity_guarantee_selection: The authenticity_guarantee_selection of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._authenticity_guarantee_selection = authenticity_guarantee_selection

    @property
    def authenticity_guarantee_fee_value(self):
        """Gets the authenticity_guarantee_fee_value of this ItemSnapshot.  # noqa: E501

        The price of the Authenticity Guarantee service for the item.<br /><br /><span class=\"tablenote\"><span style=\"color:#004680\"><strong>Note:</strong></span> The price returned in this field indicates the service fee for a single item quantity.</span>  # noqa: E501

        :return: The authenticity_guarantee_fee_value of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._authenticity_guarantee_fee_value

    @authenticity_guarantee_fee_value.setter
    def authenticity_guarantee_fee_value(self, authenticity_guarantee_fee_value):
        """Sets the authenticity_guarantee_fee_value of this ItemSnapshot.

        The price of the Authenticity Guarantee service for the item.<br /><br /><span class=\"tablenote\"><span style=\"color:#004680\"><strong>Note:</strong></span> The price returned in this field indicates the service fee for a single item quantity.</span>  # noqa: E501

        :param authenticity_guarantee_fee_value: The authenticity_guarantee_fee_value of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._authenticity_guarantee_fee_value = authenticity_guarantee_fee_value

    @property
    def authenticity_guarantee_fee_currency(self):
        """Gets the authenticity_guarantee_fee_currency of this ItemSnapshot.  # noqa: E501

        The currency used for the Authenticity Guarantee service fee.  # noqa: E501

        :return: The authenticity_guarantee_fee_currency of this ItemSnapshot.  # noqa: E501
        :rtype: str
        """
        return self._authenticity_guarantee_fee_currency

    @authenticity_guarantee_fee_currency.setter
    def authenticity_guarantee_fee_currency(self, authenticity_guarantee_fee_currency):
        """Sets the authenticity_guarantee_fee_currency of this ItemSnapshot.

        The currency used for the Authenticity Guarantee service fee.  # noqa: E501

        :param authenticity_guarantee_fee_currency: The authenticity_guarantee_fee_currency of this ItemSnapshot.  # noqa: E501
        :type: str
        """

        self._authenticity_guarantee_fee_currency = authenticity_guarantee_fee_currency

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ItemSnapshot, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ItemSnapshot):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
