# coding: utf-8

"""
    Buy Marketing API

    The Marketing API retrieves eBay products based on a metric, such as Best Selling, as well as products that were also bought and also viewed.  # noqa: E501

    OpenAPI spec version: v1_beta.2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class MerchandisedProduct(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'average_rating': 'str',
        'epid': 'str',
        'image': 'Image',
        'market_price_details': 'list[MarketPriceDetail]',
        'rating_aspects': 'list[RatingAspect]',
        'rating_count': 'int',
        'review_count': 'int',
        'title': 'str'
    }

    attribute_map = {
        'average_rating': 'averageRating',
        'epid': 'epid',
        'image': 'image',
        'market_price_details': 'marketPriceDetails',
        'rating_aspects': 'ratingAspects',
        'rating_count': 'ratingCount',
        'review_count': 'reviewCount',
        'title': 'title'
    }

    def __init__(self, average_rating=None, epid=None, image=None, market_price_details=None, rating_aspects=None, rating_count=None, review_count=None, title=None):  # noqa: E501
        """MerchandisedProduct - a model defined in Swagger"""  # noqa: E501
        self._average_rating = None
        self._epid = None
        self._image = None
        self._market_price_details = None
        self._rating_aspects = None
        self._rating_count = None
        self._review_count = None
        self._title = None
        self.discriminator = None
        if average_rating is not None:
            self.average_rating = average_rating
        if epid is not None:
            self.epid = epid
        if image is not None:
            self.image = image
        if market_price_details is not None:
            self.market_price_details = market_price_details
        if rating_aspects is not None:
            self.rating_aspects = rating_aspects
        if rating_count is not None:
            self.rating_count = rating_count
        if review_count is not None:
            self.review_count = review_count
        if title is not None:
            self.title = title

    @property
    def average_rating(self):
        """Gets the average_rating of this MerchandisedProduct.  # noqa: E501

        The average rating for the product based on eBay user ratings.  # noqa: E501

        :return: The average_rating of this MerchandisedProduct.  # noqa: E501
        :rtype: str
        """
        return self._average_rating

    @average_rating.setter
    def average_rating(self, average_rating):
        """Sets the average_rating of this MerchandisedProduct.

        The average rating for the product based on eBay user ratings.  # noqa: E501

        :param average_rating: The average_rating of this MerchandisedProduct.  # noqa: E501
        :type: str
        """

        self._average_rating = average_rating

    @property
    def epid(self):
        """Gets the epid of this MerchandisedProduct.  # noqa: E501

        The eBay product identifier of a product from the eBay product catalog. You can use this value in the Browse API <b>search</b> method to retrieve items for this product.  # noqa: E501

        :return: The epid of this MerchandisedProduct.  # noqa: E501
        :rtype: str
        """
        return self._epid

    @epid.setter
    def epid(self, epid):
        """Sets the epid of this MerchandisedProduct.

        The eBay product identifier of a product from the eBay product catalog. You can use this value in the Browse API <b>search</b> method to retrieve items for this product.  # noqa: E501

        :param epid: The epid of this MerchandisedProduct.  # noqa: E501
        :type: str
        """

        self._epid = epid

    @property
    def image(self):
        """Gets the image of this MerchandisedProduct.  # noqa: E501


        :return: The image of this MerchandisedProduct.  # noqa: E501
        :rtype: Image
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this MerchandisedProduct.


        :param image: The image of this MerchandisedProduct.  # noqa: E501
        :type: Image
        """

        self._image = image

    @property
    def market_price_details(self):
        """Gets the market_price_details of this MerchandisedProduct.  # noqa: E501

        An array of containers for the product market price details, such as condition and market price.  # noqa: E501

        :return: The market_price_details of this MerchandisedProduct.  # noqa: E501
        :rtype: list[MarketPriceDetail]
        """
        return self._market_price_details

    @market_price_details.setter
    def market_price_details(self, market_price_details):
        """Sets the market_price_details of this MerchandisedProduct.

        An array of containers for the product market price details, such as condition and market price.  # noqa: E501

        :param market_price_details: The market_price_details of this MerchandisedProduct.  # noqa: E501
        :type: list[MarketPriceDetail]
        """

        self._market_price_details = market_price_details

    @property
    def rating_aspects(self):
        """Gets the rating_aspects of this MerchandisedProduct.  # noqa: E501

        An array of containers for ratings of the product aspects, such as \"Is it a good value\".  # noqa: E501

        :return: The rating_aspects of this MerchandisedProduct.  # noqa: E501
        :rtype: list[RatingAspect]
        """
        return self._rating_aspects

    @rating_aspects.setter
    def rating_aspects(self, rating_aspects):
        """Sets the rating_aspects of this MerchandisedProduct.

        An array of containers for ratings of the product aspects, such as \"Is it a good value\".  # noqa: E501

        :param rating_aspects: The rating_aspects of this MerchandisedProduct.  # noqa: E501
        :type: list[RatingAspect]
        """

        self._rating_aspects = rating_aspects

    @property
    def rating_count(self):
        """Gets the rating_count of this MerchandisedProduct.  # noqa: E501

        The total number of eBay users that rated the product.  # noqa: E501

        :return: The rating_count of this MerchandisedProduct.  # noqa: E501
        :rtype: int
        """
        return self._rating_count

    @rating_count.setter
    def rating_count(self, rating_count):
        """Sets the rating_count of this MerchandisedProduct.

        The total number of eBay users that rated the product.  # noqa: E501

        :param rating_count: The rating_count of this MerchandisedProduct.  # noqa: E501
        :type: int
        """

        self._rating_count = rating_count

    @property
    def review_count(self):
        """Gets the review_count of this MerchandisedProduct.  # noqa: E501

        The total number of eBay users that wrote a review for the product.   # noqa: E501

        :return: The review_count of this MerchandisedProduct.  # noqa: E501
        :rtype: int
        """
        return self._review_count

    @review_count.setter
    def review_count(self, review_count):
        """Sets the review_count of this MerchandisedProduct.

        The total number of eBay users that wrote a review for the product.   # noqa: E501

        :param review_count: The review_count of this MerchandisedProduct.  # noqa: E501
        :type: int
        """

        self._review_count = review_count

    @property
    def title(self):
        """Gets the title of this MerchandisedProduct.  # noqa: E501

        The title of the product.  # noqa: E501

        :return: The title of this MerchandisedProduct.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this MerchandisedProduct.

        The title of the product.  # noqa: E501

        :param title: The title of this MerchandisedProduct.  # noqa: E501
        :type: str
        """

        self._title = title

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(MerchandisedProduct, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MerchandisedProduct):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
