# coding: utf-8

"""
    Taxonomy API

    Use the Taxonomy API to discover the most appropriate eBay categories under which sellers can offer inventory items for sale, and the most likely categories under which buyers can browse or search for items to purchase. In addition, the Taxonomy API provides metadata about the required and recommended category aspects to include in listings, and also has two operations to retrieve parts compatibility information.  # noqa: E501

    OpenAPI spec version: v1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class CompatibilityProperty(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'localized_name': 'str'
    }

    attribute_map = {
        'name': 'name',
        'localized_name': 'localizedName'
    }

    def __init__(self, name=None, localized_name=None):  # noqa: E501
        """CompatibilityProperty - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._localized_name = None
        self.discriminator = None
        if name is not None:
            self.name = name
        if localized_name is not None:
            self.localized_name = localized_name

    @property
    def name(self):
        """Gets the name of this CompatibilityProperty.  # noqa: E501

        This is the actual name of the compatible vehicle property as it is known on the specified eBay marketplace and in the eBay category. This is the string value that should be used in the <strong>compatibility_property</strong> and <strong>filter</strong> query parameters of a <strong>getCompatibilityPropertyValues</strong> request URI. <br/><br/> Typical vehicle properties are 'Make', 'Model', 'Year', 'Engine', and 'Trim', but will vary based on the eBay marketplace and the eBay category.  # noqa: E501

        :return: The name of this CompatibilityProperty.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CompatibilityProperty.

        This is the actual name of the compatible vehicle property as it is known on the specified eBay marketplace and in the eBay category. This is the string value that should be used in the <strong>compatibility_property</strong> and <strong>filter</strong> query parameters of a <strong>getCompatibilityPropertyValues</strong> request URI. <br/><br/> Typical vehicle properties are 'Make', 'Model', 'Year', 'Engine', and 'Trim', but will vary based on the eBay marketplace and the eBay category.  # noqa: E501

        :param name: The name of this CompatibilityProperty.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def localized_name(self):
        """Gets the localized_name of this CompatibilityProperty.  # noqa: E501

        This is the localized name of the compatible vehicle property. The language that is used will depend on the user making the call, or based on the language specified if the <strong>Content-Language</strong> HTTP header is used.<br/><br/>In some instances, the string value in this field may be the same as the string in the corresponding <strong>name</strong> field.  # noqa: E501

        :return: The localized_name of this CompatibilityProperty.  # noqa: E501
        :rtype: str
        """
        return self._localized_name

    @localized_name.setter
    def localized_name(self, localized_name):
        """Sets the localized_name of this CompatibilityProperty.

        This is the localized name of the compatible vehicle property. The language that is used will depend on the user making the call, or based on the language specified if the <strong>Content-Language</strong> HTTP header is used.<br/><br/>In some instances, the string value in this field may be the same as the string in the corresponding <strong>name</strong> field.  # noqa: E501

        :param localized_name: The localized_name of this CompatibilityProperty.  # noqa: E501
        :type: str
        """

        self._localized_name = localized_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CompatibilityProperty, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CompatibilityProperty):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
