# coding: utf-8

"""
    Account API

    The <b>Account API</b> gives sellers the ability to configure their eBay seller accounts, including the seller's policies (eBay business policies and seller-defined custom policies), opt in and out of eBay seller programs, configure sales tax tables, and get account information.  <br/><br/>For details on the availability of the methods in this API, see <a href=\"/api-docs/sell/account/overview.html#requirements\">Account API requirements and restrictions</a>.  # noqa: E501

    OpenAPI spec version: v1.7.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ...sell_account.api_client import ApiClient


class PaymentsProgramApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_payments_program(self, marketplace_id, payments_program_type, **kwargs):  # noqa: E501
        """get_payments_program  # noqa: E501

        <span class=\"tablenote\"><b>Note:</b> This method is no longer applicable, as all seller accounts globally have been enabled for the new eBay payment and checkout flow.</span><br/><br/>This method returns whether or not the user is opted-in to the specified payments program. Sellers opt-in to payments programs by marketplace and you use the <b>marketplace_id</b> path parameter to specify the marketplace of the status flag you want returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payments_program(marketplace_id, payments_program_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str marketplace_id: This path parameter specifies the eBay marketplace of the payments program for which you want to retrieve the seller's status. (required)
        :param str payments_program_type: This path parameter specifies the payments program whose status is returned by the call. (required)
        :return: PaymentsProgramResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_payments_program_with_http_info(marketplace_id, payments_program_type, **kwargs)  # noqa: E501
        else:
            (data) = self.get_payments_program_with_http_info(marketplace_id, payments_program_type, **kwargs)  # noqa: E501
            return data

    def get_payments_program_with_http_info(self, marketplace_id, payments_program_type, **kwargs):  # noqa: E501
        """get_payments_program  # noqa: E501

        <span class=\"tablenote\"><b>Note:</b> This method is no longer applicable, as all seller accounts globally have been enabled for the new eBay payment and checkout flow.</span><br/><br/>This method returns whether or not the user is opted-in to the specified payments program. Sellers opt-in to payments programs by marketplace and you use the <b>marketplace_id</b> path parameter to specify the marketplace of the status flag you want returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payments_program_with_http_info(marketplace_id, payments_program_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str marketplace_id: This path parameter specifies the eBay marketplace of the payments program for which you want to retrieve the seller's status. (required)
        :param str payments_program_type: This path parameter specifies the payments program whose status is returned by the call. (required)
        :return: PaymentsProgramResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['marketplace_id', 'payments_program_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payments_program" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'marketplace_id' is set
        if ('marketplace_id' not in params or
                params['marketplace_id'] is None):
            raise ValueError("Missing the required parameter `marketplace_id` when calling `get_payments_program`")  # noqa: E501
        # verify the required parameter 'payments_program_type' is set
        if ('payments_program_type' not in params or
                params['payments_program_type'] is None):
            raise ValueError("Missing the required parameter `payments_program_type` when calling `get_payments_program`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'marketplace_id' in params:
            path_params['marketplace_id'] = params['marketplace_id']  # noqa: E501
        if 'payments_program_type' in params:
            path_params['payments_program_type'] = params['payments_program_type']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_auth']  # noqa: E501

        return self.api_client.call_api(
            '/payments_program/{marketplace_id}/{payments_program_type}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaymentsProgramResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
