# coding: utf-8

# flake8: noqa
"""
     Seller Service Metrics API 

    The <i>Analytics API</i> provides data and information about a seller and their eBay business.  <br><br>The resources and methods in this API let sellers review information on their listing performance, metrics on their customer service performance, and details on their eBay seller performance rating.  <br><br>The three resources in the Analytics API provide the following data and information: <ul><li><b>Customer Service Metric</b> &ndash; Returns benchmark data and a metric rating pertaining to a seller's customer service performance as compared to other seller's in the same peer group.</li> <li><b>Traffic Report</b> &ndash; Returns data and information that shows how buyers are engaging with a seller's listings.</li> <li><b>Seller Standards Profile</b> &ndash; Returns information pertaining to a seller's profile rating.</li></ul> Sellers can use the data and information returned by the various Analytics API methods to determine where they can make improvements to increase sales and how they might improve their seller status as viewed by eBay buyers.  <br><br>For details on using this API, see <a href=\"/api-docs/sell/static/performance/analyzing-performance.html\" title=\"Selling Integration Guide\">Analyzing seller performance</a>.  # noqa: E501

    OpenAPI spec version: 1.3.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

# import models into model package
from ...sell_analytics.models.benchmark_metadata import BenchmarkMetadata
from ...sell_analytics.models.cycle import Cycle
from ...sell_analytics.models.definition import Definition
from ...sell_analytics.models.dimension import Dimension
from ...sell_analytics.models.dimension_metric import DimensionMetric
from ...sell_analytics.models.distribution import Distribution
from ...sell_analytics.models.error import Error
from ...sell_analytics.models.error_parameter import ErrorParameter
from ...sell_analytics.models.evaluation_cycle import EvaluationCycle
from ...sell_analytics.models.find_seller_standards_profiles_response import FindSellerStandardsProfilesResponse
from ...sell_analytics.models.get_customer_service_metric_response import GetCustomerServiceMetricResponse
from ...sell_analytics.models.header import Header
from ...sell_analytics.models.metadata import Metadata
from ...sell_analytics.models.metadata_header import MetadataHeader
from ...sell_analytics.models.metadata_record import MetadataRecord
from ...sell_analytics.models.metric import Metric
from ...sell_analytics.models.metric_benchmark import MetricBenchmark
from ...sell_analytics.models.metric_distribution import MetricDistribution
from ...sell_analytics.models.record import Record
from ...sell_analytics.models.report import Report
from ...sell_analytics.models.standards_profile import StandardsProfile
from ...sell_analytics.models.value import Value
