# coding: utf-8

"""
     Seller Service Metrics API 

    The <i>Analytics API</i> provides data and information about a seller and their eBay business.  <br><br>The resources and methods in this API let sellers review information on their listing performance, metrics on their customer service performance, and details on their eBay seller performance rating.  <br><br>The three resources in the Analytics API provide the following data and information: <ul><li><b>Customer Service Metric</b> &ndash; Returns benchmark data and a metric rating pertaining to a seller's customer service performance as compared to other seller's in the same peer group.</li> <li><b>Traffic Report</b> &ndash; Returns data and information that shows how buyers are engaging with a seller's listings.</li> <li><b>Seller Standards Profile</b> &ndash; Returns information pertaining to a seller's profile rating.</li></ul> Sellers can use the data and information returned by the various Analytics API methods to determine where they can make improvements to increase sales and how they might improve their seller status as viewed by eBay buyers.  <br><br>For details on using this API, see <a href=\"/api-docs/sell/static/performance/analyzing-performance.html\" title=\"Selling Integration Guide\">Analyzing seller performance</a>.  # noqa: E501

    OpenAPI spec version: 1.3.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Record(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'dimension_values': 'list[Value]',
        'metric_values': 'list[Value]'
    }

    attribute_map = {
        'dimension_values': 'dimensionValues',
        'metric_values': 'metricValues'
    }

    def __init__(self, dimension_values=None, metric_values=None):  # noqa: E501
        """Record - a model defined in Swagger"""  # noqa: E501
        self._dimension_values = None
        self._metric_values = None
        self.discriminator = None
        if dimension_values is not None:
            self.dimension_values = dimension_values
        if metric_values is not None:
            self.metric_values = metric_values

    @property
    def dimension_values(self):
        """Gets the dimension_values of this Record.  # noqa: E501

        A list where each element contains either the string <code>DAY</code> (if the <b>dimension</b> is <code>DAY</code>), or the listing ID for which the record's metric data is computed. A second array member, <b>applicable</b>, is always <code>true</code> for dimension values.  # noqa: E501

        :return: The dimension_values of this Record.  # noqa: E501
        :rtype: list[Value]
        """
        return self._dimension_values

    @dimension_values.setter
    def dimension_values(self, dimension_values):
        """Sets the dimension_values of this Record.

        A list where each element contains either the string <code>DAY</code> (if the <b>dimension</b> is <code>DAY</code>), or the listing ID for which the record's metric data is computed. A second array member, <b>applicable</b>, is always <code>true</code> for dimension values.  # noqa: E501

        :param dimension_values: The dimension_values of this Record.  # noqa: E501
        :type: list[Value]
        """

        self._dimension_values = dimension_values

    @property
    def metric_values(self):
        """Gets the metric_values of this Record.  # noqa: E501

        A list where each element contains a <b>value</b> field that indicates the record's value for the metric. Each element also contains an <b>applicable</b> field that indicates the veracity of the computed <b>value</b>.   <br><br>Note that there are no metric names or IDs associated with the values returned in this array. The metadata to which these values relate can be found in the <b>key</b> values <metadataKeys</b>. The order of the metric values in this array equals the order of the key values in <b>metadataHeader</b>.  # noqa: E501

        :return: The metric_values of this Record.  # noqa: E501
        :rtype: list[Value]
        """
        return self._metric_values

    @metric_values.setter
    def metric_values(self, metric_values):
        """Sets the metric_values of this Record.

        A list where each element contains a <b>value</b> field that indicates the record's value for the metric. Each element also contains an <b>applicable</b> field that indicates the veracity of the computed <b>value</b>.   <br><br>Note that there are no metric names or IDs associated with the values returned in this array. The metadata to which these values relate can be found in the <b>key</b> values <metadataKeys</b>. The order of the metric values in this array equals the order of the key values in <b>metadataHeader</b>.  # noqa: E501

        :param metric_values: The metric_values of this Record.  # noqa: E501
        :type: list[Value]
        """

        self._metric_values = metric_values

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Record, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Record):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
