# coding: utf-8

"""
    Feed API

    <p>The <strong>Feed API</strong> lets sellers upload input files, download reports and files including their status, filter reports using URI parameters, and retrieve customer service metrics task details.</p>  # noqa: E501

    OpenAPI spec version: v1.3.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class CreateInventoryTaskRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'schema_version': 'str',
        'feed_type': 'str',
        'filter_criteria': 'InventoryFilterCriteria',
        'inventory_file_template': 'str'
    }

    attribute_map = {
        'schema_version': 'schemaVersion',
        'feed_type': 'feedType',
        'filter_criteria': 'filterCriteria',
        'inventory_file_template': 'inventoryFileTemplate'
    }

    def __init__(self, schema_version=None, feed_type=None, filter_criteria=None, inventory_file_template=None):  # noqa: E501
        """CreateInventoryTaskRequest - a model defined in Swagger"""  # noqa: E501
        self._schema_version = None
        self._feed_type = None
        self._filter_criteria = None
        self._inventory_file_template = None
        self.discriminator = None
        if schema_version is not None:
            self.schema_version = schema_version
        if feed_type is not None:
            self.feed_type = feed_type
        if filter_criteria is not None:
            self.filter_criteria = filter_criteria
        if inventory_file_template is not None:
            self.inventory_file_template = inventory_file_template

    @property
    def schema_version(self):
        """Gets the schema_version of this CreateInventoryTaskRequest.  # noqa: E501

        The schemaVersion/version number of the file format (use the schema version of the API to which you are programming): LMS Version Details / Schema Version File Exchange Schema Version  # noqa: E501

        :return: The schema_version of this CreateInventoryTaskRequest.  # noqa: E501
        :rtype: str
        """
        return self._schema_version

    @schema_version.setter
    def schema_version(self, schema_version):
        """Sets the schema_version of this CreateInventoryTaskRequest.

        The schemaVersion/version number of the file format (use the schema version of the API to which you are programming): LMS Version Details / Schema Version File Exchange Schema Version  # noqa: E501

        :param schema_version: The schema_version of this CreateInventoryTaskRequest.  # noqa: E501
        :type: str
        """

        self._schema_version = schema_version

    @property
    def feed_type(self):
        """Gets the feed_type of this CreateInventoryTaskRequest.  # noqa: E501

        The feed type associated with the inventory task you are about to create. Use a feedType that is available for your API. Presently, only one feed type is available: LMS_ACTIVE_INVENTORY_REPORT  # noqa: E501

        :return: The feed_type of this CreateInventoryTaskRequest.  # noqa: E501
        :rtype: str
        """
        return self._feed_type

    @feed_type.setter
    def feed_type(self, feed_type):
        """Sets the feed_type of this CreateInventoryTaskRequest.

        The feed type associated with the inventory task you are about to create. Use a feedType that is available for your API. Presently, only one feed type is available: LMS_ACTIVE_INVENTORY_REPORT  # noqa: E501

        :param feed_type: The feed_type of this CreateInventoryTaskRequest.  # noqa: E501
        :type: str
        """

        self._feed_type = feed_type

    @property
    def filter_criteria(self):
        """Gets the filter_criteria of this CreateInventoryTaskRequest.  # noqa: E501


        :return: The filter_criteria of this CreateInventoryTaskRequest.  # noqa: E501
        :rtype: InventoryFilterCriteria
        """
        return self._filter_criteria

    @filter_criteria.setter
    def filter_criteria(self, filter_criteria):
        """Sets the filter_criteria of this CreateInventoryTaskRequest.


        :param filter_criteria: The filter_criteria of this CreateInventoryTaskRequest.  # noqa: E501
        :type: InventoryFilterCriteria
        """

        self._filter_criteria = filter_criteria

    @property
    def inventory_file_template(self):
        """Gets the inventory_file_template of this CreateInventoryTaskRequest.  # noqa: E501

        The inventory file template used to return specific types of inventory tasks. Presently not applicable for LMS_ACTIVE_INVENTORY_REPORT. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/feed/types/api:InventoryFileTemplateEnum'>eBay API documentation</a>  # noqa: E501

        :return: The inventory_file_template of this CreateInventoryTaskRequest.  # noqa: E501
        :rtype: str
        """
        return self._inventory_file_template

    @inventory_file_template.setter
    def inventory_file_template(self, inventory_file_template):
        """Sets the inventory_file_template of this CreateInventoryTaskRequest.

        The inventory file template used to return specific types of inventory tasks. Presently not applicable for LMS_ACTIVE_INVENTORY_REPORT. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/feed/types/api:InventoryFileTemplateEnum'>eBay API documentation</a>  # noqa: E501

        :param inventory_file_template: The inventory_file_template of this CreateInventoryTaskRequest.  # noqa: E501
        :type: str
        """

        self._inventory_file_template = inventory_file_template

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreateInventoryTaskRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateInventoryTaskRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
