# coding: utf-8

"""
    Feed API

    <p>The <strong>Feed API</strong> lets sellers upload input files, download reports and files including their status, filter reports using URI parameters, and retrieve customer service metrics task details.</p>  # noqa: E501

    OpenAPI spec version: v1.3.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ScheduleTemplateResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'feed_type': 'str',
        'frequency': 'str',
        'name': 'str',
        'schedule_template_id': 'str',
        'status': 'str',
        'supported_configurations': 'list[SupportedConfiguration]'
    }

    attribute_map = {
        'feed_type': 'feedType',
        'frequency': 'frequency',
        'name': 'name',
        'schedule_template_id': 'scheduleTemplateId',
        'status': 'status',
        'supported_configurations': 'supportedConfigurations'
    }

    def __init__(self, feed_type=None, frequency=None, name=None, schedule_template_id=None, status=None, supported_configurations=None):  # noqa: E501
        """ScheduleTemplateResponse - a model defined in Swagger"""  # noqa: E501
        self._feed_type = None
        self._frequency = None
        self._name = None
        self._schedule_template_id = None
        self._status = None
        self._supported_configurations = None
        self.discriminator = None
        if feed_type is not None:
            self.feed_type = feed_type
        if frequency is not None:
            self.frequency = frequency
        if name is not None:
            self.name = name
        if schedule_template_id is not None:
            self.schedule_template_id = schedule_template_id
        if status is not None:
            self.status = status
        if supported_configurations is not None:
            self.supported_configurations = supported_configurations

    @property
    def feed_type(self):
        """Gets the feed_type of this ScheduleTemplateResponse.  # noqa: E501

        The feed type of the schedule template. Note: When calling createSchedule and updateSchedule methods you must match the feed type specified by the schedule template (this feedType).  # noqa: E501

        :return: The feed_type of this ScheduleTemplateResponse.  # noqa: E501
        :rtype: str
        """
        return self._feed_type

    @feed_type.setter
    def feed_type(self, feed_type):
        """Sets the feed_type of this ScheduleTemplateResponse.

        The feed type of the schedule template. Note: When calling createSchedule and updateSchedule methods you must match the feed type specified by the schedule template (this feedType).  # noqa: E501

        :param feed_type: The feed_type of this ScheduleTemplateResponse.  # noqa: E501
        :type: str
        """

        self._feed_type = feed_type

    @property
    def frequency(self):
        """Gets the frequency of this ScheduleTemplateResponse.  # noqa: E501

        This field specifies how often the schedule is generated. If set to HALF_HOUR or ONE_HOUR, you cannot set a preferredTriggerHour using createSchedule or updateSchedule. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/feed/types/api:FrequencyEnum'>eBay API documentation</a>  # noqa: E501

        :return: The frequency of this ScheduleTemplateResponse.  # noqa: E501
        :rtype: str
        """
        return self._frequency

    @frequency.setter
    def frequency(self, frequency):
        """Sets the frequency of this ScheduleTemplateResponse.

        This field specifies how often the schedule is generated. If set to HALF_HOUR or ONE_HOUR, you cannot set a preferredTriggerHour using createSchedule or updateSchedule. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/feed/types/api:FrequencyEnum'>eBay API documentation</a>  # noqa: E501

        :param frequency: The frequency of this ScheduleTemplateResponse.  # noqa: E501
        :type: str
        """

        self._frequency = frequency

    @property
    def name(self):
        """Gets the name of this ScheduleTemplateResponse.  # noqa: E501

        The template name provided by the template.  # noqa: E501

        :return: The name of this ScheduleTemplateResponse.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ScheduleTemplateResponse.

        The template name provided by the template.  # noqa: E501

        :param name: The name of this ScheduleTemplateResponse.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def schedule_template_id(self):
        """Gets the schedule_template_id of this ScheduleTemplateResponse.  # noqa: E501

        The ID of the template. Use this ID to create a schedule based on the properties of this schedule template.  # noqa: E501

        :return: The schedule_template_id of this ScheduleTemplateResponse.  # noqa: E501
        :rtype: str
        """
        return self._schedule_template_id

    @schedule_template_id.setter
    def schedule_template_id(self, schedule_template_id):
        """Sets the schedule_template_id of this ScheduleTemplateResponse.

        The ID of the template. Use this ID to create a schedule based on the properties of this schedule template.  # noqa: E501

        :param schedule_template_id: The schedule_template_id of this ScheduleTemplateResponse.  # noqa: E501
        :type: str
        """

        self._schedule_template_id = schedule_template_id

    @property
    def status(self):
        """Gets the status of this ScheduleTemplateResponse.  # noqa: E501

        The present status of the template. You cannot create or modify a schedule using a template with an INACTIVE status. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/feed/types/api:StatusEnum'>eBay API documentation</a>  # noqa: E501

        :return: The status of this ScheduleTemplateResponse.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this ScheduleTemplateResponse.

        The present status of the template. You cannot create or modify a schedule using a template with an INACTIVE status. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/feed/types/api:StatusEnum'>eBay API documentation</a>  # noqa: E501

        :param status: The status of this ScheduleTemplateResponse.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def supported_configurations(self):
        """Gets the supported_configurations of this ScheduleTemplateResponse.  # noqa: E501

        An array of the configuration supported by this template.  # noqa: E501

        :return: The supported_configurations of this ScheduleTemplateResponse.  # noqa: E501
        :rtype: list[SupportedConfiguration]
        """
        return self._supported_configurations

    @supported_configurations.setter
    def supported_configurations(self, supported_configurations):
        """Sets the supported_configurations of this ScheduleTemplateResponse.

        An array of the configuration supported by this template.  # noqa: E501

        :param supported_configurations: The supported_configurations of this ScheduleTemplateResponse.  # noqa: E501
        :type: list[SupportedConfiguration]
        """

        self._supported_configurations = supported_configurations

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ScheduleTemplateResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ScheduleTemplateResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
