# coding: utf-8

"""
    eBay Finances API

    This API is used to retrieve seller payouts and monetary transaction details related to those payouts.  # noqa: E501

    OpenAPI spec version: 1.9.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Charge(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cancellation_id': 'str',
        'case_id': 'str',
        'charge_net_amount': 'Amount',
        'inquiry_id': 'str',
        'order_id': 'str',
        'payment_dispute_id': 'str',
        'refund_id': 'str',
        'return_id': 'str'
    }

    attribute_map = {
        'cancellation_id': 'cancellationId',
        'case_id': 'caseId',
        'charge_net_amount': 'chargeNetAmount',
        'inquiry_id': 'inquiryId',
        'order_id': 'orderId',
        'payment_dispute_id': 'paymentDisputeId',
        'refund_id': 'refundId',
        'return_id': 'returnId'
    }

    def __init__(self, cancellation_id=None, case_id=None, charge_net_amount=None, inquiry_id=None, order_id=None, payment_dispute_id=None, refund_id=None, return_id=None):  # noqa: E501
        """Charge - a model defined in Swagger"""  # noqa: E501
        self._cancellation_id = None
        self._case_id = None
        self._charge_net_amount = None
        self._inquiry_id = None
        self._order_id = None
        self._payment_dispute_id = None
        self._refund_id = None
        self._return_id = None
        self.discriminator = None
        if cancellation_id is not None:
            self.cancellation_id = cancellation_id
        if case_id is not None:
            self.case_id = case_id
        if charge_net_amount is not None:
            self.charge_net_amount = charge_net_amount
        if inquiry_id is not None:
            self.inquiry_id = inquiry_id
        if order_id is not None:
            self.order_id = order_id
        if payment_dispute_id is not None:
            self.payment_dispute_id = payment_dispute_id
        if refund_id is not None:
            self.refund_id = refund_id
        if return_id is not None:
            self.return_id = return_id

    @property
    def cancellation_id(self):
        """Gets the cancellation_id of this Charge.  # noqa: E501

        The unique identifier of an order cancellation. This field is only applicable and returned if the charge is related to an order  cancellation.  # noqa: E501

        :return: The cancellation_id of this Charge.  # noqa: E501
        :rtype: str
        """
        return self._cancellation_id

    @cancellation_id.setter
    def cancellation_id(self, cancellation_id):
        """Sets the cancellation_id of this Charge.

        The unique identifier of an order cancellation. This field is only applicable and returned if the charge is related to an order  cancellation.  # noqa: E501

        :param cancellation_id: The cancellation_id of this Charge.  # noqa: E501
        :type: str
        """

        self._cancellation_id = cancellation_id

    @property
    def case_id(self):
        """Gets the case_id of this Charge.  # noqa: E501

        The unique identifier of a case filed against an order. This field is only applicable and returned if the charge is related to a case filed against an order.  # noqa: E501

        :return: The case_id of this Charge.  # noqa: E501
        :rtype: str
        """
        return self._case_id

    @case_id.setter
    def case_id(self, case_id):
        """Sets the case_id of this Charge.

        The unique identifier of a case filed against an order. This field is only applicable and returned if the charge is related to a case filed against an order.  # noqa: E501

        :param case_id: The case_id of this Charge.  # noqa: E501
        :type: str
        """

        self._case_id = case_id

    @property
    def charge_net_amount(self):
        """Gets the charge_net_amount of this Charge.  # noqa: E501


        :return: The charge_net_amount of this Charge.  # noqa: E501
        :rtype: Amount
        """
        return self._charge_net_amount

    @charge_net_amount.setter
    def charge_net_amount(self, charge_net_amount):
        """Sets the charge_net_amount of this Charge.


        :param charge_net_amount: The charge_net_amount of this Charge.  # noqa: E501
        :type: Amount
        """

        self._charge_net_amount = charge_net_amount

    @property
    def inquiry_id(self):
        """Gets the inquiry_id of this Charge.  # noqa: E501

        The unique identifier of an Item Not Received (INR) inquiry filed against an order. This field is only applicable and returned if the charge is related to has an INR inquiry filed against the order.  # noqa: E501

        :return: The inquiry_id of this Charge.  # noqa: E501
        :rtype: str
        """
        return self._inquiry_id

    @inquiry_id.setter
    def inquiry_id(self, inquiry_id):
        """Sets the inquiry_id of this Charge.

        The unique identifier of an Item Not Received (INR) inquiry filed against an order. This field is only applicable and returned if the charge is related to has an INR inquiry filed against the order.  # noqa: E501

        :param inquiry_id: The inquiry_id of this Charge.  # noqa: E501
        :type: str
        """

        self._inquiry_id = inquiry_id

    @property
    def order_id(self):
        """Gets the order_id of this Charge.  # noqa: E501

        The unique identifier of the order that is associated with the charge.  # noqa: E501

        :return: The order_id of this Charge.  # noqa: E501
        :rtype: str
        """
        return self._order_id

    @order_id.setter
    def order_id(self, order_id):
        """Sets the order_id of this Charge.

        The unique identifier of the order that is associated with the charge.  # noqa: E501

        :param order_id: The order_id of this Charge.  # noqa: E501
        :type: str
        """

        self._order_id = order_id

    @property
    def payment_dispute_id(self):
        """Gets the payment_dispute_id of this Charge.  # noqa: E501

        The unique identifier of a third-party payment dispute filed against an order. This occurs when the buyer files a dispute against the order with their payment provider, and then the dispute comes into eBay's system. This field is only applicable and returned if the charge is related to a third-party payment dispute filed against an order.  # noqa: E501

        :return: The payment_dispute_id of this Charge.  # noqa: E501
        :rtype: str
        """
        return self._payment_dispute_id

    @payment_dispute_id.setter
    def payment_dispute_id(self, payment_dispute_id):
        """Sets the payment_dispute_id of this Charge.

        The unique identifier of a third-party payment dispute filed against an order. This occurs when the buyer files a dispute against the order with their payment provider, and then the dispute comes into eBay's system. This field is only applicable and returned if the charge is related to a third-party payment dispute filed against an order.  # noqa: E501

        :param payment_dispute_id: The payment_dispute_id of this Charge.  # noqa: E501
        :type: str
        """

        self._payment_dispute_id = payment_dispute_id

    @property
    def refund_id(self):
        """Gets the refund_id of this Charge.  # noqa: E501

        The unique identifier of a buyer refund associated with the charge.  # noqa: E501

        :return: The refund_id of this Charge.  # noqa: E501
        :rtype: str
        """
        return self._refund_id

    @refund_id.setter
    def refund_id(self, refund_id):
        """Sets the refund_id of this Charge.

        The unique identifier of a buyer refund associated with the charge.  # noqa: E501

        :param refund_id: The refund_id of this Charge.  # noqa: E501
        :type: str
        """

        self._refund_id = refund_id

    @property
    def return_id(self):
        """Gets the return_id of this Charge.  # noqa: E501

        The unique identifier of an order return. This field is only applicable and returned if the charge is related to an order that was returned by the buyer.  # noqa: E501

        :return: The return_id of this Charge.  # noqa: E501
        :rtype: str
        """
        return self._return_id

    @return_id.setter
    def return_id(self, return_id):
        """Sets the return_id of this Charge.

        The unique identifier of an order return. This field is only applicable and returned if the charge is related to an order that was returned by the buyer.  # noqa: E501

        :param return_id: The return_id of this Charge.  # noqa: E501
        :type: str
        """

        self._return_id = return_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Charge, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Charge):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
