# coding: utf-8

"""
    eBay Finances API

    This API is used to retrieve seller payouts and monetary transaction details related to those payouts.  # noqa: E501

    OpenAPI spec version: 1.9.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Transaction(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'amount': 'Amount',
        'booking_entry': 'str',
        'buyer': 'Buyer',
        'fee_type': 'str',
        'order_id': 'str',
        'order_line_items': 'list[OrderLineItem]',
        'payments_entity': 'str',
        'payout_id': 'str',
        'references': 'list[Reference]',
        'sales_record_reference': 'str',
        'total_fee_basis_amount': 'Amount',
        'total_fee_amount': 'Amount',
        'transaction_date': 'str',
        'transaction_id': 'str',
        'transaction_memo': 'str',
        'transaction_status': 'str',
        'transaction_type': 'str'
    }

    attribute_map = {
        'amount': 'amount',
        'booking_entry': 'bookingEntry',
        'buyer': 'buyer',
        'fee_type': 'feeType',
        'order_id': 'orderId',
        'order_line_items': 'orderLineItems',
        'payments_entity': 'paymentsEntity',
        'payout_id': 'payoutId',
        'references': 'references',
        'sales_record_reference': 'salesRecordReference',
        'total_fee_basis_amount': 'totalFeeBasisAmount',
        'total_fee_amount': 'totalFeeAmount',
        'transaction_date': 'transactionDate',
        'transaction_id': 'transactionId',
        'transaction_memo': 'transactionMemo',
        'transaction_status': 'transactionStatus',
        'transaction_type': 'transactionType'
    }

    def __init__(self, amount=None, booking_entry=None, buyer=None, fee_type=None, order_id=None, order_line_items=None, payments_entity=None, payout_id=None, references=None, sales_record_reference=None, total_fee_basis_amount=None, total_fee_amount=None, transaction_date=None, transaction_id=None, transaction_memo=None, transaction_status=None, transaction_type=None):  # noqa: E501
        """Transaction - a model defined in Swagger"""  # noqa: E501
        self._amount = None
        self._booking_entry = None
        self._buyer = None
        self._fee_type = None
        self._order_id = None
        self._order_line_items = None
        self._payments_entity = None
        self._payout_id = None
        self._references = None
        self._sales_record_reference = None
        self._total_fee_basis_amount = None
        self._total_fee_amount = None
        self._transaction_date = None
        self._transaction_id = None
        self._transaction_memo = None
        self._transaction_status = None
        self._transaction_type = None
        self.discriminator = None
        if amount is not None:
            self.amount = amount
        if booking_entry is not None:
            self.booking_entry = booking_entry
        if buyer is not None:
            self.buyer = buyer
        if fee_type is not None:
            self.fee_type = fee_type
        if order_id is not None:
            self.order_id = order_id
        if order_line_items is not None:
            self.order_line_items = order_line_items
        if payments_entity is not None:
            self.payments_entity = payments_entity
        if payout_id is not None:
            self.payout_id = payout_id
        if references is not None:
            self.references = references
        if sales_record_reference is not None:
            self.sales_record_reference = sales_record_reference
        if total_fee_basis_amount is not None:
            self.total_fee_basis_amount = total_fee_basis_amount
        if total_fee_amount is not None:
            self.total_fee_amount = total_fee_amount
        if transaction_date is not None:
            self.transaction_date = transaction_date
        if transaction_id is not None:
            self.transaction_id = transaction_id
        if transaction_memo is not None:
            self.transaction_memo = transaction_memo
        if transaction_status is not None:
            self.transaction_status = transaction_status
        if transaction_type is not None:
            self.transaction_type = transaction_type

    @property
    def amount(self):
        """Gets the amount of this Transaction.  # noqa: E501


        :return: The amount of this Transaction.  # noqa: E501
        :rtype: Amount
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this Transaction.


        :param amount: The amount of this Transaction.  # noqa: E501
        :type: Amount
        """

        self._amount = amount

    @property
    def booking_entry(self):
        """Gets the booking_entry of this Transaction.  # noqa: E501

        The enumeration value returned in this field indicates if the monetary transaction amount is a (<code>CREDIT</code>) or a (<code>DEBIT</code>) to the seller's account. Typically, the <code>SALE</code> and <code>CREDIT</code> transaction types are credits to the seller's account, and the <code>REFUND</code>, <code>DISPUTE</code>, <code>SHIPPING_LABEL</code>, and <code>TRANSFER</code> transaction types are debits to the seller's account. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:BookingEntryEnum'>eBay API documentation</a>  # noqa: E501

        :return: The booking_entry of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._booking_entry

    @booking_entry.setter
    def booking_entry(self, booking_entry):
        """Sets the booking_entry of this Transaction.

        The enumeration value returned in this field indicates if the monetary transaction amount is a (<code>CREDIT</code>) or a (<code>DEBIT</code>) to the seller's account. Typically, the <code>SALE</code> and <code>CREDIT</code> transaction types are credits to the seller's account, and the <code>REFUND</code>, <code>DISPUTE</code>, <code>SHIPPING_LABEL</code>, and <code>TRANSFER</code> transaction types are debits to the seller's account. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:BookingEntryEnum'>eBay API documentation</a>  # noqa: E501

        :param booking_entry: The booking_entry of this Transaction.  # noqa: E501
        :type: str
        """

        self._booking_entry = booking_entry

    @property
    def buyer(self):
        """Gets the buyer of this Transaction.  # noqa: E501


        :return: The buyer of this Transaction.  # noqa: E501
        :rtype: Buyer
        """
        return self._buyer

    @buyer.setter
    def buyer(self, buyer):
        """Sets the buyer of this Transaction.


        :param buyer: The buyer of this Transaction.  # noqa: E501
        :type: Buyer
        """

        self._buyer = buyer

    @property
    def fee_type(self):
        """Gets the fee_type of this Transaction.  # noqa: E501

        The type of fee. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/api:FeeTypeEnum'>eBay API documentation</a>  # noqa: E501

        :return: The fee_type of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._fee_type

    @fee_type.setter
    def fee_type(self, fee_type):
        """Sets the fee_type of this Transaction.

        The type of fee. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/api:FeeTypeEnum'>eBay API documentation</a>  # noqa: E501

        :param fee_type: The fee_type of this Transaction.  # noqa: E501
        :type: str
        """

        self._fee_type = fee_type

    @property
    def order_id(self):
        """Gets the order_id of this Transaction.  # noqa: E501

        The unique identifier of the eBay order associated with the monetary transaction.  # noqa: E501

        :return: The order_id of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._order_id

    @order_id.setter
    def order_id(self, order_id):
        """Sets the order_id of this Transaction.

        The unique identifier of the eBay order associated with the monetary transaction.  # noqa: E501

        :param order_id: The order_id of this Transaction.  # noqa: E501
        :type: str
        """

        self._order_id = order_id

    @property
    def order_line_items(self):
        """Gets the order_line_items of this Transaction.  # noqa: E501

        This array shows the fees that are deducted from a seller payout for each line item in an order.<br /><br /><span class=\"tablenote\"><strong>Note:</strong> In some cases, a transaction fee might be returned asynchronously from the associated order. In such cases, you can determine the order to which the fee applies by examining the referenceID value of the fee, which should match the ID of the order.</span>  # noqa: E501

        :return: The order_line_items of this Transaction.  # noqa: E501
        :rtype: list[OrderLineItem]
        """
        return self._order_line_items

    @order_line_items.setter
    def order_line_items(self, order_line_items):
        """Sets the order_line_items of this Transaction.

        This array shows the fees that are deducted from a seller payout for each line item in an order.<br /><br /><span class=\"tablenote\"><strong>Note:</strong> In some cases, a transaction fee might be returned asynchronously from the associated order. In such cases, you can determine the order to which the fee applies by examining the referenceID value of the fee, which should match the ID of the order.</span>  # noqa: E501

        :param order_line_items: The order_line_items of this Transaction.  # noqa: E501
        :type: list[OrderLineItem]
        """

        self._order_line_items = order_line_items

    @property
    def payments_entity(self):
        """Gets the payments_entity of this Transaction.  # noqa: E501

        This string value indicates the entity that is processing  the payment.  # noqa: E501

        :return: The payments_entity of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._payments_entity

    @payments_entity.setter
    def payments_entity(self, payments_entity):
        """Sets the payments_entity of this Transaction.

        This string value indicates the entity that is processing  the payment.  # noqa: E501

        :param payments_entity: The payments_entity of this Transaction.  # noqa: E501
        :type: str
        """

        self._payments_entity = payments_entity

    @property
    def payout_id(self):
        """Gets the payout_id of this Transaction.  # noqa: E501

        The unique identifier of the seller payout associated with the monetary transaction. This identifier is generated once eBay begins processing the payout for the corresponding order. This field will not be returned if eBay has not yet begun processing the payout for an order.  # noqa: E501

        :return: The payout_id of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._payout_id

    @payout_id.setter
    def payout_id(self, payout_id):
        """Sets the payout_id of this Transaction.

        The unique identifier of the seller payout associated with the monetary transaction. This identifier is generated once eBay begins processing the payout for the corresponding order. This field will not be returned if eBay has not yet begun processing the payout for an order.  # noqa: E501

        :param payout_id: The payout_id of this Transaction.  # noqa: E501
        :type: str
        """

        self._payout_id = payout_id

    @property
    def references(self):
        """Gets the references of this Transaction.  # noqa: E501

        This field contains reference information for the transaction fee. This includes an ID and the type of ID provided (such as item ID).  # noqa: E501

        :return: The references of this Transaction.  # noqa: E501
        :rtype: list[Reference]
        """
        return self._references

    @references.setter
    def references(self, references):
        """Sets the references of this Transaction.

        This field contains reference information for the transaction fee. This includes an ID and the type of ID provided (such as item ID).  # noqa: E501

        :param references: The references of this Transaction.  # noqa: E501
        :type: list[Reference]
        """

        self._references = references

    @property
    def sales_record_reference(self):
        """Gets the sales_record_reference of this Transaction.  # noqa: E501

        The Sales Record Number associated with a sales order. Sales Record Numbers are Selling Manager/Selling Manager Pro identifiers that are created at order checkout.<br/><br/><span class=\"tablenote\"><strong>Note:</strong> For all orders originating after February 1, 2020, a value of <code>0</code> will be returned in this field. The Sales Record Number field has also been removed from Seller Hub. Instead of <strong>salesRecordReference</strong>, depend on <strong>orderId</strong> instead as the identifier of the order. The <strong>salesRecordReference</strong> field has been scheduled for deprecation, and a date for when this field will no longer be returned at all will be announced soon.</span>  # noqa: E501

        :return: The sales_record_reference of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._sales_record_reference

    @sales_record_reference.setter
    def sales_record_reference(self, sales_record_reference):
        """Sets the sales_record_reference of this Transaction.

        The Sales Record Number associated with a sales order. Sales Record Numbers are Selling Manager/Selling Manager Pro identifiers that are created at order checkout.<br/><br/><span class=\"tablenote\"><strong>Note:</strong> For all orders originating after February 1, 2020, a value of <code>0</code> will be returned in this field. The Sales Record Number field has also been removed from Seller Hub. Instead of <strong>salesRecordReference</strong>, depend on <strong>orderId</strong> instead as the identifier of the order. The <strong>salesRecordReference</strong> field has been scheduled for deprecation, and a date for when this field will no longer be returned at all will be announced soon.</span>  # noqa: E501

        :param sales_record_reference: The sales_record_reference of this Transaction.  # noqa: E501
        :type: str
        """

        self._sales_record_reference = sales_record_reference

    @property
    def total_fee_basis_amount(self):
        """Gets the total_fee_basis_amount of this Transaction.  # noqa: E501


        :return: The total_fee_basis_amount of this Transaction.  # noqa: E501
        :rtype: Amount
        """
        return self._total_fee_basis_amount

    @total_fee_basis_amount.setter
    def total_fee_basis_amount(self, total_fee_basis_amount):
        """Sets the total_fee_basis_amount of this Transaction.


        :param total_fee_basis_amount: The total_fee_basis_amount of this Transaction.  # noqa: E501
        :type: Amount
        """

        self._total_fee_basis_amount = total_fee_basis_amount

    @property
    def total_fee_amount(self):
        """Gets the total_fee_amount of this Transaction.  # noqa: E501


        :return: The total_fee_amount of this Transaction.  # noqa: E501
        :rtype: Amount
        """
        return self._total_fee_amount

    @total_fee_amount.setter
    def total_fee_amount(self, total_fee_amount):
        """Sets the total_fee_amount of this Transaction.


        :param total_fee_amount: The total_fee_amount of this Transaction.  # noqa: E501
        :type: Amount
        """

        self._total_fee_amount = total_fee_amount

    @property
    def transaction_date(self):
        """Gets the transaction_date of this Transaction.  # noqa: E501

        This timestamp indicates when the monetary transaction (order purchase, buyer refund, seller credit) occurred. The following (UTC) format is used: <code>YYYY-MM-DDTHH:MM:SS.SSSZ</code>. For example, <code>2015-08-04T19:09:02.768Z</code>.  # noqa: E501

        :return: The transaction_date of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._transaction_date

    @transaction_date.setter
    def transaction_date(self, transaction_date):
        """Sets the transaction_date of this Transaction.

        This timestamp indicates when the monetary transaction (order purchase, buyer refund, seller credit) occurred. The following (UTC) format is used: <code>YYYY-MM-DDTHH:MM:SS.SSSZ</code>. For example, <code>2015-08-04T19:09:02.768Z</code>.  # noqa: E501

        :param transaction_date: The transaction_date of this Transaction.  # noqa: E501
        :type: str
        """

        self._transaction_date = transaction_date

    @property
    def transaction_id(self):
        """Gets the transaction_id of this Transaction.  # noqa: E501

        The unique identifier of the monetary transaction. A monetary transaction can be a sales order, an order refund to the buyer, a credit to the seller's account, a debit to the seller for the purchase of a shipping label, or a transaction where eBay recouped money from the seller if the seller lost a buyer-initiated payment dispute.  # noqa: E501

        :return: The transaction_id of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(self, transaction_id):
        """Sets the transaction_id of this Transaction.

        The unique identifier of the monetary transaction. A monetary transaction can be a sales order, an order refund to the buyer, a credit to the seller's account, a debit to the seller for the purchase of a shipping label, or a transaction where eBay recouped money from the seller if the seller lost a buyer-initiated payment dispute.  # noqa: E501

        :param transaction_id: The transaction_id of this Transaction.  # noqa: E501
        :type: str
        """

        self._transaction_id = transaction_id

    @property
    def transaction_memo(self):
        """Gets the transaction_memo of this Transaction.  # noqa: E501

        This field provides more details on shipping label transactions and transactions where the funds are being held by eBay. For shipping label transactions, the <b>transactionMemo</b> gives details about a purchase, a refund, or a price adjustment to the cost of the shipping label. For on-hold transactions, the <b>transactionMemo</b> provides information on the reason for the hold or when the hold will be released (e.g., \"Funds on hold. Estimated release on Jun 1\").<br/><br/>This field is only returned if applicable/available.  # noqa: E501

        :return: The transaction_memo of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._transaction_memo

    @transaction_memo.setter
    def transaction_memo(self, transaction_memo):
        """Sets the transaction_memo of this Transaction.

        This field provides more details on shipping label transactions and transactions where the funds are being held by eBay. For shipping label transactions, the <b>transactionMemo</b> gives details about a purchase, a refund, or a price adjustment to the cost of the shipping label. For on-hold transactions, the <b>transactionMemo</b> provides information on the reason for the hold or when the hold will be released (e.g., \"Funds on hold. Estimated release on Jun 1\").<br/><br/>This field is only returned if applicable/available.  # noqa: E501

        :param transaction_memo: The transaction_memo of this Transaction.  # noqa: E501
        :type: str
        """

        self._transaction_memo = transaction_memo

    @property
    def transaction_status(self):
        """Gets the transaction_status of this Transaction.  # noqa: E501

        This enumeration value indicates the current status of the seller payout associated with the monetary transaction. See the <code>TransactionStatusEnum</code> type for more information on the different states. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:TransactionStatusEnum'>eBay API documentation</a>  # noqa: E501

        :return: The transaction_status of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._transaction_status

    @transaction_status.setter
    def transaction_status(self, transaction_status):
        """Sets the transaction_status of this Transaction.

        This enumeration value indicates the current status of the seller payout associated with the monetary transaction. See the <code>TransactionStatusEnum</code> type for more information on the different states. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:TransactionStatusEnum'>eBay API documentation</a>  # noqa: E501

        :param transaction_status: The transaction_status of this Transaction.  # noqa: E501
        :type: str
        """

        self._transaction_status = transaction_status

    @property
    def transaction_type(self):
        """Gets the transaction_type of this Transaction.  # noqa: E501

        This enumeration value indicates the type of monetary transaction. Examples of monetary transactions include a buyer's payment for an order, a refund to the buyer for a returned item or cancelled order, or a credit issued by eBay to the seller's account. For a complete list of monetary transaction types within the <strong>Finances API</strong>, see the <a href=\"/api-docs/sell/finances/types/pay:TransactionTypeEnum\">TransactionTypeEnum</a> type. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:TransactionTypeEnum'>eBay API documentation</a>  # noqa: E501

        :return: The transaction_type of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._transaction_type

    @transaction_type.setter
    def transaction_type(self, transaction_type):
        """Sets the transaction_type of this Transaction.

        This enumeration value indicates the type of monetary transaction. Examples of monetary transactions include a buyer's payment for an order, a refund to the buyer for a returned item or cancelled order, or a credit issued by eBay to the seller's account. For a complete list of monetary transaction types within the <strong>Finances API</strong>, see the <a href=\"/api-docs/sell/finances/types/pay:TransactionTypeEnum\">TransactionTypeEnum</a> type. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:TransactionTypeEnum'>eBay API documentation</a>  # noqa: E501

        :param transaction_type: The transaction_type of this Transaction.  # noqa: E501
        :type: str
        """

        self._transaction_type = transaction_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Transaction, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Transaction):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
