# coding: utf-8

"""
    Fulfillment API

    Use the Fulfillment API to complete the process of packaging, addressing, handling, and shipping each order on behalf of the seller, in accordance with the payment method and timing specified at checkout.  # noqa: E501

    OpenAPI spec version: v1.19.10
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class IssueRefundRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'comment': 'str',
        'order_level_refund_amount': 'SimpleAmount',
        'reason_for_refund': 'str',
        'refund_items': 'list[RefundItem]'
    }

    attribute_map = {
        'comment': 'comment',
        'order_level_refund_amount': 'orderLevelRefundAmount',
        'reason_for_refund': 'reasonForRefund',
        'refund_items': 'refundItems'
    }

    def __init__(self, comment=None, order_level_refund_amount=None, reason_for_refund=None, refund_items=None):  # noqa: E501
        """IssueRefundRequest - a model defined in Swagger"""  # noqa: E501
        self._comment = None
        self._order_level_refund_amount = None
        self._reason_for_refund = None
        self._refund_items = None
        self.discriminator = None
        if comment is not None:
            self.comment = comment
        if order_level_refund_amount is not None:
            self.order_level_refund_amount = order_level_refund_amount
        if reason_for_refund is not None:
            self.reason_for_refund = reason_for_refund
        if refund_items is not None:
            self.refund_items = refund_items

    @property
    def comment(self):
        """Gets the comment of this IssueRefundRequest.  # noqa: E501

        This free-text field allows the seller to clarify why the refund is being issued to the buyer.<br/><br/><b>Max Length</b>: 100  # noqa: E501

        :return: The comment of this IssueRefundRequest.  # noqa: E501
        :rtype: str
        """
        return self._comment

    @comment.setter
    def comment(self, comment):
        """Sets the comment of this IssueRefundRequest.

        This free-text field allows the seller to clarify why the refund is being issued to the buyer.<br/><br/><b>Max Length</b>: 100  # noqa: E501

        :param comment: The comment of this IssueRefundRequest.  # noqa: E501
        :type: str
        """

        self._comment = comment

    @property
    def order_level_refund_amount(self):
        """Gets the order_level_refund_amount of this IssueRefundRequest.  # noqa: E501


        :return: The order_level_refund_amount of this IssueRefundRequest.  # noqa: E501
        :rtype: SimpleAmount
        """
        return self._order_level_refund_amount

    @order_level_refund_amount.setter
    def order_level_refund_amount(self, order_level_refund_amount):
        """Sets the order_level_refund_amount of this IssueRefundRequest.


        :param order_level_refund_amount: The order_level_refund_amount of this IssueRefundRequest.  # noqa: E501
        :type: SimpleAmount
        """

        self._order_level_refund_amount = order_level_refund_amount

    @property
    def reason_for_refund(self):
        """Gets the reason_for_refund of this IssueRefundRequest.  # noqa: E501

        The enumeration value passed into this field indicates the reason for the refund. One of the defined enumeration values in the <b>ReasonForRefundEnum</b> type must be used.<br/><br/>This field is required, and it is highly recommended that sellers use the correct refund reason, especially in the case of a buyer-requested cancellation or 'buyer remorse' return to indicate that there was nothing wrong with the item(s) or with the shipment of the order.<br/><br/><span class=\"tablenote\"><strong>Note:</strong> If issuing refunds for more than one order line item, keep in mind that the refund reason must be the same for each of the order line items. If the refund reason is different for one or more order line items in an order, the seller would need to make separate <b>issueRefund</b> calls, one for each refund reason. </span> For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/fulfillment/types/api:ReasonForRefundEnum'>eBay API documentation</a>  # noqa: E501

        :return: The reason_for_refund of this IssueRefundRequest.  # noqa: E501
        :rtype: str
        """
        return self._reason_for_refund

    @reason_for_refund.setter
    def reason_for_refund(self, reason_for_refund):
        """Sets the reason_for_refund of this IssueRefundRequest.

        The enumeration value passed into this field indicates the reason for the refund. One of the defined enumeration values in the <b>ReasonForRefundEnum</b> type must be used.<br/><br/>This field is required, and it is highly recommended that sellers use the correct refund reason, especially in the case of a buyer-requested cancellation or 'buyer remorse' return to indicate that there was nothing wrong with the item(s) or with the shipment of the order.<br/><br/><span class=\"tablenote\"><strong>Note:</strong> If issuing refunds for more than one order line item, keep in mind that the refund reason must be the same for each of the order line items. If the refund reason is different for one or more order line items in an order, the seller would need to make separate <b>issueRefund</b> calls, one for each refund reason. </span> For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/fulfillment/types/api:ReasonForRefundEnum'>eBay API documentation</a>  # noqa: E501

        :param reason_for_refund: The reason_for_refund of this IssueRefundRequest.  # noqa: E501
        :type: str
        """

        self._reason_for_refund = reason_for_refund

    @property
    def refund_items(self):
        """Gets the refund_items of this IssueRefundRequest.  # noqa: E501

        The <b>refundItems</b> array is only required if the seller is issuing a refund for one or more individual order line items in a multiple line item order. Otherwise, the seller just uses the <b>orderLevelRefundAmount</b> container to specify the amount of the refund for the entire order.  # noqa: E501

        :return: The refund_items of this IssueRefundRequest.  # noqa: E501
        :rtype: list[RefundItem]
        """
        return self._refund_items

    @refund_items.setter
    def refund_items(self, refund_items):
        """Sets the refund_items of this IssueRefundRequest.

        The <b>refundItems</b> array is only required if the seller is issuing a refund for one or more individual order line items in a multiple line item order. Otherwise, the seller just uses the <b>orderLevelRefundAmount</b> container to specify the amount of the refund for the entire order.  # noqa: E501

        :param refund_items: The refund_items of this IssueRefundRequest.  # noqa: E501
        :type: list[RefundItem]
        """

        self._refund_items = refund_items

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(IssueRefundRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IssueRefundRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
