# coding: utf-8

"""
    Inventory API

    The Inventory API is used to create and manage inventory, and then to publish and manage this inventory on an eBay marketplace. There are also methods in this API that will convert eligible, active eBay listings into the Inventory API model.  # noqa: E501

    OpenAPI spec version: 1.16.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class CompatibleProduct(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'compatibility_properties': 'list[NameValueList]',
        'notes': 'str',
        'product_family_properties': 'ProductFamilyProperties',
        'product_identifier': 'ProductIdentifier'
    }

    attribute_map = {
        'compatibility_properties': 'compatibilityProperties',
        'notes': 'notes',
        'product_family_properties': 'productFamilyProperties',
        'product_identifier': 'productIdentifier'
    }

    def __init__(self, compatibility_properties=None, notes=None, product_family_properties=None, product_identifier=None):  # noqa: E501
        """CompatibleProduct - a model defined in Swagger"""  # noqa: E501
        self._compatibility_properties = None
        self._notes = None
        self._product_family_properties = None
        self._product_identifier = None
        self.discriminator = None
        if compatibility_properties is not None:
            self.compatibility_properties = compatibility_properties
        if notes is not None:
            self.notes = notes
        if product_family_properties is not None:
            self.product_family_properties = product_family_properties
        if product_identifier is not None:
            self.product_identifier = product_identifier

    @property
    def compatibility_properties(self):
        """Gets the compatibility_properties of this CompatibleProduct.  # noqa: E501

        This container consists of an array of motor vehicles that are compatible with the motor vehicle part or accessory specified by the SKU value in the call URI. Each motor vehicle is defined through a separate set of name/value pairs. In the <strong>name</strong> field, the vehicle aspect (such as 'make', 'model', 'year', 'trim', or 'engine') will be identified, and the <strong>value</strong> field will be used to identify the value of each aspect. The <a href=\"/api-docs/commerce/taxonomy/resources/category_tree/methods/getCompatibilityProperties\">getCompatibilityProperties</a> method of the Taxonomy API can be used to retrieve applicable vehicle aspect names for a specified category, and the <a href=\"/api-docs/commerce/taxonomy/resources/category_tree/methods/getCompatibilityPropertyValues\">getCompatibilityPropertyValues</a> method of the Taxonomy API can be used to retrieve possible values for these same vehicle aspect names. Below is an example of identifying one motor vehicle using the <strong>compatibilityProperties</strong> container:<br><br><code>&quot;compatibilityProperties&quot; : &#91;<br>&nbsp;&nbsp;&#123;<br>&nbsp;&nbsp;&nbsp;&quot;name&quot; : &quot;make&quot;,<br>&nbsp;&nbsp;&nbsp;&quot;value&quot; : &quot;Subaru&quot;<br>&nbsp;&nbsp;&#125;,<br>&nbsp;&nbsp;&#123;<br>&nbsp;&nbsp;&nbsp;&quot;name&quot; : &quot;model&quot;,<br>&nbsp;&nbsp;&nbsp;&quot;value&quot; : &quot;GL&quot;<br>&nbsp;&nbsp;&#125;,<br>&nbsp;&nbsp;&#123;<br>&nbsp;&nbsp;&nbsp;&quot;name&quot; : &quot;year&quot;,<br>&nbsp;&nbsp;&nbsp;&quot;value&quot; : &quot;1983&quot;<br>&nbsp;&nbsp;&#125;,<br>&nbsp;&nbsp;&#123;<br>&nbsp;&nbsp;&nbsp;&quot;name&quot; : &quot;trim&quot;,<br>&nbsp;&nbsp;&nbsp;&quot;value&quot; : &quot;Base Wagon 4-Door&quot;<br>&nbsp;&nbsp;&#125;,<br>&nbsp;&nbsp;&#123;<br>&nbsp;&nbsp;&nbsp;&quot;name&quot; : &quot;engine&quot;,<br>&nbsp;&nbsp;&nbsp;&quot;value&quot; : &quot;1.8L Turbocharged&quot;<br>&nbsp;&nbsp;&#125;<br>&#93;</code><br><br>Typically, the make, model, and year of the motor vehicle are always required, with the trim and engine being necessary sometimes, but it will be dependent on the part or accessory, and on the vehicle class.<br/><br/><span class=\"tablenote\"> <strong>Note:</strong> The <strong>productFamilyProperties</strong> container is in the process of being deprecated and will no longer be supported in February of 2021, so if you are a new user of <strong>createOrReplaceProductCompatibility</strong>, you should use the <strong>compatibilityProperties</strong> container instead, and if you are already integrated and using the <strong>productFamilyProperties</strong> container, you should make plans to migrate to <strong>compatibilityProperties</strong>. The <strong>productFamilyProperties</strong> and <strong>compatibilityProperties</strong> containers may not be used together or the call will fail.</span>  # noqa: E501

        :return: The compatibility_properties of this CompatibleProduct.  # noqa: E501
        :rtype: list[NameValueList]
        """
        return self._compatibility_properties

    @compatibility_properties.setter
    def compatibility_properties(self, compatibility_properties):
        """Sets the compatibility_properties of this CompatibleProduct.

        This container consists of an array of motor vehicles that are compatible with the motor vehicle part or accessory specified by the SKU value in the call URI. Each motor vehicle is defined through a separate set of name/value pairs. In the <strong>name</strong> field, the vehicle aspect (such as 'make', 'model', 'year', 'trim', or 'engine') will be identified, and the <strong>value</strong> field will be used to identify the value of each aspect. The <a href=\"/api-docs/commerce/taxonomy/resources/category_tree/methods/getCompatibilityProperties\">getCompatibilityProperties</a> method of the Taxonomy API can be used to retrieve applicable vehicle aspect names for a specified category, and the <a href=\"/api-docs/commerce/taxonomy/resources/category_tree/methods/getCompatibilityPropertyValues\">getCompatibilityPropertyValues</a> method of the Taxonomy API can be used to retrieve possible values for these same vehicle aspect names. Below is an example of identifying one motor vehicle using the <strong>compatibilityProperties</strong> container:<br><br><code>&quot;compatibilityProperties&quot; : &#91;<br>&nbsp;&nbsp;&#123;<br>&nbsp;&nbsp;&nbsp;&quot;name&quot; : &quot;make&quot;,<br>&nbsp;&nbsp;&nbsp;&quot;value&quot; : &quot;Subaru&quot;<br>&nbsp;&nbsp;&#125;,<br>&nbsp;&nbsp;&#123;<br>&nbsp;&nbsp;&nbsp;&quot;name&quot; : &quot;model&quot;,<br>&nbsp;&nbsp;&nbsp;&quot;value&quot; : &quot;GL&quot;<br>&nbsp;&nbsp;&#125;,<br>&nbsp;&nbsp;&#123;<br>&nbsp;&nbsp;&nbsp;&quot;name&quot; : &quot;year&quot;,<br>&nbsp;&nbsp;&nbsp;&quot;value&quot; : &quot;1983&quot;<br>&nbsp;&nbsp;&#125;,<br>&nbsp;&nbsp;&#123;<br>&nbsp;&nbsp;&nbsp;&quot;name&quot; : &quot;trim&quot;,<br>&nbsp;&nbsp;&nbsp;&quot;value&quot; : &quot;Base Wagon 4-Door&quot;<br>&nbsp;&nbsp;&#125;,<br>&nbsp;&nbsp;&#123;<br>&nbsp;&nbsp;&nbsp;&quot;name&quot; : &quot;engine&quot;,<br>&nbsp;&nbsp;&nbsp;&quot;value&quot; : &quot;1.8L Turbocharged&quot;<br>&nbsp;&nbsp;&#125;<br>&#93;</code><br><br>Typically, the make, model, and year of the motor vehicle are always required, with the trim and engine being necessary sometimes, but it will be dependent on the part or accessory, and on the vehicle class.<br/><br/><span class=\"tablenote\"> <strong>Note:</strong> The <strong>productFamilyProperties</strong> container is in the process of being deprecated and will no longer be supported in February of 2021, so if you are a new user of <strong>createOrReplaceProductCompatibility</strong>, you should use the <strong>compatibilityProperties</strong> container instead, and if you are already integrated and using the <strong>productFamilyProperties</strong> container, you should make plans to migrate to <strong>compatibilityProperties</strong>. The <strong>productFamilyProperties</strong> and <strong>compatibilityProperties</strong> containers may not be used together or the call will fail.</span>  # noqa: E501

        :param compatibility_properties: The compatibility_properties of this CompatibleProduct.  # noqa: E501
        :type: list[NameValueList]
        """

        self._compatibility_properties = compatibility_properties

    @property
    def notes(self):
        """Gets the notes of this CompatibleProduct.  # noqa: E501

        This field is optionally used by the seller to input any notes pertaining to the compatible vehicle list being defined. The seller might use this field to specify the placement of the part on a vehicle or other applicable information. This field will only be returned if specified by the seller.<br/><br/><strong>Max Length</strong>: 500<br/>  # noqa: E501

        :return: The notes of this CompatibleProduct.  # noqa: E501
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes):
        """Sets the notes of this CompatibleProduct.

        This field is optionally used by the seller to input any notes pertaining to the compatible vehicle list being defined. The seller might use this field to specify the placement of the part on a vehicle or other applicable information. This field will only be returned if specified by the seller.<br/><br/><strong>Max Length</strong>: 500<br/>  # noqa: E501

        :param notes: The notes of this CompatibleProduct.  # noqa: E501
        :type: str
        """

        self._notes = notes

    @property
    def product_family_properties(self):
        """Gets the product_family_properties of this CompatibleProduct.  # noqa: E501


        :return: The product_family_properties of this CompatibleProduct.  # noqa: E501
        :rtype: ProductFamilyProperties
        """
        return self._product_family_properties

    @product_family_properties.setter
    def product_family_properties(self, product_family_properties):
        """Sets the product_family_properties of this CompatibleProduct.


        :param product_family_properties: The product_family_properties of this CompatibleProduct.  # noqa: E501
        :type: ProductFamilyProperties
        """

        self._product_family_properties = product_family_properties

    @property
    def product_identifier(self):
        """Gets the product_identifier of this CompatibleProduct.  # noqa: E501


        :return: The product_identifier of this CompatibleProduct.  # noqa: E501
        :rtype: ProductIdentifier
        """
        return self._product_identifier

    @product_identifier.setter
    def product_identifier(self, product_identifier):
        """Sets the product_identifier of this CompatibleProduct.


        :param product_identifier: The product_identifier of this CompatibleProduct.  # noqa: E501
        :type: ProductIdentifier
        """

        self._product_identifier = product_identifier

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CompatibleProduct, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CompatibleProduct):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
