# coding: utf-8

"""
    Inventory API

    The Inventory API is used to create and manage inventory, and then to publish and manage this inventory on an eBay marketplace. There are also methods in this API that will convert eligible, active eBay listings into the Inventory API model.  # noqa: E501

    OpenAPI spec version: 1.16.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ExtendedProducerResponsibility(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'producer_product_id': 'str',
        'product_package_id': 'str',
        'shipment_package_id': 'str',
        'product_documentation_id': 'str',
        'eco_participation_fee': 'Amount'
    }

    attribute_map = {
        'producer_product_id': 'producerProductId',
        'product_package_id': 'productPackageId',
        'shipment_package_id': 'shipmentPackageId',
        'product_documentation_id': 'productDocumentationId',
        'eco_participation_fee': 'ecoParticipationFee'
    }

    def __init__(self, producer_product_id=None, product_package_id=None, shipment_package_id=None, product_documentation_id=None, eco_participation_fee=None):  # noqa: E501
        """ExtendedProducerResponsibility - a model defined in Swagger"""  # noqa: E501
        self._producer_product_id = None
        self._product_package_id = None
        self._shipment_package_id = None
        self._product_documentation_id = None
        self._eco_participation_fee = None
        self.discriminator = None
        if producer_product_id is not None:
            self.producer_product_id = producer_product_id
        if product_package_id is not None:
            self.product_package_id = product_package_id
        if shipment_package_id is not None:
            self.shipment_package_id = shipment_package_id
        if product_documentation_id is not None:
            self.product_documentation_id = product_documentation_id
        if eco_participation_fee is not None:
            self.eco_participation_fee = eco_participation_fee

    @property
    def producer_product_id(self):
        """Gets the producer_product_id of this ExtendedProducerResponsibility.  # noqa: E501

        This ID is the Unique Identifier of the producer related to the item. For instance, if the seller is selling a cell phone, it is the ID related to the cell phone.  # noqa: E501

        :return: The producer_product_id of this ExtendedProducerResponsibility.  # noqa: E501
        :rtype: str
        """
        return self._producer_product_id

    @producer_product_id.setter
    def producer_product_id(self, producer_product_id):
        """Sets the producer_product_id of this ExtendedProducerResponsibility.

        This ID is the Unique Identifier of the producer related to the item. For instance, if the seller is selling a cell phone, it is the ID related to the cell phone.  # noqa: E501

        :param producer_product_id: The producer_product_id of this ExtendedProducerResponsibility.  # noqa: E501
        :type: str
        """

        self._producer_product_id = producer_product_id

    @property
    def product_package_id(self):
        """Gets the product_package_id of this ExtendedProducerResponsibility.  # noqa: E501

        The Unique ID of the producer of any packaging related to the product added by the seller. This does not include package in which the product is shipped (see <strong>ShipmentPackageID</strong>). For instance, if the seller adds bubble wrap, it is the ID related to the bubble wrap.   # noqa: E501

        :return: The product_package_id of this ExtendedProducerResponsibility.  # noqa: E501
        :rtype: str
        """
        return self._product_package_id

    @product_package_id.setter
    def product_package_id(self, product_package_id):
        """Sets the product_package_id of this ExtendedProducerResponsibility.

        The Unique ID of the producer of any packaging related to the product added by the seller. This does not include package in which the product is shipped (see <strong>ShipmentPackageID</strong>). For instance, if the seller adds bubble wrap, it is the ID related to the bubble wrap.   # noqa: E501

        :param product_package_id: The product_package_id of this ExtendedProducerResponsibility.  # noqa: E501
        :type: str
        """

        self._product_package_id = product_package_id

    @property
    def shipment_package_id(self):
        """Gets the shipment_package_id of this ExtendedProducerResponsibility.  # noqa: E501

        This ID is the Unique Identifier of the producer of any packaging used by the seller to ship the item. This does not include non-shipping packaging added to the product (see <strong>ProductPackageID</strong>). This ID is required when the seller uses packaging to ship the item. For instance, if the seller uses a different box to ship the item, it is the ID related to the box.  # noqa: E501

        :return: The shipment_package_id of this ExtendedProducerResponsibility.  # noqa: E501
        :rtype: str
        """
        return self._shipment_package_id

    @shipment_package_id.setter
    def shipment_package_id(self, shipment_package_id):
        """Sets the shipment_package_id of this ExtendedProducerResponsibility.

        This ID is the Unique Identifier of the producer of any packaging used by the seller to ship the item. This does not include non-shipping packaging added to the product (see <strong>ProductPackageID</strong>). This ID is required when the seller uses packaging to ship the item. For instance, if the seller uses a different box to ship the item, it is the ID related to the box.  # noqa: E501

        :param shipment_package_id: The shipment_package_id of this ExtendedProducerResponsibility.  # noqa: E501
        :type: str
        """

        self._shipment_package_id = shipment_package_id

    @property
    def product_documentation_id(self):
        """Gets the product_documentation_id of this ExtendedProducerResponsibility.  # noqa: E501

        This ID is the Unique Identifier of the producer of any paper added to the parcel of the item by the seller. For example, this ID concerns any notice, leaflet, or paper that the seller adds to a cell phone parcel.  # noqa: E501

        :return: The product_documentation_id of this ExtendedProducerResponsibility.  # noqa: E501
        :rtype: str
        """
        return self._product_documentation_id

    @product_documentation_id.setter
    def product_documentation_id(self, product_documentation_id):
        """Sets the product_documentation_id of this ExtendedProducerResponsibility.

        This ID is the Unique Identifier of the producer of any paper added to the parcel of the item by the seller. For example, this ID concerns any notice, leaflet, or paper that the seller adds to a cell phone parcel.  # noqa: E501

        :param product_documentation_id: The product_documentation_id of this ExtendedProducerResponsibility.  # noqa: E501
        :type: str
        """

        self._product_documentation_id = product_documentation_id

    @property
    def eco_participation_fee(self):
        """Gets the eco_participation_fee of this ExtendedProducerResponsibility.  # noqa: E501


        :return: The eco_participation_fee of this ExtendedProducerResponsibility.  # noqa: E501
        :rtype: Amount
        """
        return self._eco_participation_fee

    @eco_participation_fee.setter
    def eco_participation_fee(self, eco_participation_fee):
        """Sets the eco_participation_fee of this ExtendedProducerResponsibility.


        :param eco_participation_fee: The eco_participation_fee of this ExtendedProducerResponsibility.  # noqa: E501
        :type: Amount
        """

        self._eco_participation_fee = eco_participation_fee

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ExtendedProducerResponsibility, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExtendedProducerResponsibility):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
