# coding: utf-8

"""
    Inventory API

    The Inventory API is used to create and manage inventory, and then to publish and manage this inventory on an eBay marketplace. There are also methods in this API that will convert eligible, active eBay listings into the Inventory API model.  # noqa: E501

    OpenAPI spec version: 1.16.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class InventoryItemWithSkuLocaleGroupid(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'availability': 'AvailabilityWithAll',
        'condition': 'str',
        'condition_description': 'str',
        'group_ids': 'list[str]',
        'inventory_item_group_keys': 'list[str]',
        'locale': 'str',
        'package_weight_and_size': 'PackageWeightAndSize',
        'product': 'Product',
        'sku': 'str'
    }

    attribute_map = {
        'availability': 'availability',
        'condition': 'condition',
        'condition_description': 'conditionDescription',
        'group_ids': 'groupIds',
        'inventory_item_group_keys': 'inventoryItemGroupKeys',
        'locale': 'locale',
        'package_weight_and_size': 'packageWeightAndSize',
        'product': 'product',
        'sku': 'sku'
    }

    def __init__(self, availability=None, condition=None, condition_description=None, group_ids=None, inventory_item_group_keys=None, locale=None, package_weight_and_size=None, product=None, sku=None):  # noqa: E501
        """InventoryItemWithSkuLocaleGroupid - a model defined in Swagger"""  # noqa: E501
        self._availability = None
        self._condition = None
        self._condition_description = None
        self._group_ids = None
        self._inventory_item_group_keys = None
        self._locale = None
        self._package_weight_and_size = None
        self._product = None
        self._sku = None
        self.discriminator = None
        if availability is not None:
            self.availability = availability
        if condition is not None:
            self.condition = condition
        if condition_description is not None:
            self.condition_description = condition_description
        if group_ids is not None:
            self.group_ids = group_ids
        if inventory_item_group_keys is not None:
            self.inventory_item_group_keys = inventory_item_group_keys
        if locale is not None:
            self.locale = locale
        if package_weight_and_size is not None:
            self.package_weight_and_size = package_weight_and_size
        if product is not None:
            self.product = product
        if sku is not None:
            self.sku = sku

    @property
    def availability(self):
        """Gets the availability of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501


        :return: The availability of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501
        :rtype: AvailabilityWithAll
        """
        return self._availability

    @availability.setter
    def availability(self, availability):
        """Sets the availability of this InventoryItemWithSkuLocaleGroupid.


        :param availability: The availability of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501
        :type: AvailabilityWithAll
        """

        self._availability = availability

    @property
    def condition(self):
        """Gets the condition of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501

        This enumeration value indicates the condition of the item. Supported item condition values will vary by eBay site and category. <br /><br /> Since the condition of an inventory item must be specified before being published in an offer, this field is always returned in the 'Get' calls for SKUs that are part of a published offer. If a SKU is not part of a published offer, this field will only be returned if set for the inventory item. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/inventory/types/slr:ConditionEnum'>eBay API documentation</a>  # noqa: E501

        :return: The condition of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501
        :rtype: str
        """
        return self._condition

    @condition.setter
    def condition(self, condition):
        """Sets the condition of this InventoryItemWithSkuLocaleGroupid.

        This enumeration value indicates the condition of the item. Supported item condition values will vary by eBay site and category. <br /><br /> Since the condition of an inventory item must be specified before being published in an offer, this field is always returned in the 'Get' calls for SKUs that are part of a published offer. If a SKU is not part of a published offer, this field will only be returned if set for the inventory item. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/inventory/types/slr:ConditionEnum'>eBay API documentation</a>  # noqa: E501

        :param condition: The condition of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501
        :type: str
        """

        self._condition = condition

    @property
    def condition_description(self):
        """Gets the condition_description of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501

        This string field is used by the seller to more clearly describe the condition of used items, or items that are not 'Brand New', 'New with tags', or 'New in box'. The ConditionDescription field is available for all categories. If the ConditionDescription field is used with an item in a new condition (Condition IDs 1000-1499), eBay will simply ignore this field if included, and eBay will return a warning message to the user. This field should only be used to further clarify the condition of the used item. It should not be used for branding, promotions, shipping, returns, payment or other information unrelated to the condition of the item. Make sure that the condition value, condition description, listing description, and the item's pictures do not contradict one another.<br /><br /><strong>Max length</strong>/: 1000.  # noqa: E501

        :return: The condition_description of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501
        :rtype: str
        """
        return self._condition_description

    @condition_description.setter
    def condition_description(self, condition_description):
        """Sets the condition_description of this InventoryItemWithSkuLocaleGroupid.

        This string field is used by the seller to more clearly describe the condition of used items, or items that are not 'Brand New', 'New with tags', or 'New in box'. The ConditionDescription field is available for all categories. If the ConditionDescription field is used with an item in a new condition (Condition IDs 1000-1499), eBay will simply ignore this field if included, and eBay will return a warning message to the user. This field should only be used to further clarify the condition of the used item. It should not be used for branding, promotions, shipping, returns, payment or other information unrelated to the condition of the item. Make sure that the condition value, condition description, listing description, and the item's pictures do not contradict one another.<br /><br /><strong>Max length</strong>/: 1000.  # noqa: E501

        :param condition_description: The condition_description of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501
        :type: str
        """

        self._condition_description = condition_description

    @property
    def group_ids(self):
        """Gets the group_ids of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501

        This array is returned if the inventory item is associated with any inventory item group(s). The value(s) returned in this array are the unique identifier(s) of the inventory item group(s). This array is not returned if the inventory item is not associated with any inventory item groups.  # noqa: E501

        :return: The group_ids of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501
        :rtype: list[str]
        """
        return self._group_ids

    @group_ids.setter
    def group_ids(self, group_ids):
        """Sets the group_ids of this InventoryItemWithSkuLocaleGroupid.

        This array is returned if the inventory item is associated with any inventory item group(s). The value(s) returned in this array are the unique identifier(s) of the inventory item group(s). This array is not returned if the inventory item is not associated with any inventory item groups.  # noqa: E501

        :param group_ids: The group_ids of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501
        :type: list[str]
        """

        self._group_ids = group_ids

    @property
    def inventory_item_group_keys(self):
        """Gets the inventory_item_group_keys of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501

        This array is returned if the inventory item is associated with any inventory item group(s). The value(s) returned in this array are the unique identifier(s) of the inventory item's variation in a multiple-variation listing. This array is not returned if the inventory item is not associated with any inventory item groups.  # noqa: E501

        :return: The inventory_item_group_keys of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501
        :rtype: list[str]
        """
        return self._inventory_item_group_keys

    @inventory_item_group_keys.setter
    def inventory_item_group_keys(self, inventory_item_group_keys):
        """Sets the inventory_item_group_keys of this InventoryItemWithSkuLocaleGroupid.

        This array is returned if the inventory item is associated with any inventory item group(s). The value(s) returned in this array are the unique identifier(s) of the inventory item's variation in a multiple-variation listing. This array is not returned if the inventory item is not associated with any inventory item groups.  # noqa: E501

        :param inventory_item_group_keys: The inventory_item_group_keys of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501
        :type: list[str]
        """

        self._inventory_item_group_keys = inventory_item_group_keys

    @property
    def locale(self):
        """Gets the locale of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501

        This field is for future use only. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/inventory/types/slr:LocaleEnum'>eBay API documentation</a>  # noqa: E501

        :return: The locale of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501
        :rtype: str
        """
        return self._locale

    @locale.setter
    def locale(self, locale):
        """Sets the locale of this InventoryItemWithSkuLocaleGroupid.

        This field is for future use only. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/inventory/types/slr:LocaleEnum'>eBay API documentation</a>  # noqa: E501

        :param locale: The locale of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501
        :type: str
        """

        self._locale = locale

    @property
    def package_weight_and_size(self):
        """Gets the package_weight_and_size of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501


        :return: The package_weight_and_size of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501
        :rtype: PackageWeightAndSize
        """
        return self._package_weight_and_size

    @package_weight_and_size.setter
    def package_weight_and_size(self, package_weight_and_size):
        """Sets the package_weight_and_size of this InventoryItemWithSkuLocaleGroupid.


        :param package_weight_and_size: The package_weight_and_size of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501
        :type: PackageWeightAndSize
        """

        self._package_weight_and_size = package_weight_and_size

    @property
    def product(self):
        """Gets the product of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501


        :return: The product of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501
        :rtype: Product
        """
        return self._product

    @product.setter
    def product(self, product):
        """Sets the product of this InventoryItemWithSkuLocaleGroupid.


        :param product: The product of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501
        :type: Product
        """

        self._product = product

    @property
    def sku(self):
        """Gets the sku of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501

        The seller-defined Stock-Keeping Unit (SKU) of the inventory item. The seller should have a unique SKU value for every product that they sell.  # noqa: E501

        :return: The sku of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501
        :rtype: str
        """
        return self._sku

    @sku.setter
    def sku(self, sku):
        """Sets the sku of this InventoryItemWithSkuLocaleGroupid.

        The seller-defined Stock-Keeping Unit (SKU) of the inventory item. The seller should have a unique SKU value for every product that they sell.  # noqa: E501

        :param sku: The sku of this InventoryItemWithSkuLocaleGroupid.  # noqa: E501
        :type: str
        """

        self._sku = sku

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(InventoryItemWithSkuLocaleGroupid, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InventoryItemWithSkuLocaleGroupid):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
