# coding: utf-8

"""
    Inventory API

    The Inventory API is used to create and manage inventory, and then to publish and manage this inventory on an eBay marketplace. There are also methods in this API that will convert eligible, active eBay listings into the Inventory API model.  # noqa: E501

    OpenAPI spec version: 1.16.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class OperatingHours(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'day_of_week_enum': 'str',
        'intervals': 'list[Interval]'
    }

    attribute_map = {
        'day_of_week_enum': 'dayOfWeekEnum',
        'intervals': 'intervals'
    }

    def __init__(self, day_of_week_enum=None, intervals=None):  # noqa: E501
        """OperatingHours - a model defined in Swagger"""  # noqa: E501
        self._day_of_week_enum = None
        self._intervals = None
        self.discriminator = None
        if day_of_week_enum is not None:
            self.day_of_week_enum = day_of_week_enum
        if intervals is not None:
            self.intervals = intervals

    @property
    def day_of_week_enum(self):
        """Gets the day_of_week_enum of this OperatingHours.  # noqa: E501

        A <strong>dayOfWeekEnum</strong> value is required for each day of the week that the store location has regular operating hours. <br><br>This field is returned if operating hours are defined for the store location. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/inventory/types/api:DayOfWeekEnum'>eBay API documentation</a>  # noqa: E501

        :return: The day_of_week_enum of this OperatingHours.  # noqa: E501
        :rtype: str
        """
        return self._day_of_week_enum

    @day_of_week_enum.setter
    def day_of_week_enum(self, day_of_week_enum):
        """Sets the day_of_week_enum of this OperatingHours.

        A <strong>dayOfWeekEnum</strong> value is required for each day of the week that the store location has regular operating hours. <br><br>This field is returned if operating hours are defined for the store location. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/inventory/types/api:DayOfWeekEnum'>eBay API documentation</a>  # noqa: E501

        :param day_of_week_enum: The day_of_week_enum of this OperatingHours.  # noqa: E501
        :type: str
        """

        self._day_of_week_enum = day_of_week_enum

    @property
    def intervals(self):
        """Gets the intervals of this OperatingHours.  # noqa: E501

        This container is used to define the opening and closing times of a store's working day (defined in the <strong>dayOfWeekEnum</strong> field). An <strong>intervals</strong> container is needed for each day of the week that the store location is open. If a store location closes for lunch (or any other period during the day) and then reopens, multiple <strong>open</strong> and <strong>close</strong> pairs are needed <br><br>This container is returned if operating hours are defined for the store location.  # noqa: E501

        :return: The intervals of this OperatingHours.  # noqa: E501
        :rtype: list[Interval]
        """
        return self._intervals

    @intervals.setter
    def intervals(self, intervals):
        """Sets the intervals of this OperatingHours.

        This container is used to define the opening and closing times of a store's working day (defined in the <strong>dayOfWeekEnum</strong> field). An <strong>intervals</strong> container is needed for each day of the week that the store location is open. If a store location closes for lunch (or any other period during the day) and then reopens, multiple <strong>open</strong> and <strong>close</strong> pairs are needed <br><br>This container is returned if operating hours are defined for the store location.  # noqa: E501

        :param intervals: The intervals of this OperatingHours.  # noqa: E501
        :type: list[Interval]
        """

        self._intervals = intervals

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OperatingHours, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OperatingHours):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
