# coding: utf-8

"""
    Logistics API

    <span class=\"tablenote\"><b>Note:</b> This is a <a href=\"https://developer.ebay.com/api-docs/static/versioning.html#limited\" target=\"_blank\"> <img src=\"/cms/img/docs/partners-api.svg\" class=\"legend-icon partners-icon\" title=\"Limited Release\"  alt=\"Limited Release\" />(Limited Release)</a> API available only to select developers approved by business units.</span><br /><br />The <b>Logistics API</b> resources offer the following capabilities: <ul><li><b>shipping_quote</b> &ndash; Consolidates into a list a set of live shipping rates, or quotes, from which you can select a rate to ship a package.</li> <li><b>shipment</b> &ndash; Creates a \"shipment\" for the selected shipping rate.</li></ul> Call <b>createShippingQuote</b> to get a list of live shipping rates. The rates returned are all valid for a specific time window and all quoted prices are at eBay-negotiated rates. <br><br>Select one of the live rates and using its associated <b>rateId</b>, create a \"shipment\" for the package by calling <b>createFromShippingQuote</b>. Creating a shipment completes an agreement, and the cost of the base service and any added shipping options are summed into the returned <b>totalShippingCost</b> value. This action also generates a shipping label that you can use to ship the package.  The total cost of the shipment is incurred when the package is shipped using the supplied shipping label.  <p class=\"tablenote\"><b>Important!</b> Sellers must set up a payment method via their eBay account before they can use the methods in this API to create a shipment and the associated shipping label.</p>  # noqa: E501

    OpenAPI spec version: v1_beta.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Rate(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'additional_options': 'list[AdditionalOption]',
        'base_shipping_cost': 'Amount',
        'destination_time_zone': 'str',
        'max_estimated_delivery_date': 'str',
        'min_estimated_delivery_date': 'str',
        'pickup_networks': 'list[str]',
        'pickup_slots': 'list[PickupSlot]',
        'pickup_type': 'str',
        'rate_id': 'str',
        'rate_recommendation': 'list[str]',
        'shipping_carrier_code': 'str',
        'shipping_carrier_name': 'str',
        'shipping_service_code': 'str',
        'shipping_service_name': 'str'
    }

    attribute_map = {
        'additional_options': 'additionalOptions',
        'base_shipping_cost': 'baseShippingCost',
        'destination_time_zone': 'destinationTimeZone',
        'max_estimated_delivery_date': 'maxEstimatedDeliveryDate',
        'min_estimated_delivery_date': 'minEstimatedDeliveryDate',
        'pickup_networks': 'pickupNetworks',
        'pickup_slots': 'pickupSlots',
        'pickup_type': 'pickupType',
        'rate_id': 'rateId',
        'rate_recommendation': 'rateRecommendation',
        'shipping_carrier_code': 'shippingCarrierCode',
        'shipping_carrier_name': 'shippingCarrierName',
        'shipping_service_code': 'shippingServiceCode',
        'shipping_service_name': 'shippingServiceName'
    }

    def __init__(self, additional_options=None, base_shipping_cost=None, destination_time_zone=None, max_estimated_delivery_date=None, min_estimated_delivery_date=None, pickup_networks=None, pickup_slots=None, pickup_type=None, rate_id=None, rate_recommendation=None, shipping_carrier_code=None, shipping_carrier_name=None, shipping_service_code=None, shipping_service_name=None):  # noqa: E501
        """Rate - a model defined in Swagger"""  # noqa: E501
        self._additional_options = None
        self._base_shipping_cost = None
        self._destination_time_zone = None
        self._max_estimated_delivery_date = None
        self._min_estimated_delivery_date = None
        self._pickup_networks = None
        self._pickup_slots = None
        self._pickup_type = None
        self._rate_id = None
        self._rate_recommendation = None
        self._shipping_carrier_code = None
        self._shipping_carrier_name = None
        self._shipping_service_code = None
        self._shipping_service_name = None
        self.discriminator = None
        if additional_options is not None:
            self.additional_options = additional_options
        if base_shipping_cost is not None:
            self.base_shipping_cost = base_shipping_cost
        if destination_time_zone is not None:
            self.destination_time_zone = destination_time_zone
        if max_estimated_delivery_date is not None:
            self.max_estimated_delivery_date = max_estimated_delivery_date
        if min_estimated_delivery_date is not None:
            self.min_estimated_delivery_date = min_estimated_delivery_date
        if pickup_networks is not None:
            self.pickup_networks = pickup_networks
        if pickup_slots is not None:
            self.pickup_slots = pickup_slots
        if pickup_type is not None:
            self.pickup_type = pickup_type
        if rate_id is not None:
            self.rate_id = rate_id
        if rate_recommendation is not None:
            self.rate_recommendation = rate_recommendation
        if shipping_carrier_code is not None:
            self.shipping_carrier_code = shipping_carrier_code
        if shipping_carrier_name is not None:
            self.shipping_carrier_name = shipping_carrier_name
        if shipping_service_code is not None:
            self.shipping_service_code = shipping_service_code
        if shipping_service_name is not None:
            self.shipping_service_name = shipping_service_name

    @property
    def additional_options(self):
        """Gets the additional_options of this Rate.  # noqa: E501

        Contains service and pricing information for one or more shipping options that are offered by the carrier and can be purchased in addition to the base shipping service provided by this rate. Shipping options can include items such as INSURANCE and SIGNATURE.  # noqa: E501

        :return: The additional_options of this Rate.  # noqa: E501
        :rtype: list[AdditionalOption]
        """
        return self._additional_options

    @additional_options.setter
    def additional_options(self, additional_options):
        """Sets the additional_options of this Rate.

        Contains service and pricing information for one or more shipping options that are offered by the carrier and can be purchased in addition to the base shipping service provided by this rate. Shipping options can include items such as INSURANCE and SIGNATURE.  # noqa: E501

        :param additional_options: The additional_options of this Rate.  # noqa: E501
        :type: list[AdditionalOption]
        """

        self._additional_options = additional_options

    @property
    def base_shipping_cost(self):
        """Gets the base_shipping_cost of this Rate.  # noqa: E501


        :return: The base_shipping_cost of this Rate.  # noqa: E501
        :rtype: Amount
        """
        return self._base_shipping_cost

    @base_shipping_cost.setter
    def base_shipping_cost(self, base_shipping_cost):
        """Sets the base_shipping_cost of this Rate.


        :param base_shipping_cost: The base_shipping_cost of this Rate.  # noqa: E501
        :type: Amount
        """

        self._base_shipping_cost = base_shipping_cost

    @property
    def destination_time_zone(self):
        """Gets the destination_time_zone of this Rate.  # noqa: E501

        The name of the time zone region, as defined in the IANA Time Zone Database, to which the package is being shipped. Delivery dates are calculated relative to this time zone. Note: This is different from a Coordinated Universal Time (UTC) offset. For example, the America/Los_Angeles time zone identifies a region with the UTC standard time offset of -08:00, but so do several other time zones, including America/Tijuana,America/Dawson, and Pacific/Pitcairn.  # noqa: E501

        :return: The destination_time_zone of this Rate.  # noqa: E501
        :rtype: str
        """
        return self._destination_time_zone

    @destination_time_zone.setter
    def destination_time_zone(self, destination_time_zone):
        """Sets the destination_time_zone of this Rate.

        The name of the time zone region, as defined in the IANA Time Zone Database, to which the package is being shipped. Delivery dates are calculated relative to this time zone. Note: This is different from a Coordinated Universal Time (UTC) offset. For example, the America/Los_Angeles time zone identifies a region with the UTC standard time offset of -08:00, but so do several other time zones, including America/Tijuana,America/Dawson, and Pacific/Pitcairn.  # noqa: E501

        :param destination_time_zone: The destination_time_zone of this Rate.  # noqa: E501
        :type: str
        """

        self._destination_time_zone = destination_time_zone

    @property
    def max_estimated_delivery_date(self):
        """Gets the max_estimated_delivery_date of this Rate.  # noqa: E501

        The latest stated date and time the shipment will be delivered at this rate. The time stamp is formatted as an ISO 8601 string, which is based on the 24-hour Coordinated Universal Time (UTC) clock. Format: [YYYY]-[MM]-[DD]T[HH]:[MM]:[SS].[SSS]Z Example: 2018-08-20T07:09:00.000Z  # noqa: E501

        :return: The max_estimated_delivery_date of this Rate.  # noqa: E501
        :rtype: str
        """
        return self._max_estimated_delivery_date

    @max_estimated_delivery_date.setter
    def max_estimated_delivery_date(self, max_estimated_delivery_date):
        """Sets the max_estimated_delivery_date of this Rate.

        The latest stated date and time the shipment will be delivered at this rate. The time stamp is formatted as an ISO 8601 string, which is based on the 24-hour Coordinated Universal Time (UTC) clock. Format: [YYYY]-[MM]-[DD]T[HH]:[MM]:[SS].[SSS]Z Example: 2018-08-20T07:09:00.000Z  # noqa: E501

        :param max_estimated_delivery_date: The max_estimated_delivery_date of this Rate.  # noqa: E501
        :type: str
        """

        self._max_estimated_delivery_date = max_estimated_delivery_date

    @property
    def min_estimated_delivery_date(self):
        """Gets the min_estimated_delivery_date of this Rate.  # noqa: E501

        The estimated earliest date and time the shipment will be delivered at this rate. The time stamp is formatted as an ISO 8601 UTC string.  # noqa: E501

        :return: The min_estimated_delivery_date of this Rate.  # noqa: E501
        :rtype: str
        """
        return self._min_estimated_delivery_date

    @min_estimated_delivery_date.setter
    def min_estimated_delivery_date(self, min_estimated_delivery_date):
        """Sets the min_estimated_delivery_date of this Rate.

        The estimated earliest date and time the shipment will be delivered at this rate. The time stamp is formatted as an ISO 8601 UTC string.  # noqa: E501

        :param min_estimated_delivery_date: The min_estimated_delivery_date of this Rate.  # noqa: E501
        :type: str
        """

        self._min_estimated_delivery_date = min_estimated_delivery_date

    @property
    def pickup_networks(self):
        """Gets the pickup_networks of this Rate.  # noqa: E501

        A list of pickup networks compatible with the shipping service.  # noqa: E501

        :return: The pickup_networks of this Rate.  # noqa: E501
        :rtype: list[str]
        """
        return self._pickup_networks

    @pickup_networks.setter
    def pickup_networks(self, pickup_networks):
        """Sets the pickup_networks of this Rate.

        A list of pickup networks compatible with the shipping service.  # noqa: E501

        :param pickup_networks: The pickup_networks of this Rate.  # noqa: E501
        :type: list[str]
        """

        self._pickup_networks = pickup_networks

    @property
    def pickup_slots(self):
        """Gets the pickup_slots of this Rate.  # noqa: E501

        A list of available pickup slots for the package.  # noqa: E501

        :return: The pickup_slots of this Rate.  # noqa: E501
        :rtype: list[PickupSlot]
        """
        return self._pickup_slots

    @pickup_slots.setter
    def pickup_slots(self, pickup_slots):
        """Sets the pickup_slots of this Rate.

        A list of available pickup slots for the package.  # noqa: E501

        :param pickup_slots: The pickup_slots of this Rate.  # noqa: E501
        :type: list[PickupSlot]
        """

        self._pickup_slots = pickup_slots

    @property
    def pickup_type(self):
        """Gets the pickup_type of this Rate.  # noqa: E501

        The type of pickup or drop-off service associated with the pickupSlots time frames. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/logistics/types/api:PickupTypeEnum'>eBay API documentation</a>  # noqa: E501

        :return: The pickup_type of this Rate.  # noqa: E501
        :rtype: str
        """
        return self._pickup_type

    @pickup_type.setter
    def pickup_type(self, pickup_type):
        """Sets the pickup_type of this Rate.

        The type of pickup or drop-off service associated with the pickupSlots time frames. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/logistics/types/api:PickupTypeEnum'>eBay API documentation</a>  # noqa: E501

        :param pickup_type: The pickup_type of this Rate.  # noqa: E501
        :type: str
        """

        self._pickup_type = pickup_type

    @property
    def rate_id(self):
        """Gets the rate_id of this Rate.  # noqa: E501

        The unique eBay-assigned ID for this shipping rate.  # noqa: E501

        :return: The rate_id of this Rate.  # noqa: E501
        :rtype: str
        """
        return self._rate_id

    @rate_id.setter
    def rate_id(self, rate_id):
        """Sets the rate_id of this Rate.

        The unique eBay-assigned ID for this shipping rate.  # noqa: E501

        :param rate_id: The rate_id of this Rate.  # noqa: E501
        :type: str
        """

        self._rate_id = rate_id

    @property
    def rate_recommendation(self):
        """Gets the rate_recommendation of this Rate.  # noqa: E501

        A list of reasons this rate is recommended. Available values are: BUYER_CHOSEN &mdash; The rate meets or exceeds the requirements of the buyer's preferred shipping option. CHEAPEST_ON_TIME &mdash; The rate is the cheapest rate available that will provide delivery within the seller's time frame commitment. EBAY_PLUS_OK &mdash; The rate complies with the shipping requirements of the eBay Plus program. FASTEST_ON_TIME &mdash; The rate has the fastest shipping time, and will provide delivery within the seller's time frame commitment. GUARANTEED_DELIVERY_OK &mdash; The rate complies with the shipping requirements of the eBay Guaranteed Delivery program.  # noqa: E501

        :return: The rate_recommendation of this Rate.  # noqa: E501
        :rtype: list[str]
        """
        return self._rate_recommendation

    @rate_recommendation.setter
    def rate_recommendation(self, rate_recommendation):
        """Sets the rate_recommendation of this Rate.

        A list of reasons this rate is recommended. Available values are: BUYER_CHOSEN &mdash; The rate meets or exceeds the requirements of the buyer's preferred shipping option. CHEAPEST_ON_TIME &mdash; The rate is the cheapest rate available that will provide delivery within the seller's time frame commitment. EBAY_PLUS_OK &mdash; The rate complies with the shipping requirements of the eBay Plus program. FASTEST_ON_TIME &mdash; The rate has the fastest shipping time, and will provide delivery within the seller's time frame commitment. GUARANTEED_DELIVERY_OK &mdash; The rate complies with the shipping requirements of the eBay Guaranteed Delivery program.  # noqa: E501

        :param rate_recommendation: The rate_recommendation of this Rate.  # noqa: E501
        :type: list[str]
        """

        self._rate_recommendation = rate_recommendation

    @property
    def shipping_carrier_code(self):
        """Gets the shipping_carrier_code of this Rate.  # noqa: E501

        The code name of the shipping carrier who will provide the service identified by shippingServiceCode.  # noqa: E501

        :return: The shipping_carrier_code of this Rate.  # noqa: E501
        :rtype: str
        """
        return self._shipping_carrier_code

    @shipping_carrier_code.setter
    def shipping_carrier_code(self, shipping_carrier_code):
        """Sets the shipping_carrier_code of this Rate.

        The code name of the shipping carrier who will provide the service identified by shippingServiceCode.  # noqa: E501

        :param shipping_carrier_code: The shipping_carrier_code of this Rate.  # noqa: E501
        :type: str
        """

        self._shipping_carrier_code = shipping_carrier_code

    @property
    def shipping_carrier_name(self):
        """Gets the shipping_carrier_name of this Rate.  # noqa: E501

        The common name of the shipping carrier.  # noqa: E501

        :return: The shipping_carrier_name of this Rate.  # noqa: E501
        :rtype: str
        """
        return self._shipping_carrier_name

    @shipping_carrier_name.setter
    def shipping_carrier_name(self, shipping_carrier_name):
        """Sets the shipping_carrier_name of this Rate.

        The common name of the shipping carrier.  # noqa: E501

        :param shipping_carrier_name: The shipping_carrier_name of this Rate.  # noqa: E501
        :type: str
        """

        self._shipping_carrier_name = shipping_carrier_name

    @property
    def shipping_service_code(self):
        """Gets the shipping_service_code of this Rate.  # noqa: E501

        The code name of the shipping service to be provided by the carrier identified by shippingCarrierCode.  # noqa: E501

        :return: The shipping_service_code of this Rate.  # noqa: E501
        :rtype: str
        """
        return self._shipping_service_code

    @shipping_service_code.setter
    def shipping_service_code(self, shipping_service_code):
        """Sets the shipping_service_code of this Rate.

        The code name of the shipping service to be provided by the carrier identified by shippingCarrierCode.  # noqa: E501

        :param shipping_service_code: The shipping_service_code of this Rate.  # noqa: E501
        :type: str
        """

        self._shipping_service_code = shipping_service_code

    @property
    def shipping_service_name(self):
        """Gets the shipping_service_name of this Rate.  # noqa: E501

        The common name of the shipping service.  # noqa: E501

        :return: The shipping_service_name of this Rate.  # noqa: E501
        :rtype: str
        """
        return self._shipping_service_name

    @shipping_service_name.setter
    def shipping_service_name(self, shipping_service_name):
        """Sets the shipping_service_name of this Rate.

        The common name of the shipping service.  # noqa: E501

        :param shipping_service_name: The shipping_service_name of this Rate.  # noqa: E501
        :type: str
        """

        self._shipping_service_name = shipping_service_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Rate, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Rate):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
