# coding: utf-8

"""
    Marketing API

    <p>The <i>Marketing API </i> offers two platforms that sellers can use to promote and advertise their products:</p> <ul><li><b>Promoted Listings</b> is an eBay ad service that lets sellers set up <i>ad campaigns </i> for the products they want to promote. eBay displays the ads in search results and in other marketing modules as <b>SPONSORED</b> listings. If an item in a Promoted Listings campaign sells, the seller is assessed a Promoted Listings fee, which is a seller-specified percentage applied to the sales price. For complete details, see <a href=\"/api-docs/sell/static/marketing/promoted-listings.html\">Promoted Listings</a>.</li>  <li><b>Promotions Manager</b> gives sellers a way to offer discounts on specific items as a way to attract buyers to their inventory. Sellers can set up discounts (such as \"20% off\" and other types of offers) on specific items or on an entire customer order. To further attract buyers, eBay prominently displays promotion <i>teasers</i> throughout buyer flows. For complete details, see <a href=\"/api-docs/sell/static/marketing/promotions-manager.html\">Promotions Manager</a>.</li></ul>  <p><b>Marketing reports</b>, on both the Promoted Listings and Promotions Manager platforms, give sellers information that shows the effectiveness of their marketing strategies. The data gives sellers the ability to review and fine tune their marketing efforts.</p> <p class=\"tablenote\"><b>Important!</b> Sellers must have an active eBay Store subscription, and they must accept the <b>Terms and Conditions</b> before they can make requests to these APIs in the Production environment. There are also site-specific listings requirements and restrictions associated with these marketing tools, as listed in the \"requirements and restrictions\" sections for <a href=\"/api-docs/sell/marketing/static/overview.html#PL-requirements\">Promoted Listings</a> and <a href=\"/api-docs/sell/marketing/static/overview.html#PM-requirements\">Promotions Manager</a>.</p> <p>The table below lists all the Marketing API calls grouped by resource.</p>  # noqa: E501

    OpenAPI spec version: v1.10.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class FundingStrategy(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'bid_percentage': 'str',
        'funding_model': 'str'
    }

    attribute_map = {
        'bid_percentage': 'bidPercentage',
        'funding_model': 'fundingModel'
    }

    def __init__(self, bid_percentage=None, funding_model=None):  # noqa: E501
        """FundingStrategy - a model defined in Swagger"""  # noqa: E501
        self._bid_percentage = None
        self._funding_model = None
        self.discriminator = None
        if bid_percentage is not None:
            self.bid_percentage = bid_percentage
        if funding_model is not None:
            self.funding_model = funding_model

    @property
    def bid_percentage(self):
        """Gets the bid_percentage of this FundingStrategy.  # noqa: E501

        The user-defined <b>bid percentage</b> (also known as the <i>ad rate</i>) sets the level that eBay increases the visibility in search results for the associated listing. The higher the <b>bidPercentage</b> value, the more eBay promotes the listing.  <br><br>The value specified here is also used to calculate the Promoted Listings fee. This percentage value is multiplied by the final sales price to determine the fee. <br><br>The Promoted Listings fee is determined at the time the transaction completes and the seller is assessed the fee only when an item sells through a Promoted Listings ad campaign. <br><br><b>bidPercentage</b> is a single precision value that is guided by the following rules: <ul><li>These values are <b>valid</b>:<br>&nbsp;&nbsp;&nbsp;<code>1</code>, &nbsp;&nbsp;&nbsp;<code>1.0</code>, &nbsp;&nbsp;&nbsp;<code>4.1</code>,<br /> &nbsp;&nbsp;&nbsp;<code>5.0</code>, &nbsp;&nbsp;&nbsp;<code>5.5</code>, ...</li>  <li>These values are <b>not valid</b>:<br /> &nbsp;&nbsp;&nbsp;<code>0.01</code>, &nbsp;&nbsp;&nbsp;<code>10.75</code>, &nbsp;&nbsp;&nbsp;<code>99.99</code>,<br /> &nbsp;&nbsp;&nbsp;and so on.</li></ul>  <p>If a bid percentage is not provided for an ad, eBay uses the default bid percentage of the associated campaign.</p><b>Minimum value:</b> 1.0 <br><b>Maximum value:</b> 100.0  # noqa: E501

        :return: The bid_percentage of this FundingStrategy.  # noqa: E501
        :rtype: str
        """
        return self._bid_percentage

    @bid_percentage.setter
    def bid_percentage(self, bid_percentage):
        """Sets the bid_percentage of this FundingStrategy.

        The user-defined <b>bid percentage</b> (also known as the <i>ad rate</i>) sets the level that eBay increases the visibility in search results for the associated listing. The higher the <b>bidPercentage</b> value, the more eBay promotes the listing.  <br><br>The value specified here is also used to calculate the Promoted Listings fee. This percentage value is multiplied by the final sales price to determine the fee. <br><br>The Promoted Listings fee is determined at the time the transaction completes and the seller is assessed the fee only when an item sells through a Promoted Listings ad campaign. <br><br><b>bidPercentage</b> is a single precision value that is guided by the following rules: <ul><li>These values are <b>valid</b>:<br>&nbsp;&nbsp;&nbsp;<code>1</code>, &nbsp;&nbsp;&nbsp;<code>1.0</code>, &nbsp;&nbsp;&nbsp;<code>4.1</code>,<br /> &nbsp;&nbsp;&nbsp;<code>5.0</code>, &nbsp;&nbsp;&nbsp;<code>5.5</code>, ...</li>  <li>These values are <b>not valid</b>:<br /> &nbsp;&nbsp;&nbsp;<code>0.01</code>, &nbsp;&nbsp;&nbsp;<code>10.75</code>, &nbsp;&nbsp;&nbsp;<code>99.99</code>,<br /> &nbsp;&nbsp;&nbsp;and so on.</li></ul>  <p>If a bid percentage is not provided for an ad, eBay uses the default bid percentage of the associated campaign.</p><b>Minimum value:</b> 1.0 <br><b>Maximum value:</b> 100.0  # noqa: E501

        :param bid_percentage: The bid_percentage of this FundingStrategy.  # noqa: E501
        :type: str
        """

        self._bid_percentage = bid_percentage

    @property
    def funding_model(self):
        """Gets the funding_model of this FundingStrategy.  # noqa: E501

        Indicates the model that eBay uses to calculate the Promoted Listings fee. Currently, only <code>COST_PER_SALE</code> is supported. <br><br><b>Default: </b> COST_PER_SALE For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/marketing/types/pls:FundingModelEnum'>eBay API documentation</a>  # noqa: E501

        :return: The funding_model of this FundingStrategy.  # noqa: E501
        :rtype: str
        """
        return self._funding_model

    @funding_model.setter
    def funding_model(self, funding_model):
        """Sets the funding_model of this FundingStrategy.

        Indicates the model that eBay uses to calculate the Promoted Listings fee. Currently, only <code>COST_PER_SALE</code> is supported. <br><br><b>Default: </b> COST_PER_SALE For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/marketing/types/pls:FundingModelEnum'>eBay API documentation</a>  # noqa: E501

        :param funding_model: The funding_model of this FundingStrategy.  # noqa: E501
        :type: str
        """

        self._funding_model = funding_model

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(FundingStrategy, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FundingStrategy):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
