# coding: utf-8

"""
    Marketing API

    <p>The <i>Marketing API </i> offers two platforms that sellers can use to promote and advertise their products:</p> <ul><li><b>Promoted Listings</b> is an eBay ad service that lets sellers set up <i>ad campaigns </i> for the products they want to promote. eBay displays the ads in search results and in other marketing modules as <b>SPONSORED</b> listings. If an item in a Promoted Listings campaign sells, the seller is assessed a Promoted Listings fee, which is a seller-specified percentage applied to the sales price. For complete details, see <a href=\"/api-docs/sell/static/marketing/promoted-listings.html\">Promoted Listings</a>.</li>  <li><b>Promotions Manager</b> gives sellers a way to offer discounts on specific items as a way to attract buyers to their inventory. Sellers can set up discounts (such as \"20% off\" and other types of offers) on specific items or on an entire customer order. To further attract buyers, eBay prominently displays promotion <i>teasers</i> throughout buyer flows. For complete details, see <a href=\"/api-docs/sell/static/marketing/promotions-manager.html\">Promotions Manager</a>.</li></ul>  <p><b>Marketing reports</b>, on both the Promoted Listings and Promotions Manager platforms, give sellers information that shows the effectiveness of their marketing strategies. The data gives sellers the ability to review and fine tune their marketing efforts.</p> <p class=\"tablenote\"><b>Important!</b> Sellers must have an active eBay Store subscription, and they must accept the <b>Terms and Conditions</b> before they can make requests to these APIs in the Production environment. There are also site-specific listings requirements and restrictions associated with these marketing tools, as listed in the \"requirements and restrictions\" sections for <a href=\"/api-docs/sell/marketing/static/overview.html#PL-requirements\">Promoted Listings</a> and <a href=\"/api-docs/sell/marketing/static/overview.html#PM-requirements\">Promotions Manager</a>.</p> <p>The table below lists all the Marketing API calls grouped by resource.</p>  # noqa: E501

    OpenAPI spec version: v1.10.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class SelectionRule(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'brands': 'list[str]',
        'category_ids': 'list[str]',
        'category_scope': 'str',
        'listing_condition_ids': 'list[str]',
        'max_price': 'Amount',
        'min_price': 'Amount'
    }

    attribute_map = {
        'brands': 'brands',
        'category_ids': 'categoryIds',
        'category_scope': 'categoryScope',
        'listing_condition_ids': 'listingConditionIds',
        'max_price': 'maxPrice',
        'min_price': 'minPrice'
    }

    def __init__(self, brands=None, category_ids=None, category_scope=None, listing_condition_ids=None, max_price=None, min_price=None):  # noqa: E501
        """SelectionRule - a model defined in Swagger"""  # noqa: E501
        self._brands = None
        self._category_ids = None
        self._category_scope = None
        self._listing_condition_ids = None
        self._max_price = None
        self._min_price = None
        self.discriminator = None
        if brands is not None:
            self.brands = brands
        if category_ids is not None:
            self.category_ids = category_ids
        if category_scope is not None:
            self.category_scope = category_scope
        if listing_condition_ids is not None:
            self.listing_condition_ids = listing_condition_ids
        if max_price is not None:
            self.max_price = max_price
        if min_price is not None:
            self.min_price = min_price

    @property
    def brands(self):
        """Gets the brands of this SelectionRule.  # noqa: E501

        A list of the brands of the items to be included in the campaign.  # noqa: E501

        :return: The brands of this SelectionRule.  # noqa: E501
        :rtype: list[str]
        """
        return self._brands

    @brands.setter
    def brands(self, brands):
        """Sets the brands of this SelectionRule.

        A list of the brands of the items to be included in the campaign.  # noqa: E501

        :param brands: The brands of this SelectionRule.  # noqa: E501
        :type: list[str]
        """

        self._brands = brands

    @property
    def category_ids(self):
        """Gets the category_ids of this SelectionRule.  # noqa: E501

        A list of category IDs associated with the listings to be included in the campaign. Ads are created for all the seller's items listed in the specified categories, up to a maximum of 50,000 items. The IDs can be either a list of eBay category IDs (from the site where the item is hosted), or a list of category IDs defined and used by the seller's store. <p><b>eBay Marketplace category IDs</b>  <br>To get a list of marketplace category IDs, do one of the following:</p> <ul><li>Get a list of category IDs for a marketplace by adding <code>/sch/allcategories/all-categories</code> to the marketplace URL when browsing the site. <br>For example: <code> http://www.ebay.com.au/sch/allcategories/all-categories</code> </li><li>Navigate to the desired category on the host site and copy the category ID from the URL.</li>  <li>These options are also available for the US marketplace: <ul><li>See <a href=\"http://pages.ebay.com/sellerinformation/news/categorychanges.html\" target=\"_blank\">Category Changes</a> for the latest list of category IDs.</li><li>Retrieve a list of category IDs using the <a href=\"/api-docs/commerce/taxonomy/resources/methods\">Taxonomy API</a>.</li></ul></li></ul><p><b>Seller store category IDs</b> <br>Because store category IDs are uniquely defined and maintained by each seller, this service cannot provide a list of a seller's IDs. However, sellers can retrieve their store category IDs as follows:</p><ol><li>Go to <b>Seller Hub</b> &gt; <b>Marketing</b>.</li> <li>Click <b>Manage store categories</b>. <br>  A list of your store categories displays.</li> <li>Click the <b>All categories</b> link displayed at the bottom of the list. <br>A complete list of your store categories and their associated store category IDs displays.</li></ol>  # noqa: E501

        :return: The category_ids of this SelectionRule.  # noqa: E501
        :rtype: list[str]
        """
        return self._category_ids

    @category_ids.setter
    def category_ids(self, category_ids):
        """Sets the category_ids of this SelectionRule.

        A list of category IDs associated with the listings to be included in the campaign. Ads are created for all the seller's items listed in the specified categories, up to a maximum of 50,000 items. The IDs can be either a list of eBay category IDs (from the site where the item is hosted), or a list of category IDs defined and used by the seller's store. <p><b>eBay Marketplace category IDs</b>  <br>To get a list of marketplace category IDs, do one of the following:</p> <ul><li>Get a list of category IDs for a marketplace by adding <code>/sch/allcategories/all-categories</code> to the marketplace URL when browsing the site. <br>For example: <code> http://www.ebay.com.au/sch/allcategories/all-categories</code> </li><li>Navigate to the desired category on the host site and copy the category ID from the URL.</li>  <li>These options are also available for the US marketplace: <ul><li>See <a href=\"http://pages.ebay.com/sellerinformation/news/categorychanges.html\" target=\"_blank\">Category Changes</a> for the latest list of category IDs.</li><li>Retrieve a list of category IDs using the <a href=\"/api-docs/commerce/taxonomy/resources/methods\">Taxonomy API</a>.</li></ul></li></ul><p><b>Seller store category IDs</b> <br>Because store category IDs are uniquely defined and maintained by each seller, this service cannot provide a list of a seller's IDs. However, sellers can retrieve their store category IDs as follows:</p><ol><li>Go to <b>Seller Hub</b> &gt; <b>Marketing</b>.</li> <li>Click <b>Manage store categories</b>. <br>  A list of your store categories displays.</li> <li>Click the <b>All categories</b> link displayed at the bottom of the list. <br>A complete list of your store categories and their associated store category IDs displays.</li></ol>  # noqa: E501

        :param category_ids: The category_ids of this SelectionRule.  # noqa: E501
        :type: list[str]
        """

        self._category_ids = category_ids

    @property
    def category_scope(self):
        """Gets the category_scope of this SelectionRule.  # noqa: E501

        Indicates the source of the category ID; eBay or seller's store. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/marketing/types/sme:CategoryScopeEnum'>eBay API documentation</a>  # noqa: E501

        :return: The category_scope of this SelectionRule.  # noqa: E501
        :rtype: str
        """
        return self._category_scope

    @category_scope.setter
    def category_scope(self, category_scope):
        """Sets the category_scope of this SelectionRule.

        Indicates the source of the category ID; eBay or seller's store. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/marketing/types/sme:CategoryScopeEnum'>eBay API documentation</a>  # noqa: E501

        :param category_scope: The category_scope of this SelectionRule.  # noqa: E501
        :type: str
        """

        self._category_scope = category_scope

    @property
    def listing_condition_ids(self):
        """Gets the listing_condition_ids of this SelectionRule.  # noqa: E501

        A comma-separated list of unique identifiers for the conditions of listings to be included in the campaign. Up to four IDs can be specified.<br /><br />This array is only returned if one or more item condition values are used as a filter.<br /><br /><span class=\"tablenote\"><strong>Note:</strong> Multiple listing condition IDs are mapped to the four valid values listed below. Refer to <a href=\"/api-docs/sell/static/marketing/pl-create-campaign.html#add-by-rule\" target=\"_blank\">Creating a Promoted Listings campaign</a> for more details.</span><br /><br /><strong>Valid Values:</strong><ul><li><code>1000</code> = New</li><li><code>2000</code> = Certified Refurbished</li><li><code>2500</code> = Seller Refurbished</li><li><code>3000</code> = Used</li></ul>  # noqa: E501

        :return: The listing_condition_ids of this SelectionRule.  # noqa: E501
        :rtype: list[str]
        """
        return self._listing_condition_ids

    @listing_condition_ids.setter
    def listing_condition_ids(self, listing_condition_ids):
        """Sets the listing_condition_ids of this SelectionRule.

        A comma-separated list of unique identifiers for the conditions of listings to be included in the campaign. Up to four IDs can be specified.<br /><br />This array is only returned if one or more item condition values are used as a filter.<br /><br /><span class=\"tablenote\"><strong>Note:</strong> Multiple listing condition IDs are mapped to the four valid values listed below. Refer to <a href=\"/api-docs/sell/static/marketing/pl-create-campaign.html#add-by-rule\" target=\"_blank\">Creating a Promoted Listings campaign</a> for more details.</span><br /><br /><strong>Valid Values:</strong><ul><li><code>1000</code> = New</li><li><code>2000</code> = Certified Refurbished</li><li><code>2500</code> = Seller Refurbished</li><li><code>3000</code> = Used</li></ul>  # noqa: E501

        :param listing_condition_ids: The listing_condition_ids of this SelectionRule.  # noqa: E501
        :type: list[str]
        """

        self._listing_condition_ids = listing_condition_ids

    @property
    def max_price(self):
        """Gets the max_price of this SelectionRule.  # noqa: E501


        :return: The max_price of this SelectionRule.  # noqa: E501
        :rtype: Amount
        """
        return self._max_price

    @max_price.setter
    def max_price(self, max_price):
        """Sets the max_price of this SelectionRule.


        :param max_price: The max_price of this SelectionRule.  # noqa: E501
        :type: Amount
        """

        self._max_price = max_price

    @property
    def min_price(self):
        """Gets the min_price of this SelectionRule.  # noqa: E501


        :return: The min_price of this SelectionRule.  # noqa: E501
        :rtype: Amount
        """
        return self._min_price

    @min_price.setter
    def min_price(self, min_price):
        """Sets the min_price of this SelectionRule.


        :param min_price: The min_price of this SelectionRule.  # noqa: E501
        :type: Amount
        """

        self._min_price = min_price

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SelectionRule, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SelectionRule):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
