# coding: utf-8

"""
    Metadata API

    The Metadata API has operations that retrieve configuration details pertaining to the different eBay marketplaces. In addition to marketplace information, the API also has operations that get information that helps sellers list items on eBay.  # noqa: E501

    OpenAPI spec version: v1.5.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ReturnPolicy(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'category_id': 'str',
        'category_tree_id': 'str',
        'domestic': 'ReturnPolicyDetails',
        'international': 'ReturnPolicyDetails',
        'required': 'bool'
    }

    attribute_map = {
        'category_id': 'categoryId',
        'category_tree_id': 'categoryTreeId',
        'domestic': 'domestic',
        'international': 'international',
        'required': 'required'
    }

    def __init__(self, category_id=None, category_tree_id=None, domestic=None, international=None, required=None):  # noqa: E501
        """ReturnPolicy - a model defined in Swagger"""  # noqa: E501
        self._category_id = None
        self._category_tree_id = None
        self._domestic = None
        self._international = None
        self._required = None
        self.discriminator = None
        if category_id is not None:
            self.category_id = category_id
        if category_tree_id is not None:
            self.category_tree_id = category_tree_id
        if domestic is not None:
            self.domestic = domestic
        if international is not None:
            self.international = international
        if required is not None:
            self.required = required

    @property
    def category_id(self):
        """Gets the category_id of this ReturnPolicy.  # noqa: E501

        The category ID to which the return policies apply.  # noqa: E501

        :return: The category_id of this ReturnPolicy.  # noqa: E501
        :rtype: str
        """
        return self._category_id

    @category_id.setter
    def category_id(self, category_id):
        """Sets the category_id of this ReturnPolicy.

        The category ID to which the return policies apply.  # noqa: E501

        :param category_id: The category_id of this ReturnPolicy.  # noqa: E501
        :type: str
        """

        self._category_id = category_id

    @property
    def category_tree_id(self):
        """Gets the category_tree_id of this ReturnPolicy.  # noqa: E501

        A value that indicates the root node of the category tree used for the response set. Each marketplace is based on a category tree whose root node is indicated by this unique category ID value. All category policy information returned by this call pertains to the categories included below this root node of the tree.    <br><br>A <i>category tree</i> is a hierarchical framework of eBay categories that begins at the root node of the tree and extends to include all the child nodes in the tree. Each child node in the tree is an eBay category that is represented by a unique <b>categoryId</b> value. Within a category tree, the root node has no parent node and <i>leaf nodes</i> are nodes that have no child nodes.  # noqa: E501

        :return: The category_tree_id of this ReturnPolicy.  # noqa: E501
        :rtype: str
        """
        return self._category_tree_id

    @category_tree_id.setter
    def category_tree_id(self, category_tree_id):
        """Sets the category_tree_id of this ReturnPolicy.

        A value that indicates the root node of the category tree used for the response set. Each marketplace is based on a category tree whose root node is indicated by this unique category ID value. All category policy information returned by this call pertains to the categories included below this root node of the tree.    <br><br>A <i>category tree</i> is a hierarchical framework of eBay categories that begins at the root node of the tree and extends to include all the child nodes in the tree. Each child node in the tree is an eBay category that is represented by a unique <b>categoryId</b> value. Within a category tree, the root node has no parent node and <i>leaf nodes</i> are nodes that have no child nodes.  # noqa: E501

        :param category_tree_id: The category_tree_id of this ReturnPolicy.  # noqa: E501
        :type: str
        """

        self._category_tree_id = category_tree_id

    @property
    def domestic(self):
        """Gets the domestic of this ReturnPolicy.  # noqa: E501


        :return: The domestic of this ReturnPolicy.  # noqa: E501
        :rtype: ReturnPolicyDetails
        """
        return self._domestic

    @domestic.setter
    def domestic(self, domestic):
        """Sets the domestic of this ReturnPolicy.


        :param domestic: The domestic of this ReturnPolicy.  # noqa: E501
        :type: ReturnPolicyDetails
        """

        self._domestic = domestic

    @property
    def international(self):
        """Gets the international of this ReturnPolicy.  # noqa: E501


        :return: The international of this ReturnPolicy.  # noqa: E501
        :rtype: ReturnPolicyDetails
        """
        return self._international

    @international.setter
    def international(self, international):
        """Sets the international of this ReturnPolicy.


        :param international: The international of this ReturnPolicy.  # noqa: E501
        :type: ReturnPolicyDetails
        """

        self._international = international

    @property
    def required(self):
        """Gets the required of this ReturnPolicy.  # noqa: E501

        If set to <code>true</code>, this flag indicates that you must specify a return policy for items listed in the associated category.  <br><br>Note that not accepting returns (setting <b>returnsAcceptedEnabled</b> to <code>false</code>) is a valid return policy.  # noqa: E501

        :return: The required of this ReturnPolicy.  # noqa: E501
        :rtype: bool
        """
        return self._required

    @required.setter
    def required(self, required):
        """Sets the required of this ReturnPolicy.

        If set to <code>true</code>, this flag indicates that you must specify a return policy for items listed in the associated category.  <br><br>Note that not accepting returns (setting <b>returnsAcceptedEnabled</b> to <code>false</code>) is a valid return policy.  # noqa: E501

        :param required: The required of this ReturnPolicy.  # noqa: E501
        :type: bool
        """

        self._required = required

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ReturnPolicy, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ReturnPolicy):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
