# coding: utf-8

"""
    Negotiation API

    The <b>Negotiations API</b> gives sellers the ability to proactively send discount offers to buyers who have shown an \"interest\" in their listings.  <br><br>By sending buyers discount offers on listings where they have shown an interest, sellers can increase the velocity of their sales.  <br><br>There are various ways for a buyer to show <i>interest </i> in a listing. For example, if a buyer adds the listing to their <b>Watch</b> list, or if they add the listing to their shopping cart and later abandon the cart, they are deemed to have shown an interest in the listing.  <br><br>In the offers that sellers send, they can discount their listings by either a percentage off the listing price, or they can set a new discounted price that is lower than the original listing price.  <br><br>For details about how seller offers work, see <a href=\"/api-docs/sell/static/marketing/offers-to-buyers.html\" title=\"Selling Integration Guide\">Sending offers to buyers</a>.  # noqa: E501

    OpenAPI spec version: v1.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class OfferedItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'discount_percentage': 'str',
        'listing_id': 'str',
        'price': 'Amount',
        'quantity': 'int'
    }

    attribute_map = {
        'discount_percentage': 'discountPercentage',
        'listing_id': 'listingId',
        'price': 'price',
        'quantity': 'quantity'
    }

    def __init__(self, discount_percentage=None, listing_id=None, price=None, quantity=None):  # noqa: E501
        """OfferedItem - a model defined in Swagger"""  # noqa: E501
        self._discount_percentage = None
        self._listing_id = None
        self._price = None
        self._quantity = None
        self.discriminator = None
        if discount_percentage is not None:
            self.discount_percentage = discount_percentage
        if listing_id is not None:
            self.listing_id = listing_id
        if price is not None:
            self.price = price
        if quantity is not None:
            self.quantity = quantity

    @property
    def discount_percentage(self):
        """Gets the discount_percentage of this OfferedItem.  # noqa: E501

        This value denotes the percentage that the listing in the offer will be discounted from its original listed price. The seller can specify either the exact price of the discounted items with the price field or they can use this field to specify the percentage that the listing will be discounted, but not both. Minimum: 5 Required if you do not specify a price value.  # noqa: E501

        :return: The discount_percentage of this OfferedItem.  # noqa: E501
        :rtype: str
        """
        return self._discount_percentage

    @discount_percentage.setter
    def discount_percentage(self, discount_percentage):
        """Sets the discount_percentage of this OfferedItem.

        This value denotes the percentage that the listing in the offer will be discounted from its original listed price. The seller can specify either the exact price of the discounted items with the price field or they can use this field to specify the percentage that the listing will be discounted, but not both. Minimum: 5 Required if you do not specify a price value.  # noqa: E501

        :param discount_percentage: The discount_percentage of this OfferedItem.  # noqa: E501
        :type: str
        """

        self._discount_percentage = discount_percentage

    @property
    def listing_id(self):
        """Gets the listing_id of this OfferedItem.  # noqa: E501

        This value is a unique eBay-assigned ID that identifies the listing to which the offer pertains. A listingId value is generated by eBay when you list an item with the Trading API.  # noqa: E501

        :return: The listing_id of this OfferedItem.  # noqa: E501
        :rtype: str
        """
        return self._listing_id

    @listing_id.setter
    def listing_id(self, listing_id):
        """Sets the listing_id of this OfferedItem.

        This value is a unique eBay-assigned ID that identifies the listing to which the offer pertains. A listingId value is generated by eBay when you list an item with the Trading API.  # noqa: E501

        :param listing_id: The listing_id of this OfferedItem.  # noqa: E501
        :type: str
        """

        self._listing_id = listing_id

    @property
    def price(self):
        """Gets the price of this OfferedItem.  # noqa: E501


        :return: The price of this OfferedItem.  # noqa: E501
        :rtype: Amount
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this OfferedItem.


        :param price: The price of this OfferedItem.  # noqa: E501
        :type: Amount
        """

        self._price = price

    @property
    def quantity(self):
        """Gets the quantity of this OfferedItem.  # noqa: E501

        This integer value indicates the number of items in the eBay listing for which the offer is being made. The offer being made by the seller is an &quot;all or nothing&quot; offer, meaning the buyer must purchase the indicated quantity of items in order to receive the discount on the transaction. Default: 1  # noqa: E501

        :return: The quantity of this OfferedItem.  # noqa: E501
        :rtype: int
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this OfferedItem.

        This integer value indicates the number of items in the eBay listing for which the offer is being made. The offer being made by the seller is an &quot;all or nothing&quot; offer, meaning the buyer must purchase the indicated quantity of items in order to receive the discount on the transaction. Default: 1  # noqa: E501

        :param quantity: The quantity of this OfferedItem.  # noqa: E501
        :type: int
        """

        self._quantity = quantity

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OfferedItem, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OfferedItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
