# coding: utf-8

"""
    Negotiation API

    The <b>Negotiations API</b> gives sellers the ability to proactively send discount offers to buyers who have shown an \"interest\" in their listings.  <br><br>By sending buyers discount offers on listings where they have shown an interest, sellers can increase the velocity of their sales.  <br><br>There are various ways for a buyer to show <i>interest </i> in a listing. For example, if a buyer adds the listing to their <b>Watch</b> list, or if they add the listing to their shopping cart and later abandon the cart, they are deemed to have shown an interest in the listing.  <br><br>In the offers that sellers send, they can discount their listings by either a percentage off the listing price, or they can set a new discounted price that is lower than the original listing price.  <br><br>For details about how seller offers work, see <a href=\"/api-docs/sell/static/marketing/offers-to-buyers.html\" title=\"Selling Integration Guide\">Sending offers to buyers</a>.  # noqa: E501

    OpenAPI spec version: v1.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class PagedEligibleItemCollection(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'eligible_items': 'list[EligibleItem]',
        'href': 'str',
        'limit': 'int',
        'next': 'str',
        'offset': 'int',
        'prev': 'str',
        'total': 'int'
    }

    attribute_map = {
        'eligible_items': 'eligibleItems',
        'href': 'href',
        'limit': 'limit',
        'next': 'next',
        'offset': 'offset',
        'prev': 'prev',
        'total': 'total'
    }

    def __init__(self, eligible_items=None, href=None, limit=None, next=None, offset=None, prev=None, total=None):  # noqa: E501
        """PagedEligibleItemCollection - a model defined in Swagger"""  # noqa: E501
        self._eligible_items = None
        self._href = None
        self._limit = None
        self._next = None
        self._offset = None
        self._prev = None
        self._total = None
        self.discriminator = None
        if eligible_items is not None:
            self.eligible_items = eligible_items
        if href is not None:
            self.href = href
        if limit is not None:
            self.limit = limit
        if next is not None:
            self.next = next
        if offset is not None:
            self.offset = offset
        if prev is not None:
            self.prev = prev
        if total is not None:
            self.total = total

    @property
    def eligible_items(self):
        """Gets the eligible_items of this PagedEligibleItemCollection.  # noqa: E501

        A list of items that are eligible for a seller-initiated offer to a buyer. Each element in the list contains the listing ID of a listed item. These IDs represent the listings for which buyers have shown an interest.  # noqa: E501

        :return: The eligible_items of this PagedEligibleItemCollection.  # noqa: E501
        :rtype: list[EligibleItem]
        """
        return self._eligible_items

    @eligible_items.setter
    def eligible_items(self, eligible_items):
        """Sets the eligible_items of this PagedEligibleItemCollection.

        A list of items that are eligible for a seller-initiated offer to a buyer. Each element in the list contains the listing ID of a listed item. These IDs represent the listings for which buyers have shown an interest.  # noqa: E501

        :param eligible_items: The eligible_items of this PagedEligibleItemCollection.  # noqa: E501
        :type: list[EligibleItem]
        """

        self._eligible_items = eligible_items

    @property
    def href(self):
        """Gets the href of this PagedEligibleItemCollection.  # noqa: E501

        The URI of the current page of results from the result set.  # noqa: E501

        :return: The href of this PagedEligibleItemCollection.  # noqa: E501
        :rtype: str
        """
        return self._href

    @href.setter
    def href(self, href):
        """Sets the href of this PagedEligibleItemCollection.

        The URI of the current page of results from the result set.  # noqa: E501

        :param href: The href of this PagedEligibleItemCollection.  # noqa: E501
        :type: str
        """

        self._href = href

    @property
    def limit(self):
        """Gets the limit of this PagedEligibleItemCollection.  # noqa: E501

        The number of items returned on a single page from the result set. This value can be set in the request with the limit query parameter.  # noqa: E501

        :return: The limit of this PagedEligibleItemCollection.  # noqa: E501
        :rtype: int
        """
        return self._limit

    @limit.setter
    def limit(self, limit):
        """Sets the limit of this PagedEligibleItemCollection.

        The number of items returned on a single page from the result set. This value can be set in the request with the limit query parameter.  # noqa: E501

        :param limit: The limit of this PagedEligibleItemCollection.  # noqa: E501
        :type: int
        """

        self._limit = limit

    @property
    def next(self):
        """Gets the next of this PagedEligibleItemCollection.  # noqa: E501

        The URI for the following page of results. This value is returned only if there is an additional page of results to display from the result set. Max length: 2048  # noqa: E501

        :return: The next of this PagedEligibleItemCollection.  # noqa: E501
        :rtype: str
        """
        return self._next

    @next.setter
    def next(self, next):
        """Sets the next of this PagedEligibleItemCollection.

        The URI for the following page of results. This value is returned only if there is an additional page of results to display from the result set. Max length: 2048  # noqa: E501

        :param next: The next of this PagedEligibleItemCollection.  # noqa: E501
        :type: str
        """

        self._next = next

    @property
    def offset(self):
        """Gets the offset of this PagedEligibleItemCollection.  # noqa: E501

        The number of results skipped in the result set before listing the first returned result. This value can be set in the request with the offset query parameter. Note: The items in a paginated result set use a zero-based list where the first item in the list has an offset of 0.  # noqa: E501

        :return: The offset of this PagedEligibleItemCollection.  # noqa: E501
        :rtype: int
        """
        return self._offset

    @offset.setter
    def offset(self, offset):
        """Sets the offset of this PagedEligibleItemCollection.

        The number of results skipped in the result set before listing the first returned result. This value can be set in the request with the offset query parameter. Note: The items in a paginated result set use a zero-based list where the first item in the list has an offset of 0.  # noqa: E501

        :param offset: The offset of this PagedEligibleItemCollection.  # noqa: E501
        :type: int
        """

        self._offset = offset

    @property
    def prev(self):
        """Gets the prev of this PagedEligibleItemCollection.  # noqa: E501

        The URI for the preceding page of results. This value is returned only if there is a previous page of results to display from the result set. Max length: 2048  # noqa: E501

        :return: The prev of this PagedEligibleItemCollection.  # noqa: E501
        :rtype: str
        """
        return self._prev

    @prev.setter
    def prev(self, prev):
        """Sets the prev of this PagedEligibleItemCollection.

        The URI for the preceding page of results. This value is returned only if there is a previous page of results to display from the result set. Max length: 2048  # noqa: E501

        :param prev: The prev of this PagedEligibleItemCollection.  # noqa: E501
        :type: str
        """

        self._prev = prev

    @property
    def total(self):
        """Gets the total of this PagedEligibleItemCollection.  # noqa: E501

        The total number of items retrieved in the result set. If no items match the search criteria, the server returns the HTTP status code 204 No Content.  # noqa: E501

        :return: The total of this PagedEligibleItemCollection.  # noqa: E501
        :rtype: int
        """
        return self._total

    @total.setter
    def total(self, total):
        """Sets the total of this PagedEligibleItemCollection.

        The total number of items retrieved in the result set. If no items match the search criteria, the server returns the HTTP status code 204 No Content.  # noqa: E501

        :param total: The total of this PagedEligibleItemCollection.  # noqa: E501
        :type: int
        """

        self._total = total

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PagedEligibleItemCollection, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PagedEligibleItemCollection):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
