# coding: utf-8

"""
    Recommendation API

    The <b>Recommendation API</b> returns information that sellers can use to optimize the configuration of their listings on eBay. <br><br>Currently, the API contains a single method, <b>findListingRecommendations</b>. This method provides information that sellers can use to configure Promoted Listings ad campaigns to maximize the visibility of their items in the eBay marketplace.  # noqa: E501

    OpenAPI spec version: 1.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class PagedListingRecommendationCollection(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'href': 'str',
        'limit': 'int',
        'listing_recommendations': 'list[ListingRecommendation]',
        'next': 'str',
        'offset': 'int',
        'prev': 'str',
        'total': 'int'
    }

    attribute_map = {
        'href': 'href',
        'limit': 'limit',
        'listing_recommendations': 'listingRecommendations',
        'next': 'next',
        'offset': 'offset',
        'prev': 'prev',
        'total': 'total'
    }

    def __init__(self, href=None, limit=None, listing_recommendations=None, next=None, offset=None, prev=None, total=None):  # noqa: E501
        """PagedListingRecommendationCollection - a model defined in Swagger"""  # noqa: E501
        self._href = None
        self._limit = None
        self._listing_recommendations = None
        self._next = None
        self._offset = None
        self._prev = None
        self._total = None
        self.discriminator = None
        if href is not None:
            self.href = href
        if limit is not None:
            self.limit = limit
        if listing_recommendations is not None:
            self.listing_recommendations = listing_recommendations
        if next is not None:
            self.next = next
        if offset is not None:
            self.offset = offset
        if prev is not None:
            self.prev = prev
        if total is not None:
            self.total = total

    @property
    def href(self):
        """Gets the href of this PagedListingRecommendationCollection.  # noqa: E501

        The URI of the current page of results from the result set.  # noqa: E501

        :return: The href of this PagedListingRecommendationCollection.  # noqa: E501
        :rtype: str
        """
        return self._href

    @href.setter
    def href(self, href):
        """Sets the href of this PagedListingRecommendationCollection.

        The URI of the current page of results from the result set.  # noqa: E501

        :param href: The href of this PagedListingRecommendationCollection.  # noqa: E501
        :type: str
        """

        self._href = href

    @property
    def limit(self):
        """Gets the limit of this PagedListingRecommendationCollection.  # noqa: E501

        The number of items returned on a single page from the result set. This value can be set in the request with the limit query parameter.  # noqa: E501

        :return: The limit of this PagedListingRecommendationCollection.  # noqa: E501
        :rtype: int
        """
        return self._limit

    @limit.setter
    def limit(self, limit):
        """Sets the limit of this PagedListingRecommendationCollection.

        The number of items returned on a single page from the result set. This value can be set in the request with the limit query parameter.  # noqa: E501

        :param limit: The limit of this PagedListingRecommendationCollection.  # noqa: E501
        :type: int
        """

        self._limit = limit

    @property
    def listing_recommendations(self):
        """Gets the listing_recommendations of this PagedListingRecommendationCollection.  # noqa: E501

        Returns a list of listingRecommendations, where each element in the list offers recommendations for the associated listingId. Which elements are returned depend on how you structure the request. For example, if you request recommendations for all of a sellers listings (by leaving the request payload empty), ad recommendations are returned only for those listings where promoteWithAd is set to RECOMMENDED.  # noqa: E501

        :return: The listing_recommendations of this PagedListingRecommendationCollection.  # noqa: E501
        :rtype: list[ListingRecommendation]
        """
        return self._listing_recommendations

    @listing_recommendations.setter
    def listing_recommendations(self, listing_recommendations):
        """Sets the listing_recommendations of this PagedListingRecommendationCollection.

        Returns a list of listingRecommendations, where each element in the list offers recommendations for the associated listingId. Which elements are returned depend on how you structure the request. For example, if you request recommendations for all of a sellers listings (by leaving the request payload empty), ad recommendations are returned only for those listings where promoteWithAd is set to RECOMMENDED.  # noqa: E501

        :param listing_recommendations: The listing_recommendations of this PagedListingRecommendationCollection.  # noqa: E501
        :type: list[ListingRecommendation]
        """

        self._listing_recommendations = listing_recommendations

    @property
    def next(self):
        """Gets the next of this PagedListingRecommendationCollection.  # noqa: E501

        The URI for the following page of results. This value is returned only if there is an additional page of results to display from the result set. Max length: 2048  # noqa: E501

        :return: The next of this PagedListingRecommendationCollection.  # noqa: E501
        :rtype: str
        """
        return self._next

    @next.setter
    def next(self, next):
        """Sets the next of this PagedListingRecommendationCollection.

        The URI for the following page of results. This value is returned only if there is an additional page of results to display from the result set. Max length: 2048  # noqa: E501

        :param next: The next of this PagedListingRecommendationCollection.  # noqa: E501
        :type: str
        """

        self._next = next

    @property
    def offset(self):
        """Gets the offset of this PagedListingRecommendationCollection.  # noqa: E501

        The number of results skipped in the result set before listing the first returned result. This value can be set in the request with the offset query parameter. Note: The items in a paginated result set use a zero-based list where the first item in the list has an offset of 0.  # noqa: E501

        :return: The offset of this PagedListingRecommendationCollection.  # noqa: E501
        :rtype: int
        """
        return self._offset

    @offset.setter
    def offset(self, offset):
        """Sets the offset of this PagedListingRecommendationCollection.

        The number of results skipped in the result set before listing the first returned result. This value can be set in the request with the offset query parameter. Note: The items in a paginated result set use a zero-based list where the first item in the list has an offset of 0.  # noqa: E501

        :param offset: The offset of this PagedListingRecommendationCollection.  # noqa: E501
        :type: int
        """

        self._offset = offset

    @property
    def prev(self):
        """Gets the prev of this PagedListingRecommendationCollection.  # noqa: E501

        The URI for the preceding page of results. This value is returned only if there is a previous page of results to display from the result set. Max length: 2048  # noqa: E501

        :return: The prev of this PagedListingRecommendationCollection.  # noqa: E501
        :rtype: str
        """
        return self._prev

    @prev.setter
    def prev(self, prev):
        """Sets the prev of this PagedListingRecommendationCollection.

        The URI for the preceding page of results. This value is returned only if there is a previous page of results to display from the result set. Max length: 2048  # noqa: E501

        :param prev: The prev of this PagedListingRecommendationCollection.  # noqa: E501
        :type: str
        """

        self._prev = prev

    @property
    def total(self):
        """Gets the total of this PagedListingRecommendationCollection.  # noqa: E501

        The total number of items retrieved in the result set. If no items are found, this field is returned with a value of 0.  # noqa: E501

        :return: The total of this PagedListingRecommendationCollection.  # noqa: E501
        :rtype: int
        """
        return self._total

    @total.setter
    def total(self, total):
        """Sets the total of this PagedListingRecommendationCollection.

        The total number of items retrieved in the result set. If no items are found, this field is returned with a value of 0.  # noqa: E501

        :param total: The total of this PagedListingRecommendationCollection.  # noqa: E501
        :type: int
        """

        self._total = total

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PagedListingRecommendationCollection, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PagedListingRecommendationCollection):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
