"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const ses_generated_1 = require("./ses.generated");
/**
 * The policy for the receipt filter.
 */
var ReceiptFilterPolicy;
(function (ReceiptFilterPolicy) {
    /**
     * Allow the ip address or range.
     */
    ReceiptFilterPolicy["ALLOW"] = "Allow";
    /**
     * Block the ip address or range.
     */
    ReceiptFilterPolicy["BLOCK"] = "Block";
})(ReceiptFilterPolicy = exports.ReceiptFilterPolicy || (exports.ReceiptFilterPolicy = {}));
/**
 * A receipt filter. When instantiated without props, it creates a
 * block all receipt filter.
 */
class ReceiptFilter extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.receiptFilterName,
        });
        new ses_generated_1.CfnReceiptFilter(this, 'Resource', {
            filter: {
                ipFilter: {
                    cidr: props.ip || '0.0.0.0/0',
                    policy: props.policy || ReceiptFilterPolicy.BLOCK,
                },
                name: this.physicalName,
            }
        });
    }
}
exports.ReceiptFilter = ReceiptFilter;
/**
 * A white list receipt filter.
 */
class WhiteListReceiptFilter extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        new ReceiptFilter(this, 'BlockAll');
        props.ips.forEach(ip => {
            new ReceiptFilter(this, `Allow${ip.replace(/[^\d]/g, '')}`, {
                ip,
                policy: ReceiptFilterPolicy.ALLOW
            });
        });
    }
}
exports.WhiteListReceiptFilter = WhiteListReceiptFilter;
//# sourceMappingURL=data:application/json;base64,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