# Generated by Django 3.0.9 on 2020-08-26 07:55

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Grade',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('grade', models.CharField(max_length=50)),
                ('is_senior', models.BooleanField(default=True)),
            ],
            options={
                'ordering': ('-is_senior', 'grade'),
            },
        ),
        migrations.CreateModel(
            name='Player',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('first_name', models.CharField(blank=True, max_length=200)),
                ('nickname', models.CharField(blank=True, max_length=200)),
                ('middle_names', models.CharField(blank=True, max_length=200)),
                ('last_name', models.CharField(max_length=200)),
                ('first_XI_number', models.PositiveSmallIntegerField(blank=True, null=True, unique=True)),
            ],
            options={
                'ordering': ('last_name', 'first_name', 'middle_names'),
                'unique_together': {('first_name', 'nickname', 'middle_names', 'last_name')},
            },
        ),
        migrations.CreateModel(
            name='Season',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('year', models.PositiveSmallIntegerField(unique=True)),
            ],
            options={
                'ordering': ('-year',),
            },
        ),
        migrations.CreateModel(
            name='Statistic',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('number_of_matches', models.PositiveSmallIntegerField(verbose_name='mat')),
                ('batting_innings', models.PositiveSmallIntegerField(default=0, verbose_name='inns')),
                ('batting_aggregate', models.PositiveSmallIntegerField(default=0, verbose_name='runs')),
                ('batting_not_outs', models.PositiveSmallIntegerField(default=0, verbose_name='NO')),
                ('number_batting_milestone_50', models.PositiveSmallIntegerField(default=0, verbose_name='50')),
                ('number_of_ducks', models.PositiveSmallIntegerField(default=0, verbose_name='ducks')),
                ('batting_high_score_runs', models.PositiveSmallIntegerField(blank=True, default=0, verbose_name='HS runs')),
                ('batting_high_score_is_not_out', models.BooleanField(blank=True, default=False, verbose_name='HS NO?')),
                ('batting_4s', models.PositiveSmallIntegerField(default=0, verbose_name='4s')),
                ('batting_6s', models.PositiveSmallIntegerField(default=0, verbose_name='6s')),
                ('bowling_wickets', models.PositiveSmallIntegerField(default=0, verbose_name='wkts')),
                ('bowling_maidens', models.PositiveSmallIntegerField(default=0, verbose_name='mdns')),
                ('bowling_runs', models.PositiveSmallIntegerField(default=0, verbose_name='runs')),
                ('best_bowling_wickets', models.PositiveSmallIntegerField(blank=True, default=0, verbose_name='BB wickets')),
                ('best_bowling_runs', models.PositiveSmallIntegerField(blank=True, default=0, verbose_name='BB runs')),
                ('bowling_balls', models.PositiveSmallIntegerField(blank=True, default=0, verbose_name='balls')),
                ('fielding_catches_non_wk', models.PositiveSmallIntegerField(default=0, verbose_name='ct')),
                ('fielding_catches_wk', models.PositiveSmallIntegerField(default=0, verbose_name='ct Wk')),
                ('fielding_run_outs', models.PositiveSmallIntegerField(default=0, verbose_name='RO')),
                ('fielding_throw_outs', models.PositiveSmallIntegerField(default=0, verbose_name='TO')),
                ('fielding_stumpings', models.PositiveSmallIntegerField(default=0, verbose_name='st')),
                ('grade', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='django_cricket_statistics.Grade')),
                ('player', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='django_cricket_statistics.Player')),
                ('season', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='django_cricket_statistics.Season')),
            ],
            options={
                'ordering': ('player__last_name', 'player__first_name', 'player__middle_names', 'season', 'grade'),
                'unique_together': {('player', 'season', 'grade')},
            },
        ),
        migrations.CreateModel(
            name='Hundred',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('runs', models.PositiveSmallIntegerField(default=0, validators=[django.core.validators.MinValueValidator(100)])),
                ('is_not_out', models.BooleanField(default=False)),
                ('is_in_final', models.BooleanField(default=False)),
                ('statistic', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='django_cricket_statistics.Statistic')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='FiveWicketInning',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('wickets', models.PositiveSmallIntegerField(default=0, validators=[django.core.validators.MinValueValidator(5)])),
                ('runs', models.PositiveSmallIntegerField(default=0)),
                ('is_in_final', models.BooleanField(default=False)),
                ('statistic', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='django_cricket_statistics.Statistic')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
